/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

final class Source {
    char functionNumber;
    StringBuffer buf = new StringBuffer(64);

    Source() {
    }

    void append(char c) {
        this.buf.append(c);
    }

    void addString(int type, String str) {
        this.buf.append((char)type);
        this.buf.append((char)str.length());
        this.buf.append(str);
    }

    void addNumber(Number n) {
        this.buf.append('-');
        if (n instanceof Double || n instanceof Float) {
            this.buf.append('D');
            long lbits = Double.doubleToLongBits(n.doubleValue());
            this.buf.append((char)(lbits >> 48 & (long)65535));
            this.buf.append((char)(lbits >> 32 & (long)65535));
            this.buf.append((char)(lbits >> 16 & (long)65535));
            this.buf.append((char)(lbits & (long)65535));
        } else {
            long lbits = n.longValue();
            if (lbits <= (long)65535) {
                this.buf.append('S');
                this.buf.append((char)lbits);
            } else {
                this.buf.append('J');
                this.buf.append((char)(lbits >> 48 & (long)65535));
                this.buf.append((char)(lbits >> 32 & (long)65535));
                this.buf.append((char)(lbits >> 16 & (long)65535));
                this.buf.append((char)(lbits & (long)65535));
            }
        }
    }
}

