/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

class UintMap {
    private static final boolean checkWorld = true;
    private static final boolean checkSelf = false;
    private static final int A = -1640531527;
    private static final int EMPTY = -1;
    private static final int DELETED = -2;
    private int[] keys;
    private Object[] values;
    private int minimalPower;
    private int power;
    private int keyCount;
    private int occupiedCount;
    private int ivaluesShift;

    public UintMap() {
        this(4);
    }

    public UintMap(int initialCapacity) {
        UintMap.check(initialCapacity >= 0);
        int minimalCapacity = initialCapacity * 4 / 3;
        int i = 2;
        while (1 << i < minimalCapacity) {
            ++i;
        }
        this.minimalPower = i;
    }

    public boolean isEmpty() {
        return this.keyCount == 0;
    }

    public int size() {
        return this.keyCount;
    }

    public boolean has(int key) {
        UintMap.check(key >= 0);
        return this.findIndex(key) >= 0;
    }

    public boolean isObjectType(int key) {
        UintMap.check(key >= 0);
        int index = this.findIndex(key);
        return index >= 0 && this.isObjectTypeValue(index);
    }

    public boolean isIntType(int key) {
        UintMap.check(key >= 0);
        int index = this.findIndex(key);
        return index >= 0 && !this.isObjectTypeValue(index);
    }

    public Object getObject(int key) {
        int index;
        UintMap.check(key >= 0);
        if (this.values != null && (index = this.findIndex(key)) >= 0) {
            return this.values[index];
        }
        return null;
    }

    public int getInt(int key, int defaultValue) {
        int index;
        UintMap.check(key >= 0);
        if (this.ivaluesShift != 0 && (index = this.findIndex(key)) >= 0 && !this.isObjectTypeValue(index)) {
            return this.keys[this.ivaluesShift + index];
        }
        return defaultValue;
    }

    public int getExistingInt(int key) {
        int index;
        UintMap.check(key >= 0);
        if (this.ivaluesShift != 0 && (index = this.findIndex(key)) >= 0 && !this.isObjectTypeValue(index)) {
            return this.keys[this.ivaluesShift + index];
        }
        UintMap.check(false);
        return 0;
    }

    public void put(int key, Object value) {
        UintMap.check(key >= 0 && value != null);
        int index = this.ensureIndex(key, false);
        if (this.values == null) {
            this.values = new Object[1 << this.power];
        }
        this.values[index] = value;
    }

    public void put(int key, int value) {
        UintMap.check(key >= 0);
        int index = this.ensureIndex(key, true);
        if (this.ivaluesShift == 0) {
            int N = 1 << this.power;
            int[] tmp = new int[N * 2];
            System.arraycopy(this.keys, 0, tmp, 0, N);
            this.keys = tmp;
            this.ivaluesShift = N;
        }
        this.keys[this.ivaluesShift + index] = value;
        if (this.values != null) {
            this.values[index] = null;
        }
    }

    public void remove(int key) {
        UintMap.check(key >= 0);
        int index = this.findIndex(key);
        if (index >= 0) {
            this.keys[index] = -2;
            --this.keyCount;
            if (this.values != null) {
                this.values[index] = null;
            }
        }
    }

    public void clear() {
        this.power = 0;
        this.keys = null;
        this.values = null;
        this.ivaluesShift = 0;
        this.keyCount = 0;
        this.occupiedCount = 0;
    }

    public int[] getKeys() {
        int[] keys = this.keys;
        int n = this.keyCount;
        int[] result = new int[n];
        int i = 0;
        while (n != 0) {
            int entry = keys[i];
            if (entry != -1 && entry != -2) {
                result[--n] = entry;
            }
            ++i;
        }
        return result;
    }

    private static int tableLookupStep(int fraction, int mask, int power) {
        int shift = 32 - 2 * power;
        if (shift >= 0) {
            return fraction >>> shift & mask | 1;
        }
        return fraction & mask >>> -shift | 1;
    }

    private int findIndex(int key) {
        int[] keys = this.keys;
        if (keys != null) {
            int fraction = key * -1640531527;
            int index = fraction >>> 32 - this.power;
            int entry = keys[index];
            if (entry == key) {
                return index;
            }
            if (entry != -1) {
                int mask = (1 << this.power) - 1;
                int step = UintMap.tableLookupStep(fraction, mask, this.power);
                boolean n = false;
                do {
                    if ((entry = keys[index = index + step & mask]) != key) continue;
                    return index;
                } while (entry != -1);
            }
        }
        return -1;
    }

    private int getFreeIndex(int key) {
        int[] keys = this.keys;
        int fraction = key * -1640531527;
        int index = fraction >>> 32 - this.power;
        if (keys[index] != -1) {
            int mask = (1 << this.power) - 1;
            int step = UintMap.tableLookupStep(fraction, mask, this.power);
            int firstIndex = index;
            while (keys[index = index + step & mask] != -1) {
            }
        }
        return index;
    }

    private void rehashTable(boolean ensureIntSpace) {
        if (this.keys == null) {
            this.power = this.minimalPower;
        } else if (this.keyCount * 2 >= this.occupiedCount) {
            ++this.power;
        }
        int N = 1 << this.power;
        int[] old = this.keys;
        int oldShift = this.ivaluesShift;
        if (oldShift == 0 && !ensureIntSpace) {
            this.keys = new int[N];
        } else {
            this.ivaluesShift = N;
            this.keys = new int[N * 2];
        }
        for (int i = 0; i != N; ++i) {
            this.keys[i] = -1;
        }
        Object[] oldValues = this.values;
        if (oldValues != null) {
            this.values = new Object[N];
        }
        if (old != null) {
            int i = 0;
            int remaining = this.keyCount;
            while (remaining != 0) {
                int entry = old[i];
                if (entry != -1 && entry != -2) {
                    int index = this.getFreeIndex(entry);
                    this.keys[index] = entry;
                    if (oldValues != null) {
                        this.values[index] = oldValues[i];
                    }
                    if (oldShift != 0) {
                        this.keys[this.ivaluesShift + index] = old[oldShift + i];
                    }
                    --remaining;
                }
                ++i;
            }
        }
        this.occupiedCount = this.keyCount;
    }

    private int ensureIndex(int key, boolean intType) {
        int index = -1;
        int firstDeleted = -1;
        int[] keys = this.keys;
        if (keys != null) {
            int fraction = key * -1640531527;
            index = fraction >>> 32 - this.power;
            int entry = keys[index];
            if (entry == key) {
                return index;
            }
            if (entry != -1) {
                if (entry == -2) {
                    firstDeleted = index;
                }
                int mask = (1 << this.power) - 1;
                int step = UintMap.tableLookupStep(fraction, mask, this.power);
                boolean n = false;
                do {
                    if ((entry = keys[index = index + step & mask]) == key) {
                        return index;
                    }
                    if (entry != -2 || firstDeleted >= 0) continue;
                    firstDeleted = index;
                } while (entry != -1);
            }
        }
        if (firstDeleted >= 0) {
            index = firstDeleted;
        } else {
            if (keys == null || this.occupiedCount * 4 >= (1 << this.power) * 3) {
                this.rehashTable(intType);
                keys = this.keys;
                index = this.getFreeIndex(key);
            }
            ++this.occupiedCount;
        }
        keys[index] = key;
        ++this.keyCount;
        return index;
    }

    private boolean isObjectTypeValue(int index) {
        return this.values != null && this.values[index] != null;
    }

    private static void check(boolean condition) {
        if (!condition) {
            throw new RuntimeException();
        }
    }

    static {
        checkWorld = true;
        checkSelf = false;
        A = -1640531527;
        EMPTY = -1;
        DELETED = -2;
    }
}

