/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.LocalVariable;

public class VariableTable {
    protected Vector itsVariables = new Vector();
    protected Hashtable itsVariableNames = new Hashtable(11);
    protected int varStart;

    public int size() {
        return this.itsVariables.size();
    }

    public int getParameterCount() {
        return this.varStart;
    }

    public LocalVariable createLocalVariable(String name, boolean isParameter) {
        return new LocalVariable(name, isParameter);
    }

    public LocalVariable getVariable(int index) {
        return (LocalVariable)this.itsVariables.elementAt(index);
    }

    public LocalVariable getVariable(String name) {
        Integer vIndex = (Integer)this.itsVariableNames.get(name);
        if (vIndex != null) {
            return (LocalVariable)this.itsVariables.elementAt(vIndex);
        }
        return null;
    }

    public int getOrdinal(String name) {
        Integer vIndex = (Integer)this.itsVariableNames.get(name);
        if (vIndex != null) {
            return vIndex;
        }
        return -1;
    }

    public String getName(int index) {
        return ((LocalVariable)this.itsVariables.elementAt(index)).getName();
    }

    public String[] getAllNames() {
        int N = this.size();
        String[] result = null;
        if (N != 0) {
            result = new String[N];
            for (int i = 0; i != N; ++i) {
                result[i] = this.getName(i);
            }
        }
        return result;
    }

    public void establishIndices() {
        for (int i = 0; i < this.itsVariables.size(); ++i) {
            LocalVariable lVar = (LocalVariable)this.itsVariables.elementAt(i);
            lVar.setIndex(i);
        }
    }

    public void addParameter(String pName) {
        Integer pIndex = (Integer)this.itsVariableNames.get(pName);
        if (pIndex != null) {
            LocalVariable p = (LocalVariable)this.itsVariables.elementAt(pIndex);
            if (p.isParameter()) {
                String message = Context.getMessage1("msg.dup.parms", pName);
                Context.reportWarning(message, null, 0, null, 0);
            } else {
                this.itsVariables.removeElementAt(pIndex);
            }
        }
        int curIndex = this.varStart++;
        LocalVariable lVar = this.createLocalVariable(pName, true);
        this.itsVariables.insertElementAt(lVar, curIndex);
        this.itsVariableNames.put(pName, new Integer(curIndex));
    }

    public void addLocal(String vName) {
        Integer vIndex = (Integer)this.itsVariableNames.get(vName);
        if (vIndex != null) {
            return;
        }
        int index = this.itsVariables.size();
        LocalVariable lVar = this.createLocalVariable(vName, false);
        this.itsVariables.addElement(lVar);
        this.itsVariableNames.put(vName, new Integer(index));
    }

    public void removeLocal(String name) {
        Integer i = (Integer)this.itsVariableNames.get(name);
        if (i != null) {
            this.itsVariables.removeElementAt(i);
            this.itsVariableNames.remove(name);
            Hashtable ht = new Hashtable(11);
            Enumeration e = this.itsVariableNames.keys();
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                Integer v = (Integer)this.itsVariableNames.get(k);
                int v2 = v;
                if (v2 > i) {
                    v = new Integer(v2 - 1);
                }
                ht.put(k, v);
            }
            this.itsVariableNames = ht;
        }
    }
}

