/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class DebugReader
extends Reader {
    private BufferedReader reader;
    private StringBuffer saved;

    public DebugReader(Reader reader) {
        this.reader = new BufferedReader(reader);
        this.saved = new StringBuffer();
    }

    public StringBuffer getSaved() {
        return this.saved;
    }

    public int read() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            this.saved.append((char)c);
        }
        return c;
    }

    public int read(char[] cbuf) throws IOException {
        int i = this.reader.read(cbuf);
        if (i != -1) {
            this.saved.append(cbuf, 0, i);
        }
        return i;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = this.reader.read(cbuf, off, len);
        if (i > 0) {
            this.saved.append(cbuf, off, i);
        }
        return i;
    }

    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }

    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    public boolean markSupported() {
        return this.reader.markSupported();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.reader.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    protected void finalize() throws Throwable {
        this.reader = null;
    }
}

