/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.MatchState;
import org.mozilla.javascript.regexp.NativeRegExp;

class RENode {
    public static final int ANCHORED = 1;
    public static final int SINGLE = 2;
    public static final int NONEMPTY = 4;
    public static final int ISNEXT = 8;
    public static final int GOODNEXT = 16;
    public static final int ISJOIN = 32;
    public static final int REALLOK = 64;
    public static final int MINIMAL = 128;
    byte op;
    byte flags;
    short offset;
    RENode next;
    Object kid;
    int kid2;
    int num;
    char chr;
    short min;
    short max;
    short kidlen;
    short bmsize;
    char[] s;
    byte[] bitmap;

    RENode(CompilerState state, byte op, Object kid) {
        this.op = op;
        this.kid = kid;
    }

    private void calcBMSize(char[] s, int index, int cp2, boolean fold) {
        char maxc = '\u0000';
        while (index < cp2) {
            char c;
            if ((c = s[index++]) == '\\') {
                if (index + 5 <= cp2 && s[index] == 'u' && NativeRegExp.isHex(s[index + 1]) && NativeRegExp.isHex(s[index + 2]) && NativeRegExp.isHex(s[index + 3]) && NativeRegExp.isHex(s[index + 4])) {
                    int x = (((NativeRegExp.unHex(s[index + 0]) << 4) + NativeRegExp.unHex(s[index + 1]) << 4) + NativeRegExp.unHex(s[index + 2]) << 4) + NativeRegExp.unHex(s[index + 3]);
                    c = (char)x;
                    index += 5;
                } else {
                    if (maxc >= '\u00ff') continue;
                    maxc = '\u00ff';
                    continue;
                }
            }
            if (fold) {
                char c2 = Character.toUpperCase(c);
                if (c2 > maxc) {
                    maxc = c2;
                }
                if ((c2 = Character.toLowerCase(c2)) > maxc) {
                    maxc = c2;
                }
            }
            if (c <= maxc) continue;
            maxc = c;
        }
        this.bmsize = (short)((maxc + 8) / 8);
    }

    private void matchBit(char c, int fill) {
        int i = c >> 3;
        byte b = (byte)(c & 7);
        b = (byte)(1 << b);
        if (fill != 0) {
            int n = i;
            this.bitmap[n] = (byte)(this.bitmap[n] & ~b);
        } else {
            int n = i;
            this.bitmap[n] = (byte)(this.bitmap[n] | b);
        }
    }

    private void checkRange(char lastc, int fill) {
        this.matchBit(lastc, fill);
        this.matchBit('-', fill);
    }

    void buildBitmap(MatchState state, char[] s, boolean fold) {
        int i;
        int index = (Integer)this.kid;
        int end = this.kid2;
        int fill = 0;
        boolean not = false;
        this.kid2 = 0;
        if (s[index] == '^') {
            not = true;
            this.kid2 = -1;
            ++index;
        }
        this.calcBMSize(s, index, end, fold);
        this.bitmap = new byte[this.bmsize];
        if (not) {
            fill = -1;
            for (i = 0; i < this.bmsize; ++i) {
                this.bitmap[i] = -1;
            }
            this.bitmap[0] = -2;
        }
        char nchars = this.bmsize * 8;
        char lastc = nchars;
        boolean inrange = false;
        block14: while (index < end) {
            char c;
            if ((c = s[index++]) == '\\') {
                c = s[index++];
                switch (c) {
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'v': {
                        c = NativeRegExp.getEscape(c);
                        break;
                    }
                    case 'd': {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 'D': {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = '\u0000'; c < '0'; c = (char)(c + '\u0001')) {
                            this.matchBit(c, fill);
                        }
                        for (c = ':'; c < nchars; c = (char)(c + '\u0001')) {
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 'w': {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = '\u0000'; c < nchars; c = (char)(c + '\u0001')) {
                            if (!NativeRegExp.isWord(c)) continue;
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 'W': {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = '\u0000'; c < nchars; c = (char)(c + '\u0001')) {
                            if (NativeRegExp.isWord(c)) continue;
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 's': {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = '\u0000'; c < nchars; c = (char)(c + '\u0001')) {
                            if (!Character.isWhitespace(c)) continue;
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case 'S': {
                        if (inrange) {
                            this.checkRange(lastc, fill);
                        }
                        lastc = nchars;
                        for (c = '\u0000'; c < nchars; c = (char)(c + '\u0001')) {
                            if (Character.isWhitespace(c)) continue;
                            this.matchBit(c, fill);
                        }
                        continue block14;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int n = NativeRegExp.unDigit(c);
                        int ocp = index - 2;
                        c = s[index];
                        if ('0' <= c && c <= '7') {
                            n = 8 * n + NativeRegExp.unDigit(c);
                            if ('0' <= (c = s[++index]) && c <= '7') {
                                ++index;
                                i = 8 * n + NativeRegExp.unDigit(c);
                                if (i <= 255) {
                                    n = i;
                                } else {
                                    --index;
                                }
                            }
                        }
                        c = (char)n;
                        break;
                    }
                    case 'x': {
                        int n;
                        int ocp = index;
                        if (index < s.length && NativeRegExp.isHex(c = s[index++])) {
                            n = NativeRegExp.unHex(c);
                            if (index < s.length && NativeRegExp.isHex(c = s[index++])) {
                                n <<= 4;
                                n += NativeRegExp.unHex(c);
                            }
                        } else {
                            index = ocp;
                            n = 120;
                        }
                        c = (char)n;
                        break;
                    }
                    case 'u': {
                        if (s.length <= index + 3 || !NativeRegExp.isHex(s[index + 0]) || !NativeRegExp.isHex(s[index + 1]) || !NativeRegExp.isHex(s[index + 2]) || !NativeRegExp.isHex(s[index + 3])) break;
                        int n = (((NativeRegExp.unHex(s[index + 0]) << 4) + NativeRegExp.unHex(s[index + 1]) << 4) + NativeRegExp.unHex(s[index + 2]) << 4) + NativeRegExp.unHex(s[index + 3]);
                        c = (char)n;
                        index += 4;
                        break;
                    }
                    case 'c': {
                        c = s[index++];
                        c = Character.toUpperCase(c);
                        c = (char)(c ^ 0x40);
                        break;
                    }
                }
            }
            if (inrange) {
                if (lastc > c) {
                    throw NativeGlobal.constructError(Context.getCurrentContext(), "RangeError", ScriptRuntime.getMessage("msg.bad.range", null), state.scope);
                }
                inrange = false;
            } else {
                lastc = c;
                if (index + 1 < end && s[index] == '-' && s[index + 1] != ']') {
                    ++index;
                    inrange = true;
                    continue;
                }
            }
            while (lastc <= c) {
                this.matchBit(lastc, fill);
                if (fold) {
                    char foldc = Character.toUpperCase(lastc);
                    this.matchBit(foldc, fill);
                    foldc = Character.toLowerCase(foldc);
                    this.matchBit(foldc, fill);
                }
                lastc = (char)(lastc + '\u0001');
            }
            lastc = c;
        }
    }

    static {
        ANCHORED = 1;
        SINGLE = 2;
        NONEMPTY = 4;
        ISNEXT = 8;
        GOODNEXT = 16;
        ISJOIN = 32;
        REALLOK = 64;
        MINIMAL = 128;
    }
}

