/*
 * Decompiled with CFR 0.152.
 */
package scriptor;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;
import scriptor.TabbedPanel;

class TabSelector
extends Canvas {
    Color hi;
    Color lo;
    Vector name = new Vector();
    int chosen = 0;
    Font font = new Font("timesRoman", 0, 12);
    Font chfont = new Font(this.font.getName(), 1, 13);

    TabSelector(Color h, Color l) {
        this.hi = h;
        this.lo = l;
    }

    void addItem(String n) {
        this.name.addElement(n);
        this.paint(this.getGraphics());
    }

    void choose(String n) {
        for (int i = 0; i < this.name.size(); ++i) {
            if (!((String)this.name.elementAt(i)).equals(n)) continue;
            this.chosen = i;
            this.paint(this.getGraphics());
        }
    }

    public void paint(Graphics g) {
        if (g == null || this.name.size() == 0) {
            return;
        }
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        int tw = this.getSize().width / this.name.size();
        int th = this.getSize().height;
        for (int i = 0; i < this.name.size(); ++i) {
            int x = tw * i;
            if (i == this.chosen) {
                g.setColor(this.lo);
                g.drawLine(x + tw - 3, 1, x + tw - 3, th - 1);
                g.drawLine(x + tw - 4, 2, x + tw - 4, th - 1);
                g.setColor(this.hi);
                g.drawLine(x, 0, x, th - 1);
                g.drawLine(x + 1, 0, x + 1, th - 1);
                g.drawLine(x, 0, x + tw - 4, 0);
                g.drawLine(x, 1, x + tw - 5, 1);
                g.drawLine(x + tw - 3, th - 1, x + tw - 1, th - 1);
                g.drawLine(x + tw - 3, th - 2, x + tw - 1, th - 2);
            } else {
                g.setColor(this.lo);
                g.drawLine(x + tw - 3, 6, x + tw - 3, th - 1);
                g.drawLine(x + tw - 4, 7, x + tw - 4, th - 1);
                g.setColor(this.hi);
                g.drawLine(x, 5, x, th - 1);
                g.drawLine(x + 1, 5, x + 1, th - 1);
                g.drawLine(x, 5, x + tw - 4, 5);
                g.drawLine(x, 6, x + tw - 5, 6);
                g.drawLine(x, th - 1, x + tw - 1, th - 1);
                g.drawLine(x, th - 2, x + tw - 1, th - 2);
            }
            g.setColor(this.lo);
            if (i == this.chosen) {
                g.setFont(this.chfont);
            } else {
                g.setFont(this.font);
            }
            String str = (String)this.name.elementAt(i);
            int textw = g.getFontMetrics().stringWidth(str);
            int texth = g.getFontMetrics().getHeight();
            if (textw >= tw - 5) continue;
            g.drawString(str, x + (tw - textw) / 2, (th - texth) / 2 + texth);
        }
    }

    public boolean mouseDown(Event evt, int x, int y) {
        if (this.name.size() == 0) {
            return false;
        }
        this.chosen = x / (this.getSize().width / this.name.size());
        this.paint(this.getGraphics());
        ((TabbedPanel)this.getParent()).chose((String)this.name.elementAt(this.chosen));
        return true;
    }

    public Dimension minimumSize() {
        return new Dimension(50, 25);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }
}

