/*
 * Decompiled with CFR 0.152.
 */
package spectrum;

import edu.davidson.numerics.Parser;
import java.awt.Color;
import java.awt.Graphics;
import spectrum.SpectrumPanel;
import spectrum.SpectrumThing;

public class ABand
extends SpectrumThing {
    double lambda1 = 0.0;
    double lambda2 = 0.0;
    String inString = null;
    Parser iparser = null;

    public ABand(SpectrumPanel spectrumPanel, double d, double d2, String string) {
        super(spectrumPanel, Math.abs(0.5 * (d - d2)), Math.abs(d - d2), 0.0);
        this.lambda1 = Math.min(d, d2);
        this.lambda2 = Math.max(d, d2);
        if (this.setParse(string)) {
            this.inString = string;
        }
    }

    public double paintLambda(double d) {
        double d2;
        double d3;
        if (this.doppler) {
            d3 = this.dopplerShiftLine(this.lambda1, this.spectrumPanel.beta);
            d2 = this.dopplerShiftLine(this.lambda2, this.spectrumPanel.beta);
            double d4 = this.dopplerShiftLine(this.lineWidth, this.spectrumPanel.beta);
        } else {
            d3 = this.lambda1;
            d2 = this.lambda2;
            double d5 = this.lineWidth;
        }
        if (d < Math.min(d3, d2) || d > Math.max(d3, d2)) {
            return 0.0;
        }
        return -this.iparser.evaluate(d);
    }

    public boolean setParse(String string) {
        String string2 = string;
        boolean bl = true;
        string2.toLowerCase().trim();
        this.iparser = new Parser(1);
        this.iparser.define(string2);
        this.iparser.defineVariable(1, "h");
        this.iparser.parse();
        if (this.iparser.getErrorCode() != 0) {
            bl = false;
            System.out.println("Failed to parse f(h)): ".concat(String.valueOf(String.valueOf(string2))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in MathFunction: ").append(this.iparser.getErrorString()).append(" at function 1, position ").append(this.iparser.getErrorPosition()))));
        }
        return bl;
    }

    public void setNewLambda(double d) {
        if (d <= 0.0) {
            return;
        }
        this.lambda = d;
        double d2 = (this.lambda1 - this.lambda2) / (double)2;
        this.lambda1 = d - d2;
        this.lambda2 = d + d2;
    }

    void paintOS(Graphics graphics) {
        double d;
        double d2;
        Color color = Color.black;
        if (this.doppler) {
            d2 = this.dopplerShiftLine(this.lambda1, this.spectrumPanel.beta);
            d = this.dopplerShiftLine(this.lambda2, this.spectrumPanel.beta);
        } else {
            d2 = this.lambda1;
            d = this.lambda2;
        }
        int n = this.spectrumPanel.lambdaToPix(d2);
        int n2 = this.spectrumPanel.lambdaToPix(d);
        for (int i = n; i < n2; ++i) {
            if (i < 0 || i >= this.spectrumPanel.intensity.length) continue;
            int n3 = i;
            this.spectrumPanel.intensity[n3] = this.spectrumPanel.intensity[n3] + this.paintLambda(this.spectrumPanel.pixToLambda(i));
            if (this.spectrumPanel.intensity[i] > 1.0) {
                this.spectrumPanel.intensity[i] = 1.0;
            } else if (this.spectrumPanel.intensity[i] < 0.0) {
                this.spectrumPanel.intensity[i] = 0.0;
            }
            color = new Color((int)(this.spectrumPanel.intensity[i] * this.spectrumPanel.red[i]), (int)(this.spectrumPanel.intensity[i] * this.spectrumPanel.green[i]), (int)(this.spectrumPanel.intensity[i] * this.spectrumPanel.blue[i]));
            graphics.setColor(color);
            graphics.drawLine(i, 0, i, this.spectrumPanel.currentHeight);
        }
    }
}

