/*
 * Decompiled with CFR 0.152.
 */
package spectrum;

import java.awt.Color;
import java.awt.Graphics;
import spectrum.SpectrumPanel;
import spectrum.SpectrumThing;

public class Absorption
extends SpectrumThing {
    public Absorption(SpectrumPanel spectrumPanel, double d, double d2, double d3) {
        super(spectrumPanel, d, d2, d3);
    }

    public double paintLambda(double d) {
        double d2;
        double d3;
        if (this.doppler) {
            d3 = this.dopplerShiftLine(this.lambda, this.spectrumPanel.beta);
            d2 = this.dopplerShiftLine(this.lineWidth, this.spectrumPanel.beta);
        } else {
            d3 = this.lambda;
            d2 = this.lineWidth;
        }
        if (d < d3 - d2 / (double)2 || d > d3 + d2 / (double)2) {
            return 0.0;
        }
        return -this.in;
    }

    void paintOS(Graphics graphics) {
        double d;
        double d2;
        Color color = Color.black;
        if (this.doppler) {
            d2 = this.dopplerShiftLine(this.lambda, this.spectrumPanel.beta);
            d = this.dopplerShiftLine(this.lineWidth, this.spectrumPanel.beta);
        } else {
            d2 = this.lambda;
            d = this.lineWidth;
        }
        int n = this.spectrumPanel.lambdaToPix(d2 - d / 2.0);
        int n2 = this.spectrumPanel.lambdaToPix(d2 + d / 2.0);
        for (int i = n; i < n2; ++i) {
            if (i < 0 || i >= this.spectrumPanel.intensity.length) continue;
            int n3 = i;
            this.spectrumPanel.intensity[n3] = this.spectrumPanel.intensity[n3] + this.paintLambda(this.spectrumPanel.pixToLambda(i));
            if (this.spectrumPanel.intensity[i] > 1.0) {
                this.spectrumPanel.intensity[i] = 1.0;
            } else if (this.spectrumPanel.intensity[i] < 0.0) {
                this.spectrumPanel.intensity[i] = 0.0;
            }
            color = new Color((int)(this.spectrumPanel.intensity[i] * this.spectrumPanel.red[i]), (int)(this.spectrumPanel.intensity[i] * this.spectrumPanel.green[i]), (int)(this.spectrumPanel.intensity[i] * this.spectrumPanel.blue[i]));
            graphics.setColor(color);
            graphics.drawLine(i, 0, i, this.spectrumPanel.currentHeight);
        }
    }
}

