/*
 * Decompiled with CFR 0.152.
 */
package spectrum;

import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import spectrum.SpectrumPanel;
import spectrum.SpectrumThing;

public class Spectrum
extends SApplet {
    double minLambda = 350.0;
    double maxLambda = 700.0;
    String oneShotMessage = null;
    boolean trueColor = true;
    boolean falseColor = false;
    boolean firstTime = true;
    boolean isStandalone = false;
    boolean showControls;
    SpectrumPanel specPanel1 = new SpectrumPanel(this);
    EtchedBorder controlPanel = new EtchedBorder();
    Button goBtn = new Button();
    Button button2 = new Button();
    FlowLayout flowLayout2 = new FlowLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.minLambda = Double.valueOf(this.getParameter("Min", "400"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.maxLambda = Double.valueOf(this.getParameter("Max", "650"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.trueColor = Boolean.valueOf(this.getParameter("TrueColor", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.falseColor = Boolean.valueOf(this.getParameter("FalseColor", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setShowControls(this.showControls);
        this.setTrueColor(this.trueColor);
        this.setFalseColor(this.falseColor);
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setEnabled(true);
        ((Component)((Object)this)).setSize(new Dimension(310, 158));
        this.controlPanel.setLayout(this.flowLayout1);
        this.goBtn.setLabel("Run");
        this.goBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Spectrum.this.goBtn_actionPerformed(actionEvent);
            }
        });
        this.button2.setLabel("Balmer");
        this.button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Spectrum.this.button2_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this.specPanel1)).setLayout(this.flowLayout2);
        ((Container)((Object)this)).setLayout(this.borderLayout2);
        ((Container)((Object)this)).add((Component)((Object)this.specPanel1), "Center");
        ((Container)((Object)this)).add((Component)this.controlPanel, "South");
        this.controlPanel.add((Component)this.button2, null);
        this.controlPanel.add((Component)this.goBtn, null);
    }

    public void start() {
        super.start();
        this.specPanel1.setScale(this.minLambda, this.maxLambda);
    }

    public void runSpectrum() {
        this.specPanel1.runSpectrum();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"ShowControls", "boolean", ""}};
        return stringArray;
    }

    public void setShowControls(boolean bl) {
        this.showControls = bl;
        this.controlPanel.setVisible(this.showControls);
        this.controlPanel.invalidate();
        this.controlPanel.validate();
    }

    public void setOneShot(double d, double d2, String string) {
        this.clock.setOneShot(d, d2);
        this.setMessage(null);
        this.oneShotMessage = string;
    }

    protected void stoppingClock() {
        this.setMessage(this.oneShotMessage);
    }

    public void setMessage(String string) {
        this.specPanel1.setMessage(string);
    }

    public int addCaption(String string) {
        return this.specPanel1.addCaption(string);
    }

    public void setRGB(int n, int n2, int n3, int n4) {
        this.specPanel1.setRGB(n, n2, n3, n4);
    }

    public void setDisplayOffset(int n, int n2, int n3) {
        this.specPanel1.setDisplayOffset(n, n2, n3);
    }

    public int setCaption(int n, String string) {
        return this.specPanel1.setCaption(n, string);
    }

    public void setGroundState(int n, double d) {
        this.specPanel1.setGroundState(n, d);
    }

    public int addEmission(double d, double d2, double d3) {
        return this.specPanel1.addEmission(d, d2, d3);
    }

    public int addEmissionLine(double d, double d2, double d3) {
        return this.specPanel1.addEmissionLine(d, d2, d3);
    }

    public int addEmissionBand(double d, double d2, String string) {
        return this.specPanel1.addEmissionBand(d, d2, string);
    }

    public int addAbsorption(double d, double d2, double d3) {
        return this.specPanel1.addAbsorption(d, d2, d3);
    }

    public int addAbsorptionLine(double d, double d2, double d3) {
        return this.specPanel1.addAbsorptionLine(d, d2, d3);
    }

    public int addAbsorptionBand(double d, double d2, String string) {
        return this.specPanel1.addAbsorptionBand(d, d2, string);
    }

    public void addBlackBody(int n, double d) {
    }

    public void clearAllLines() {
        this.specPanel1.clearAllLines();
    }

    public void clearLine(int n) {
        this.specPanel1.clearLine(n);
    }

    public void clearCaption(int n) {
        this.specPanel1.clearCaption(n);
    }

    public void setScale(double d, double d2) {
        this.specPanel1.setScale(d, d2);
    }

    public void setDefault() {
        this.clearAllLines();
        this.setWavelengthUnit("nm");
        this.specPanel1.setScale(this.minLambda, this.maxLambda);
        this.setDopplerShift(0.0, false);
        this.specPanel1.showMessage = false;
    }

    public void setDopplerShift(double d, boolean bl) {
        this.specPanel1.setDopplerShift(d, bl);
    }

    public void setTrueColor(boolean bl) {
        this.specPanel1.setTrueColor(bl);
    }

    public void setFalseColor(boolean bl) {
        this.specPanel1.setFalseColor(bl);
    }

    void goBtn_actionPerformed(ActionEvent actionEvent) {
        this.clearAllLines();
        this.setScale(1.0, 1200.0);
        this.setDragable(this.addAbsorptionLine(500.0, 20.0, 1.0), true);
        this.addEmission(600.0, 1190.0, 1.0);
        this.runSpectrum();
    }

    void button2_actionPerformed(ActionEvent actionEvent) {
        this.setDefault();
        this.setAutoRefresh(false);
        this.addBalmerSeries(3, 8);
        this.autoScale();
        this.runSpectrum();
        this.setAutoRefresh(true);
    }

    public void addBalmerSeries(int n, int n2) {
        this.setWavelengthUnit("nm");
        this.specPanel1.addBalmerSeries(n, n2);
    }

    public void addLymanSeries(int n, int n2) {
        this.specPanel1.addLymanSeries(n, n2);
    }

    public void addPaschenSeries(int n, int n2) {
        this.specPanel1.addPaschenSeries(n, n2);
    }

    public void addBrackettSeries(int n, int n2) {
        this.specPanel1.addBrackettSeries(n, n2);
    }

    public void setAutoRefresh(boolean bl) {
        this.specPanel1.setAutoRefresh(bl);
    }

    public void autoScale() {
        this.specPanel1.autoScale();
    }

    public boolean setDragable(int n, boolean bl) {
        SpectrumThing spectrumThing = this.specPanel1.getThing(n);
        if (spectrumThing == null) {
            return false;
        }
        spectrumThing.dragable = bl;
        return true;
    }

    public void setIntensity(int n, double d) {
        this.specPanel1.setIntensity(n, d);
    }

    public void setWavelength(int n, double d) {
        this.specPanel1.setWavelength(n, d);
    }

    public void setWavelengthUnit(String string) {
        if (string.equals("cm")) {
            this.specPanel1.setWavelengthUnit(1);
        } else {
            this.specPanel1.setWavelengthUnit(0);
        }
    }

    public int getSpectrumID() {
        return ((Object)((Object)this.specPanel1)).hashCode();
    }

    public double getWavelength(int n) {
        return this.specPanel1.getWavelength(n);
    }

    public double getEnergy(int n) {
        return this.specPanel1.getEnergy(n);
    }

    public double getWidth(int n) {
        return this.specPanel1.getWidth(n);
    }

    public double getIntensity(int n) {
        SpectrumThing spectrumThing = this.specPanel1.getThing(n);
        return spectrumThing.in;
    }

    void specPanel1_mousePressed(MouseEvent mouseEvent) {
        this.clearAllLines();
        this.runSpectrum();
    }

    public static void main(String[] stringArray) {
        Spectrum spectrum = new Spectrum();
        spectrum.isStandalone = true;
        Frame frame = new Frame(){

            protected void processWindowEvent(WindowEvent windowEvent) {
                super.processWindowEvent(windowEvent);
                if (windowEvent.getID() == 201) {
                    System.exit(0);
                }
            }

            public synchronized void setTitle(String string) {
                super.setTitle(string);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("Spectrum Frame");
        frame.add((Component)((Object)spectrum), "Center");
        spectrum.init();
        spectrum.start();
        ((Component)frame).setSize(400, 320);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation((dimension.width - frame.getSize().width) / 2, (dimension.height - frame.getSize().height) / 2);
        ((Component)frame).setVisible(true);
    }
}

