/*
 * Decompiled with CFR 0.152.
 */
package spectrum;

import edu.davidson.display.Format;
import edu.davidson.display.SScalable;
import edu.davidson.graphics.SPanel;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;
import spectrum.ABand;
import spectrum.ALine;
import spectrum.Absorption;
import spectrum.Caption;
import spectrum.EBand;
import spectrum.ELine;
import spectrum.Emission;
import spectrum.SpectrumFrame;
import spectrum.SpectrumThing;
import spectrum.TextThing;
import spectrum.Title;

public class SpectrumPanel
extends SPanel
implements SDataSource,
SScalable {
    SApplet owner = null;
    static double rh = 0.010973732;
    static double clight = 0.2998;
    char lamChar = (char)34;
    Vector textVector = new Vector(20);
    Vector thingVector = new Vector(125);
    Vector emissionDataSources = new Vector();
    Format format = new Format("%7.3f");
    int unit = 0;
    double[] red = null;
    double[] blue = null;
    double[] green = null;
    double[] intensity = null;
    double[] saturation = null;
    int currentWidth = 0;
    int currentHeight = 0;
    int wallW = 0;
    double lbound = 400.0;
    double ubound = 650.0;
    Image osi = null;
    boolean falseColor = true;
    boolean trueColor = true;
    boolean autoRefresh = true;
    SpectrumThing dragThing = null;
    double lamPress = 0.0;
    double dopplerV = 0.0;
    double beta = 0.0;
    String[] varStrings = new String[]{"lambda", "intensity"};
    double[][] vars = new double[1][2];
    boolean showMessage = false;
    String message;
    int mouseX = 0;
    boolean mouseDown = false;

    public SpectrumPanel() {
    }

    public SpectrumPanel(SApplet sApplet) {
        this();
        this.owner = sApplet;
        try {
            SApplet.addDataSource((Object)((Object)this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void runSpectrum() {
        this.setBounds();
        this.fillMatrices();
        this.repaint();
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (bl) {
            this.runSpectrum();
        }
    }

    public void autoScale() {
        if (this.thingVector.isEmpty()) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 100.0;
        double d4 = 1.0E8;
        SpectrumThing spectrumThing = null;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            double d5;
            double d6;
            spectrumThing = (SpectrumThing)((Object)enumeration.nextElement());
            if (spectrumThing.doppler) {
                d6 = spectrumThing.dopplerShiftLine(spectrumThing.lambda, this.beta);
                d5 = spectrumThing.dopplerShiftLine(spectrumThing.lineWidth, this.beta);
            } else {
                d6 = spectrumThing.lambda;
                d5 = spectrumThing.lineWidth;
            }
            if (d6 + d5 / (double)2 > d) {
                d = d6 + d5 / (double)2;
                d2 = d5;
            }
            if (!(d6 - d5 / (double)2 < d4)) continue;
            d4 = d6 - d5 / (double)2;
            d3 = d5;
        }
        if (this.unit == 1) {
            d4 = this.nmToCm(d4);
            d = this.nmToCm(d);
            d3 = this.nmToCm(d3);
            d2 = this.nmToCm(d2);
        }
        this.setScale(d4 - (double)4 * d3, d + (double)4 * d2);
    }

    public void repaint() {
        this.paintOSI();
        Graphics graphics = ((Component)((Object)this)).getGraphics();
        if (graphics == null) {
            return;
        }
        this.paint(graphics);
        graphics.dispose();
        if (this.owner != null) {
            this.owner.clearData(((Object)((Object)this)).hashCode());
            this.owner.updateDataConnections();
        }
    }

    public void setBounds() {
        this.currentWidth = ((Component)((Object)this)).getSize().width;
        this.currentHeight = ((Component)((Object)this)).getSize().height;
        this.initializeMatrices();
        if (this.currentWidth < 2 || this.currentHeight < 2) {
            this.osi = null;
            return;
        }
        this.osi = ((Component)((Object)this)).createImage(this.currentWidth, this.currentHeight);
    }

    public double getLBound() {
        return this.lbound;
    }

    public double getUBound() {
        return this.ubound;
    }

    public void initializeMatrices() {
        this.red = new double[this.currentWidth];
        this.green = new double[this.currentWidth];
        this.blue = new double[this.currentWidth];
        this.intensity = new double[this.currentWidth];
        this.vars = new double[this.currentWidth][2];
    }

    public void fillMatrices() {
        if (this.falseColor) {
            this.makePalette();
        } else {
            this.makePalette2();
        }
        for (int i = 0; i < this.currentWidth; ++i) {
            this.intensity[i] = 0.0;
        }
    }

    void paintOSI() {
        if (this.osi == null || this.currentWidth != ((Component)((Object)this)).getBounds().width || this.currentHeight != ((Component)((Object)this)).getBounds().height) {
            this.setBounds();
        }
        if (this.osi == null) {
            return;
        }
        Graphics graphics = this.osi.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.currentWidth, this.currentHeight);
        this.paintThings(graphics);
        this.paintText(graphics);
        if (this.dragThing != null && this.mouseDown) {
            this.paintLambda(graphics, this.mouseX);
        }
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        if (this.osi == null) {
            return;
        }
        graphics.drawImage(this.osi, 0, 0, this.currentWidth, this.currentHeight, (ImageObserver)((Object)this));
    }

    void paintThings(Graphics graphics) {
        for (int i = 0; i < this.currentWidth; ++i) {
            this.intensity[i] = 0.0;
        }
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            SpectrumThing spectrumThing = (SpectrumThing)((Object)enumeration.nextElement());
            spectrumThing.paintOS(graphics);
        }
    }

    void paintText(Graphics graphics) {
        if (this.showMessage) {
            this.paintMessage(graphics);
        }
        TextThing textThing = null;
        Enumeration enumeration = this.textVector.elements();
        while (enumeration.hasMoreElements()) {
            textThing = (TextThing)enumeration.nextElement();
            textThing.paintOS(graphics);
        }
    }

    void makePalette() {
        for (int i = 0; i < this.currentWidth; ++i) {
            double d = this.lbound + (double)i * (this.ubound - this.lbound) / (double)this.currentWidth;
            if (!this.trueColor) {
                this.red[i] = 200.0;
                this.green[i] = 200.0;
                this.blue[i] = 200.0;
                continue;
            }
            if (d > (double)880) {
                this.green[i] = Math.min(200.0, (double)100 + (double)100 * (d - (double)880) / (double)100);
                this.red[i] = Math.min(255.0, (double)155 + (double)100 * (d - (double)880) / (double)100);
                this.blue[i] = Math.min(200.0, (double)100 + (double)100 * (d - (double)880) / (double)100);
                continue;
            }
            if (d > (double)730 && d <= (double)880) {
                this.green[i] = (double)100 * (d - (double)730) / (double)150;
                this.blue[i] = (double)100 * (d - (double)730) / (double)150;
                this.red[i] = (double)155 + (double)100 * ((double)880 - d) / (double)150;
                continue;
            }
            if (d >= (double)560 && d <= (double)750) {
                this.green[i] = d < (double)660 ? (double)255 * ((double)660 - d) / (double)100 : 0.0;
                this.red[i] = 255.0;
                this.blue[i] = 0.0;
                continue;
            }
            if (d < (double)560 && d >= (double)480) {
                this.green[i] = 255.0;
                this.red[i] = (double)255 * (d - (double)480) / (double)80;
                this.blue[i] = 0.0;
                continue;
            }
            if (d < (double)480 && d >= (double)440) {
                this.red[i] = 0.0;
                if (d > (double)460) {
                    this.green[i] = (double)200 + (double)55 * (d - (double)460) / (double)20;
                    this.blue[i] = (double)150 * ((double)480 - d) / (double)20;
                    continue;
                }
                this.green[i] = (double)200 * (d - (double)440) / (double)20;
                this.blue[i] = (double)150 + (double)105 * ((double)460 - d) / (double)20;
                continue;
            }
            if (d < (double)440 && d >= (double)400) {
                this.red[i] = (double)200 * ((double)440 - d) / (double)40;
                this.blue[i] = (double)255 - (double)55 * ((double)440 - d) / (double)40;
                this.green[i] = 0.0;
                continue;
            }
            if (d < (double)400 && d > (double)330) {
                this.red[i] = (double)200 * (d - (double)250) / (double)150;
                this.blue[i] = (double)200 * (d - (double)250) / (double)150;
                this.green[i] = (double)60 * (d - (double)330) / (double)70;
                continue;
            }
            if (d < (double)330) {
                this.red[i] = Math.min(200.0, (double)105 + (double)95 * ((double)330 - d) / (double)150);
                this.blue[i] = Math.min(255.0, (double)105 + (double)150 * ((double)330 - d) / (double)150);
                this.green[i] = Math.min(200.0, (double)60 + (double)140 * ((double)330 - d) / (double)150);
                continue;
            }
            this.red[i] = 0.0;
            this.blue[i] = 0.0;
            this.green[i] = 0.0;
        }
    }

    void makePalette2() {
        for (int i = 0; i < this.currentWidth; ++i) {
            double d = this.lbound + (double)i * (this.ubound - this.lbound) / (double)this.currentWidth;
            if (!this.trueColor) {
                this.red[i] = 200.0;
                this.green[i] = 200.0;
                this.blue[i] = 200.0;
                continue;
            }
            if (d > (double)880) {
                this.green[i] = Math.min(155.0, (double)100 + (double)155 * (d - (double)880) / (double)100);
                this.red[i] = 155.0;
                this.blue[i] = Math.min(155.0, (double)100 + (double)155 * (d - (double)880) / (double)100);
                continue;
            }
            if (d > (double)730 && d <= (double)880) {
                this.green[i] = (double)100 * (d - (double)730) / (double)150;
                this.blue[i] = (double)100 * (d - (double)730) / (double)150;
                this.red[i] = (double)155 + (double)100 * ((double)880 - d) / (double)150;
                continue;
            }
            if (d >= (double)560 && d <= (double)750) {
                this.green[i] = d < (double)660 ? (double)255 * ((double)660 - d) / (double)100 : 0.0;
                this.red[i] = 255.0;
                this.blue[i] = 0.0;
                continue;
            }
            if (d < (double)560 && d >= (double)480) {
                this.green[i] = 255.0;
                this.red[i] = (double)255 * (d - (double)480) / (double)80;
                this.blue[i] = 0.0;
                continue;
            }
            if (d < (double)480 && d >= (double)440) {
                this.red[i] = 0.0;
                if (d > (double)460) {
                    this.green[i] = (double)200 + (double)55 * (d - (double)460) / (double)20;
                    this.blue[i] = (double)150 * ((double)480 - d) / (double)20;
                    continue;
                }
                this.green[i] = (double)200 * (d - (double)440) / (double)20;
                this.blue[i] = (double)150 + (double)105 * ((double)460 - d) / (double)20;
                continue;
            }
            if (d < (double)440 && d >= (double)400) {
                this.red[i] = (double)200 * ((double)440 - d) / (double)40;
                this.blue[i] = (double)255 - (double)55 * ((double)440 - d) / (double)40;
                this.green[i] = 0.0;
                continue;
            }
            if (d < (double)400 && d > (double)330) {
                this.red[i] = (double)200 - (double)45 * ((double)400 - d) / (double)70;
                this.blue[i] = (double)200 - (double)45 * ((double)400 - d) / (double)70;
                this.green[i] = (double)155 * ((double)400 - d) / (double)200;
                continue;
            }
            if (d < (double)330) {
                this.red[i] = 155.0;
                this.blue[i] = 155.0;
                this.green[i] = Math.min(155.0, (double)155 * ((double)400 - d) / (double)200);
                continue;
            }
            this.red[i] = 0.0;
            this.blue[i] = 0.0;
            this.green[i] = 0.0;
        }
    }

    void setScale(double d, double d2) {
        this.lbound = Math.min(d, d2);
        this.ubound = Math.max(d, d2);
        if (this.unit == 1) {
            this.lbound = this.cmToNm(this.lbound);
            this.ubound = this.cmToNm(this.ubound);
        }
        if (this.autoRefresh) {
            this.runSpectrum();
        }
    }

    public void setWavelengthUnit(int n) {
        this.unit = n;
    }

    void setTrueColor(boolean bl) {
        this.trueColor = bl;
    }

    void setFalseColor(boolean bl) {
        this.falseColor = bl;
    }

    public void setGroundState(int n, double d) {
        SpectrumThing spectrumThing = this.getThing(n);
        if (this.unit == 1) {
            d *= 1.0E-6;
        }
        spectrumThing.gs = d;
    }

    public double getEnergy(int n) {
        SpectrumThing spectrumThing = this.getThing(n);
        double d = spectrumThing.calcEn();
        if (this.unit == 1) {
            d *= 1.0E8;
        }
        return d;
    }

    void setDopplerShift(double d, boolean bl) {
        if (d < 1.0 && d > (double)-1) {
            this.beta = d;
        }
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            SpectrumThing spectrumThing = (SpectrumThing)((Object)enumeration.nextElement());
            spectrumThing.doppler = bl;
        }
    }

    void clearAllLines() {
        this.thingVector.removeAllElements();
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void clearLine(int n) {
        SpectrumThing spectrumThing = this.getThing(n);
        this.thingVector.removeElement((Object)spectrumThing);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void clearCaption(int n) {
        TextThing textThing = this.getTextThing(n);
        this.textVector.removeElement(textThing);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public int addEmission(double d, double d2, double d3) {
        if (this.unit == 1) {
            d = this.cmToNm(d);
            d2 = this.cmToNm(d2);
        }
        Emission emission = new Emission(this, d, d2, d3);
        this.thingVector.addElement(emission);
        if (this.autoRefresh) {
            this.runSpectrum();
        }
        return ((Object)((Object)emission)).hashCode();
    }

    public int addEmissionLine(double d, double d2, double d3) {
        if (this.unit == 1) {
            d = this.cmToNm(d);
            d2 = this.cmToNm(d2);
        }
        ELine eLine = new ELine(this, d, d2, d3);
        this.thingVector.addElement(eLine);
        if (this.autoRefresh) {
            this.runSpectrum();
        }
        return ((Object)((Object)eLine)).hashCode();
    }

    public int addEmissionBand(double d, double d2, String string) {
        if (this.unit == 1) {
            d = this.cmToNm(d);
            d2 = this.cmToNm(d2);
        }
        EBand eBand = new EBand(this, d, d2, string);
        this.thingVector.addElement(eBand);
        if (this.autoRefresh) {
            this.runSpectrum();
        }
        return ((Object)((Object)eBand)).hashCode();
    }

    public int addAbsorption(double d, double d2, double d3) {
        if (this.unit == 1) {
            d = this.cmToNm(d);
            d2 = this.cmToNm(d2);
        }
        Absorption absorption = new Absorption(this, d, d2, d3);
        this.thingVector.addElement(absorption);
        if (this.autoRefresh) {
            this.runSpectrum();
        }
        return ((Object)((Object)absorption)).hashCode();
    }

    public int addAbsorptionLine(double d, double d2, double d3) {
        if (this.unit == 1) {
            d = this.cmToNm(d);
            d2 = this.cmToNm(d2);
        }
        ALine aLine = new ALine(this, d, d2, d3);
        this.thingVector.addElement(aLine);
        if (this.autoRefresh) {
            this.runSpectrum();
        }
        return ((Object)((Object)aLine)).hashCode();
    }

    public int addAbsorptionBand(double d, double d2, String string) {
        if (this.unit == 1) {
            d = this.cmToNm(d);
            d2 = this.cmToNm(d2);
        }
        ABand aBand = new ABand(this, d, d2, string);
        this.thingVector.addElement(aBand);
        if (this.autoRefresh) {
            this.runSpectrum();
        }
        return ((Object)((Object)aBand)).hashCode();
    }

    public void addBalmerSeries(int n, int n2) {
        double d = 0.0;
        int n3 = n2;
        if (n2 > n) {
            n2 = n;
            n = n3;
        }
        if (n2 < 3) {
            n2 = 3;
            n = 6;
        }
        for (int i = n2; i < n + 1; ++i) {
            d = 1.0 / (rh * (0.25 - 1.0 / (double)(i * i)));
            this.addEmissionLine(d, 4.0, 1.0);
        }
    }

    public void addPaschenSeries(int n, int n2) {
        double d = 0.0;
        int n3 = n2;
        if (n2 > n) {
            n2 = n;
            n = n3;
        }
        if (n2 < 4) {
            n2 = 4;
            n = 7;
        }
        for (int i = n2; i < n + 1; ++i) {
            double d2 = 0.1111111111111111 - 1.0 / (double)(i * i);
            d = 1.0 / (rh * d2);
            this.addEmissionLine(d, 10.0, 1.0);
        }
    }

    public void addLymanSeries(int n, int n2) {
        double d = 0.0;
        int n3 = n2;
        if (n2 > n) {
            n2 = n;
            n = n3;
        }
        if (n2 < 2) {
            n2 = 2;
            n = 5;
        }
        for (int i = n2; i < n + 1; ++i) {
            d = 1.0 / (rh * (1.0 - 1.0 / (double)(i * i)));
            this.addEmissionLine(d, 0.5, 1.0);
        }
    }

    public void addBrackettSeries(int n, int n2) {
        double d = 0.0;
        int n3 = n2;
        if (n2 > n) {
            n2 = n;
            n = n3;
        }
        if (n2 < 5) {
            n2 = 5;
            n = 8;
        }
        for (int i = n2; i < n + 1; ++i) {
            double d2 = 0.0625 - 1.0 / (double)(i * i);
            d = 1.0 / (rh * d2);
            this.addEmissionLine(d, 20.0, 1.0);
        }
    }

    public SpectrumThing getThing(int n) {
        SpectrumThing spectrumThing = null;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            spectrumThing = (SpectrumThing)((Object)enumeration.nextElement());
            if (((Object)((Object)spectrumThing)).hashCode() != n) continue;
            return spectrumThing;
        }
        return null;
    }

    public TextThing getTextThing(int n) {
        TextThing textThing = null;
        Enumeration enumeration = this.textVector.elements();
        while (enumeration.hasMoreElements()) {
            textThing = (TextThing)enumeration.nextElement();
            if (textThing.hashCode() != n) continue;
            return textThing;
        }
        return null;
    }

    public double getWavelength(int n) {
        SpectrumThing spectrumThing = this.getThing(n);
        if (this.unit == 1) {
            return spectrumThing.lambda * 1.0E-6;
        }
        return spectrumThing.lambda;
    }

    public double getWidth(int n) {
        SpectrumThing spectrumThing = this.getThing(n);
        if (this.unit == 1) {
            return spectrumThing.lineWidth * 1.0E-6;
        }
        return spectrumThing.lineWidth;
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                SpectrumPanel.this.this_mouseDragged(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                SpectrumPanel.this.this_mouseMoved(mouseEvent);
            }
        });
        ((Component)((Object)this)).addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SpectrumPanel.this.this_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                SpectrumPanel.this.this_mouseReleased(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                SpectrumPanel.this.this_mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                SpectrumPanel.this.this_mouseExited(mouseEvent);
            }
        });
    }

    private void paintMessage(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = Math.max(110, 10 + fontMetrics.stringWidth(this.message));
        graphics.setColor(Color.yellow);
        graphics.fillRect(this.currentWidth - n - 3, this.currentHeight - this.wallW - 18, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(this.message, this.currentWidth - n, this.currentHeight - this.wallW - 6);
    }

    private void paintLambda(Graphics graphics, int n) {
        String string = null;
        double d = this.lbound + (this.ubound - this.lbound) * (double)n / (double)this.currentWidth;
        if (this.unit == 1) {
            d = this.nmToCm(d);
            string = String.valueOf(String.valueOf(new StringBuffer("Wavelength: ").append(this.format.form(d)).append(" ").append("cm")));
        } else {
            string = String.valueOf(String.valueOf(new StringBuffer("Wavelength: ").append(this.format.form(d)).append(" ").append("nm")));
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n2 = Math.max(110, 10 + fontMetrics.stringWidth(string));
        graphics.setColor(Color.yellow);
        graphics.fillRect(3, this.currentHeight - this.wallW - 18, n2, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, 7, this.currentHeight - this.wallW - 6);
    }

    private void paintLambda(int n) {
        Graphics graphics = ((Component)((Object)this)).getGraphics();
        this.paintLambda(graphics, n);
        graphics.dispose();
    }

    void clearLambdaBox() {
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            if (this.osi == null) {
                return;
            }
            SpectrumFrame spectrumFrame = new SpectrumFrame(this.osi);
            spectrumFrame.setTitle(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.format.form(this.lbound)))).append(" ").append("nm").append(" ").append("to").append(" ").append(this.format.form(this.ubound)).append(" ").append("nm"))));
            spectrumFrame.show();
        } else {
            this.mouseDown = true;
            this.mouseX = mouseEvent.getX();
            this.paintLambda(this.mouseX);
        }
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseDown = false;
        this.repaint();
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        if (this.dragThing != null) {
            this.mouseX = Math.min(mouseEvent.getX(), this.currentWidth);
            this.mouseX = Math.max(0, this.mouseX);
            double d = this.lbound + (double)this.mouseX * (this.ubound - this.lbound) / (double)this.currentWidth;
            this.moveLine(this.dragThing, d);
            this.repaint();
        } else {
            this.paintLambda(mouseEvent.getX());
        }
    }

    public void moveLine(SpectrumThing spectrumThing, double d) {
        spectrumThing.setNewLambda(d);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setWavelength(int n, double d) {
        SpectrumThing spectrumThing = this.getThing(n);
        if (this.unit == 1) {
            d = this.cmToNm(d);
        }
        this.moveLine(spectrumThing, d);
    }

    public double nmToCm(double d) {
        return d * 1.0E-7;
    }

    public double cmToNm(double d) {
        return d * 1.0E7;
    }

    public void setIntensity(int n, double d) {
        SpectrumThing spectrumThing = this.getThing(n);
        spectrumThing.in = d;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    void this_mouseEntered(MouseEvent mouseEvent) {
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(1));
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        double d = this.lbound + (double)mouseEvent.getX() * (this.ubound - this.lbound) / (double)this.currentWidth;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            SpectrumThing spectrumThing = (SpectrumThing)((Object)enumeration.nextElement());
            if (!spectrumThing.isInside(d) || !spectrumThing.dragable) continue;
            this.dragThing = spectrumThing;
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(12));
            bl = true;
            break;
        }
        if (!bl) {
            this.dragThing = null;
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    void this_mouseExited(MouseEvent mouseEvent) {
        this.dragThing = null;
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
        this.repaint();
    }

    public void setMessage(String string) {
        this.showMessage = true;
        this.message = string;
    }

    public void setDisplayOffset(int n, int n2, int n3) {
        TextThing textThing = this.getTextThing(n);
        textThing.xoff = n2;
        textThing.yoff = n3;
    }

    public void setRGB(int n, int n2, int n3, int n4) {
        SpectrumThing spectrumThing = this.getThing(n);
        TextThing textThing = this.getTextThing(n);
        if (spectrumThing != null) {
            spectrumThing.colr = n2;
            spectrumThing.colg = n3;
            spectrumThing.colb = n4;
        } else if (textThing != null) {
            textThing.txtColor = new Color(n2, n3, n4);
        }
    }

    public int setCaption(int n, String string) {
        Caption caption = new Caption(this, n, string);
        this.textVector.addElement(caption);
        return caption.hashCode();
    }

    public int addCaption(String string) {
        Title title = new Title(this, string);
        this.textVector.addElement(title);
        return title.hashCode();
    }

    public synchronized int addEmissionDataSource(int n) {
        DataSource dataSource = new DataSource(n);
        this.emissionDataSources.addElement(dataSource);
        return dataSource.hashCode();
    }

    public int getID() {
        return ((Object)((Object)this)).hashCode();
    }

    public void setOwner(SApplet sApplet) {
        this.owner = sApplet;
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public double[][] getVariables() {
        for (int i = 0; i < this.currentWidth; ++i) {
            this.vars[i][0] = this.pixToLambda(i);
            this.vars[i][1] = this.intensity[i];
        }
        return this.vars;
    }

    double pixToLambda(int n) {
        double d = this.lbound + (double)n * (this.ubound - this.lbound) / (double)this.currentWidth;
        return d;
    }

    int lambdaToPix(double d) {
        int n = (int)Math.round((d - this.lbound) / (this.ubound - this.lbound) * (double)this.currentWidth);
        return n;
    }

    public double pixToIntensity(int n) {
        if (n < 0 || n >= this.intensity.length) {
            return 0.0;
        }
        return this.intensity[n];
    }

    public double xFromPix(int n) {
        return this.pixToLambda(n);
    }

    public double yFromPix(int n) {
        return 0.0;
    }

    public int pixFromX(double d) {
        return this.lambdaToPix(d);
    }

    public int pixFromY(double d) {
        return 0;
    }

    public int getPixWidth() {
        return this.currentWidth;
    }

    public int getPixHeight() {
        return this.currentHeight;
    }

    public class DataSource
    implements SDataSource {
        String[] varStrings = new String[]{"lam", "int", "w"};
        double[][] ds = new double[1][3];
        int index = 0;

        DataSource(int n) {
            this.index = n;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            SpectrumThing spectrumThing = SpectrumPanel.this.getThing(this.index);
            if (spectrumThing == null) {
                return this.ds;
            }
            this.ds[0][0] = spectrumThing.lambda;
            this.ds[0][1] = spectrumThing.in;
            this.ds[0][2] = spectrumThing.lineWidth;
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return SpectrumPanel.this.owner;
        }
    }
}

