/*
 * Decompiled with CFR 0.152.
 */
package spectrum;

import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Graphics;
import spectrum.SpectrumPanel;

public class SpectrumThing
extends Thing {
    SpectrumPanel spectrumPanel = null;
    SApplet sapplet = null;
    double lambda = 500.0;
    double lineWidth = 5.0;
    double in = 0.0;
    boolean dragable = false;
    boolean doppler = false;
    int colr = -1;
    int colb = -1;
    int colg = -1;
    double gs = 0.0;

    public SpectrumThing(SpectrumPanel spectrumPanel, double d, double d2, double d3) {
        super((SScalable)spectrumPanel, d, 0.0);
        this.spectrumPanel = spectrumPanel;
        this.sapplet = this.spectrumPanel.getOwner();
        if (d > 0.0) {
            this.lambda = d;
        }
        if (d2 > 0.0) {
            this.lineWidth = d2;
        }
        this.in = d3;
        this.varStrings = new String[]{"lambda", "width", "intensity", "lower"};
        this.ds = new double[1][4];
    }

    public final double[][] getVariables() {
        this.ds[0][0] = this.lambda;
        this.ds[0][1] = this.lineWidth;
        this.ds[0][2] = this.in;
        this.ds[0][3] = this.gs;
        return this.ds;
    }

    double paintLambda(double d) {
        return 1.0;
    }

    public boolean isInside(double d) {
        return d >= this.lambda - this.lineWidth / (double)2 && d <= this.lambda + this.lineWidth / (double)2;
    }

    public void setNewLambda(double d) {
        if (d > 0.0) {
            this.lambda = d;
        }
        this.sapplet.updateDataConnection(((Object)((Object)this)).hashCode());
    }

    double dopplerShiftLine(double d, double d2) {
        double d3 = SpectrumPanel.clight / d;
        double d4 = d3 * Math.sqrt(1.0 + d2) / Math.sqrt(1.0 - d2);
        return SpectrumPanel.clight / d4;
    }

    public double getX() {
        return this.lambda;
    }

    public void setX(double d) {
        super.setX(d);
        this.lambda = super.getX();
    }

    double calcEn() {
        if (this.lambda == 0.0) {
            return 0.0;
        }
        return -this.gs + 1.0 / this.lambda;
    }

    void paintOS(Graphics graphics) {
        double d;
        double d2;
        Color color = Color.black;
        if (this.doppler) {
            d2 = this.dopplerShiftLine(this.lambda, this.spectrumPanel.beta);
            d = this.dopplerShiftLine(this.lineWidth, this.spectrumPanel.beta);
        } else {
            d2 = this.lambda;
            d = this.lineWidth;
        }
        int n = this.spectrumPanel.lambdaToPix(d2 - d / 2.0);
        int n2 = this.spectrumPanel.lambdaToPix(d2 + d / 2.0);
        for (int i = n; i < n2; ++i) {
            if (i < 0 || i >= this.spectrumPanel.intensity.length) continue;
            if (this.colr >= 0) {
                color = new Color((int)((double)this.colr * this.paintLambda(this.spectrumPanel.pixToLambda(i))), (int)((double)this.colg * this.paintLambda(this.spectrumPanel.pixToLambda(i))), (int)((double)this.colb * this.paintLambda(this.spectrumPanel.pixToLambda(i))));
            } else {
                int n3 = i;
                this.spectrumPanel.intensity[n3] = this.spectrumPanel.intensity[n3] + this.paintLambda(this.spectrumPanel.pixToLambda(i));
                if (this.spectrumPanel.intensity[i] > 1.0) {
                    this.spectrumPanel.intensity[i] = 1.0;
                } else if (this.spectrumPanel.intensity[i] < 0.0) {
                    this.spectrumPanel.intensity[i] = 0.0;
                }
                color = new Color((int)(this.spectrumPanel.intensity[i] * this.spectrumPanel.red[i]), (int)(this.spectrumPanel.intensity[i] * this.spectrumPanel.green[i]), (int)(this.spectrumPanel.intensity[i] * this.spectrumPanel.blue[i]));
            }
            graphics.setColor(color);
            graphics.drawLine(i, 0, i, this.spectrumPanel.currentHeight);
        }
    }
}

