/*
 * Decompiled with CFR 0.152.
 */
package poisson;

import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import poisson.Poisson;
import poisson.PoissonPanel;
import poisson.PotentialObject;

public class CalcThing
extends Thing {
    private double[] tempVars = new double[5];
    private String calcStr;
    Parser calcFunc;
    private String text;

    public CalcThing(SApplet sApplet, SScalable sScalable, String string, String string2, double d, double d2) {
        super(sScalable, d, d2);
        this.applet = sApplet;
        this.font = new Font("Helvetica", 1, 14);
        this.text = string;
        this.calcStr = string2;
        if (this.calcStr == null) {
            return;
        }
        this.calcFunc = new Parser(5);
        this.calcFunc.defineVariable(1, "x");
        this.calcFunc.defineVariable(2, "y");
        this.calcFunc.defineVariable(3, "q");
        this.calcFunc.defineVariable(4, "v");
        this.calcFunc.defineVariable(5, "p");
        this.calcFunc.define(this.calcStr);
        this.calcFunc.parse();
        if (this.calcFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse calc-text: ".concat(String.valueOf(String.valueOf(this.calcStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.calcFunc.getErrorString()).append(" at function 1, position ").append(this.calcFunc.getErrorPosition()))));
            return;
        }
    }

    public final String getText() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.calcStr == null || this.calcFunc == null) {
            return this.text;
        }
        if (this.getMaster() != null && this.getMaster() instanceof PotentialObject) {
            PotentialObject potentialObject = (PotentialObject)this.getMaster();
            d2 = potentialObject.getCharge();
            d3 = potentialObject.getPotential();
            d4 = potentialObject.getPotentialEnergy();
        } else {
            PoissonPanel poissonPanel = ((Poisson)this.applet).poissonPanel;
            d3 = poissonPanel.getPotential(this.x, this.y);
        }
        this.tempVars[0] = this.x;
        this.tempVars[1] = this.y;
        this.tempVars[2] = d2;
        this.tempVars[3] = d3;
        this.tempVars[4] = d4;
        try {
            d = this.calcFunc.evaluate(this.tempVars);
            d = SUtil.chop((double)d, (double)1.0E-12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.text))).append(" ").append(this.format.form(d))));
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (!this.visible) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        int n = Math.round(this.canvas.pixFromX(this.x)) + this.xDisplayOff;
        int n2 = Math.round(this.canvas.pixFromY(this.y)) - this.yDisplayOff;
        graphics.setColor(this.color);
        graphics.drawString(this.getText(), n, n2);
        graphics.setColor(Color.black);
        graphics.setFont(font);
    }
}

