/*
 * Decompiled with CFR 0.152.
 */
package poisson;

import edu.davidson.display.BoxThing;
import edu.davidson.display.CaptionThing;
import edu.davidson.display.CircleThing;
import edu.davidson.display.ConnectorLine;
import edu.davidson.display.Constraint;
import edu.davidson.display.MarkerThing;
import edu.davidson.display.RectangleThing;
import edu.davidson.display.SNumber;
import edu.davidson.display.SScalable;
import edu.davidson.display.ShellThing;
import edu.davidson.display.Thing;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import poisson.ArrowThing2;
import poisson.BoxObject;
import poisson.CalcThing;
import poisson.CircleObject;
import poisson.ContourThing;
import poisson.FieldThing;
import poisson.PoissonPanel;
import poisson.Poisson_addCircleBtn_actionAdapter;
import poisson.Poisson_addRectBtn_actionAdapter;
import poisson.Poisson_clearBtn_actionAdapter;
import poisson.Poisson_contoursCkBox_itemAdapter;
import poisson.Poisson_fieldVectorsCkBox_itemAdapter;
import poisson.Poisson_gridCkBox_itemAdapter;
import poisson.Poisson_poissonPanel_mouseAdapter;
import poisson.Poisson_rhoCkBox_itemAdapter;
import poisson.Poisson_voltageNumber_actionAdapter;
import poisson.PotentialObject;
import poisson.RectObject;
import poisson.RingObject;
import poisson.TestChargeThing;

public class Poisson
extends SApplet {
    String button_oval = "Add Oval";
    String button_rect = "Add Rect";
    String button_reset = "Clear";
    String label_rhov = "rho|V";
    String label_contours = "Contours";
    String label_vectors = "Field Vectors";
    String label_grid = "Grid";
    String label_rho = "rho=";
    String label_v = "V=";
    String label_e = "|E|=";
    String label_calculating = "Calculating.";
    String label_not_converge = "Did not converge.";
    private boolean showContours = true;
    private boolean showFieldVectors = true;
    private boolean showGrid = false;
    private boolean drawChargeDensity = false;
    private boolean showControls = true;
    private int gridSize = 50;
    private String rangeStr;
    private boolean noDrag = true;
    private Color defaultColor = null;
    String testParam;
    String objectString;
    double defaultVoltage = 10.0;
    EtchedBorder bevelPanel1 = new EtchedBorder();
    FlowLayout flowLayout1 = new FlowLayout();
    Button addCircleBtn = new Button();
    Button addRectBtn = new Button();
    Button clearBtn = new Button();
    BorderLayout borderLayout1 = new BorderLayout();
    PoissonPanel poissonPanel = new PoissonPanel(this);
    SNumber voltageNumber = new SNumber();
    EtchedBorder bevelPanel2 = new EtchedBorder();
    Checkbox gridCkBox = new Checkbox();
    Checkbox contoursCkBox = new Checkbox();
    Checkbox fieldVectorsCkBox = new Checkbox();
    FlowLayout flowLayout2 = new FlowLayout();
    Checkbox rhoCkBox = new Checkbox();

    protected void setResources() {
        this.button_oval = this.localProperties.getProperty("button.oval", this.button_oval);
        this.button_rect = this.localProperties.getProperty("button.rect", this.button_rect);
        this.button_reset = this.localProperties.getProperty("button.reset", this.button_reset);
        this.label_rhov = this.localProperties.getProperty("label.rhov", this.label_rhov);
        this.label_contours = this.localProperties.getProperty("label.contours", this.label_contours);
        this.label_vectors = this.localProperties.getProperty("label.vectors", this.label_vectors);
        this.label_grid = this.localProperties.getProperty("label.grid", this.label_grid);
        this.label_calculating = this.localProperties.getProperty("label.calculating", this.label_calculating);
        this.label_e = this.localProperties.getProperty("label.e", this.label_e);
        this.label_v = this.localProperties.getProperty("label.v", this.label_v);
        this.label_rho = this.localProperties.getProperty("label.rho", this.label_rho);
        this.label_not_converge = this.localProperties.getProperty("label.not_converge", this.label_not_converge);
    }

    public void init() {
        this.initResources(null);
        int n = 0;
        try {
            this.rangeStr = this.getParameter("Range", "-1,1,-1,1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showContours = Boolean.valueOf(this.getParameter("ShowContours", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showGrid = Boolean.valueOf(this.getParameter("ShowGrid", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showFieldVectors = Boolean.valueOf(this.getParameter("ShowFieldVectors", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.gridSize = Integer.parseInt(this.getParameter("GridSize", "32"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            n = Integer.parseInt(this.getParameter("Gutter", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.poissonPanel.resizeMatrices(this.gridSize, this.gridSize, n);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.showControls) {
            this.poissonPanel.setVDisplay(this.voltageNumber);
            this.poissonPanel.setShowEOnDrag(true);
            this.poissonPanel.setShowVOnDrag(true);
            this.poissonPanel.setShowRhoOnDrag(true);
        }
        this.poissonPanel.setRange(this.rangeStr);
        this.poissonPanel.setShowContours(this.showContours);
        this.contoursCkBox.setState(this.showContours);
        this.poissonPanel.setShowGrid(this.showGrid);
        this.gridCkBox.setState(this.showGrid);
        this.poissonPanel.setShowFieldVectors(this.showFieldVectors);
        this.fieldVectorsCkBox.setState(this.showFieldVectors);
        this.poissonPanel.clearElements();
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setSize(new Dimension(400, 500));
        this.addCircleBtn.setActionCommand("addCircleBtn");
        this.addCircleBtn.setLabel(this.button_oval);
        this.addCircleBtn.addActionListener(new Poisson_addCircleBtn_actionAdapter(this));
        this.addRectBtn.setActionCommand("addRectBtn");
        this.addRectBtn.addActionListener(new Poisson_addRectBtn_actionAdapter(this));
        this.addRectBtn.setLabel(this.button_rect);
        this.clearBtn.setActionCommand("clearBtn");
        this.poissonPanel.addMouseListener(new Poisson_poissonPanel_mouseAdapter(this));
        this.voltageNumber.setValue(10.0);
        this.voltageNumber.addActionListener(new Poisson_voltageNumber_actionAdapter(this));
        this.bevelPanel2.setLayout(this.flowLayout2);
        this.gridCkBox.setLabel(this.label_grid);
        this.gridCkBox.addItemListener(new Poisson_gridCkBox_itemAdapter(this));
        this.contoursCkBox.setLabel(this.label_contours);
        this.contoursCkBox.addItemListener(new Poisson_contoursCkBox_itemAdapter(this));
        this.fieldVectorsCkBox.setLabel(this.label_vectors);
        this.rhoCkBox.setFont(new Font("Dialog", 1, 12));
        this.rhoCkBox.setLabel(this.label_rhov);
        this.rhoCkBox.addItemListener(new Poisson_rhoCkBox_itemAdapter(this));
        this.fieldVectorsCkBox.addItemListener(new Poisson_fieldVectorsCkBox_itemAdapter(this));
        this.clearBtn.addActionListener(new Poisson_clearBtn_actionAdapter(this));
        this.clearBtn.setLabel(this.button_reset);
        this.bevelPanel1.setLayout(this.flowLayout1);
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        if (this.showControls) {
            ((Container)((Object)this)).add((Component)this.bevelPanel1, "South");
        }
        this.bevelPanel1.add((Component)this.rhoCkBox, null);
        this.bevelPanel1.add((Component)this.voltageNumber, null);
        this.bevelPanel1.add((Component)this.addCircleBtn, null);
        this.bevelPanel1.add((Component)this.addRectBtn, null);
        this.bevelPanel1.add((Component)this.clearBtn, null);
        ((Container)((Object)this)).add(this.poissonPanel, "Center");
        if (this.showControls) {
            ((Container)((Object)this)).add((Component)this.bevelPanel2, "North");
        }
        this.bevelPanel2.add((Component)this.contoursCkBox, null);
        this.bevelPanel2.add((Component)this.fieldVectorsCkBox, null);
        this.bevelPanel2.add((Component)this.gridCkBox, null);
    }

    public void destroy() {
        this.poissonPanel.destroy();
        super.destroy();
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        if (this.firstTime) {
            this.firstTime = false;
            this.set(0, "charge", "plus,r=255,g=162,b=162");
            this.set(0, "charge", "minus,r=162,g=162,b=255");
        }
        super.start();
    }

    public synchronized int addConnectorLine(int n, int n2) {
        Thing thing = this.poissonPanel.getThing(n);
        Thing thing2 = this.poissonPanel.getThing(n2);
        thing = this.poissonPanel.getThing(n);
        thing2 = this.poissonPanel.getThing(n2);
        if (thing == null || thing2 == null) {
            System.out.println("Invalid id. Connector line not created in Poisson.");
            return 0;
        }
        ConnectorLine connectorLine = new ConnectorLine((SApplet)this, (SScalable)this.poissonPanel, thing, thing2);
        if (this.autoRefresh) {
            this.poissonPanel.repaint();
        }
        return connectorLine.hashCode();
    }

    public int addCircle(double d, double d2, int n, double d3) {
        CircleObject circleObject = this.poissonPanel.addPotCircle(n, d, d2, d3);
        circleObject.setNoDrag(this.noDrag);
        if (this.defaultColor != null) {
            circleObject.setColor(this.defaultColor);
        }
        this.poissonPanel.recalculate();
        return ((Object)((Object)circleObject)).hashCode();
    }

    public int addCircleCharge(double d, double d2, int n, double d3) {
        CircleObject circleObject = this.poissonPanel.addPotCircle(n, d, d2, d3);
        circleObject.setNoDrag(this.noDrag);
        circleObject.setChargeType(1);
        if (this.defaultColor != null) {
            circleObject.setColor(this.defaultColor);
        }
        if (this.autoRefresh) {
            this.poissonPanel.recalculate();
        }
        return ((Object)((Object)circleObject)).hashCode();
    }

    public synchronized int addObject(String string, String string2) {
        Object object = null;
        double d = 0.0;
        double d2 = 0.0;
        int n = 20;
        int n2 = 20;
        int n3 = 10;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("contour") || string.equals("contours")) {
            return this.poissonPanel.addContours();
        }
        if (string.equals("field")) {
            return this.poissonPanel.addField();
        }
        if (string.equals("box")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new BoxThing((SApplet)this, (SScalable)this.poissonPanel, d, d2, n, n2);
        } else if (string.equals("constraint")) {
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"xmin=")) {
                d3 = SUtil.getParam((String)string2, (String)"xmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=")) {
                d5 = SUtil.getParam((String)string2, (String)"ymin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmax=")) {
                d4 = SUtil.getParam((String)string2, (String)"xmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymax=")) {
                d6 = SUtil.getParam((String)string2, (String)"ymax=");
            }
            object = new Constraint((SApplet)this, (SScalable)this.poissonPanel, d3, d4, d5, d6);
        } else {
            if (string.equals("chargedensity") || string.equals("charge")) {
                double d7 = 10.0;
                int n4 = 20;
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"w=")) {
                    n = (int)SUtil.getParam((String)string2, (String)"w=");
                }
                if (SUtil.parameterExist((String)string2, (String)"h=")) {
                    n2 = (int)SUtil.getParam((String)string2, (String)"h=");
                }
                if (SUtil.parameterExist((String)string2, (String)"q=")) {
                    d7 = SUtil.getParam((String)string2, (String)"q=");
                }
                if (SUtil.parameterExist((String)string2, (String)"r=")) {
                    n3 = 2 * (int)SUtil.getParam((String)string2, (String)"r=");
                }
                if (SUtil.parameterExist((String)string2, (String)"s=")) {
                    n4 = (int)SUtil.getParam((String)string2, (String)"s=");
                }
                if (SUtil.parameterExist((String)string2, (String)"circle")) {
                    CircleObject circleObject = this.poissonPanel.addPotCircle(n3, d, d2, d7);
                    circleObject.setNoDrag(this.noDrag);
                    circleObject.setChargeType(1);
                    object = circleObject;
                } else if (SUtil.parameterExist((String)string2, (String)"ring") || SUtil.parameterExist((String)string2, (String)"shell")) {
                    RingObject ringObject = this.poissonPanel.addPotRing(n3, n4, d, d2, d7);
                    ringObject.setNoDrag(this.noDrag);
                    ringObject.setChargeType(1);
                    object = ringObject;
                } else if (SUtil.parameterExist((String)string2, (String)"box")) {
                    BoxObject boxObject = this.poissonPanel.addPotBox(n, n2, n4, d, d2, d7);
                    boxObject.setNoDrag(this.noDrag);
                    boxObject.setChargeType(1);
                    object = boxObject;
                } else {
                    RectObject rectObject = this.poissonPanel.addPotRect(n, n2, d, d2, d7);
                    rectObject.setNoDrag(this.noDrag);
                    rectObject.setChargeType(1);
                    object = rectObject;
                }
                if (this.autoRefresh) {
                    this.poissonPanel.recalculate();
                }
                if (this.defaultColor != null) {
                    object.setColor(this.defaultColor);
                }
                if (this.autoRefresh) {
                    this.poissonPanel.repaint();
                }
                return object.hashCode();
            }
            if (string.equals("conductor")) {
                double d8 = 10.0;
                int n5 = 20;
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"w=")) {
                    n = (int)SUtil.getParam((String)string2, (String)"w=");
                }
                if (SUtil.parameterExist((String)string2, (String)"h=")) {
                    n2 = (int)SUtil.getParam((String)string2, (String)"h=");
                }
                if (SUtil.parameterExist((String)string2, (String)"r=")) {
                    n3 = 2 * (int)SUtil.getParam((String)string2, (String)"r=");
                }
                if (SUtil.parameterExist((String)string2, (String)"s=")) {
                    n5 = (int)SUtil.getParam((String)string2, (String)"s=");
                }
                if (SUtil.parameterExist((String)string2, (String)"v=")) {
                    d8 = SUtil.getParam((String)string2, (String)"v=");
                }
                if (SUtil.parameterExist((String)string2, (String)"circle")) {
                    CircleObject circleObject = this.poissonPanel.addPotCircle(n3, d, d2, d8);
                    circleObject.setNoDrag(this.noDrag);
                    circleObject.setChargeType(0);
                    object = circleObject;
                } else if (SUtil.parameterExist((String)string2, (String)"ring") || SUtil.parameterExist((String)string2, (String)"shell")) {
                    RingObject ringObject = this.poissonPanel.addPotRing(n3, n5, d, d2, d8);
                    ringObject.setNoDrag(this.noDrag);
                    ringObject.setChargeType(0);
                    object = ringObject;
                } else if (SUtil.parameterExist((String)string2, (String)"box")) {
                    BoxObject boxObject = this.poissonPanel.addPotBox(n, n2, n5, d, d2, d8);
                    boxObject.setNoDrag(this.noDrag);
                    boxObject.setChargeType(0);
                    object = boxObject;
                } else {
                    RectObject rectObject = this.poissonPanel.addPotRect(n, n2, d, d2, d8);
                    rectObject.setNoDrag(this.noDrag);
                    rectObject.setChargeType(0);
                    object = rectObject;
                }
                if (this.autoRefresh) {
                    this.poissonPanel.recalculate();
                }
                if (this.defaultColor != null) {
                    object.setColor(this.defaultColor);
                }
                if (this.autoRefresh) {
                    this.poissonPanel.repaint();
                }
                return object.hashCode();
            }
            if (string.equals("dielectric")) {
                double d9 = 1.0;
                int n6 = 20;
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"w=")) {
                    n = (int)SUtil.getParam((String)string2, (String)"w=");
                }
                if (SUtil.parameterExist((String)string2, (String)"h=")) {
                    n2 = (int)SUtil.getParam((String)string2, (String)"h=");
                }
                if (SUtil.parameterExist((String)string2, (String)"r=")) {
                    n3 = 2 * (int)SUtil.getParam((String)string2, (String)"r=");
                }
                if (SUtil.parameterExist((String)string2, (String)"s=")) {
                    n6 = (int)SUtil.getParam((String)string2, (String)"s=");
                }
                if (SUtil.parameterExist((String)string2, (String)"chi=")) {
                    d9 = SUtil.getParam((String)string2, (String)"chi=");
                }
                d9 = Math.abs(d9);
                if (SUtil.parameterExist((String)string2, (String)"circle")) {
                    CircleObject circleObject = this.poissonPanel.addPotCircle(n3, d, d2, d9);
                    circleObject.setNoDrag(this.noDrag);
                    circleObject.setChargeType(2);
                    object = circleObject;
                } else if (SUtil.parameterExist((String)string2, (String)"ring") || SUtil.parameterExist((String)string2, (String)"shell")) {
                    RingObject ringObject = this.poissonPanel.addPotRing(n3, n6, d, d2, d9);
                    ringObject.setNoDrag(this.noDrag);
                    ringObject.setChargeType(2);
                    object = ringObject;
                } else if (SUtil.parameterExist((String)string2, (String)"box")) {
                    BoxObject boxObject = this.poissonPanel.addPotBox(n, n2, n6, d, d2, d9);
                    boxObject.setNoDrag(this.noDrag);
                    boxObject.setChargeType(2);
                    object = boxObject;
                } else {
                    RectObject rectObject = this.poissonPanel.addPotRect(n, n2, d, d2, d9);
                    rectObject.setNoDrag(this.noDrag);
                    rectObject.setChargeType(2);
                    object = rectObject;
                }
                if (this.autoRefresh) {
                    this.poissonPanel.recalculate();
                }
                if (this.defaultColor != null) {
                    object.setColor(this.defaultColor);
                }
                if (this.autoRefresh) {
                    this.poissonPanel.repaint();
                }
                return object.hashCode();
            }
            if (string.equals("connectorline")) {
                int n7 = 0;
                int n8 = 0;
                if (SUtil.parameterExist((String)string2, (String)"id1=")) {
                    n7 = (int)SUtil.getParam((String)string2, (String)"id1=");
                }
                if (SUtil.parameterExist((String)string2, (String)"id2=")) {
                    n8 = (int)SUtil.getParam((String)string2, (String)"id2=");
                }
                Thing thing = this.poissonPanel.getThing(n7);
                Thing thing2 = this.poissonPanel.getThing(n8);
                object = new ConnectorLine((SApplet)this, (SScalable)this.poissonPanel, thing, thing2);
            } else if (string.equals("rectangle")) {
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"w=")) {
                    n = (int)SUtil.getParam((String)string2, (String)"w=");
                }
                if (SUtil.parameterExist((String)string2, (String)"h=")) {
                    n2 = (int)SUtil.getParam((String)string2, (String)"h=");
                }
                object = new RectangleThing((SApplet)this, (SScalable)this.poissonPanel, d, d2, n, n2);
            } else if (string.equals("circle")) {
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"r=")) {
                    n3 = (int)SUtil.getParam((String)string2, (String)"r=");
                }
                object = new CircleThing((SApplet)this, (SScalable)this.poissonPanel, d, d2, n3);
            } else if (string.equals("testcharge")) {
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"r=")) {
                    n3 = (int)SUtil.getParam((String)string2, (String)"r=");
                }
                object = new TestChargeThing(this, this.poissonPanel, d, d2, n3);
            } else if (string.equals("cursor")) {
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"r=")) {
                    n3 = (int)SUtil.getParam((String)string2, (String)"r=");
                }
                object = new MarkerThing((SApplet)this, (SScalable)this.poissonPanel, 2 * n3 + 1, d, d2);
            } else if (string.equals("shell")) {
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"r=")) {
                    n3 = (int)SUtil.getParam((String)string2, (String)"r=");
                }
                object = new ShellThing((SApplet)this, (SScalable)this.poissonPanel, d, d2, n3);
            } else if (string.equals("arrow")) {
                String string4 = "1";
                String string5 = "1";
                int n9 = 4;
                if (SUtil.parameterExist((String)string2, (String)"s=")) {
                    n9 = (int)SUtil.getParam((String)string2, (String)"s=");
                }
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"h=")) {
                    string4 = SUtil.getParamStr((String)string2, (String)"h=");
                }
                if (SUtil.parameterExist((String)string2, (String)"v=")) {
                    string5 = SUtil.getParamStr((String)string2, (String)"v=");
                }
                object = new ArrowThing2(this, this.poissonPanel, n9, string4, string5, d, d2);
            } else if (string.equals("text")) {
                String string6 = "";
                String string7 = null;
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                    string6 = SUtil.getParamStr((String)string3, (String)"txt=");
                }
                if (SUtil.parameterExist((String)string2, (String)"text=")) {
                    string6 = SUtil.getParamStr((String)string3, (String)"text=");
                }
                if (SUtil.parameterExist((String)string2, (String)"calc=")) {
                    string7 = SUtil.getParamStr((String)string2, (String)"calc=");
                }
                object = new CalcThing(this, this.poissonPanel, string6, string7, d, d2);
            } else if (string.equals("caption")) {
                String string8 = "";
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                    string8 = SUtil.getParamStr((String)string3, (String)"txt=");
                }
                if (SUtil.parameterExist((String)string2, (String)"text=")) {
                    string8 = SUtil.getParamStr((String)string3, (String)"text=");
                }
                object = new CaptionThing((SApplet)this, (SScalable)this.poissonPanel, string8, d, d2);
            } else if (string.equals("function")) {
                String string9 = "0";
                String string10 = "x";
                if (SUtil.parameterExist((String)string2, (String)"f=")) {
                    string9 = SUtil.getParamStr((String)string2, (String)"f=");
                }
                if (SUtil.parameterExist((String)string2, (String)"var=")) {
                    string10 = SUtil.getParamStr((String)string2, (String)"var=");
                }
                int n10 = this.poissonPanel.contour.addFunction(string10, string9);
                if (SUtil.parameterExist((String)string2, (String)"xmin=") && SUtil.parameterExist((String)string2, (String)"xmax=")) {
                    int n11 = 100;
                    n11 = Math.max(this.poissonPanel.getSize().width / 2, n11);
                    if (SUtil.parameterExist((String)string2, (String)"n=")) {
                        n11 = (int)SUtil.getParam((String)string2, (String)"n=");
                    }
                    double d10 = SUtil.getParam((String)string2, (String)"xmin=");
                    double d11 = SUtil.getParam((String)string2, (String)"xmax=");
                    this.poissonPanel.contour.setFunctionRange(n10, d10, d11, n11);
                }
                return n10;
            }
        }
        if (object == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2))));
            return 0;
        }
        if (this.defaultColor != null) {
            object.setColor(this.defaultColor);
        }
        if (this.autoRefresh) {
            this.poissonPanel.repaint();
        }
        this.poissonPanel.addThing((Thing)object);
        return object.hashCode();
    }

    public int addRectangle(double d, double d2, int n, int n2, double d3) {
        RectObject rectObject = this.poissonPanel.addPotRect(n, n2, d, d2, d3);
        rectObject.setNoDrag(this.noDrag);
        if (this.defaultColor != null) {
            rectObject.setColor(this.defaultColor);
        }
        if (this.autoRefresh) {
            this.poissonPanel.recalculate();
        }
        return ((Object)((Object)rectObject)).hashCode();
    }

    public int addRectangleCharge(double d, double d2, int n, int n2, double d3) {
        RectObject rectObject = this.poissonPanel.addPotRect(n, n2, d, d2, d3);
        rectObject.setNoDrag(this.noDrag);
        rectObject.setChargeType(1);
        if (this.defaultColor != null) {
            rectObject.setColor(this.defaultColor);
        }
        if (this.autoRefresh) {
            this.poissonPanel.recalculate();
        }
        return ((Object)((Object)rectObject)).hashCode();
    }

    public String getAppletInfo() {
        return "Solve Poisson's equation for conductors and charge distributions. wochristian@davidson.edu";
    }

    public synchronized boolean set(int n, String string, String string2) {
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        String string4 = "false";
        double d = this.poissonPanel.contour.getMinX();
        double d2 = this.poissonPanel.contour.getMaxX();
        double d3 = this.poissonPanel.contour.getMinY();
        double d4 = this.poissonPanel.contour.getMaxY();
        if (string.equals("scale")) {
            if (SUtil.parameterExist((String)string2, (String)"xmin=")) {
                d = SUtil.getParam((String)string2, (String)"xmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmax=")) {
                d2 = SUtil.getParam((String)string2, (String)"xmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmin=") || SUtil.parameterExist((String)string2, (String)"xmax=")) {
                this.poissonPanel.setXRange(d, d2);
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=")) {
                d3 = SUtil.getParam((String)string2, (String)"ymin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymax=")) {
                d4 = SUtil.getParam((String)string2, (String)"ymax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=") || SUtil.parameterExist((String)string2, (String)"ymax=")) {
                this.poissonPanel.setYRange(d3, d4);
            }
            return true;
        }
        if (string.equals("charge")) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            if (SUtil.parameterExist((String)string2, (String)"g=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"g=");
            }
            if (SUtil.parameterExist((String)string2, (String)"b=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"b=");
            }
            Color color = new Color(n2, n3, n4);
            if (SUtil.parameterExist((String)string2, (String)"positive") || SUtil.parameterExist((String)string2, (String)"plus")) {
                this.poissonPanel.positiveChargeColor = color;
            } else {
                this.poissonPanel.negativeChargeColor = color;
            }
            return true;
        }
        if (string.equals("chargescale")) {
            double d5 = 10.0;
            if (SUtil.parameterExist((String)string2, (String)"scale=")) {
                d5 = SUtil.getParam((String)string2, (String)"scale=");
            }
            this.poissonPanel.inducedChargeScale = d5;
            return true;
        }
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2))));
            return false;
        }
        return true;
    }

    public boolean setAnimationSlave(int n, int n2) {
        Thing thing = this.poissonPanel.getThing(n);
        Thing thing2 = this.poissonPanel.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        thing.addSlave(thing2);
        if (this.autoRefresh) {
            this.poissonPanel.repaint();
        }
        return true;
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        this.poissonPanel.setAutoRefresh(bl);
    }

    void setBtnOff() {
        this.addCircleBtn.setForeground(Color.black);
        this.addRectBtn.setForeground(Color.black);
    }

    public void setCaption(String string) {
        this.poissonPanel.setCaption(string);
    }

    public boolean setConnector(int n, int n2, int n3) {
        Thing thing = this.poissonPanel.getThing(n);
        Thing thing2 = this.poissonPanel.getThing(n2);
        Thing thing3 = this.poissonPanel.getThing(n3);
        if (thing == null || thing2 == null || thing3 == null) {
            return false;
        }
        if (!(thing instanceof ConnectorLine)) {
            return false;
        }
        ((ConnectorLine)thing).setConnectorIDs(thing2, thing3);
        return true;
    }

    public boolean setConstraint(int n, int n2) {
        Thing thing = this.poissonPanel.getThing(n);
        Thing thing2 = this.poissonPanel.getThing(n2);
        if (thing == null) {
            return false;
        }
        if (thing2 == null) {
            return false;
        }
        if (!(thing2 instanceof Constraint)) {
            return false;
        }
        thing.setConstraint((Constraint)thing2);
        return true;
    }

    public void setDefaultRGB(int n, int n2, int n3) {
        this.defaultColor = new Color(n, n2, n3);
    }

    public void setDefault() {
        this.deleteDataConnections();
        this.setShowFieldVectors(false);
        this.setShowContours(true);
        this.setShowGrid(false);
        this.noDrag = true;
        this.defaultColor = null;
        this.poissonPanel.setDefault();
    }

    public boolean setDisplayOffset(int n, int n2, int n3) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDisplayOff(n2, n3);
        if (this.autoRefresh) {
            this.poissonPanel.repaint();
        }
        return true;
    }

    public void setDefaultDragable(boolean bl) {
        this.noDrag = !bl;
    }

    public void setShowFieldVectors(boolean bl) {
        this.fieldVectorsCkBox.setState(bl);
        this.showFieldVectors = bl;
        this.poissonPanel.setShowFieldVectors(bl);
    }

    public boolean setShowCharge(int n, boolean bl) {
        Thing thing = this.poissonPanel.getThing(n);
        if (n == 0) {
            this.poissonPanel.setShowCharge(bl);
            return true;
        }
        if (thing == null) {
            return false;
        }
        if (!(thing instanceof PotentialObject)) {
            return false;
        }
        PotentialObject potentialObject = (PotentialObject)thing;
        potentialObject.setShowCharge(bl);
        if (this.autoRefresh) {
            this.poissonPanel.repaint();
        }
        return true;
    }

    public void setShowContours(boolean bl) {
        this.contoursCkBox.setState(bl);
        this.poissonPanel.setShowContours(bl);
        this.showContours = bl;
    }

    public void setShowGrid(boolean bl) {
        this.gridCkBox.setState(bl);
        this.poissonPanel.setShowGrid(bl);
        this.showGrid = bl;
    }

    public boolean setDragable(int n, boolean bl) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDragable(bl);
        return true;
    }

    public boolean setResizable(int n, boolean bl) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setResizable(bl);
        return true;
    }

    public boolean setConstantQ(int n, double d, boolean bl) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        if (!(thing instanceof PotentialObject)) {
            return false;
        }
        PotentialObject potentialObject = (PotentialObject)thing;
        potentialObject.setConstantQ(d, bl);
        if (this.autoRefresh) {
            this.poissonPanel.recalculate();
        }
        return true;
    }

    public boolean setVoltage(int n, double d) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        if (!(thing instanceof PotentialObject)) {
            return false;
        }
        PotentialObject potentialObject = (PotentialObject)thing;
        potentialObject.setVoltage(d);
        if (this.autoRefresh) {
            this.poissonPanel.recalculate();
        }
        return true;
    }

    public double getXPos(int n) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getX();
    }

    public double getYPos(int n) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getY();
    }

    public boolean setXPos(int n, double d) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setX(d);
        thing.updateMySlaves();
        if (this.autoRefresh && thing instanceof PotentialObject) {
            this.poissonPanel.recalculate();
        }
        return true;
    }

    public boolean setYPos(int n, double d) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setY(d);
        thing.updateMySlaves();
        if (this.autoRefresh && thing instanceof PotentialObject) {
            this.poissonPanel.recalculate();
        }
        return true;
    }

    public boolean setXYPos(int n, double d, double d2) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setX(d);
        thing.setY(d2);
        thing.updateMySlaves();
        if (this.autoRefresh && thing instanceof PotentialObject) {
            this.poissonPanel.recalculate();
        }
        return true;
    }

    public boolean setChi(int n, double d) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        if (!(thing instanceof PotentialObject)) {
            return false;
        }
        PotentialObject potentialObject = (PotentialObject)thing;
        potentialObject.setChi(d);
        if (this.autoRefresh) {
            this.poissonPanel.recalculate();
        }
        return true;
    }

    public boolean setChargeDensity(int n, double d) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        if (!(thing instanceof PotentialObject)) {
            return false;
        }
        PotentialObject potentialObject = (PotentialObject)thing;
        potentialObject.setChargeDensity(d);
        if (this.autoRefresh) {
            this.poissonPanel.recalculate();
        }
        return true;
    }

    public boolean setVisibility(int n, boolean bl) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setVisible(bl);
        if (thing instanceof FieldThing) {
            this.setShowFieldVectors(bl);
        }
        if (thing instanceof ContourThing) {
            this.setShowContours(bl);
        }
        if (this.autoRefresh) {
            this.poissonPanel.repaint();
        }
        return true;
    }

    public void setFieldResolution(int n) {
        this.poissonPanel.setFieldResolution(n);
    }

    public void setGutter(int n) {
        this.poissonPanel.setGutter(n);
    }

    public boolean setFont(int n, String string, int n2, int n3) {
        Font font = new Font(string, n2, n3);
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null || font == null) {
            return false;
        }
        thing.setFont(font);
        if (this.poissonPanel.autoRefresh) {
            this.poissonPanel.repaint();
        }
        return true;
    }

    public boolean setObjectFont(int n, String string, int n2, int n3) {
        return this.setFont(n, string, n2, n3);
    }

    public boolean setFormat(int n, String string) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setFormat(string);
        if (this.poissonPanel.autoRefresh) {
            this.poissonPanel.repaint();
        }
        return true;
    }

    public void setMessage(String string) {
        this.poissonPanel.setMessage(string);
    }

    public void setMaxIterations(int n) {
        this.poissonPanel.setMaxIterations(n);
    }

    public void setTolerance(double d) {
        this.poissonPanel.setTolerance(d);
    }

    public void setDrawChargeDensity(boolean bl) {
        this.rhoCkBox.setState(bl);
        if (bl) {
            this.poissonPanel.setDefaultChargeType(1);
        } else {
            this.poissonPanel.setDefaultChargeType(0);
        }
        this.drawChargeDensity = bl;
    }

    public void setXRange(double d, double d2) {
        this.poissonPanel.setXRange(d, d2);
    }

    public void setYRange(double d, double d2) {
        this.poissonPanel.setYRange(d, d2);
    }

    public void setShowEOnDrag(boolean bl) {
        this.poissonPanel.setShowEOnDrag(bl);
    }

    public void setShowRhoOnDrag(boolean bl) {
        this.poissonPanel.setShowRhoOnDrag(bl);
    }

    public void setShowVOnDrag(boolean bl) {
        this.poissonPanel.setShowVOnDrag(bl);
    }

    public boolean setRGB(int n, int n2, int n3, int n4) {
        Thing thing = this.poissonPanel.getThing(n);
        if (thing == null) {
            this.poissonPanel.contour.setObjectColor(n, new Color(n2, n3, n4));
            return false;
        }
        thing.setColor(new Color(n2, n3, n4));
        if (this.autoRefresh) {
            this.poissonPanel.repaint();
        }
        return true;
    }

    public int getPotentialArrayID() {
        return this.poissonPanel.getPotentialArrayID();
    }

    public int getChargeArrayID() {
        return this.poissonPanel.getChargeArrayID();
    }

    public int getEnsembleID() {
        return this.poissonPanel.getID();
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"ShowControls", "boolean", "Show controls at bottom of applet."}, {"Range", "String", "xmin, xmax, ymin, ymax"}, {"GridSize", "int", "Number of grid points along x."}};
        return stringArray;
    }

    void addCircleBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.addCircleBtn.getForeground() == Color.blue) {
            this.setNull();
            this.setBtnOff();
        } else {
            this.objectString = "circle";
            this.poissonPanel.setObjectString(this.objectString);
            this.poissonPanel.makeActiveElementNull();
            this.poissonPanel.setDefaultVoltate(this.voltageNumber.getValue());
            this.setBtnOff();
            this.addCircleBtn.setForeground(Color.blue);
        }
    }

    void addRectBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.addRectBtn.getForeground() == Color.blue) {
            this.setNull();
            this.setBtnOff();
        } else {
            this.objectString = "rect";
            this.poissonPanel.setObjectString(this.objectString);
            this.poissonPanel.makeActiveElementNull();
            this.poissonPanel.setDefaultVoltate(this.voltageNumber.getValue());
            this.setBtnOff();
            this.addRectBtn.setForeground(Color.blue);
        }
    }

    void clearBtn_actionPerformed(ActionEvent actionEvent) {
        this.poissonPanel.clearElements();
    }

    void voltageNumber_actionPerformed(ActionEvent actionEvent) {
        this.poissonPanel.setActiveElementVoltage(this.voltageNumber.getValue());
    }

    void setNull() {
        this.objectString = null;
        this.poissonPanel.setObjectString(this.objectString);
        this.setBtnOff();
    }

    void fieldVectorsCkBox_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.poissonPanel.setShowFieldVectors(true);
            this.showFieldVectors = true;
        } else {
            this.poissonPanel.setShowFieldVectors(false);
            this.showFieldVectors = false;
        }
    }

    void contoursCkBox_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.poissonPanel.setShowContours(true);
            this.showContours = true;
        } else {
            this.poissonPanel.setShowContours(false);
            this.showContours = false;
        }
    }

    void gridCkBox_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.poissonPanel.setShowGrid(true);
            this.showGrid = true;
        } else {
            this.poissonPanel.setShowGrid(false);
            this.showGrid = false;
        }
    }

    void poissonPanel_mouseReleased(MouseEvent mouseEvent) {
        this.setNull();
    }

    void rhoCkBox_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.poissonPanel.setDefaultChargeType(1);
            this.drawChargeDensity = true;
        } else {
            this.poissonPanel.setDefaultChargeType(0);
            this.drawChargeDensity = false;
        }
    }
}

