/*
 * Decompiled with CFR 0.152.
 */
package poisson;

import edu.davidson.display.Format;
import edu.davidson.display.SContour;
import edu.davidson.display.SNumber;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import poisson.BoxObject;
import poisson.CircleObject;
import poisson.ContourThing;
import poisson.FieldThing;
import poisson.Poisson;
import poisson.PoissonPanel_mouseAdapter;
import poisson.PoissonPanel_mouseMotionAdapter;
import poisson.PotentialObject;
import poisson.RectObject;
import poisson.RingObject;
import poisson.VectorField;

public final class PoissonPanel
extends Panel
implements Runnable,
SScalable,
SDataSource {
    private boolean hasFieldThing = false;
    private boolean hasContourThing = false;
    private boolean keepRunning = true;
    private int vectorResolution = 2;
    private String newObjectString = null;
    private int gutter = 0;
    private int gutter2 = 0;
    private int xPts = 8;
    private int yPts = 8;
    private int xPtsg = 8;
    private int yPtsg = 8;
    private int xPts2g = 8;
    private int yPts2g = 8;
    private boolean invalidPotential = false;
    private Font f = new Font("Helvetica", 1, 12);
    private String message = null;
    private Thread runThread = null;
    private int sleepTime = 30;
    VectorField field = new VectorField(this.yPts, this.xPts);
    private boolean[][] isConductor = new boolean[this.xPts + 2 * this.gutter][this.yPts + 2 * this.gutter];
    private double[][] potential = new double[this.xPts + 2 * this.gutter][this.yPts + 2 * this.gutter];
    private double[][] charge = new double[this.xPts + 2 * this.gutter][this.yPts + 2 * this.gutter];
    private double[][] dielectric = new double[this.xPts + 2 * this.gutter][this.yPts + 2 * this.gutter];
    private double[][] displaymatrix = new double[this.xPts][this.yPts];
    private double defaultVoltage = 10.0;
    private Format format = new Format("%-+8.4g");
    private int boxWidth = 0;
    private boolean isDrag = false;
    private SNumber vDisplay = null;
    private double contourInterval = 1.0;
    private String caption = null;
    private boolean showCharge = false;
    private int defaultChargeType = 0;
    private boolean showRhoOnDrag = false;
    private int mouseX = 0;
    private int mouseY = 0;
    private int maxInterations = 200;
    protected String[] varStrings = new String[]{"p", "q"};
    protected double[][] ds = new double[1][2];
    Poisson owner = null;
    PContour contour = new PContour();
    ChargeDataSource chargeDataSource = null;
    PotentialDataSource potentialDataSource = null;
    double tolerance = 0.002;
    boolean showContours = true;
    boolean showGrid = true;
    boolean showFieldVectors = true;
    boolean showCoordOnDrag = true;
    boolean showVOnDrag = true;
    boolean showEOnDrag = true;
    double xPixPerCell = 0.0;
    double yPixPerCell = 0.0;
    double xUnitPerCell = 0.0;
    double yUnitPerCell = 0.0;
    double xmin = -1.0;
    double xmax = 1.0;
    double ymin = -1.0;
    double ymax = 1.0;
    boolean autoRefresh = true;
    Color positiveChargeColor = Color.red;
    Color negativeChargeColor = Color.blue;
    double inducedChargeScale = 10.0;
    int maxNumber = 1024;
    int iwidth;
    int iheight;
    int dx;
    int dy;
    int hotSpot;
    Vector things = new Vector();
    PotentialObject activeElement = null;
    Thing dragThing = null;
    Image osi;

    public PoissonPanel(Poisson poisson, int n, int n2) {
        this.owner = poisson;
        this.resizeMatrices(n, n2, this.gutter);
        this.addMouseMotionListener(new PoissonPanel_mouseMotionAdapter(this));
        this.addMouseListener(new PoissonPanel_mouseAdapter(this));
        this.contour.setShowAxis(false);
        this.contour.setDataBackground(Color.white);
        this.contour.setLabelColor(Color.green);
        this.contour.setDrawLabels(false);
        this.contour.setOwner(this.owner);
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PoissonPanel(Poisson poisson) {
        this(poisson, 50, 50);
    }

    public void setOwner(SApplet sApplet) {
        this.owner = (Poisson)sApplet;
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public int getID() {
        return this.hashCode();
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.calcPotentialEnergy();
        this.ds[0][1] = 0.0;
        return this.ds;
    }

    public CircleObject addPotCircle(int n, double d, double d2, double d3) {
        if (this.things.size() >= this.maxNumber) {
            return null;
        }
        CircleObject circleObject = new CircleObject(this, d, d2, d3);
        n = Math.max(n, (int)(this.xPixPerCell * (double)3));
        n = Math.max(n, (int)(this.yPixPerCell * (double)3));
        circleObject.setWidth(n);
        circleObject.setHeight(n);
        this.things.addElement(circleObject);
        if (this.autoRefresh) {
            this.recalculate();
        }
        return circleObject;
    }

    public RingObject addPotRing(int n, int n2, double d, double d2, double d3) {
        if (this.things.size() >= this.maxNumber) {
            return null;
        }
        RingObject ringObject = new RingObject(this, d, d2, d3);
        n = Math.max(n, (int)(this.xPixPerCell * (double)3));
        n = Math.max(n, (int)(this.yPixPerCell * (double)3));
        n2 = Math.max(n2, (int)(this.xPixPerCell * (double)3));
        n2 = Math.max(n2, (int)(this.yPixPerCell * (double)3));
        ringObject.setWidth(n);
        ringObject.setHeight(n);
        ringObject.setSize(n2);
        this.things.addElement(ringObject);
        if (this.autoRefresh) {
            this.recalculate();
        }
        return ringObject;
    }

    public RectObject addPotRect(int n, int n2, double d, double d2, double d3) {
        if (this.things.size() >= this.maxNumber) {
            return null;
        }
        RectObject rectObject = new RectObject(this, d, d2, d3);
        n = Math.max(n, (int)(this.xPixPerCell * (double)3));
        n2 = Math.max(n2, (int)(this.yPixPerCell * (double)3));
        rectObject.setWidth(n);
        rectObject.setHeight(n2);
        this.things.addElement(rectObject);
        if (this.autoRefresh) {
            this.recalculate();
        }
        return rectObject;
    }

    public int addField() {
        if (this.hasFieldThing) {
            return 0;
        }
        FieldThing fieldThing = new FieldThing(this);
        this.hasFieldThing = true;
        this.things.addElement(fieldThing);
        return ((Object)((Object)fieldThing)).hashCode();
    }

    public int addContours() {
        if (this.hasContourThing) {
            return 0;
        }
        ContourThing contourThing = new ContourThing(this);
        this.hasContourThing = true;
        this.things.addElement(contourThing);
        return ((Object)((Object)contourThing)).hashCode();
    }

    public BoxObject addPotBox(int n, int n2, int n3, double d, double d2, double d3) {
        if (this.things.size() >= this.maxNumber) {
            return null;
        }
        BoxObject boxObject = new BoxObject(this, d, d2, d3);
        n = Math.max(n, (int)(this.xPixPerCell * (double)3));
        n2 = Math.max(n2, (int)(this.yPixPerCell * (double)3));
        n3 = Math.max(n3, (int)(this.xPixPerCell * (double)3));
        n3 = Math.max(n3, (int)(this.yPixPerCell * (double)3));
        boxObject.setWidth(n);
        boxObject.setHeight(n2);
        boxObject.setSize(n3);
        this.things.addElement(boxObject);
        if (this.autoRefresh) {
            this.recalculate();
        }
        return boxObject;
    }

    public int addThing(Thing thing) {
        if (this.things.size() >= this.maxNumber) {
            return 0;
        }
        this.things.addElement(thing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return thing.hashCode();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    final int xPixToIndex(int n) {
        int n2 = (int)Math.round((double)n / this.xPixPerCell) + this.gutter;
        if (n2 < 0) {
            return 0;
        }
        if (n2 > this.xPts - 1 + this.gutter2) {
            return this.xPts - 1 + this.gutter2;
        }
        return n2;
    }

    final int xIndexToPix(int n) {
        n = Math.max(n - this.gutter, 0);
        int n2 = (int)Math.round(((double)n + 0.5) * this.xPixPerCell);
        return n2;
    }

    final void setVDisplay(SNumber sNumber) {
        this.vDisplay = sNumber;
    }

    final int yPixToIndex(int n) {
        int n2 = (int)Math.round((double)n / this.yPixPerCell) + this.gutter;
        if (n2 < 0) {
            return 0;
        }
        if (n2 > this.yPts - 1 + this.gutter2) {
            return this.yPts - 1 + this.gutter2;
        }
        return n2;
    }

    final int yIndexToPix(int n) {
        n = Math.max(n - this.gutter, 0);
        int n2 = (int)Math.round(((double)n + 0.5) * this.yPixPerCell);
        return n2;
    }

    final void copyToDisplayMatrix() {
        for (int i = this.gutter; i < this.xPtsg; ++i) {
            int n = i - this.gutter;
            for (int j = this.gutter; j < this.yPtsg; ++j) {
                this.displaymatrix[n][j - this.gutter] = -this.potential[i][j];
            }
        }
    }

    public void paint(Graphics graphics) {
        Object object;
        Rectangle rectangle;
        Graphics graphics2;
        Rectangle rectangle2 = this.getBounds();
        if (rectangle2.width < 16 || rectangle2.height < 16) {
            return;
        }
        if (this.osi == null || rectangle2.width != this.iwidth || rectangle2.height != this.iheight) {
            this.iheight = rectangle2.height;
            this.iwidth = rectangle2.width;
            this.setXRange(this.xmin, this.xmax);
            this.osi = this.createImage(this.iwidth, this.iheight);
            this.xPixPerCell = (double)this.iwidth / (double)this.xPts;
            this.yPixPerCell = (double)this.iheight / (double)this.yPts;
            this.xUnitPerCell = (this.xmax - this.xmin) / (double)this.xPts;
            this.yUnitPerCell = (this.ymax - this.ymin) / (double)this.yPts;
            graphics2 = this.osi.getGraphics();
            this.contour.setNoContours(true);
            this.contour.paint(graphics2, this.getBounds());
            this.contour.setNoContours(!this.showContours);
            graphics2.dispose();
            for (int i = 0; i < this.things.size(); ++i) {
                rectangle = (Thing)this.things.elementAt(i);
                if (!(rectangle instanceof PotentialObject)) continue;
                object = (PotentialObject)((Object)rectangle);
            }
            this.setConductors();
            this.invalidPotential = true;
            this.startThread();
        }
        if (this.invalidPotential) {
            this.copyToDisplayMatrix();
            this.contour.setGrid(this.displaymatrix, this.xmin, this.xmax, this.ymin, this.ymax);
            this.setFieldFromGrad();
            this.invalidPotential = false;
        }
        graphics2 = this.osi.getGraphics();
        rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        this.contour.paint(graphics2, rectangle);
        if (this.activeElement != null) {
            this.activeElement.paintActive(graphics2);
        }
        if (this.showGrid) {
            this.paintGrid(graphics2, rectangle2);
        }
        if (this.caption != null) {
            object = graphics2.getFont();
            graphics2.setFont(this.f);
            FontMetrics fontMetrics = graphics2.getFontMetrics(this.f);
            graphics2.drawString(this.caption, (this.iwidth - fontMetrics.stringWidth(this.caption)) / 2, 25);
            graphics2.setFont((Font)object);
        }
        if (this.gutter == 0) {
            graphics2.setColor(Color.black);
            graphics2.fillRect(0, 0, (int)this.xPixPerCell, this.iheight);
            graphics2.fillRect(0, 0, this.iwidth, (int)this.yPixPerCell);
            graphics2.fillRect(this.iwidth - (int)this.xPixPerCell, 0, (int)this.xPixPerCell, this.iheight);
            graphics2.fillRect(0, this.iheight - (int)this.yPixPerCell, this.iwidth, (int)this.yPixPerCell);
        }
        if (this.showCharge) {
            this.paintCharge(graphics2);
        }
        graphics2.dispose();
        graphics.drawImage(this.osi, 0, 0, this);
        if (this.runThread != null) {
            this.paintMessage(graphics, this.owner.label_calculating);
        } else {
            this.paintMessage(graphics, this.message);
        }
    }

    void paintCoordinates(int n, int n2) {
        Graphics graphics = this.getGraphics();
        this.paintCoordinates(graphics, n, n2);
        graphics.dispose();
    }

    void paintCoordinates(Graphics graphics, int n, int n2) {
        double d;
        double d2 = this.xFromPix(n);
        double d3 = this.yFromPix(n2);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        String string = "";
        if (this.showCoordOnDrag) {
            string = String.valueOf(String.valueOf(new StringBuffer("x=").append(this.format.form(d2)).append(" y=").append(this.format.form(d3))));
        }
        boolean bl = this.isPixInsidePotentialObject(n, n2);
        if (this.showVOnDrag) {
            d = bl ? this.defaultVoltage : -this.potential[this.xPixToIndex(n)][this.yPts2g - this.yPixToIndex(n2) - 1];
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.owner.label_v).append(this.format.form(d))));
        }
        if (this.showEOnDrag) {
            d = -this.dudx(this.xPixToIndex(n), this.yPts2g - this.yPixToIndex(n2) - 1);
            double d4 = -this.dudy(this.xPixToIndex(n), this.yPts2g - this.yPixToIndex(n2) - 1);
            string = bl ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.owner.label_e).append("0"))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.owner.label_e).append(this.format.form(Math.sqrt(d * d + d4 * d4)))));
        }
        if (this.showRhoOnDrag) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.owner.label_rho).append(this.format.form(this.charge[this.xPixToIndex(n)][this.yPts2g - this.yPixToIndex(n2) - 1]))));
        }
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, this.getBounds().height - 15, this.boxWidth, 15);
        this.boxWidth = 20 + fontMetrics.stringWidth(string);
        graphics.fillRect(0, this.getBounds().height - 15, this.boxWidth, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, 8, this.getBounds().height - 2);
    }

    void poissonPanel_mousePressed(MouseEvent mouseEvent) {
        Object object;
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (this.newObjectString == "circle") {
            object = this.addPotCircle(40, this.xFromPix(this.mouseX), this.yFromPix(this.mouseY), this.defaultVoltage);
            ((PotentialObject)((Object)object)).setChargeType(this.defaultChargeType);
            this.newObjectString = null;
        } else if (this.newObjectString == "rect") {
            object = this.addPotRect(40, 40, this.xFromPix(this.mouseX), this.yFromPix(this.mouseY), this.defaultVoltage);
            ((PotentialObject)((Object)object)).setChargeType(this.defaultChargeType);
            this.newObjectString = null;
        }
        object = this.getGraphics();
        this.paintCoordinates((Graphics)object, this.mouseX, this.mouseY);
        if (this.newObjectString == null) {
            this.activeElement = null;
            this.dragThing = null;
            for (int i = this.things.size() - 1; i >= 0; --i) {
                Thing thing = (Thing)this.things.elementAt(i);
                if (thing instanceof PotentialObject) {
                    PotentialObject potentialObject = (PotentialObject)thing;
                    if (potentialObject.isInsideHotSpot(this.mouseX, this.mouseY) == 0) continue;
                    this.activeElement = potentialObject;
                    this.hotSpot = this.activeElement.isInsideHotSpot(this.mouseX, this.mouseY);
                    this.poissonPanel_mouseMoved(mouseEvent);
                    this.stopThread();
                    this.isDrag = true;
                    this.activeElement.paintActive((Graphics)object);
                    if (this.vDisplay == null) break;
                    this.vDisplay.setValue(this.activeElement.getPotential());
                    break;
                }
                if (thing.getMaster() != null || !thing.isInsideThing(this.mouseX, this.mouseY) || thing.isNoDrag()) continue;
                this.dragThing = thing;
                break;
            }
        }
        if (this.dragThing != null) {
            this.mouseX = this.pixFromX(this.dragThing.getX());
            this.mouseY = this.pixFromY(this.dragThing.getY());
            double d = this.xFromPix(this.mouseX);
            double d2 = this.yFromPix(this.mouseY);
            this.dragThing.setXY(d, d2);
            this.dragThing.updateMySlaves();
            this.owner.updateDataConnection(this.dragThing.hashCode());
            ((Graphics)object).setXORMode(this.getBackground());
            ((Graphics)object).setPaintMode();
        }
        ((Graphics)object).dispose();
    }

    void poissonPanel_mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.activeElement != null) {
            switch (this.activeElement.isInsideHotSpot(n, n2)) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 4: {
                    this.setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                default: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            return;
        }
        for (int i = 0; i < this.things.size(); ++i) {
            Thing thing = (Thing)this.things.elementAt(i);
            if (thing.isInsideThing(n, n2) && (!thing.isNoDrag() || thing.isResizable())) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void poissonPanel_mouseReleased(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        if (this.activeElement != null) {
            this.contour.setNoContours(true);
            boolean bl = this.showFieldVectors;
            this.showFieldVectors = false;
            this.paint(graphics);
            this.contour.setNoContours(!this.showContours);
            this.showFieldVectors = bl;
        } else {
            graphics.drawImage(this.osi, 0, 0, this);
        }
        if (this.runThread != null) {
            this.paintMessage(graphics, this.owner.label_calculating);
        }
        graphics.dispose();
        if (this.isDrag) {
            this.setConductors();
        }
        this.boxWidth = 0;
        this.isDrag = false;
        this.dragThing = null;
        this.startThread();
    }

    void poissonPanel_mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        int n = this.iwidth;
        int n2 = 0;
        if (this.mouseX < n2) {
            this.mouseX = n2;
        } else if (this.mouseX > n - 2) {
            this.mouseX = n - 2;
        }
        double d = this.xFromPix(this.mouseX);
        n2 = 0;
        n = this.iheight;
        if (this.mouseY < n2) {
            this.mouseY = n2;
        } else if (this.mouseY > n - 2) {
            this.mouseY = n - 2;
        }
        double d2 = this.yFromPix(this.mouseY);
        if (this.activeElement != null && this.hotSpot == 1) {
            this.activeElement.setPosition(this.mouseX, this.mouseY);
        } else if (this.activeElement != null && this.hotSpot == 2) {
            this.activeElement.setWidth(2 * (this.mouseX - this.activeElement.getXPix()));
        } else if (this.activeElement != null && this.hotSpot == 3) {
            this.activeElement.setHeight(2 * (this.mouseY - this.activeElement.getYPix()));
        } else if (this.activeElement != null && this.hotSpot == 4) {
            this.activeElement.setWidth(2 * (this.mouseX - this.activeElement.getXPix()));
            this.activeElement.setHeight(2 * (this.mouseY - this.activeElement.getYPix()));
        }
        Graphics graphics = this.getGraphics();
        if (this.activeElement != null && this.isDrag) {
            graphics.drawImage(this.osi, 0, 0, this);
            this.activeElement.paintActive(graphics);
        }
        if (this.dragThing != null) {
            graphics.setXORMode(this.getBackground());
            this.dragThing.paint(graphics);
            this.dragThing.paintMySlaves(graphics);
            this.dragThing.setXY(d, d2);
            this.dragThing.updateMySlaves();
            this.dragThing.paint(graphics);
            this.dragThing.paintMySlaves(graphics);
            graphics.setPaintMode();
            this.owner.updateDataConnection(this.dragThing.hashCode());
        }
        this.paintCoordinates(graphics, this.mouseX, this.mouseY);
        graphics.dispose();
    }

    public void setCaption(String string) {
        this.caption = string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void changeVoltage(PotentialObject potentialObject, double d) {
        Rectangle rectangle = this.getBounds();
        double d2 = this.xUnitPerCell * this.yUnitPerCell;
        if (d2 == 0.0) {
            return;
        }
        potentialObject.v = d;
        int n = this.xPixToIndex(potentialObject.getXPix() - potentialObject.getWidth() / 2);
        int n2 = this.yPixToIndex(potentialObject.getYPix() - potentialObject.getHeight() / 2);
        int n3 = n + (int)((double)potentialObject.getWidth() / this.xPixPerCell + 0.5);
        n3 = Math.min(n3, this.yPts2g - 1);
        int n4 = n2 + (int)((double)potentialObject.getHeight() / this.yPixPerCell + 0.5);
        n4 = Math.min(n4, this.yPts2g - 1);
        for (int i = n; i < n3; ++i) {
            for (int j = n2; j < n4; ++j) {
                if (!(potentialObject instanceof RectObject) && !potentialObject.isInsideThing(this.xIndexToPix(i), this.yIndexToPix(j)) || potentialObject.getChargeType() != 0) continue;
                this.potential[i][this.yPts2g - 1 - j] = -potentialObject.getPotential();
            }
        }
    }

    public void setConductors() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Thing thing;
        int n7;
        Rectangle rectangle = this.getBounds();
        for (int i = 1; i < this.xPts2g - 1; ++i) {
            for (int j = 1; j < this.yPts2g - 1; ++j) {
                this.isConductor[i][j] = false;
                this.charge[i][j] = 0.0;
                this.dielectric[i][j] = 1.0;
            }
        }
        double d = this.xUnitPerCell * this.yUnitPerCell;
        if (d == 0.0) {
            return;
        }
        PotentialObject potentialObject = null;
        for (n7 = 0; n7 < this.things.size(); ++n7) {
            thing = (Thing)this.things.elementAt(n7);
            if (!(thing instanceof PotentialObject)) continue;
            potentialObject = (PotentialObject)thing;
            n6 = this.xPixToIndex(potentialObject.getXPix() - potentialObject.getWidth() / 2) + 1;
            n5 = this.yPixToIndex(potentialObject.getYPix() - potentialObject.getHeight() / 2) + 1;
            n4 = n6 + (int)((double)potentialObject.getWidth() / this.xPixPerCell + 0.5) - 2;
            n4 = Math.min(n4, this.yPts2g - 1);
            n3 = n5 + (int)((double)potentialObject.getHeight() / this.yPixPerCell + 0.5) - 2;
            n3 = Math.min(n3, this.yPts2g - 1);
            for (n2 = n6; n2 < n4; ++n2) {
                for (n = n5; n < n3; ++n) {
                    if (!(potentialObject instanceof RectObject) && !potentialObject.isInsideThing(this.xIndexToPix(n2), this.yIndexToPix(n)) || potentialObject.getChargeType() != 2) continue;
                    this.dielectric[n2][this.yPts2g - 1 - n] = potentialObject.getPotential() + 1.0;
                }
            }
        }
        for (n7 = 0; n7 < this.xPts2g; ++n7) {
            this.isConductor[n7][0] = true;
            this.potential[n7][0] = 0.0;
            this.dielectric[n7][0] = 1.0;
            this.isConductor[n7][this.yPts2g - 1] = true;
            this.potential[n7][this.yPts2g - 1] = 0.0;
            this.dielectric[n7][this.yPts2g - 1] = 1.0;
        }
        for (n7 = 0; n7 < this.yPts2g; ++n7) {
            this.isConductor[0][n7] = true;
            this.potential[0][n7] = 0.0;
            this.dielectric[0][n7] = 1.0;
            this.isConductor[this.xPts2g - 1][n7] = true;
            this.potential[this.xPts2g - 1][n7] = 0.0;
            this.dielectric[this.xPts2g - 1][n7] = 1.0;
        }
        for (n7 = 0; n7 < this.things.size(); ++n7) {
            thing = (Thing)this.things.elementAt(n7);
            if (!(thing instanceof PotentialObject)) continue;
            potentialObject = (PotentialObject)thing;
            n6 = this.xPixToIndex(potentialObject.getXPix() - potentialObject.getWidth() / 2);
            n5 = this.yPixToIndex(potentialObject.getYPix() - potentialObject.getHeight() / 2);
            n4 = n6 + (int)((double)potentialObject.getWidth() / this.xPixPerCell + 0.5);
            n4 = Math.min(n4, this.yPts2g - 1);
            n3 = n5 + (int)((double)potentialObject.getHeight() / this.yPixPerCell + 0.5);
            n3 = Math.min(n3, this.yPts2g - 1);
            for (n2 = n6; n2 < n4; ++n2) {
                for (n = n5; n < n3; ++n) {
                    if (!(potentialObject instanceof RectObject) && !potentialObject.isInsideThing(this.xIndexToPix(n2), this.yIndexToPix(n))) continue;
                    if (potentialObject.getChargeType() == 1) {
                        this.isConductor[n2][this.yPts2g - 1 - n] = false;
                        this.dielectric[n2][this.yPts2g - 1 - n] = 1.0;
                        double[] dArray = this.charge[n2];
                        int n8 = this.yPts2g - 1 - n;
                        dArray[n8] = dArray[n8] + potentialObject.getPotential() * d;
                        continue;
                    }
                    if (potentialObject.getChargeType() != 0) continue;
                    this.isConductor[n2][this.yPts2g - 1 - n] = true;
                    this.dielectric[n2][this.yPts2g - 1 - n] = 1.0;
                    this.charge[n2][this.yPts2g - 1 - n] = 0.0;
                    this.potential[n2][this.yPts2g - 1 - n] = -potentialObject.getPotential();
                }
            }
        }
        this.copyToDisplayMatrix();
        this.contour.setGrid(this.displaymatrix, this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public void setDefault() {
        this.stopThread();
        this.tolerance = 1.0E-4;
        this.message = null;
        this.showCoordOnDrag = true;
        this.showVOnDrag = false;
        this.showEOnDrag = false;
        this.setXRange(this.xmin, this.xmax);
        this.message = null;
        this.clearElements();
        this.chargeDataSource = null;
        this.potentialDataSource = null;
        if (this.autoRefresh) {
            this.recalculate();
        }
    }

    public void setDefaultVoltate(double d) {
        this.defaultVoltage = d;
    }

    public void setDefaultChargeType(int n) {
        this.defaultChargeType = n;
    }

    public void setGutter(int n) {
        if (this.gutter == n) {
            return;
        }
        this.resizeMatrices(this.xPts, this.yPts, n);
        if (this.autoRefresh) {
            this.recalculate();
        }
    }

    public void setFieldResolution(int n) {
        if (this.vectorResolution == n) {
            return;
        }
        this.vectorResolution = n;
        this.resizeMatrices(this.xPts, this.yPts, this.gutter);
        if (this.autoRefresh) {
            this.recalculate();
        }
    }

    public void setFieldFromGrad() {
        int n = 1;
        int n2 = this.yPts;
        int n3 = this.xPts;
        n = 1 + (int)(16.0 / this.xPixPerCell);
        n = this.vectorResolution;
        n2 = this.yPts / n;
        n3 = this.xPts / n;
        double[][][] dArray = this.field.resize(this.yPts / n, this.xPts / n);
        this.field.setLength((double)n * this.xPixPerCell * 0.75);
        for (int i = 0; i < n2; ++i) {
            int n4 = this.gutter + i * n;
            int n5 = n2 - i - 1;
            for (int j = 0; j < n3; ++j) {
                double d = -this.dudx(this.gutter + j * n, n4);
                double d2 = -this.dudy(this.gutter + j * n, n4);
                double d3 = Math.sqrt(d * d + d2 * d2);
                dArray[n5][j][0] = d / d3;
                dArray[n5][j][1] = d2 / d3;
                dArray[n5][j][2] = d3;
            }
        }
    }

    public void setMessage(String string) {
        this.message = string == null || string.trim().equals("") ? null : string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setObjectString(String string) {
        this.newObjectString = string;
    }

    public boolean setRange(String string) {
        boolean bl = false;
        double[] dArray = new double[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ", ; / \\ ( { [ ) } ] \t \n \r");
        if (stringTokenizer.countTokens() < 4) {
            bl = true;
        } else {
            for (int i = 0; i < 4; ++i) {
                try {
                    dArray[i] = Double.valueOf(stringTokenizer.nextToken().trim());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Error setting range:".concat(String.valueOf(String.valueOf(string))));
                    bl = true;
                }
            }
        }
        if (bl) {
            return false;
        }
        this.xmin = dArray[0];
        this.xmax = dArray[1];
        this.ymin = dArray[2];
        this.ymax = dArray[3];
        return true;
    }

    public void setShowContours(boolean bl) {
        this.showContours = bl;
        this.contour.setNoContours(!this.showContours);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setShowGrid(boolean bl) {
        this.showGrid = bl;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setShowCharge(boolean bl) {
        this.showCharge = bl;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setShowVOnDrag(boolean bl) {
        this.showVOnDrag = bl;
    }

    public void setShowRhoOnDrag(boolean bl) {
        this.showRhoOnDrag = bl;
    }

    public void setShowEOnDrag(boolean bl) {
        this.showEOnDrag = bl;
    }

    public void setShowFieldVectors(boolean bl) {
        this.showFieldVectors = bl;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }

    public void setMaxIterations(int n) {
        this.maxInterations = n;
    }

    public void setXRange(double d, double d2) {
        if (d2 == d) {
            this.xmin = d - 0.5;
            this.xmax = d2 + 0.5;
        } else if (d2 > d) {
            this.xmin = d;
            this.xmax = d2;
        } else {
            this.xmin = d2;
            this.xmax = d;
        }
        if (this.iwidth == 0) {
            return;
        }
        double d3 = (this.xmax - this.xmin) / (double)this.iwidth;
        this.ymin = (this.ymax + this.ymin) / (double)2 - d3 * (double)this.iheight / 2.0;
        this.ymax = this.ymin + d3 * (double)this.iheight;
        if (this.autoRefresh) {
            this.recalculate();
        }
    }

    public void setYRange(double d, double d2) {
        if (d2 == d) {
            this.ymin = d - 0.5;
            this.ymax = d2 + 0.5;
        } else if (d2 > d) {
            this.ymin = d;
            this.ymax = d2;
        } else {
            this.ymin = d2;
            this.ymax = d;
        }
        if (this.iheight == 0) {
            return;
        }
        double d3 = (this.ymax - this.ymin) / (double)this.iheight;
        this.xmin = (this.xmax + this.xmin) / (double)2 - d3 * (double)this.iwidth / 2.0;
        this.xmax = this.xmin + d3 * (double)this.iwidth;
        if (this.autoRefresh) {
            this.recalculate();
        }
    }

    public void destroy() {
        this.stopThread();
        this.contour.destroy();
    }

    public void run() {
        double d = (double)10 * this.tolerance;
        int n = 0;
        this.setMessage(null);
        while (this.keepRunning && this.runThread == Thread.currentThread() && n < this.maxInterations) {
            try {
                for (int i = 0; i < 10; ++i) {
                    if (this.keepRunning) {
                        d = this.step();
                    }
                    if (d < this.tolerance) {
                        this.keepRunning = false;
                    }
                    ++n;
                }
                if (!this.keepRunning) continue;
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                this.keepRunning = false;
            }
        }
        this.keepRunning = false;
        if (d > this.tolerance && n >= this.maxInterations) {
            this.setMessage(this.owner.label_not_converge);
        } else {
            this.setMessage(null);
        }
        this.invalidPotential = true;
        this.copyToDisplayMatrix();
        this.owner.updateDataConnections();
        this.runThread = null;
        this.repaint();
    }

    public synchronized void startThread() {
        if (this.runThread == null) {
            this.runThread = new Thread(this);
            this.keepRunning = true;
            this.runThread.start();
        }
    }

    public synchronized void stopThread() {
        Thread thread = this.runThread;
        this.keepRunning = false;
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                thread.stop();
                this.runThread = null;
            }
        }
    }

    public double step() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        int n;
        int n2;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = (double)2 / (1.0 + Math.PI / (double)this.xPts2g);
        this.adjustVoltage();
        for (n2 = 1; n2 < this.xPts2g - 1; ++n2) {
            for (n = 1; n < this.yPts2g - 1; ++n) {
                if (!this.keepRunning) {
                    return (double)10 * this.tolerance;
                }
                if (this.isConductor[n2][n]) continue;
                d5 = (this.dielectric[n2 + 1][n] + this.dielectric[n2][n]) / (double)2;
                d4 = (this.dielectric[n2 - 1][n] + this.dielectric[n2][n]) / (double)2;
                d3 = (this.dielectric[n2][n + 1] + this.dielectric[n2][n]) / (double)2;
                d2 = (this.dielectric[n2][n - 1] + this.dielectric[n2][n]) / (double)2;
                d = (d5 + d4 + d3 + d2) / 4.0;
                d8 = this.potential[n2][n];
                d7 = (d5 * this.potential[n2 + 1][n] + d4 * this.potential[n2 - 1][n] + d3 * this.potential[n2][n + 1] + d2 * this.potential[n2][n - 1]) / 4.0;
                d9 = d7 / d - d8;
                this.potential[n2][n] = this.potential[n2][n] + d10 * d9 - this.charge[n2][n] / this.dielectric[n2][n];
            }
        }
        for (n2 = this.xPts2g - 2; n2 > 0; --n2) {
            for (n = this.yPts2g - 2; n > 0; --n) {
                if (!this.keepRunning) {
                    return (double)10 * this.tolerance;
                }
                if (this.isConductor[n2][n]) continue;
                d5 = (this.dielectric[n2 + 1][n] + this.dielectric[n2][n]) / (double)2;
                d4 = (this.dielectric[n2 - 1][n] + this.dielectric[n2][n]) / (double)2;
                d3 = (this.dielectric[n2][n + 1] + this.dielectric[n2][n]) / (double)2;
                d2 = (this.dielectric[n2][n - 1] + this.dielectric[n2][n]) / (double)2;
                d = (d5 + d4 + d3 + d2) / 4.0;
                d8 = this.potential[n2][n];
                d7 = (d5 * this.potential[n2 + 1][n] + d4 * this.potential[n2 - 1][n] + d3 * this.potential[n2][n + 1] + d2 * this.potential[n2][n - 1]) / 4.0;
                d9 = d7 / d - d8;
                this.potential[n2][n] = this.potential[n2][n] + d10 * d9 - this.charge[n2][n] / this.dielectric[n2][n];
                if (!(Math.abs(d9) > d6)) continue;
                d6 = Math.abs(this.potential[n2][n] - d8);
            }
        }
        return d6;
    }

    public void paintBoundCharge(PotentialObject potentialObject, Graphics graphics) {
        double d = 0.0;
        int n = this.xPixToIndex(potentialObject.getXPix() - potentialObject.getWidth() / 2) - 2;
        int n2 = this.yPixToIndex(potentialObject.getYPix() - potentialObject.getHeight() / 2) - 2;
        int n3 = n + (int)((double)potentialObject.getWidth() / this.xPixPerCell) + 4;
        int n4 = n2 + (int)((double)potentialObject.getHeight() / this.yPixPerCell) + 4;
        n = Math.max(1, n);
        n3 = Math.min(this.xPts2g - 2, n3);
        n2 = Math.max(1, n2);
        n4 = Math.min(this.yPts2g - 2, n4);
        for (int i = n2; i < n4; ++i) {
            int n5 = this.yPts2g - 1 - i;
            for (int j = n; j < n3; ++j) {
                d = this.potential[j][n5] - (this.potential[j + 1][n5] + this.potential[j - 1][n5] + this.potential[j][n5 + 1] + this.potential[j][n5 - 1]) / 4.0;
                this.paintChargeDot(-d, j - this.gutter, n5 - this.gutter, graphics);
            }
        }
    }

    public void paintCharge(PotentialObject potentialObject, Graphics graphics) {
        if (potentialObject.getChargeType() == 2) {
            this.paintBoundCharge(potentialObject, graphics);
            return;
        }
        double d = 0.0;
        int n = this.xPixToIndex(potentialObject.getXPix() - potentialObject.getWidth() / 2);
        int n2 = this.yPixToIndex(potentialObject.getYPix() - potentialObject.getHeight() / 2);
        int n3 = n + (int)((double)potentialObject.getWidth() / this.xPixPerCell + 0.5);
        int n4 = n2 + (int)((double)potentialObject.getHeight() / this.yPixPerCell + 0.5);
        n = Math.max(1, n);
        n3 = Math.min(this.xPts2g - 2, n3);
        n2 = Math.max(1, n2);
        n4 = Math.min(this.yPts2g - 2, n4);
        for (int i = n2; i < n4; ++i) {
            int n5 = this.yPts2g - 1 - i;
            for (int j = n; j < n3; ++j) {
                if (!(potentialObject instanceof RectObject) && !potentialObject.isInsideThing(this.xIndexToPix(j), this.yIndexToPix(i))) continue;
                d = this.isConductor[j + 1][n5] && this.isConductor[j - 1][n5] && !this.isConductor[j][n5] || this.isConductor[j][n5 + 1] && this.isConductor[j][n5 - 1] && !this.isConductor[j][n5] ? 0.0 : this.potential[j][n5] - (this.potential[j + 1][n5] + this.potential[j - 1][n5] + this.potential[j][n5 + 1] + this.potential[j][n5 - 1]) / 4.0;
                this.paintChargeDot(-d, j - this.gutter, n5 - this.gutter, graphics);
            }
        }
    }

    void paintChargeDot(double d, int n, int n2, Graphics graphics) {
        int n3 = 1;
        if (d > this.tolerance) {
            d = Math.sqrt(d);
            n3 = (int)(this.inducedChargeScale * d);
            graphics.setColor(this.positiveChargeColor);
            graphics.fillOval((int)(this.xPixPerCell * ((double)n + 0.5)) - n3 / 2, (int)(this.yPixPerCell * ((double)(this.yPts - n2) - 0.5)) - n3 / 2, n3, n3);
        } else if (d < -this.tolerance) {
            d = Math.sqrt(-d);
            n3 = (int)(this.inducedChargeScale * d);
            graphics.setColor(this.negativeChargeColor);
            graphics.fillOval((int)(this.xPixPerCell * ((double)n + 0.5)) - n3 / 2, (int)(this.yPixPerCell * ((double)(this.yPts - n2) - 0.5)) - n3 / 2, n3, n3);
        }
    }

    public double calcCharge(PotentialObject potentialObject) {
        double d = 0.0;
        int n = this.xPixToIndex(potentialObject.getXPix() - potentialObject.getWidth() / 2);
        int n2 = this.yPixToIndex(potentialObject.getYPix() - potentialObject.getHeight() / 2);
        int n3 = n + (int)((double)potentialObject.getWidth() / this.xPixPerCell + 0.5);
        int n4 = n2 + (int)((double)potentialObject.getHeight() / this.yPixPerCell + 0.5);
        n = Math.max(1, n);
        n3 = Math.min(this.yPts2g - 2, n3);
        n2 = Math.max(1, n2);
        n4 = Math.min(this.yPts2g - 2, n4);
        for (int i = n; i < n3; ++i) {
            for (int j = n2; j < n4; ++j) {
                int n5 = this.yPts2g - 1 - j;
                if (!(potentialObject instanceof RectObject) && !potentialObject.isInsideThing(this.xIndexToPix(i), this.yIndexToPix(j)) || this.isConductor[i + 1][n5] && this.isConductor[i - 1][n5] && !this.isConductor[i][n5] || this.isConductor[i][n5 + 1] && this.isConductor[i][n5 - 1] && !this.isConductor[i][n5]) continue;
                d += this.potential[i][n5] - (this.potential[i + 1][n5] + this.potential[i - 1][n5] + this.potential[i][n5 + 1] + this.potential[i][n5 - 1]) / 4.0;
            }
        }
        return -d;
    }

    double calcPotentialEnergy() {
        double d = 0.0;
        for (int i = 0; i < this.things.size(); ++i) {
            Thing thing = (Thing)this.things.elementAt(i);
            if (!(thing instanceof PotentialObject)) continue;
            PotentialObject potentialObject = (PotentialObject)thing;
            d += this.calcPotentialEnergy(potentialObject);
        }
        return d;
    }

    public double calcPotentialEnergy(PotentialObject potentialObject) {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.xPixToIndex(potentialObject.getXPix() - potentialObject.getWidth() / 2);
        int n2 = this.yPixToIndex(potentialObject.getYPix() - potentialObject.getHeight() / 2);
        int n3 = n + (int)((double)potentialObject.getWidth() / this.xPixPerCell + 0.5);
        int n4 = n2 + (int)((double)potentialObject.getHeight() / this.yPixPerCell + 0.5);
        n = Math.max(1, n);
        n3 = Math.min(this.yPts2g - 2, n3);
        n2 = Math.max(1, n2);
        n4 = Math.min(this.yPts2g - 2, n4);
        for (int i = n; i < n3; ++i) {
            for (int j = n2; j < n4; ++j) {
                int n5 = this.yPts2g - 1 - j;
                if (!(potentialObject instanceof RectObject) && !potentialObject.isInsideThing(this.xIndexToPix(i), this.yIndexToPix(j))) continue;
                d = this.isConductor[i + 1][n5] && this.isConductor[i - 1][n5] && !this.isConductor[i][n5] || this.isConductor[i][n5 + 1] && this.isConductor[i][n5 - 1] && !this.isConductor[i][n5] ? 0.0 : this.potential[i][n5] - (this.potential[i + 1][n5] + this.potential[i - 1][n5] + this.potential[i][n5 + 1] + this.potential[i][n5 - 1]) / 4.0;
                d2 += d * this.potential[i][n5];
            }
        }
        return d2;
    }

    public void paintCharge(Graphics graphics) {
        double d;
        int n;
        boolean bl = true;
        int n2 = 1;
        n2 = Math.max(this.gutter, n2);
        if (this.gutter == 0) {
            for (n = 1; n < this.xPts - 1; ++n) {
                int n3 = 0;
                d = this.potential[n][n3] - (this.potential[n + 1][n3] + this.potential[n - 1][n3] + this.potential[n][n3 + 1] + this.potential[n][n3]) / 4.0;
                this.paintChargeDot(-d, n, 0, graphics);
                n3 = this.yPts - 1;
                d = this.potential[n][n3] - (this.potential[n + 1][n3] + this.potential[n - 1][n3] + this.potential[n][n3] + this.potential[n][n3 - 1]) / 4.0;
                this.paintChargeDot(-d, n, this.yPts - 1, graphics);
            }
        }
        if (this.gutter == 0) {
            for (n = 1; n < this.yPts - 1; ++n) {
                int n4 = 0;
                d = this.potential[n4][n] - (this.potential[n4 + 1][n] + this.potential[n4][n] + this.potential[n4][n + 1] + this.potential[n4][n - 1]) / 4.0;
                this.paintChargeDot(-d, 0, n, graphics);
                n4 = this.xPts - 1;
                d = this.potential[n4][n] - (this.potential[n4][n] + this.potential[n4 - 1][n] + this.potential[n4][n + 1] + this.potential[n4][n - 1]) / 4.0;
                this.paintChargeDot(-d, this.xPts - 1, n, graphics);
            }
        }
    }

    double adjustVoltage() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < this.things.size(); ++i) {
            Thing thing = (Thing)this.things.elementAt(i);
            if (!(thing instanceof PotentialObject)) continue;
            PotentialObject potentialObject = (PotentialObject)thing;
            if (!potentialObject.isConstantQ || potentialObject.getChargeType() != 0) continue;
            d5 = potentialObject.getPotential();
            d3 = this.calcCharge(potentialObject);
            d2 = potentialObject.getQ();
            d += Math.abs(d2 - d3);
            d4 = d2 - d3 > 0.0 ? d5 + 0.05 * Math.abs(d2 - d3) / (Math.abs(d3) + Math.abs(d2) + 1.0E-6) : (d2 - d3 < 0.0 ? d5 - 0.05 * Math.abs(d2 - d3) / (Math.abs(d3) + Math.abs(d2) + 1.0E-6) : d5);
            this.changeVoltage(potentialObject, d4);
        }
        return d;
    }

    void printChargeValues() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.things.size(); ++i) {
            Thing thing = (Thing)this.things.elementAt(i);
            if (!(thing instanceof PotentialObject)) continue;
            PotentialObject potentialObject = (PotentialObject)thing;
            d = this.calcCharge(potentialObject);
            d2 += d;
            System.out.println("chage=".concat(String.valueOf(String.valueOf(d))));
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n = 1; n < this.xPts2g - 1; ++n) {
            int n2 = 0;
            d3 -= this.potential[n][n2] - (this.potential[n + 1][n2] + this.potential[n - 1][n2] + this.potential[n][n2 + 1] + this.potential[n][n2]) / 4.0;
            n2 = this.yPts2g - 1;
            d4 -= this.potential[n][n2] - (this.potential[n + 1][n2] + this.potential[n - 1][n2] + this.potential[n][n2] + this.potential[n][n2 - 1]) / 4.0;
        }
        for (n = 1; n < this.yPts2g - 1; ++n) {
            int n3 = 0;
            d5 -= this.potential[n3][n] - (this.potential[n3 + 1][n] + this.potential[n3][n] + this.potential[n3][n + 1] + this.potential[n3][n - 1]) / 4.0;
            n3 = this.xPts2g - 1;
            d6 -= this.potential[n3][n] - (this.potential[n3][n] + this.potential[n3 - 1][n] + this.potential[n3][n + 1] + this.potential[n3][n - 1]) / 4.0;
        }
        System.out.println("chage total=".concat(String.valueOf(String.valueOf(d2 += d3 + d4 + d5 + d6))));
    }

    public void paintGrid(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.black);
        for (int i = 0; i <= this.xPts; ++i) {
            for (int j = 0; j <= this.yPts; ++j) {
                graphics.drawLine((int)(this.xPixPerCell * (double)i), (int)(this.yPixPerCell * (double)j), (int)(this.xPixPerCell * (double)i), (int)(this.yPixPerCell * (double)j));
            }
        }
    }

    public void paintMessage(Graphics graphics, String string) {
        if (string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        graphics.setColor(Color.yellow);
        int n = 15 + fontMetrics.stringWidth(string);
        graphics.fillRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, this.iwidth - n + 2, this.iheight - 3);
    }

    public void resetMatrices() {
        for (int i = 0; i < this.xPts2g; ++i) {
            for (int j = 0; j < this.yPts2g; ++j) {
                this.isConductor[i][j] = false;
                this.potential[i][j] = 0.0;
                this.charge[i][j] = 0.0;
                this.dielectric[i][j] = 1.0;
            }
        }
    }

    public void recalculate() {
        this.setConductors();
        this.invalidPotential = true;
        this.repaint();
        this.startThread();
    }

    public synchronized void resizeMatrices(int n, int n2, int n3) {
        if (this.xPts == n && this.yPts == n2 && this.gutter == n3) {
            return;
        }
        this.stopThread();
        this.gutter = n3;
        this.xPts = n;
        this.yPts = n2;
        this.xPtsg = n + this.gutter;
        this.yPtsg = n2 + this.gutter;
        this.gutter2 = 2 * this.gutter;
        this.xPts2g = n + this.gutter2;
        this.yPts2g = n2 + this.gutter2;
        this.isConductor = new boolean[this.xPts2g][this.yPts2g];
        this.potential = new double[this.xPts2g][this.yPts2g];
        this.charge = new double[this.xPts2g][this.yPts2g];
        this.dielectric = new double[this.xPts2g][this.yPts2g];
        this.displaymatrix = new double[this.xPts][this.yPts];
        if (this.chargeDataSource != null) {
            this.chargeDataSource = new ChargeDataSource(this.owner);
        }
        if (this.potentialDataSource != null) {
            this.potentialDataSource = new PotentialDataSource(this.owner);
        }
        int n4 = 1;
        int n5 = this.yPts;
        int n6 = this.xPts;
        n4 = 1 + (int)(16.0 / this.xPixPerCell);
        n4 = this.vectorResolution;
        n5 = this.yPts / n4;
        n6 = this.xPts / n4;
        this.field.resize(this.yPts / n4, this.xPts / n4);
        this.osi = null;
    }

    public void makeActiveElementNull() {
        this.activeElement = null;
        this.repaint();
    }

    public void clearElements() {
        this.stopThread();
        this.activeElement = null;
        this.things.removeAllElements();
        this.hasFieldThing = false;
        this.hasContourThing = false;
        this.resetMatrices();
        if (this.autoRefresh) {
            this.recalculate();
        }
    }

    public int getPotentialArrayID() {
        if (this.potentialDataSource == null) {
            this.potentialDataSource = new PotentialDataSource(this.owner);
        }
        return this.potentialDataSource.hashCode();
    }

    public int getChargeArrayID() {
        if (this.chargeDataSource == null) {
            this.chargeDataSource = new ChargeDataSource(this.owner);
        }
        return this.chargeDataSource.hashCode();
    }

    public int getPixWidth() {
        return this.getSize().width;
    }

    public int getPixHeight() {
        return this.getSize().height;
    }

    final double getPotential(double d, double d2) {
        int n = this.pixFromX(d);
        int n2 = this.pixFromY(d2);
        return this.potential[this.xPixToIndex(n)][this.yPts2g - this.yPixToIndex(n2) - 1];
    }

    final double dudx(double d, double d2) {
        if (this.xPixPerCell == 0.0) {
            return 0.0;
        }
        int n = this.pixFromX(d);
        int n2 = this.pixFromY(d2);
        int n3 = this.xPixToIndex(n);
        int n4 = this.yPts2g - this.yPixToIndex(n2) - 1;
        if (n3 < 1) {
            n3 = 1;
        } else if (n3 > this.xPts2g - 2) {
            n3 = this.xPts2g - 2;
        }
        if (n4 < 1) {
            n4 = 1;
        } else if (n4 > this.yPts2g - 2) {
            n4 = this.yPts2g - 2;
        }
        if (this.isConductor[n3][n4] || this.isConductor[n3][n4 - 1] || this.isConductor[n3][n4 + 1]) {
            return 0.0;
        }
        double d3 = this.potential[n3 - 1][n4];
        double d4 = this.potential[n3][n4];
        double d5 = this.potential[n3 + 1][n4];
        double d6 = d5 - d4;
        double d7 = d4 - d3;
        if (Math.abs(d6) > Math.abs(d7)) {
            return -d6 / this.xUnitPerCell;
        }
        return -d7 / this.xUnitPerCell;
    }

    final double dudx(int n, int n2) {
        if (this.xPixPerCell == 0.0) {
            return 0.0;
        }
        if (n < 1) {
            n = 1;
        } else if (n > this.xPts2g - 2) {
            n = this.xPts2g - 2;
        }
        double d = this.potential[n - 1][n2];
        double d2 = this.potential[n][n2];
        double d3 = this.potential[n + 1][n2];
        double d4 = d3 - d2;
        double d5 = d2 - d;
        if (Math.abs(d4) > Math.abs(d5)) {
            return -d4 / this.xUnitPerCell;
        }
        return -d5 / this.xUnitPerCell;
    }

    final double dudy(double d, double d2) {
        if (this.yPixPerCell == 0.0) {
            return 0.0;
        }
        int n = this.pixFromX(d);
        int n2 = this.pixFromY(d2);
        int n3 = this.xPixToIndex(n);
        int n4 = this.yPts2g - this.yPixToIndex(n2) - 1;
        if (n3 < 1) {
            n3 = 1;
        } else if (n3 > this.xPts2g - 2) {
            n3 = this.xPts2g - 2;
        }
        if (n4 < 1) {
            n4 = 1;
        } else if (n4 > this.yPts2g - 2) {
            n4 = this.yPts2g - 2;
        }
        if (this.isConductor[n3][n4] || this.isConductor[n3 + 1][n4] || this.isConductor[n3 - 1][n4]) {
            return 0.0;
        }
        double d3 = this.potential[n3][n4 - 1];
        double d4 = this.potential[n3][n4];
        double d5 = this.potential[n3][n4 + 1];
        double d6 = d5 - d4;
        double d7 = d4 - d3;
        if (Math.abs(d6) > Math.abs(d7)) {
            return -d6 / this.yUnitPerCell;
        }
        return -d7 / this.yUnitPerCell;
    }

    final double dudy(int n, int n2) {
        if (this.yPixPerCell == 0.0) {
            return 0.0;
        }
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.yPts2g - 2) {
            n2 = this.yPts2g - 2;
        }
        double d = this.potential[n][n2 - 1];
        double d2 = this.potential[n][n2];
        double d3 = this.potential[n][n2 + 1];
        double d4 = d3 - d2;
        double d5 = d2 - d;
        if (Math.abs(d4) > Math.abs(d5)) {
            return -d4 / this.yUnitPerCell;
        }
        return -d5 / this.yUnitPerCell;
    }

    Thing getThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        return null;
    }

    final boolean isPixInsidePotentialObject(int n, int n2) {
        for (int i = this.things.size() - 1; i >= 0; --i) {
            PotentialObject potentialObject;
            Thing thing = (Thing)this.things.elementAt(i);
            if (!(thing instanceof PotentialObject) || (potentialObject = (PotentialObject)thing).getChargeType() != 0 || !potentialObject.isInsideThing(n, n2)) continue;
            this.defaultVoltage = potentialObject.getPotential();
            return true;
        }
        return false;
    }

    public double xFromPix(int n) {
        if (this.contour != null) {
            return this.contour.xFromPix(n);
        }
        return n;
    }

    public int pixFromX(double d) {
        if (this.contour != null) {
            return this.contour.pixFromX(d);
        }
        return (int)Math.round(d);
    }

    public double yFromPix(int n) {
        if (this.contour != null) {
            return this.contour.yFromPix(n);
        }
        return n;
    }

    public int pixFromY(double d) {
        if (this.contour != null) {
            return this.contour.pixFromY(d);
        }
        return (int)Math.round(d);
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (this.autoRefresh) {
            this.setConductors();
            this.invalidPotential = true;
            this.repaint();
            this.startThread();
        }
    }

    public void setActiveElementVoltage(double d) {
        this.defaultVoltage = d;
        if (this.activeElement != null) {
            this.activeElement.setV(d);
            this.setConductors();
            this.startThread();
        }
    }

    public class PotentialDataSource
    implements SDataSource {
        SApplet applet;
        String[] varStrings = new String[]{"surfacedata"};
        double[][] ds = new double[PoissonPanel.access$4(PoissonPanel.this)][PoissonPanel.access$5(PoissonPanel.this)];

        PotentialDataSource(SApplet sApplet) {
            this.applet = sApplet;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            return PoissonPanel.this.displaymatrix;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
            this.applet = sApplet;
        }

        public SApplet getOwner() {
            return this.applet;
        }
    }

    public class ChargeDataSource
    implements SDataSource {
        SApplet applet;
        String[] varStrings = new String[]{"surfacedata"};
        double[][] ds = new double[PoissonPanel.access$4(PoissonPanel.this)][PoissonPanel.access$5(PoissonPanel.this)];

        ChargeDataSource(SApplet sApplet) {
            this.applet = sApplet;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            int n;
            int n2;
            for (int i = 1 + PoissonPanel.this.gutter; i < PoissonPanel.this.xPtsg - 1; ++i) {
                for (int j = 1 + PoissonPanel.this.gutter; j < PoissonPanel.this.yPts - 1 + PoissonPanel.this.gutter; ++j) {
                    this.ds[i - ((PoissonPanel)PoissonPanel.this).gutter][j - ((PoissonPanel)PoissonPanel.this).gutter] = -PoissonPanel.this.inducedChargeScale * (PoissonPanel.this.potential[i][j] - (PoissonPanel.this.potential[i + 1][j] + PoissonPanel.this.potential[i - 1][j] + PoissonPanel.this.potential[i][j + 1] + PoissonPanel.this.potential[i][j - 1]) / 4.0);
                }
            }
            if (PoissonPanel.this.gutter == 0) {
                for (n2 = 1; n2 < PoissonPanel.this.xPts - 1; ++n2) {
                    n = 0;
                    double d = -(PoissonPanel.this.potential[n2][n] - PoissonPanel.this.potential[n2][n + 1]) / 2.0;
                    this.ds[n2 - ((PoissonPanel)PoissonPanel.this).gutter][n] = d * PoissonPanel.this.inducedChargeScale;
                    n = PoissonPanel.this.yPts - 1;
                    d = -(PoissonPanel.this.potential[n2][n] - PoissonPanel.this.potential[n2][n - 1]) / 2.0;
                    this.ds[n2 - ((PoissonPanel)PoissonPanel.this).gutter][n - ((PoissonPanel)PoissonPanel.this).gutter] = d * PoissonPanel.this.inducedChargeScale;
                }
            }
            if (PoissonPanel.this.gutter == 0) {
                for (n2 = 1 + PoissonPanel.this.gutter; n2 < PoissonPanel.this.yPts - 1; ++n2) {
                    n = 0;
                    double d = -(PoissonPanel.this.potential[n][n2] - PoissonPanel.this.potential[n + 1][n2]) / 2.0;
                    this.ds[n][n2 - ((PoissonPanel)PoissonPanel.this).gutter] = d * PoissonPanel.this.inducedChargeScale;
                    n = PoissonPanel.this.xPts - 1;
                    d = -(PoissonPanel.this.potential[n][n2] - PoissonPanel.this.potential[n - 1][n2]) / 2.0;
                    this.ds[n - ((PoissonPanel)PoissonPanel.this).gutter][n2] = d * PoissonPanel.this.inducedChargeScale;
                }
            }
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
            this.applet = sApplet;
        }

        public SApplet getOwner() {
            return this.applet;
        }
    }

    class PContour
    extends SContour {
        PContour() {
        }

        private void paintBeforeData_Special(Graphics graphics, Rectangle rectangle) {
            super.paintBeforeData(graphics, rectangle);
            for (int i = 0; i < PoissonPanel.this.things.size(); ++i) {
                Thing thing = (Thing)PoissonPanel.this.things.elementAt(i);
                if (thing instanceof FieldThing && thing.isVisible()) {
                    PoissonPanel.this.field.paint(graphics, rectangle, PoissonPanel.this.isConductor, PoissonPanel.this.gutter);
                } else {
                    thing.paint(graphics);
                }
                if (!(thing instanceof ContourThing)) continue;
                return;
            }
        }

        public void paintBeforeData(Graphics graphics, Rectangle rectangle) {
            if (PoissonPanel.this.hasContourThing) {
                this.paintBeforeData_Special(graphics, rectangle);
                return;
            }
            super.paintBeforeData(graphics, rectangle);
            for (int i = 0; i < PoissonPanel.this.things.size(); ++i) {
                Thing thing = (Thing)PoissonPanel.this.things.elementAt(i);
                if (thing instanceof PotentialObject) {
                    PotentialObject potentialObject = (PotentialObject)thing;
                    if (potentialObject.getChargeType() == 0) continue;
                    potentialObject.paint(graphics);
                    continue;
                }
                if (!(thing instanceof FieldThing) || !thing.isVisible()) continue;
                PoissonPanel.this.field.paint(graphics, rectangle, PoissonPanel.this.isConductor, PoissonPanel.this.gutter);
            }
            if (PoissonPanel.this.showFieldVectors && !PoissonPanel.this.hasFieldThing) {
                PoissonPanel.this.field.paint(graphics, rectangle, PoissonPanel.this.isConductor, PoissonPanel.this.gutter);
            }
        }

        private void paintLast_Special(Graphics graphics, Rectangle rectangle) {
            super.paintLast(graphics, rectangle);
            boolean bl = false;
            for (int i = 0; i < PoissonPanel.this.things.size(); ++i) {
                Thing thing = (Thing)PoissonPanel.this.things.elementAt(i);
                if (!bl) {
                    if (!(thing instanceof ContourThing)) continue;
                    bl = true;
                    continue;
                }
                if (thing instanceof FieldThing && thing.isVisible()) {
                    PoissonPanel.this.field.paint(graphics, rectangle, PoissonPanel.this.isConductor, PoissonPanel.this.gutter);
                    continue;
                }
                thing.paint(graphics);
            }
        }

        public void paintLast(Graphics graphics, Rectangle rectangle) {
            if (PoissonPanel.this.hasContourThing) {
                this.paintLast_Special(graphics, rectangle);
                return;
            }
            super.paintLast(graphics, rectangle);
            for (int i = 0; i < PoissonPanel.this.things.size(); ++i) {
                Thing thing = (Thing)PoissonPanel.this.things.elementAt(i);
                if (thing instanceof PotentialObject) {
                    PotentialObject potentialObject = (PotentialObject)thing;
                    if (potentialObject.getChargeType() != 0) continue;
                    potentialObject.paint(graphics);
                    continue;
                }
                thing.paint(graphics);
            }
        }
    }
}

