/*
 * Decompiled with CFR 0.152.
 */
package poisson;

import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import java.awt.Color;
import java.awt.Graphics;
import poisson.PoissonPanel;

public class PotentialObject
extends Thing {
    static final int CONDUCTOR_TYPE = 0;
    static final int DENSITY_TYPE = 1;
    static final int DIELECTRIC_TYPE = 2;
    private int type = 0;
    PoissonPanel p = null;
    double v;
    boolean showCharge = false;
    double constantQ = 1.0;
    boolean isConstantQ = false;

    public PotentialObject(PoissonPanel poissonPanel, double d, double d2, double d3) {
        super((SScalable)poissonPanel);
        this.varStrings = new String[]{"x", "y", "q", "v", "p"};
        this.ds = new double[1][5];
        this.noDrag = false;
        this.color = Color.darkGray;
        this.w = 50;
        this.h = 50;
        this.p = poissonPanel;
        this.x = d;
        this.y = d2;
        this.setV(d3);
    }

    public void paint(Graphics graphics) {
    }

    public void paintActive(Graphics graphics) {
        if (this.noDrag && !this.resizable) {
            return;
        }
        int n = this.canvas.pixFromX(this.x);
        int n2 = this.canvas.pixFromY(this.y);
        if (this.resizable) {
            graphics.setColor(Color.black);
            graphics.drawRect(n - this.w / 2, n2 - this.h / 2, this.w, this.h);
            graphics.drawRect(n + 1 - this.w / 2, n2 + 1 - this.h / 2, this.w - 2, this.h - 2);
        } else {
            graphics.setColor(Color.darkGray);
            graphics.drawRect(n - this.w / 2, n2 - this.h / 2, this.w, this.h);
        }
        if (!this.noDrag) {
            graphics.drawRect(n - 10, n2 - 10, 20, 20);
            graphics.drawRect(n - 10 + 1, n2 - 10 + 1, 18, 18);
        }
        if (this.resizable) {
            graphics.fillRect(n + this.w / 2 - 1, n2 - 5, 6, 10);
            graphics.fillRect(n - 5, n2 + this.h / 2 - 1, 10, 6);
            graphics.fillRect(n + this.w / 2, n2 + this.h / 2, 5, 5);
        }
    }

    public final void setPosition(int n, int n2) {
        int n3 = this.canvas.pixFromX(this.x);
        int n4 = this.canvas.pixFromY(this.y);
        if (n3 == n && n4 == n2) {
            return;
        }
        this.x = this.canvas.xFromPix(n);
        this.y = this.canvas.yFromPix(n2);
        if (this.constraint != null) {
            this.constraint.enforceConstraint((Thing)this);
        }
        this.updateMySlaves();
    }

    private final void calcColor() {
        this.color = this.type == 1 ? (this.v < 0.0 ? new Color(191, 191, 255) : (this.v > 0.0 ? new Color(255, 191, 191) : Color.darkGray)) : (this.type == 2 ? new Color(191, 191, 191) : (this.v < 0.0 ? Color.blue : (this.v > 0.0 ? Color.red : Color.black)));
    }

    public double getCharge() {
        return this.p.calcCharge(this);
    }

    public double getPotentialEnergy() {
        return this.p.calcPotentialEnergy(this);
    }

    public final double getPotential() {
        return this.v;
    }

    public final double getQ() {
        return this.constantQ;
    }

    public final void setConstantQ(double d, boolean bl) {
        if (this.getChargeType() != 0) {
            this.isConstantQ = false;
            return;
        }
        this.constantQ = d;
        this.isConstantQ = bl;
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.x;
        this.ds[0][1] = this.y;
        this.ds[0][2] = this.p.calcCharge(this);
        this.ds[0][3] = this.v;
        this.ds[0][4] = this.p.calcPotentialEnergy(this);
        return this.ds;
    }

    public final void setChargeType(int n) {
        this.type = n;
        this.calcColor();
    }

    public final int getChargeType() {
        return this.type;
    }

    final void setShowCharge(boolean bl) {
        this.showCharge = bl;
    }

    public void setHeight(int n) {
        n = Math.abs(n);
        this.h = Math.max(n, (int)this.p.yPixPerCell * 2);
    }

    public void setWidth(int n) {
        n = Math.abs(n);
        this.w = Math.max(n, (int)this.p.xPixPerCell * 2);
    }

    public void setV(double d) {
        if (d == this.v) {
            return;
        }
        this.v = d;
        this.calcColor();
    }

    public void setVoltage(double d) {
        if (this.type != 0) {
            System.out.println("Error: trying to set the voltage of a non-conductor.");
            return;
        }
        if (d == this.v) {
            return;
        }
        this.v = d;
    }

    public void setChi(double d) {
        if (this.type != 2) {
            System.out.println("Error: trying to set chi for a non-dielectric.");
            return;
        }
        if (d < 0.0) {
            System.out.println("Error: must be >0.");
            return;
        }
        this.v = d;
    }

    public void setChargeDensity(double d) {
        if (this.type != 1) {
            System.out.println("Error: trying to set the chage density.");
            return;
        }
        this.v = d;
    }

    void setConductors(PoissonPanel poissonPanel) {
    }

    public boolean isInsideThing(int n, int n2) {
        int n3 = this.canvas.pixFromX(this.x);
        int n4 = this.canvas.pixFromY(this.y);
        return n >= n3 - this.w / 2 && n2 >= n4 - this.h / 2 && n <= n3 + this.w / 2 && n2 <= n4 + this.h / 2;
    }

    public int isInsideHotSpot(int n, int n2) {
        if (this.noDrag && !this.resizable) {
            return 0;
        }
        int n3 = this.canvas.pixFromX(this.x);
        int n4 = this.canvas.pixFromY(this.y);
        if (this.resizable && n >= n3 + this.w / 2 && n2 >= n4 + this.h / 2 && n <= n3 + this.w / 2 + 5 && n2 <= n4 + this.h / 2 + 5) {
            return 4;
        }
        if (!this.noDrag && n >= n3 - 10 && n2 >= n4 - 10 && n <= n3 + 10 && n2 <= n4 + 10) {
            return 1;
        }
        if (this.resizable && n >= n3 + this.w / 2 - 1 && n2 >= n4 - 5 && n <= n3 + this.w / 2 - 1 + 6 && n2 <= n4 + 5) {
            return 2;
        }
        if (this.resizable && n2 >= n4 + this.h / 2 - 1 && n >= n3 - 5 && n2 <= n4 + this.h / 2 - 1 + 6 && n <= n3 + 5) {
            return 3;
        }
        if (n >= n3 - this.w / 2 && n2 >= n4 - this.h / 2 && n <= n3 + this.w / 2 && n2 <= n4 + this.h / 2) {
            return 5;
        }
        return 0;
    }

    static {
        CONDUCTOR_TYPE = 0;
        DENSITY_TYPE = 1;
        DIELECTRIC_TYPE = 2;
    }
}

