/*
 * Decompiled with CFR 0.152.
 */
package poisson;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public final class VectorField {
    static int halfWidth = 175;
    static int[] saturation = new int[halfWidth * 2];
    double[][][] field;
    int row = 0;
    int col = 0;
    double scale = 1.0;
    double length = 15.0;

    public VectorField(int n, int n2) {
        this.field = new double[n][n2][3];
        VectorField.calSaturation();
        this.row = n;
        this.col = n2;
    }

    private static void calSaturation() {
        int n = halfWidth * 2;
        for (int i = 0; i < n; ++i) {
            double d = 1.4 * (double)(i - halfWidth) / (double)halfWidth;
            VectorField.saturation[i] = (int)((double)255 * Math.exp(-d * d));
        }
    }

    public double[][][] resize(int n, int n2) {
        if (n == this.row && n2 == this.col) {
            return this.field;
        }
        this.field = new double[n][n2][3];
        this.row = n;
        this.col = n2;
        return this.field;
    }

    public void setGridValue(int n, int n2, double d, double d2, double d3) {
        this.field[n][n2][0] = d;
        this.field[n][n2][1] = d2;
        this.field[n][n2][2] = d3;
    }

    public void setLength(double d) {
        this.length = d;
    }

    private final Color getColor(double d) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = (int)((double)100 * d);
        if (n4 > 100 - halfWidth && n4 < 100 + halfWidth) {
            n3 = saturation[n4 - 100 + halfWidth];
        }
        if (n4 > 275 - halfWidth && n4 < 275 + halfWidth) {
            n2 = saturation[n4 - 275 + halfWidth];
        }
        if (n4 > 450 - halfWidth && n4 < 450 + halfWidth) {
            n = saturation[n4 - 450 + halfWidth];
        }
        return new Color(n, n2, n3);
    }

    private final Color colorFromMag(double d) {
        if ((d *= this.scale) > 1.0) {
            return this.getColor(d);
        }
        int n = (int)((double)255 * (1.0 - d));
        int n2 = (int)((double)255 * (1.0 - d));
        int n3 = 255;
        return new Color(n, n2, n3);
    }

    public void paint(Graphics graphics, Rectangle rectangle, boolean[][] blArray, int n) {
        if (this.row == 0 || this.col == 0) {
            return;
        }
        double d = 2.0;
        int n2 = (blArray[0].length - 2 * n) / this.row;
        double d2 = (double)rectangle.width / (double)this.col;
        double d3 = (double)rectangle.height / (double)this.row;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = d2 / 4.0;
        double d6 = d3 * 3.0 / 4.0;
        for (int i = 0; i < this.row; ++i) {
            int n3 = (int)d6;
            d5 = d2 / 4.0;
            for (int j = 0; j < this.col; ++j) {
                if (!blArray[n + j * n2][n + (this.row - i - 1) * n2]) {
                    int n4 = (int)d5;
                    double d7 = this.field[i][j][0];
                    double d8 = this.field[i][j][1];
                    double d9 = this.field[i][j][2];
                    graphics.setColor(this.colorFromMag(d9));
                    int n5 = (int)(d4 * d7 * (double)n2 / 4.0);
                    int n6 = -((int)(d4 * d8 * (double)n2 / 4.0));
                    int n7 = n5 + n4;
                    int n8 = n6 + n3;
                    graphics.drawLine(n4, n3, n7, n8);
                    double d10 = d * (double)n5 / this.length;
                    double d11 = d * (double)n6 / this.length;
                    double d12 = (double)n7 - (double)3 * d10;
                    double d13 = (double)n8 - (double)3 * d11;
                    graphics.drawLine((int)(d12 - d11), (int)(d13 + d10), n7, n8);
                    graphics.drawLine((int)(d12 + d11), (int)(d13 - d10), n7, n8);
                }
                d5 += d2;
            }
            d6 += d3;
        }
    }
}

