/*
 * Decompiled with CFR 0.152.
 */
package blackbody;

import blackbody.BlackBody_autox_itemAdapter;
import blackbody.BlackBody_autoy_itemAdapter;
import blackbody.BlackBody_graph_mouseAdapter;
import blackbody.BlackBody_graph_mouseMotionAdapter;
import blackbody.BlackBody_redNumber_actionAdapter;
import blackbody.BlackBody_slider_adjustmentAdapter;
import blackbody.BlackBody_slider_mouseAdapter;
import blackbody.BlackBody_tempNumber_actionAdapter;
import edu.davidson.display.CaptionThing;
import edu.davidson.display.Format;
import edu.davidson.display.SGraph;
import edu.davidson.display.SNumber;
import edu.davidson.display.SScalable;
import edu.davidson.display.SSlider;
import edu.davidson.display.Thing;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.graphics.SPanel;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;

public class BlackBody
extends SApplet
implements Runnable,
SDataSource {
    static double h = 6.626075E-34;
    static double c = 2.99792458E8;
    static double k = 1.380658E-23;
    static double pi = Math.PI;
    static double exp = Math.E;
    static double phcc = (double)2 * pi * h * c * c;
    static double hc = h * c;
    static int np = 1000;
    static int halfWidth = 160;
    static int[] saturation = new int[halfWidth * 2];
    Object lock = new Object();
    private Thread paintThread = null;
    String[] varStrings = new String[]{"t", "lambda"};
    double[][] ds = new double[1][2];
    boolean isStandalone = false;
    BBGraph graph = new BBGraph();
    PyroPanel swatch = new PyroPanel();
    Checkbox autox = new Checkbox();
    Checkbox autoy = new Checkbox();
    SNumber redNumber = new SNumber();
    SNumber greenNumber = new SNumber();
    SNumber blueNumber = new SNumber();
    Label label1 = new Label();
    Label label2 = new Label();
    Label label3 = new Label();
    SNumber totalNumber = new SNumber();
    EtchedBorder bevelPanel1 = new EtchedBorder();
    FlowLayout flowLayout1 = new FlowLayout();
    Label label4 = new Label();
    EtchedBorder bevelPanel2 = new EtchedBorder();
    EtchedBorder bevelPanel3 = new EtchedBorder();
    double temperature;
    double lambda;
    int r;
    int g;
    int b;
    int greenColor;
    boolean showControls = true;
    boolean colorSwatch = true;
    boolean enableCursor = true;
    int i = 0;
    int xPos1;
    int xPos2;
    double[] x = new double[np];
    double[] y = new double[np];
    boolean newData = false;
    BorderLayout borderLayout3 = new BorderLayout();
    Label label5 = new Label();
    Label label6 = new Label();
    BorderLayout borderLayout4 = new BorderLayout();
    Format mouseFormat = new Format("%-3.3g");
    SSlider slider = new SSlider();
    SNumber tempNumber = new SNumber();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();

    public static void calSaturation() {
        int n = halfWidth * 2;
        for (int i = 0; i < n; ++i) {
            double d = 1.4 * (double)(i - halfWidth) / (double)halfWidth;
            BlackBody.saturation[i] = (int)((double)255 * Math.exp(-d * d));
        }
    }

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.colorSwatch = Boolean.valueOf(this.getParameter("ColorSwatch", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.enableCursor = Boolean.valueOf(this.getParameter("EnableCursor", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.temperature = Double.valueOf(this.getParameter("Temp", "5321"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.graph.setSeriesStyle(1, Color.red, true, 0);
        this.graph.setAutoReplaceData(1, true);
        BlackBody.calSaturation();
        this.tempNumber.setFormat("%+6.2f");
        this.paintThread = new Thread(this);
        this.paintThread.start();
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        ((Component)((Object)this)).setBackground(Color.white);
        ((Component)((Object)this)).setSize(new Dimension(445, 378));
        this.graph.setBorders("20,20,50,20");
        this.graph.setLabelY("Energy Density [J^{.}s/m^{3}]");
        ((Component)((Object)this.graph)).addMouseMotionListener(new BlackBody_graph_mouseMotionAdapter(this));
        ((Component)((Object)this.graph)).addMouseListener(new BlackBody_graph_mouseAdapter(this));
        this.autox.setState(true);
        this.autox.addItemListener(new BlackBody_autox_itemAdapter(this));
        this.autox.setVisible(true);
        this.autox.setLabel("Auto X");
        this.autoy.setState(true);
        this.autoy.addItemListener(new BlackBody_autoy_itemAdapter(this));
        ((Container)((Object)this.swatch)).setLayout(this.borderLayout4);
        this.label1.setText("blue");
        this.label2.setText("green");
        this.label3.setText("red");
        this.bevelPanel1.setVisible(false);
        this.label4.setText("total");
        this.label5.setText("Blackbody Radiation");
        this.label6.setBackground(Color.black);
        this.label6.setForeground(Color.white);
        this.label6.setText("        Colors");
        this.slider.addMouseListener(new BlackBody_slider_mouseAdapter(this));
        this.slider.addAdjustmentListener(new BlackBody_slider_adjustmentAdapter(this));
        this.bevelPanel3.setLayout(this.borderLayout3);
        this.bevelPanel2.setLayout(this.borderLayout2);
        this.bevelPanel1.setLayout(this.flowLayout1);
        this.redNumber.addActionListener(new BlackBody_redNumber_actionAdapter(this));
        this.autoy.setVisible(true);
        this.autoy.setLabel("Auto Y");
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        ((Container)((Object)this)).add((Component)((Object)this.graph), "Center");
        if (this.colorSwatch) {
            ((Container)((Object)this)).add((Component)((Object)this.swatch), "West");
        }
        ((Component)((Object)this.swatch)).setBackground(Color.black);
        ((Component)((Object)this.graph)).setBackground(new Color(230, 230, 230));
        this.graph.setLabelX("Wavelength [m]");
        if (this.showControls) {
            ((Container)((Object)this)).add((Component)this.bevelPanel2, "South");
        }
        this.bevelPanel2.add((Component)this.bevelPanel1, "North");
        this.bevelPanel1.add((Component)this.label1, null);
        this.bevelPanel1.add((Component)this.blueNumber, null);
        this.bevelPanel1.add((Component)this.label2, null);
        this.bevelPanel1.add((Component)this.greenNumber, null);
        this.bevelPanel1.add((Component)this.label3, null);
        this.bevelPanel1.add((Component)this.redNumber, null);
        this.bevelPanel1.add((Component)this.label4, null);
        this.bevelPanel1.add((Component)this.totalNumber, null);
        this.bevelPanel2.add((Component)this.bevelPanel3, "South");
        this.bevelPanel3.add((Component)this.autox, "West");
        this.bevelPanel3.add((Component)this.autoy, "Center");
        this.bevelPanel3.add((Component)this.label5, "East");
        this.bevelPanel2.add((Component)this.slider, "Center");
        this.bevelPanel2.add((Component)this.tempNumber, "East");
        this.setT(this.temperature);
        this.slider.setDValue(this.temperature / (double)10000);
        this.tempNumber.addActionListener(new BlackBody_tempNumber_actionAdapter(this));
    }

    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.newData = true;
            this.graph.iheight = 0;
            this.lock.notify();
        }
    }

    public void setDefault() {
        this.pause();
        this.deleteDataConnections();
        this.graph.clearAllThings();
    }

    public void destroy() {
        this.graph.destroy();
        this.paintThread = null;
        Object object = this.lock;
        synchronized (object) {
            this.newData = true;
            this.lock.notify();
        }
        super.destroy();
    }

    public String getAppletInfo() {
        return "Name: BlackBody\r\nAuthor: Wolfgang Christian and Mike Lee\r\nemail:wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Temp", "double", "Temperature"}, {"ShowControls", "boolean", "whether or not to show UI controls"}, {"colorSwatch", "integer", "whether or not to show color swatch"}, {"EnableCursor", "integer", "whether or not to enable cursor"}};
        return stringArray;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.temperature;
        this.ds[0][1] = this.lambda * 1.0E9;
        return this.ds;
    }

    public int addCaption(String string) {
        CaptionThing captionThing = new CaptionThing((SApplet)this, (SScalable)this.graph, string, 0.0, 0.0);
        captionThing.setDisplayOff(0, -40);
        int n = this.graph.addThing((Thing)captionThing);
        Object object = this.lock;
        synchronized (object) {
            this.newData = true;
            this.lock.notify();
        }
        this.graph.repaint();
        return n;
    }

    public synchronized void setRGB(int n, int n2, int n3, int n4) {
        Color color = new Color(n2, n3, n4);
        this.graph.setObjectColor(n, color);
    }

    public boolean setDisplayOffset(int n, int n2, int n3) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDisplayOff(n2, n3);
        Object object = this.lock;
        synchronized (object) {
            this.newData = true;
            this.lock.notify();
        }
        this.graph.repaint();
        return true;
    }

    public void setTemperature(double d) {
        this.setT(d);
    }

    public void setT(double d) {
        this.graph.clearSeries(1);
        double d2 = 1.0E-6;
        double d3 = d2 / (double)np;
        this.temperature = d;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = (double)np / 60.0;
        this.i = 1;
        while (this.i < np) {
            this.x[this.i] = (double)this.i * d3;
            this.y[this.i] = this.x[this.i] * k * this.temperature <= 0.0 ? 0.0 : phcc / ((Math.pow(exp, hc / (this.x[this.i] * k * this.temperature)) - 1.0) * Math.pow(this.x[this.i], 5.0));
            if ((double)this.i >= (double)19 * d10 & (double)this.i <= (double)29 * d10) {
                d6 += this.y[this.i];
            }
            if ((double)this.i >= (double)29 * d10 & (double)this.i <= (double)38 * d10) {
                d5 += this.y[this.i];
            }
            if ((double)this.i >= (double)38 * d10 & (double)this.i <= (double)46 * d10) {
                d4 += this.y[this.i];
            }
            ++this.i;
        }
        d7 = d6 + d5 + d4;
        d9 = Math.max(d6, d4);
        d9 = Math.max(d9, d5);
        double d11 = d4 < 6.158 ? 0.0 : 255.0 * d4 / d9 * (Math.log(d7) / (double)20);
        double d12 = d5 < 6.158 ? 0.0 : 255.0 * d5 / d9 * (Math.log(d7) / (double)20);
        double d13 = d6 < 6.158 ? 0.0 : 255.0 * d6 / d9 * (Math.log(d7) / (double)20);
        this.r = (int)Math.min(d11, 255.0);
        this.greenColor = this.g = (int)Math.min(d12, 255.0);
        this.b = (int)Math.min(d13, 255.0);
        this.redNumber.setValue(d4);
        this.greenNumber.setValue(d5);
        this.blueNumber.setValue(d6);
        this.totalNumber.setValue(d7);
        this.graph.addData(1, this.x, this.y);
        ((Component)((Object)this.swatch)).repaint();
        this.tempNumber.setValue(this.temperature);
        this.lambda = 0.0029 / this.temperature;
        Object object = this.lock;
        synchronized (object) {
            this.newData = true;
            this.lock.notify();
        }
        this.updateDataConnections();
    }

    public void run() {
        while (this.paintThread != null) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.newData) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.newData = false;
                if (this.paintThread != null) {
                    this.graph.paintImage();
                }
            }
            if (this.paintThread == null) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setAutoscale(boolean bl, boolean bl2) {
        if (bl) {
            this.graph.setAutoscaleX(true);
        } else {
            this.graph.setAutoscaleX(false);
        }
        if (bl2) {
            this.graph.setAutoscaleY(true);
        } else {
            this.graph.setAutoscaleY(false);
        }
    }

    void slider_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setT(this.slider.getDValue() * (double)10000);
        this.graph.repaint();
    }

    void redNumber_actionPerformed(ActionEvent actionEvent) {
    }

    void graph_mousePressed(MouseEvent mouseEvent) {
        if (this.enableCursor) {
            Graphics graphics = ((Component)((Object)this.graph)).getGraphics();
            graphics.setColor(Color.yellow);
            graphics.fillRect(25, this.graph.pixFromY(0.0) + 28, 155, 15);
            this.lambda = 0.0029 / this.temperature;
            this.xPos1 = this.graph.pixFromX(this.lambda);
            graphics.setColor(Color.blue);
            graphics.drawLine(this.xPos1, 0, this.xPos1, 12);
            graphics.drawLine(this.xPos1, 12, this.xPos1 - 3, 9);
            graphics.drawLine(this.xPos1, 12, this.xPos1 + 3, 9);
            this.xPos2 = mouseEvent.getX();
            if (this.xPos2 <= this.graph.pixFromX(0.0)) {
                this.xPos2 = this.graph.pixFromX(0.0) + 1;
            }
            if (this.xPos2 >= this.graph.pixFromX(1.0E-6)) {
                this.xPos2 = this.graph.pixFromX(1.0E-6);
            }
            graphics.drawLine(this.xPos2, 0, this.xPos2, 12);
            graphics.drawLine(this.xPos2, 12, this.xPos2 - 3, 9);
            graphics.drawLine(this.xPos2, 12, this.xPos2 + 3, 9);
            this.lambda = this.graph.xFromPix(this.xPos2);
            graphics.drawString(String.valueOf(new StringBuffer("lambda max = ").append(this.mouseFormat.form(this.lambda * 1.0E9)).append(" nm")), 30, this.graph.pixFromY(0.0) + 40);
            this.slider.setDValue(0.0029 / this.lambda / (double)10000);
            this.tempNumber.setValue(0.0029 / this.lambda);
            this.temperature = 0.0029 / this.lambda;
            graphics.dispose();
            this.updateDataConnections();
        }
    }

    void graph_mouseDragged(MouseEvent mouseEvent) {
        if (this.enableCursor) {
            Graphics graphics = ((Component)((Object)this.graph)).getGraphics();
            graphics.setColor(new Color(230, 230, 230));
            graphics.drawLine(this.xPos2, 0, this.xPos2, 12);
            graphics.drawLine(this.xPos2, 12, this.xPos2 - 3, 9);
            graphics.drawLine(this.xPos2, 12, this.xPos2 + 3, 9);
            graphics.setColor(Color.yellow);
            graphics.fillRect(25, this.graph.pixFromY(0.0) + 28, 155, 15);
            graphics.setColor(Color.blue);
            this.xPos2 = mouseEvent.getX();
            if (this.xPos2 <= this.graph.pixFromX(0.0)) {
                this.xPos2 = this.graph.pixFromX(0.0) + 1;
            }
            if (this.xPos2 >= this.graph.pixFromX(1.0E-6)) {
                this.xPos2 = this.graph.pixFromX(1.0E-6);
            }
            graphics.drawLine(this.xPos1, 0, this.xPos1, 12);
            graphics.drawLine(this.xPos1, 12, this.xPos1 - 3, 9);
            graphics.drawLine(this.xPos1, 12, this.xPos1 + 3, 9);
            graphics.drawLine(this.xPos2, 0, this.xPos2, 12);
            graphics.drawLine(this.xPos2, 12, this.xPos2 - 3, 9);
            graphics.drawLine(this.xPos2, 12, this.xPos2 + 3, 9);
            this.lambda = this.graph.xFromPix(this.xPos2);
            graphics.drawString(String.valueOf(new StringBuffer("lambda max = ").append(this.mouseFormat.form(this.lambda * 1.0E9)).append(" nm")), 30, this.graph.pixFromY(0.0) + 40);
            this.slider.setDValue(0.0029 / this.lambda / (double)10000);
            this.tempNumber.setValue(0.0029 / this.lambda);
            this.temperature = 0.0029 / this.lambda;
            graphics.dispose();
            this.updateDataConnections();
        }
    }

    void graph_mouseReleased(MouseEvent mouseEvent) {
        if (this.enableCursor) {
            this.xPos2 = mouseEvent.getX();
            if (this.xPos2 <= this.graph.pixFromX(0.0)) {
                this.xPos2 = this.graph.pixFromX(0.0) + 1;
            }
            if (this.xPos2 >= this.graph.pixFromX(1.0E-6)) {
                this.xPos2 = this.graph.pixFromX(1.0E-6);
            }
            this.lambda = this.graph.xFromPix(this.xPos2);
            this.setT(0.0029 / this.lambda);
            this.slider.setDValue(0.0029 / this.lambda / (double)10000);
            this.tempNumber.setValue(0.0029 / this.lambda);
        }
    }

    void slider_mouseReleased(MouseEvent mouseEvent) {
        this.setAutoscale(this.autox.getState(), this.autoy.getState());
        this.setT(this.slider.getDValue() * (double)10000);
        this.graph.repaint();
    }

    void graph_mouseEntered(MouseEvent mouseEvent) {
        if (this.enableCursor) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    void graph_mouseExited(MouseEvent mouseEvent) {
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
    }

    void autoy_itemStateChanged(ItemEvent itemEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.newData = true;
            this.lock.notify();
        }
        this.setAutoscale(this.autox.getState(), this.autoy.getState());
    }

    void autox_itemStateChanged(ItemEvent itemEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.newData = true;
            this.lock.notify();
        }
        this.setAutoscale(this.autox.getState(), this.autoy.getState());
    }

    void tempNumber_actionPerformed(ActionEvent actionEvent) {
        this.setT(this.tempNumber.getValue());
        this.slider.setDValue(this.tempNumber.getValue() / (double)10000);
    }

    class PyroPanel
    extends SPanel {
        public PyroPanel() {
            this.setMinimumSize(new Dimension(80, 100));
            this.setPreferredSize(new Dimension(80, 100));
        }

        public void paint(Graphics graphics) {
            graphics.setColor(new Color(BlackBody.this.r, 0, 0));
            graphics.fillOval(((Component)((Object)this)).getBounds().width / 2 - 15, 15, 30, 30);
            graphics.setColor(Color.white);
            graphics.drawString("R", ((Component)((Object)this)).getBounds().width / 2 - 30, 35);
            graphics.setColor(new Color(0, BlackBody.this.greenColor, 0));
            graphics.fillOval(((Component)((Object)this)).getBounds().width / 2 - 15, 50, 30, 30);
            graphics.setColor(Color.white);
            graphics.drawString("G", ((Component)((Object)this)).getBounds().width / 2 - 30, 70);
            graphics.setColor(new Color(0, 0, BlackBody.this.b));
            graphics.fillOval(((Component)((Object)this)).getBounds().width / 2 - 15, 85, 30, 30);
            graphics.setColor(Color.white);
            graphics.drawString("B", ((Component)((Object)this)).getBounds().width / 2 - 30, 105);
            graphics.setColor(new Color(BlackBody.this.r, BlackBody.this.greenColor, BlackBody.this.b));
            graphics.fillOval(((Component)((Object)this)).getBounds().width / 2 - 20, 150, 40, 40);
            graphics.setColor(Color.white);
            graphics.drawString("Appearance", ((Component)((Object)this)).getBounds().width / 2 - 35, 210);
            graphics.setColor(Color.white);
            graphics.drawString(String.valueOf(new StringBuffer("T=").append((long)BlackBody.this.temperature).append(" K")), ((Component)((Object)this)).getBounds().width / 2 - 30, 240);
        }
    }

    class BBGraph
    extends SGraph {
        int iheight = 0;
        int iwidth = 0;
        Image osi = null;

        BBGraph() {
        }

        public void paint(Graphics graphics) {
            Object object = BlackBody.this.lock;
            synchronized (object) {
                if (!BlackBody.this.newData && this.osi != null) {
                    graphics.drawImage(this.osi, 0, 0, (ImageObserver)((Object)this));
                } else {
                    super.paint(graphics);
                }
            }
        }

        public void paintImage() {
            if (this.osi == null || this.iwidth != ((Component)((Object)this)).getSize().width || this.iheight != ((Component)((Object)this)).getSize().height) {
                this.iwidth = ((Component)((Object)this)).getSize().width;
                this.iheight = ((Component)((Object)this)).getSize().height;
                if (this.iheight < 10 || this.iwidth < 10) {
                    this.osi = null;
                    return;
                }
                this.osi = ((Component)((Object)this)).createImage(this.iwidth, this.iheight);
            }
            if (this.osi == null) {
                return;
            }
            Graphics graphics = this.osi.getGraphics();
            graphics.setColor(((Component)((Object)this)).getBackground());
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
            graphics.setColor(Color.black);
            super.paint(graphics);
            graphics.dispose();
            Graphics graphics2 = ((Component)((Object)this)).getGraphics();
            graphics2.drawImage(this.osi, 0, 0, (ImageObserver)((Object)this));
            graphics2.dispose();
        }

        public final double getIntensity(double d) {
            if (d * k * BlackBody.this.temperature <= 0.0) {
                return 0.0;
            }
            return phcc / ((Math.pow(exp, hc / (d * k * BlackBody.this.temperature)) - 1.0) * Math.pow(d, 5.0));
        }

        public final Color getColor(double d) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = (int)(d * 1.0E9);
            if (n4 > 400 - halfWidth && n4 < 400 + halfWidth) {
                n3 = saturation[n4 - 400 + halfWidth];
            }
            if (n4 > 500 - halfWidth && n4 < 500 + halfWidth) {
                n2 = saturation[n4 - 500 + halfWidth];
            }
            if (n4 > 600 - halfWidth && n4 < 600 + halfWidth) {
                n = saturation[n4 - 600 + halfWidth];
            }
            return new Color(n, n2, n3);
        }

        public void paintLast(Graphics graphics, Rectangle rectangle) {
            this.paintSpectrum(graphics);
            super.paintLast(graphics, rectangle);
        }

        public void paintSpectrum(Graphics graphics) {
            int n = this.pixFromX(BlackBody.this.x[1]);
            int n2 = this.pixFromX(BlackBody.this.x[np - 1]);
            int n3 = this.pixFromY(0.0);
            double d = 0.0;
            double d2 = 0.0;
            for (int i = n; i < n2; ++i) {
                d2 = this.xFromPix(i);
                d = this.getIntensity(d2);
                graphics.setColor(this.getColor(d2));
                graphics.drawLine(i, n3, i, this.pixFromY(d));
            }
        }
    }
}

