/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.views;

import edu.davidson.display.Format;
import edu.davidson.views.SGridPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SGrid
extends Panel {
    SGridPanel gridpanel = null;
    int nRows = 50;
    int nCols = 3;
    int preferredWidth = 20;
    int preferredHeight = 20;
    int currentWidth = 0;
    int currentHeight = 0;
    int defaultCellWidth = 40;
    int defaultCellHeight = 20;
    private Cell[][] cells = null;
    Image osi = null;
    Font font = new Font("TimesRoman", 0, 12);
    Font hlFont = new Font("TimesRoman", 1, 12);
    Color silver = new Color(224, 224, 224);
    Cell hlCell = null;
    boolean showColHeader = true;
    boolean showRowHeader = true;
    boolean autoscaleRows = false;
    boolean autoscaleCols = false;
    boolean autoRefresh = true;
    boolean lastOnTop = false;
    boolean showHLCell = false;
    int maxRow = 1;
    Format defaultFormat = new Format("%-+6.2f");
    String[] colLabels = null;
    int[] stride = null;
    int[] skipCounter = null;
    int[] nextRow = null;

    public SGrid(SGridPanel sGridPanel) {
        this();
        this.gridpanel = sGridPanel;
    }

    public SGrid(int n, int n2) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setBackground(this.silver);
        this.nRows = n + 1;
        this.nCols = n2 + 1;
        this.initCells(this.nRows, this.nCols);
    }

    public SGrid() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setBackground(this.silver);
        this.initCells(this.nRows, this.nCols);
    }

    public void addDatum(int n, double d) {
        if (n >= this.nCols) {
            System.out.println("Error: Data table initialized with insufficient number of rows.");
            return;
        }
        if (this.lastOnTop) {
            this.addOnTop(n, d);
            return;
        }
        int n2 = n;
        this.skipCounter[n2] = this.skipCounter[n2] - 1;
        if (this.skipCounter[n] > 0) {
            return;
        }
        this.skipCounter[n] = this.stride[n];
        if (this.nextRow[n] == this.nRows) {
            return;
        }
        this.cells[this.nextRow[n]][n].setValue(d);
        if (this.nextRow[n] < this.nRows) {
            int n3 = n;
            this.nextRow[n3] = this.nextRow[n3] + 1;
        }
    }

    public void addData(int n, double[] dArray) {
        this.clearSeries(n);
        for (int i = 1; i < Math.min(dArray.length + 1, this.maxRow); i += this.stride[n]) {
            this.cells[i][n].setValue(dArray[i - 1]);
        }
    }

    public void addOnTop(int n, double d) {
        int n2 = n;
        this.skipCounter[n2] = this.skipCounter[n2] - 1;
        if (this.skipCounter[n] > 0) {
            return;
        }
        this.skipCounter[n] = this.stride[n];
        if (this.nextRow[n] < this.maxRow - 1) {
            int n3 = n;
            this.nextRow[n3] = this.nextRow[n3] + 1;
        }
        for (int i = this.nextRow[n]; i > 1; --i) {
            this.cells[i][n].setValue(this.cells[i - 1][n].str);
        }
        this.cells[1][n].setValue(d);
    }

    void setDefaultCellWidth(int n) {
        this.defaultCellWidth = n;
    }

    public void setDefault() {
        int n;
        for (n = 1; n < this.nRows; ++n) {
            for (int i = 1; i < this.nCols; ++i) {
                this.cells[n][i].str = "";
                this.cells[n][i].value = 0.0;
            }
        }
        for (n = 1; n < this.nCols; ++n) {
            this.nextRow[n] = 1;
            this.skipCounter[n] = 1;
            this.stride[n] = 1;
        }
        this.setGridSize();
    }

    synchronized void sizeToFit() {
        if (this.nCols < 2 || this.nRows < 2) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = this.cells[0][0].width;
        int n4 = this.cells[0][0].height;
        if (!this.showRowHeader) {
            n3 = 0;
        }
        if (!this.showColHeader) {
            n4 = 0;
        }
        int n5 = (n - n3) / (this.nCols - 1);
        int n6 = (n2 - n4) / (this.nRows - 1);
        this.currentWidth = 0;
        this.currentHeight = 0;
        for (int i = 0; i < this.maxRow; ++i) {
            this.currentWidth = 0;
            for (int j = 0; j < this.nCols; ++j) {
                this.cells[i][j].width = j == 0 ? n3 : n5;
                this.cells[i][j].height = i == 0 ? n4 : n6;
                this.currentWidth += this.cells[0][j].width;
            }
            this.currentHeight += this.cells[i][0].height;
        }
        this.osi = null;
        this.invalidate();
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    synchronized void setGridSize() {
        this.currentWidth = 0;
        this.currentHeight = 0;
        for (int i = 0; i < this.maxRow; ++i) {
            this.currentWidth = 0;
            for (int j = 0; j < this.nCols; ++j) {
                this.cells[i][j].width = i == 0 ? 40 : this.defaultCellWidth;
                this.cells[i][j].height = j == 0 ? 20 : this.defaultCellHeight;
                this.currentWidth += this.cells[0][j].width;
            }
            this.currentHeight += this.cells[i][0].height;
        }
        this.osi = null;
        this.invalidate();
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public boolean clearSeries(int n) {
        if (n < 1 || n >= this.nCols) {
            return false;
        }
        for (int i = 1; i < this.nRows; ++i) {
            this.cells[i][n].str = "";
            this.cells[i][n].paintOSI();
            if (!this.autoRefresh) continue;
            this.cells[i][n].paint();
        }
        this.nextRow[n] = 1;
        this.skipCounter[n] = 1;
        return true;
    }

    public boolean clearAllSeries() {
        for (int i = 1; i < this.nCols; ++i) {
            for (int j = 1; j < this.nRows; ++j) {
                this.cells[j][i].str = "";
                this.cells[j][i].paintOSI();
                if (!this.autoRefresh) continue;
                this.cells[j][i].paint();
            }
            this.nextRow[i] = 1;
            this.skipCounter[i] = 1;
        }
        return true;
    }

    public int getColWidth(int n) {
        if (n < 0 || n >= this.nCols || this.nRows < 1) {
            return 0;
        }
        return this.cells[0][n].width;
    }

    public boolean setColWidth(int n, int n2) {
        if (n < 0 || n >= this.nCols) {
            return false;
        }
        this.currentWidth = this.currentWidth - this.cells[0][n].width + n2;
        for (int i = 0; i < this.nRows; ++i) {
            this.cells[i][n].width = n2;
        }
        this.osi = null;
        this.invalidate();
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    public final boolean setFormat(String string) {
        try {
            this.defaultFormat = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public boolean setNumericFormat(int n, String string) {
        if (n < 1 || n >= this.nCols || this.nRows < 2) {
            return false;
        }
        try {
            this.cells[1][n].format = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl = false;
            return bl;
        }
        this.cells[1][n].paintOSI();
        if (this.autoRefresh) {
            this.cells[1][n].paint();
        }
        for (int i = 2; i < this.nRows; ++i) {
            this.cells[i][n].format = this.cells[1][n].format;
            this.cells[i][n].paintOSI();
            if (!this.autoRefresh) continue;
            this.cells[i][n].paint();
        }
        return true;
    }

    void initCells(int n, int n2) {
        char c = 'A';
        c = (char)(c - 1);
        this.nRows = n;
        this.nCols = n2;
        this.maxRow = this.autoscaleRows ? this.nRows + 10 : this.nRows;
        this.skipCounter = new int[this.nCols];
        this.stride = new int[this.nCols];
        this.colLabels = new String[this.nCols];
        this.nextRow = new int[this.nCols];
        this.cells = new Cell[this.maxRow][this.nCols];
        this.currentWidth = 0;
        this.currentHeight = 0;
        for (int i = 0; i < this.maxRow; ++i) {
            this.currentWidth = 0;
            for (int j = 0; j < this.nCols; ++j) {
                this.cells[i][j] = new Cell(i, j);
                this.currentWidth += this.cells[0][j].width;
                if (i != 0) continue;
                this.cells[0][j].str = new Character(c).toString();
                this.cells[0][j].bgColor = Color.lightGray;
                this.cells[0][j].centered = true;
                this.colLabels[j] = this.cells[0][j].str;
                this.skipCounter[j] = 1;
                this.stride[j] = 1;
                this.nextRow[j] = 1;
                c = (char)(c + '\u0001');
            }
            this.cells[i][0].str = "".concat(String.valueOf(String.valueOf(i)));
            this.cells[i][0].bgColor = Color.lightGray;
            this.currentHeight += this.cells[i][0].height;
        }
        this.cells[0][0].str = "";
        if (this.gridpanel != null) {
            ((Container)((Object)this.gridpanel)).validate();
        }
    }

    Cell getCellFromPix(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!this.showRowHeader) {
            n7 = 1;
        }
        if (!this.showColHeader) {
            n6 = 1;
        }
        if (n >= this.currentWidth || n2 >= this.currentHeight) {
            return null;
        }
        int n8 = -1;
        int n9 = -1;
        for (n3 = n6; n3 < this.nRows; ++n3) {
            if ((n5 += this.cells[n3][0].height) < n2) continue;
            n8 = n3;
            break;
        }
        for (n3 = n7; n3 < this.nCols; ++n3) {
            if ((n4 += this.cells[0][n3].width) < n) continue;
            n9 = n3;
            break;
        }
        if (n8 >= 0 && n9 >= 0) {
            return this.cells[n8][n9];
        }
        return null;
    }

    public int getCol(String string) {
        for (int i = 0; i < this.nCols; ++i) {
            if (!this.colLabels[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void highlightRow(int n, boolean bl) {
        if (n >= this.nRows) {
            return;
        }
        for (int i = 0; i < this.nCols; ++i) {
            this.cells[n][i].highlight = bl;
            this.cells[n][i].paintOSI();
            if (!this.autoRefresh) continue;
            this.cells[n][i].paint();
        }
    }

    public void setDataStride(int n, int n2) {
        this.stride[n] = Math.max(1, n2);
        this.skipCounter[n] = 1;
    }

    public boolean setColLabel(int n, String string) {
        if (n < 0 || n >= this.nCols) {
            return false;
        }
        this.colLabels[n] = string;
        this.cells[0][n].str = string;
        this.cells[0][n].paintOSI();
        if (this.autoRefresh) {
            this.cells[0][n].paint();
        }
        return true;
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (this.autoRefresh) {
            this.paintOsi();
        }
    }

    public boolean setCell(int n, int n2, String string) {
        if (n < 0 || n2 < 0 || n > this.nRows || n2 > this.nCols) {
            return false;
        }
        if (n == 0 && n2 == 0) {
            return false;
        }
        this.cells[n][n2].setValue(string);
        return true;
    }

    public double getCellValue(int n, int n2) {
        if (n < 0 || n2 < 0 || n > this.nRows || n2 > this.nCols) {
            return Double.NaN;
        }
        if (n == 0 && n2 == 0) {
            return Double.NaN;
        }
        return this.cells[n][n2].getValue();
    }

    public double getActiveCellValue() {
        if (this.hlCell == null) {
            return Double.NaN;
        }
        return this.hlCell.getValue();
    }

    public boolean setActiveCellValue(double d) {
        if (this.hlCell == null) {
            return false;
        }
        this.hlCell.setValue(d);
        return true;
    }

    public int getActiveCellRow() {
        if (this.hlCell == null) {
            return -1;
        }
        return this.hlCell.row;
    }

    public int getActiveCellCol() {
        if (this.hlCell == null) {
            return -1;
        }
        return this.hlCell.col;
    }

    public int getNextRow(int n) {
        return this.nextRow[n];
    }

    public void setHighlight(int n, int n2) {
        if (this.hlCell != null) {
            if (this.hlCell.row == 0) {
                this.highlightCol(this.hlCell.col, false);
            } else if (this.hlCell.col == 0) {
                this.highlightRow(this.hlCell.row, false);
            } else {
                this.hlCell.highlight = false;
                this.hlCell.paint();
                this.hlCell.paintOSI();
            }
        }
        this.hlCell = null;
        if (n < 0 || n2 < 0 || n > this.nRows || n2 > this.nCols) {
            return;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        this.hlCell = this.cells[n][n2];
        if (this.hlCell.row == 0) {
            this.highlightCol(this.hlCell.col, true);
        } else if (this.hlCell.col == 0) {
            this.highlightRow(this.hlCell.row, true);
        } else {
            this.hlCell.highlight = true;
            this.hlCell.paint();
            this.hlCell.paintOSI();
        }
    }

    public void highlightCol(int n, boolean bl) {
        if (n >= this.nCols) {
            return;
        }
        for (int i = 0; i < this.nRows; ++i) {
            this.cells[i][n].highlight = bl;
            this.cells[i][n].paintOSI();
            if (!this.autoRefresh) continue;
            this.cells[i][n].paint();
        }
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        if (this.nCols == 0 || this.nRows == 0) {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return;
        }
        int n = this.currentWidth;
        int n2 = this.currentHeight;
        if (n <= 1 || n2 <= 1) {
            return;
        }
        if (!this.showRowHeader) {
            n -= this.cells[0][0].width;
        }
        if (!this.showColHeader) {
            n2 -= this.cells[0][0].height;
        }
        int n3 = 0;
        SGrid sGrid = this;
        synchronized (sGrid) {
            if (this.osi == null) {
                this.osi = this.createImage(n, n2);
                if (this.osi == null) {
                    return;
                }
                while (!this.prepareImage(this.osi, this) && n3 < 5) {
                    try {
                        ++n3;
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {}
                }
                Graphics graphics2 = this.osi.getGraphics();
                if (graphics2 == null) {
                    return;
                }
                this.paintOsi(graphics2);
                graphics2.dispose();
                graphics2 = null;
            }
            graphics.drawImage(this.osi, 0, 0, n, n2, this);
        }
    }

    public synchronized void paintOsi() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paintOsi(graphics);
        graphics.dispose();
    }

    public synchronized void paintOsi(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!this.showRowHeader) {
            n4 = 1;
        }
        if (!this.showColHeader) {
            n3 = 1;
        }
        for (int i = n3; i < this.nRows; ++i) {
            n = 0;
            for (int j = n4; j < this.nCols; ++j) {
                this.cells[i][j].paint(graphics, n, n2);
                n += this.cells[0][j].width;
            }
            n2 += this.cells[i][0].height;
        }
    }

    public Dimension getPreferredSize() {
        int n = this.currentWidth;
        int n2 = this.currentHeight;
        if (!this.showRowHeader) {
            n -= this.cells[0][0].width;
        }
        if (!this.showColHeader) {
            n2 -= this.cells[0][0].height;
        }
        return new Dimension(n, n2);
    }

    private void jbInit() throws Exception {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SGrid.this.this_mouseClicked(mouseEvent);
            }
        });
    }

    void this_mouseClicked(MouseEvent mouseEvent) {
        if (!this.showHLCell) {
            return;
        }
        if (this.hlCell != null) {
            if (this.hlCell.row == 0) {
                this.highlightCol(this.hlCell.col, false);
            } else if (this.hlCell.col == 0) {
                this.highlightRow(this.hlCell.row, false);
            } else {
                this.hlCell.highlight = false;
                this.hlCell.paint();
                this.hlCell.paintOSI();
            }
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.hlCell = this.getCellFromPix(n, n2);
        if (this.hlCell == null) {
            return;
        }
        if (this.hlCell.col == 0 && this.hlCell.row == 0) {
            this.hlCell = null;
        }
        if (this.hlCell != null) {
            if (this.hlCell.row == 0) {
                this.highlightCol(this.hlCell.col, true);
            } else if (this.hlCell.col == 0) {
                this.highlightRow(this.hlCell.row, true);
            } else {
                this.hlCell.highlight = true;
                this.hlCell.paint();
                this.hlCell.paintOSI();
            }
            if (this.gridpanel != null) {
                this.gridpanel.rowField.setText(this.cells[this.hlCell.row][0].str);
                this.gridpanel.colField.setText(this.cells[0][this.hlCell.col].str);
                this.gridpanel.cellField.setText(this.cells[this.hlCell.row][this.hlCell.col].str);
                this.gridpanel.rowField.setBackground(Color.white);
                this.gridpanel.colField.setBackground(Color.white);
                this.gridpanel.cellField.setBackground(Color.white);
            }
        }
    }

    boolean setActiveCell(int n, int n2) {
        if (this.hlCell != null) {
            if (this.hlCell.row == 0) {
                this.highlightCol(this.hlCell.col, false);
            } else if (this.hlCell.col == 0) {
                this.highlightRow(this.hlCell.row, false);
            } else {
                this.hlCell.highlight = false;
                this.hlCell.paint();
                this.hlCell.paintOSI();
            }
        }
        if (n < 0 || n2 < 0 || n > this.nRows || n2 > this.nCols) {
            return false;
        }
        if (n == 0 && n2 == 0) {
            return false;
        }
        this.hlCell = this.cells[n][n2];
        if (this.hlCell.col == 0 && this.hlCell.row == 0) {
            this.hlCell = null;
        }
        if (this.hlCell != null) {
            if (this.hlCell.row == 0) {
                this.highlightCol(this.hlCell.col, true);
            } else if (this.hlCell.col == 0) {
                this.highlightRow(this.hlCell.row, true);
            } else {
                this.hlCell.highlight = true;
                this.hlCell.paint();
                this.hlCell.paintOSI();
            }
            if (this.gridpanel != null) {
                this.gridpanel.rowField.setText(this.cells[this.hlCell.row][0].str);
                this.gridpanel.colField.setText(this.cells[0][this.hlCell.col].str);
                this.gridpanel.cellField.setText(this.cells[this.hlCell.row][this.hlCell.col].str);
                this.gridpanel.rowField.setBackground(Color.white);
                this.gridpanel.colField.setBackground(Color.white);
                this.gridpanel.cellField.setBackground(Color.white);
            }
        }
        return true;
    }

    void setShowActiveCell(boolean bl) {
        this.showHLCell = bl;
        if (bl || this.hlCell == null) {
            return;
        }
        if (this.hlCell.row == 0) {
            this.highlightCol(this.hlCell.col, false);
        } else if (this.hlCell.col == 0) {
            this.highlightRow(this.hlCell.row, false);
        } else {
            this.hlCell.highlight = false;
            this.hlCell.paint();
            this.hlCell.paintOSI();
        }
        this.hlCell = null;
    }

    void setShowColHeader(boolean bl) {
        if (this.showColHeader == bl) {
            return;
        }
        this.showColHeader = bl;
        this.osi = null;
        this.invalidate();
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    void setShowRowHeader(boolean bl) {
        if (this.showRowHeader == bl) {
            return;
        }
        this.showRowHeader = bl;
        this.osi = null;
        this.invalidate();
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    void setLastOnTop(boolean bl) {
        this.lastOnTop = bl;
    }

    class Cell {
        boolean centered = false;
        int row = 0;
        int col = 0;
        int x = 0;
        int y = 0;
        int width;
        int height;
        String str;
        boolean highlight;
        Color hlFontColor;
        Color hlBGColor;
        Color bgColor;
        Format format;
        double value;

        Cell(int n, int n2) {
            this.width = SGrid.this.defaultCellWidth;
            this.height = SGrid.this.defaultCellHeight;
            this.str = "";
            this.highlight = false;
            this.hlFontColor = Color.red;
            this.hlBGColor = SGrid.this.silver;
            this.bgColor = Color.white;
            this.format = SGrid.this.defaultFormat;
            this.value = 0.0;
            this.row = n;
            this.col = n2;
        }

        void paint(Graphics graphics, int n, int n2) {
            this.x = n;
            this.y = n2;
            this.paint(graphics);
        }

        void paint() {
            Graphics graphics = SGrid.this.getGraphics();
            if (graphics == null) {
                return;
            }
            this.paint(graphics);
            graphics.dispose();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void paintOSI() {
            Graphics graphics;
            block8: {
                block7: {
                    graphics = null;
                    try {
                        try {
                            if (SGrid.this.osi == null) {
                                Object var4_2 = null;
                                if (graphics == null) return;
                                graphics.dispose();
                                return;
                            }
                            graphics = SGrid.this.osi.getGraphics();
                            if (graphics == null) {
                                break block7;
                            }
                            this.paint(graphics);
                            break block8;
                        }
                        catch (Exception exception) {
                            Object var4_5 = null;
                            if (graphics == null) return;
                            graphics.dispose();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        if (graphics == null) throw throwable;
                        graphics.dispose();
                        throw throwable;
                    }
                }
                Object var4_3 = null;
                if (graphics == null) return;
                graphics.dispose();
                return;
            }
            Object var4_4 = null;
            if (graphics == null) return;
            graphics.dispose();
        }

        void paint(Graphics graphics) {
            if (this.highlight) {
                graphics.setColor(this.hlBGColor);
            } else {
                graphics.setColor(this.bgColor);
            }
            graphics.fillRect(this.x, this.y, this.width - 1, this.height - 1);
            if (this.highlight) {
                graphics.setColor(this.hlFontColor);
                graphics.setFont(SGrid.this.hlFont);
            } else {
                graphics.setColor(Color.black);
                if (this.row == 0 || this.col == 0) {
                    graphics.setFont(SGrid.this.hlFont);
                } else {
                    graphics.setFont(SGrid.this.font);
                }
            }
            graphics.drawRect(this.x, this.y, this.width - 1, this.height - 1);
            int n = 4;
            if (this.centered) {
                FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
                n = (this.width - fontMetrics.stringWidth(this.str)) / 2;
            }
            graphics.drawString(this.str, this.x + n, this.y + this.height - 5);
            graphics.setColor(Color.black);
        }

        synchronized void setValue(double d) {
            this.value = d;
            this.str = this.value > 1.0E127 ? "NaN" : this.format.form(d);
            this.paintOSI();
            if (SGrid.this.autoRefresh) {
                this.paint();
            }
        }

        synchronized void setValue(String string) {
            try {
                this.value = Double.valueOf(this.str);
            }
            catch (NumberFormatException numberFormatException) {
                this.value = 0.0;
            }
            this.str = this.value > 1.0E127 ? "NaN" : string;
            this.paintOSI();
            if (SGrid.this.autoRefresh) {
                this.paint();
            }
        }

        double getValue() {
            return this.value;
        }
    }
}

