/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.views;

import edu.davidson.graphics.EtchedBorder;
import edu.davidson.graphics.SPanel;
import edu.davidson.graphics.Util;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import edu.davidson.views.SGrid;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.net.URL;

public class SGridPanel
extends EtchedBorder
implements SDataListener {
    boolean showScrollBars = true;
    SApplet owner = null;
    Container scrollPane;
    EtchedBorder controlPanel = new EtchedBorder();
    Panel panel2 = new Panel();
    Label label1 = new Label();
    Panel panel3 = new Panel();
    TextField colField = new TextField();
    Label label2 = new Label();
    BorderLayout borderLayout2 = new BorderLayout();
    Panel panel4 = new Panel();
    Button enterBtn = new Button();
    TextField rowField = new TextField();
    Label label3 = new Label();
    BorderLayout borderLayout1 = new BorderLayout();
    SPanel panel1 = new SPanel();
    TextField cellField = new TextField();
    BorderLayout borderLayout3 = new BorderLayout();
    boolean autosizeGrid = false;
    SGrid sgrid = new SGrid(this);
    BorderLayout borderLayout4 = new BorderLayout();

    public SGridPanel(SApplet sApplet, boolean bl) {
        this.showScrollBars = bl;
        this.scrollPane = this.showScrollBars ? new ScrollPane(0) : new Panel();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.owner = sApplet;
        try {
            SApplet.addDataListener((Object)((Object)this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (!this.showScrollBars) {
            this.scrollPane.setLayout(this.borderLayout4);
        }
        this.panel2.setLayout(this.borderLayout1);
        this.controlPanel.setLayout(this.borderLayout2);
        this.label1.setAlignment(2);
        this.label1.setText("Cell:");
        this.colField.setText("A");
        this.label2.setAlignment(2);
        this.label2.setText("C:");
        this.enterBtn.setLabel("Enter");
        this.enterBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGridPanel.this.enterBtn_actionPerformed(actionEvent);
            }
        });
        this.rowField.setText("1");
        this.label3.setAlignment(2);
        this.label3.setText("R:");
        this.panel1.setVinsets(5);
        this.panel1.setLayout(this.borderLayout3);
        ((Container)((Object)this)).add(this.scrollPane, "Center");
        if (this.showScrollBars) {
            this.scrollPane.add((Component)this.sgrid, null);
        } else {
            this.scrollPane.add((Component)this.sgrid, "Center");
        }
        ((Container)((Object)this)).add((Component)this.controlPanel, "North");
        this.controlPanel.add((Component)this.panel3, "West");
        this.panel3.add((Component)this.label3, null);
        this.panel3.add((Component)this.rowField, null);
        this.panel3.add((Component)this.label2, null);
        this.panel3.add((Component)this.colField, null);
        this.controlPanel.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.label1, "West");
        this.panel2.add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.cellField, "Center");
        this.controlPanel.add((Component)this.panel4, "East");
        this.panel4.add((Component)this.enterBtn, null);
    }

    public void setNumericFormat(int n, String string) {
        this.sgrid.setNumericFormat(n, string);
    }

    public void setShowActiveCell(boolean bl) {
        this.sgrid.setShowActiveCell(bl);
    }

    public double getActiveCellValue() {
        return this.sgrid.getActiveCellValue();
    }

    public void initCells(int n, int n2) {
        this.sgrid.initCells(n + 1, n2 + 1);
    }

    public void setAutoRefresh(boolean bl) {
        this.sgrid.setAutoRefresh(bl);
    }

    public void setShowRowHeader(boolean bl) {
        this.sgrid.setShowRowHeader(bl);
    }

    public void setShowColHeader(boolean bl) {
        this.sgrid.setShowColHeader(bl);
    }

    public void setLastOnTop(boolean bl) {
        this.sgrid.setLastOnTop(bl);
    }

    public void setShowControls(boolean bl) {
        this.controlPanel.setVisible(bl);
        if (this.owner != null) {
            this.owner.invalidate();
        }
    }

    public int getActiveCellRow() {
        return this.sgrid.getActiveCellRow();
    }

    public int getActiveCellCol() {
        return this.sgrid.getActiveCellCol();
    }

    public boolean setActiveCellValue(double d) {
        return this.sgrid.setActiveCellValue(d);
    }

    public boolean setActiveCell(int n, int n2) {
        return this.sgrid.setActiveCell(n, n2);
    }

    public void loadFile(int n, String string) {
        Object object = this.owner;
        if (object == null) {
            object = Util.getApplet((Component)((Object)this));
        }
        if (object == null) {
            System.out.println("File load failed. Aplet not found.");
            return;
        }
        boolean bl = this.sgrid.autoRefresh;
        this.sgrid.autoRefresh = false;
        this.clearSeries(n);
        try {
            InputStream inputStream = new URL(((Applet)object).getDocumentBase(), string).openStream();
            this.readFile(n, inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("file load failed: ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
        }
        this.sgrid.autoRefresh = bl;
        if (this.sgrid.autoRefresh) {
            this.sgrid.paintOsi();
        }
    }

    void readFile(int n, InputStream inputStream) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(inputStream);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        block5: while (streamTokenizer.ttype != -1) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    break block5;
                }
                case 10: {
                    break;
                }
                case -3: {
                    if ("series".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        n = (int)streamTokenizer.nval;
                        this.clearSeries(n);
                        break;
                    }
                }
                case -2: {
                    double d = streamTokenizer.nval;
                    this.addDatum(n, d, 0.0);
                }
            }
            while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
                streamTokenizer.nextToken();
            }
        }
    }

    public void setDataStride(int n, int n2) {
        this.sgrid.setDataStride(n, n2);
    }

    public boolean setSeriesLabel(int n, String string) {
        return this.sgrid.setColLabel(n, string);
    }

    public int getID() {
        return ((Object)((Object)this)).hashCode();
    }

    public void addDatum(int n, double d, double d2) {
        this.sgrid.addDatum(n, d);
        this.owner.updateDataConnections();
    }

    public void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        this.sgrid.addDatum(n, d);
        if (sDataSource.getOwner() != this.owner) {
            this.owner.updateDataConnections();
        }
    }

    public void addData(int n, double[] dArray, double[] dArray2) {
        this.sgrid.addData(n, dArray);
        this.owner.updateDataConnections();
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        this.sgrid.addData(n, dArray);
        if (sDataSource.getOwner() != this.owner) {
            this.owner.updateDataConnections();
        }
    }

    public void setDefault() {
        this.owner.deleteDataConnections();
        this.sgrid.setDefault();
        if (this.autosizeGrid) {
            this.sgrid.sizeToFit();
        } else {
            this.sgrid.setGridSize();
        }
    }

    public void setDefaultCellWidth(int n) {
        this.sgrid.setDefaultCellWidth(n);
    }

    public void deleteSeries(int n) {
        this.sgrid.clearSeries(n);
    }

    public void clearSeries(int n) {
        this.sgrid.clearSeries(n);
    }

    public void clearAllSeries() {
        this.sgrid.clearAllSeries();
    }

    public void setOwner(SApplet sApplet) {
        this.owner = sApplet;
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public boolean setFormat(SDataSource sDataSource, String string) {
        if (sDataSource instanceof SeriesDataSource) {
            int n = ((SeriesDataSource)sDataSource).sid;
            return this.sgrid.setNumericFormat(n, string);
        }
        return false;
    }

    public boolean setFormat(String string) {
        return this.sgrid.setFormat(string);
    }

    public int getSeriesWidth(int n) {
        return this.sgrid.getColWidth(n);
    }

    public void setSeriesWidth(int n, int n2) {
        this.sgrid.setColWidth(n, n2);
    }

    public void sizeToFit(boolean bl) {
        this.autosizeGrid = bl;
        if (bl) {
            this.sgrid.sizeToFit();
        } else {
            this.sgrid.setGridSize();
        }
    }

    void enterBtn_actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        try {
            n = new Integer(this.rowField.getText());
            this.rowField.setBackground(Color.white);
        }
        catch (NumberFormatException numberFormatException) {
            this.rowField.setBackground(Color.red);
            return;
        }
        int n2 = this.sgrid.getCol(this.colField.getText());
        if (n2 < 0) {
            this.colField.setBackground(Color.red);
            return;
        }
        this.colField.setBackground(Color.white);
        this.sgrid.setHighlight(n, n2);
        this.sgrid.setCell(n, n2, this.cellField.getText());
    }

    public int getSeriesID(int n) {
        SeriesDataSource seriesDataSource = new SeriesDataSource(n);
        return seriesDataSource.hashCode();
    }

    public class SeriesDataSource
    implements SDataSource {
        String[] varStrings = new String[]{"x", "dx"};
        double[][] ds = new double[1][2];
        int sid = 0;

        SeriesDataSource(int n) {
            this.sid = n;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            int n2 = SGridPanel.this.sgrid.getNextRow(this.sid) - 1;
            if (n2 > 0) {
                this.ds = new double[n2][2];
            }
        }

        public double[][] getVariables() {
            int n;
            int n2 = SGridPanel.this.sgrid.getNextRow(this.sid) - 1;
            if (this.ds == null || this.ds.length != n2) {
                this.ds = new double[n2][2];
            }
            for (n = 0; n < this.ds.length; ++n) {
                this.ds[n][0] = SGridPanel.this.sgrid.getCellValue(n + 1, this.sid);
            }
            for (n = 0; n < this.ds.length - 1; ++n) {
                this.ds[n][1] = this.ds[n + 1][0] - this.ds[n][0];
            }
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return SGridPanel.this.owner;
        }
    }
}

