/*
 * Decompiled with CFR 0.152.
 */
package diatomic;

import diatomic.PhysletPanel;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Diatomic
extends SApplet {
    boolean isStandalone = false;
    boolean showControls;
    int numDiatomic;
    int numAtom;
    int fps;
    double dt;
    BorderLayout borderLayout1 = new BorderLayout();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    EtchedBorder controlPanel = new EtchedBorder();
    Panel panel1 = new Panel();
    Panel panel2 = new Panel();
    Button runBtn = new Button();
    PhysletPanel physletPanel = new PhysletPanel(this);
    Button stepBtn = new Button();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.numDiatomic = Integer.parseInt(this.getParameter("NumMol", "16"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.numAtom = Integer.parseInt(this.getParameter("NumAtom", "16"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fps = Integer.parseInt(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dt = Double.valueOf(this.getParameter("Dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clock.setDt(this.dt);
        this.clock.setFPS((double)this.fps);
        this.clock.addClockListener((SStepable)this.physletPanel);
        this.controlPanel.setVisible(this.showControls);
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.runBtn.setLabel("Run ");
        this.runBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Diatomic.this.runBtn_actionPerformed(actionEvent);
            }
        });
        this.stepBtn.setLabel("Step");
        this.stepBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Diatomic.this.stepBtn_actionPerformed(actionEvent);
            }
        });
        this.controlPanel.setBackground(Color.lightGray);
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "Center");
        this.etchedBorder1.add((Component)this.physletPanel, "Center");
        ((Container)((Object)this)).add((Component)this.controlPanel, "South");
        this.controlPanel.add((Component)this.panel2, "West");
        this.panel2.add((Component)this.runBtn, null);
        this.panel2.add((Component)this.stepBtn, null);
        this.controlPanel.add((Component)this.panel1, "Center");
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"ShowControls", "boolean", "Show the user interface"}, {"NumMol", "int", "Number of diatomic molecules"}, {"NumAtom", "int", "Number of atoms"}, {"FPS", "int", "Frames per second"}, {"Dt", "double", "Time step"}};
        return stringArray;
    }

    void runBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.clock.isRunning()) {
            this.runBtn.setLabel("Stop");
            this.clock.stopClock();
        } else {
            this.runBtn.setLabel("Run ");
            this.clock.startClock();
        }
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public synchronized void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
            this.physletPanel.createOSI();
            this.physletPanel.initialize();
            this.physletPanel.setAtomNum(this.numAtom);
            this.physletPanel.setMolNum(this.numDiatomic);
            this.physletPanel.paintOSI();
        }
    }

    void stepBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.clock.isRunning()) {
            this.runBtn_actionPerformed(null);
        } else {
            this.clock.doStep();
        }
    }

    public synchronized int addObject(String string, String string2) {
        int n = 1;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("atom")) {
            if (SUtil.parameterExist((String)string2, (String)"n=")) {
                n = (int)SUtil.getParam((String)string2, (String)"n=");
            }
            n = Math.max(0, n);
            n = Math.min(n, 99);
            this.createAtoms(n);
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                this.physletPanel.mM = SUtil.getParam((String)string2, (String)"m=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                int n2 = (int)SUtil.getParam((String)string2, (String)"r=");
                this.physletPanel.setAtomRad(n2);
            }
            return this.physletPanel.getID();
        }
        if (string.equals("diatomic") || string.equals("diatom") || string.equals("molecule")) {
            if (SUtil.parameterExist((String)string2, (String)"n=")) {
                n = (int)SUtil.getParam((String)string2, (String)"n=");
            }
            n = Math.max(0, n);
            n = Math.min(n, 99);
            this.createDiatomics(n);
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                this.physletPanel.mD = SUtil.getParam((String)string2, (String)"m=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                int n3 = (int)SUtil.getParam((String)string2, (String)"r=");
                this.physletPanel.setMolRad(n3);
            }
            if (SUtil.parameterExist((String)string2, (String)"d=")) {
                double d = SUtil.getParam((String)string2, (String)"d=");
                this.physletPanel.setMolSeparation(d);
            }
            return this.physletPanel.getID();
        }
        return 0;
    }

    private void createAtoms(int n) {
        boolean bl = false;
        if (this.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        this.physletPanel.setAtomNum(n);
        if (bl) {
            bl = false;
            this.forward();
        } else {
            this.physletPanel.paintOSI();
            if (this.autoRefresh) {
                this.physletPanel.repaint();
            }
        }
    }

    private void createDiatomics(int n) {
        boolean bl = false;
        if (this.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        this.physletPanel.setMolNum(n);
        if (bl) {
            bl = false;
            this.forward();
        } else {
            this.physletPanel.paintOSI();
            if (this.autoRefresh) {
                this.physletPanel.repaint();
            }
        }
    }

    public void setDefault() {
        this.clock.stopClock();
        this.clock.setTime(0.0);
        this.deleteDataConnections();
        this.physletPanel.setDefault();
        this.physletPanel.paintOSI();
    }

    public int addAtomDataSource(int n) {
        return this.physletPanel.addAtomDataSource(n);
    }

    public int addDiatomicDataSource(int n) {
        return this.physletPanel.addDiatomicDataSource(n);
    }

    public synchronized boolean set(int n, String string, String string2) {
        boolean bl = false;
        if (this.clock.isRunning()) {
            this.clock.stopClock();
            bl = true;
        }
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.physletPanel.scale;
        if (string.equals("atom")) {
            if (SUtil.parameterExist((String)string2, (String)"i=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"i=");
                if (n2 < 1) {
                    System.out.println("Atom index <1.");
                    return false;
                }
                if (n2 > this.physletPanel.anMax) {
                    System.out.println("Atom index out of range. Number of atoms=".concat(String.valueOf(String.valueOf(this.physletPanel.anMax))));
                    return false;
                }
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    this.physletPanel.ax[n2] = SUtil.getParam((String)string2, (String)"x=") * d5;
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    this.physletPanel.ay[n2] = (double)this.physletPanel.iheight - SUtil.getParam((String)string2, (String)"y=") * d5;
                }
                if (SUtil.parameterExist((String)string2, (String)"vx=")) {
                    this.physletPanel.avx[n2] = SUtil.getParam((String)string2, (String)"vx=") * d5;
                }
                if (SUtil.parameterExist((String)string2, (String)"vy=")) {
                    this.physletPanel.avy[n2] = -SUtil.getParam((String)string2, (String)"vy=") * d5;
                }
                if (SUtil.parameterExist((String)string2, (String)"fixed=")) {
                    if (SUtil.getParamStr((String)string2, (String)"fixed=").equalsIgnoreCase("true")) {
                        this.physletPanel.setAtomFixed(n2, true);
                    } else {
                        this.physletPanel.setAtomFixed(n2, false);
                    }
                }
            }
        } else if (string.equals("diatomic") || string.equals("molecule")) {
            if (SUtil.parameterExist((String)string2, (String)"i=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"i=");
                if (n2 < 1) {
                    System.out.println("Diatomic index <1.");
                    return false;
                }
                if (n2 > this.physletPanel.mnMax) {
                    System.out.println("Diatomic index out of range. Number of atoms=".concat(String.valueOf(String.valueOf(this.physletPanel.mnMax))));
                    return false;
                }
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    this.physletPanel.xcm[n2] = SUtil.getParam((String)string2, (String)"x=") * d5;
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    this.physletPanel.ycm[n2] = (double)this.physletPanel.iheight - SUtil.getParam((String)string2, (String)"y=") * d5;
                }
                if (SUtil.parameterExist((String)string2, (String)"vx=")) {
                    this.physletPanel.vxcm[n2] = SUtil.getParam((String)string2, (String)"vx=") * d5;
                }
                if (SUtil.parameterExist((String)string2, (String)"vy=")) {
                    this.physletPanel.vycm[n2] = -SUtil.getParam((String)string2, (String)"vy=") * d5;
                }
                if (SUtil.parameterExist((String)string2, (String)"theta=")) {
                    this.physletPanel.teta[n2] = SUtil.getParam((String)string2, (String)"theta=");
                }
                if (SUtil.parameterExist((String)string2, (String)"w=")) {
                    this.physletPanel.w[n2] = SUtil.getParam((String)string2, (String)"w=");
                }
                this.physletPanel.BallDValues(n2);
            }
        } else if (string.equals("ensemble")) {
            int n3;
            if (SUtil.parameterExist((String)string2, (String)"steps=")) {
                this.physletPanel.numSteps = Math.max(1, (int)SUtil.getParam((String)string2, (String)"steps="));
            }
            if (SUtil.parameterExist((String)string2, (String)"mass_atom=")) {
                this.physletPanel.mM = SUtil.getParam((String)string2, (String)"mass_atom=");
            }
            if (SUtil.parameterExist((String)string2, (String)"mass_mol=")) {
                this.physletPanel.mD = SUtil.getParam((String)string2, (String)"mass_mol=");
            } else if (SUtil.parameterExist((String)string2, (String)"mass_diatomic=")) {
                this.physletPanel.mD = SUtil.getParam((String)string2, (String)"mass_diatomic=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r_atom=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r_atom=");
                this.physletPanel.setAtomRad(n3);
            }
            if (SUtil.parameterExist((String)string2, (String)"r_mol=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r_mol=");
                this.physletPanel.setMolRad(n3);
            } else if (SUtil.parameterExist((String)string2, (String)"r_diatomic=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r_diatomic=");
                this.physletPanel.setMolRad(n3);
            }
            if (SUtil.parameterExist((String)string2, (String)"separation=")) {
                double d6 = SUtil.getParam((String)string2, (String)"separation=");
                this.physletPanel.setMolSeparation(d6);
            }
            if (SUtil.parameterExist((String)string2, (String)"scale=")) {
                this.physletPanel.scale = SUtil.getParam((String)string2, (String)"scale=");
            } else if (SUtil.parameterExist((String)string2, (String)"ppu=")) {
                this.physletPanel.scale = SUtil.getParam((String)string2, (String)"ppu=");
            }
        } else {
            return false;
        }
        this.physletPanel.KinEnTotal();
        if (bl) {
            this.clock.startClock();
        } else if (this.autoRefresh) {
            this.physletPanel.paintOSI();
            this.physletPanel.repaint();
        }
        return true;
    }

    private void repaintOSI() {
        if (this.autoRefresh && !this.clock.isRunning()) {
            this.physletPanel.paintOSI();
            this.physletPanel.repaint();
        }
    }

    public boolean setRGB(int n, int n2, int n3, int n4) {
        Color color = new Color(n2, n3, n4);
        if (n == 0 || n == this.physletPanel.hashCode()) {
            this.physletPanel.backgroundColor = color;
            this.repaintOSI();
            return true;
        }
        SDataSource sDataSource = SApplet.getDataSource((int)n);
        if (sDataSource != null && sDataSource instanceof PhysletPanel.AtomSource) {
            int n5 = ((PhysletPanel.AtomSource)sDataSource).index;
            if (n5 < this.physletPanel.atomColor.length) {
                this.physletPanel.atomColor[n5] = color;
            }
            this.repaintOSI();
            return true;
        }
        if (sDataSource != null && sDataSource instanceof PhysletPanel.DiatomicSource) {
            int n6 = ((PhysletPanel.DiatomicSource)sDataSource).index;
            if (n6 < this.physletPanel.molColor.length) {
                this.physletPanel.molColor[n6] = color;
            }
            this.repaintOSI();
            return true;
        }
        return false;
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (this.autoRefresh) {
            this.physletPanel.paintOSI();
            this.physletPanel.repaint();
        }
    }

    public int getEnsembleID() {
        return this.physletPanel.hashCode();
    }
}

