/*
 * Decompiled with CFR 0.152.
 */
package diatomic;

import java.awt.Color;
import java.awt.Panel;

public class EnsemblePanel
extends Panel {
    int iwidth = 0;
    int iheight = 0;
    int radiusD = 10;
    double separationD = 1.2;
    double d = (double)this.radiusD * this.separationD;
    double mD = 2.0;
    double mM = 1.0;
    double IM = this.mD * this.d * this.d;
    int mnMax = 0;
    int anMax = 0;
    int mn = 1;
    int an = 1;
    int mnC = 1;
    int anC = 1;
    int mnC_Ncb = 1;
    int mnC_cb = 1;
    int mn_cb = 1;
    int mwc;
    int tcount;
    int tEnerAv;
    int wc = 0;
    int wc0 = 0;
    int wc1;
    int wc2;
    int wcn;
    int cb;
    int cb0;
    int cbn;
    int MDcol = 0;
    double KinEnDiat;
    double KinEnDiatTrans;
    double KinEnDiatRot;
    double keRot_keTrans;
    double KinEnMonoat;
    double KinEnTotalMD;
    double momChange;
    double momChangeM;
    double momChangeD;
    double tempM;
    double tempD;
    double tMav;
    double tDav;
    double theTime;
    double dt;
    Color[] molColor;
    double[][] x;
    double[][] y;
    double[][] vx;
    double[][] vy;
    double[] xcm;
    double[] ycm;
    double[] vxcm;
    double[] vycm;
    double[] teta;
    double[] w;
    double[] xcm0;
    double[] ycm0;
    double[] vxcm0;
    double[] vycm0;
    double[] w0;
    double[] teta0;
    double vDinit;
    double wDinit;
    double tetaDinit;
    boolean[] atomFixed;
    Color[] atomColor;
    double[] ax;
    double[] ay;
    double[] avx;
    double[] avy;
    double[] ax0;
    double[] ay0;
    double[] avx0;
    double[] avy0;
    int radiusM;
    double vMinit;
    double dotProduct;
    int energyCalls;

    void InitSemiRandDValues() {
        this.theTime = 0.0;
        this.tcount = 0;
        this.tEnerAv = 0;
        this.keRot_keTrans = 0.0;
        int n = (int)(Math.sqrt((double)this.mnMax * 1.0) + 1.0);
        this.mn = 1;
        double d = (double)this.iwidth / ((double)n + 1.0);
        double d2 = (double)this.iheight / ((double)n + 1.0);
        int n2 = 0;
        while (this.mn < this.mnMax + 1) {
            int n3 = (this.mn - 1) % n;
            if (n3 == 0) {
                ++n2;
            }
            this.xcm[this.mn] = (double)(n3 + 1) * d;
            this.ycm[this.mn] = (double)n2 * d2;
            double d3 = (Math.random() - 0.5) * 2.0;
            this.vxcm[this.mn] = d3 * this.vDinit;
            d3 = (Math.random() - 0.5) * 2.0;
            this.vycm[this.mn] = d3 * this.vDinit;
            d3 = (Math.random() - 0.5) * 2.0;
            this.w[this.mn] = d3 * this.wDinit;
            d3 = (Math.random() - 0.5) * 2.0;
            this.teta[this.mn] = d3 * this.tetaDinit;
            this.BallDValues(this.mn);
            ++this.mn;
        }
        this.mn = 1;
        this.energyCalls = 0;
    }

    void InitSemiRandMValues() {
        this.theTime = 0.0;
        this.tcount = 0;
        this.tEnerAv = 0;
        this.keRot_keTrans = 0.0;
        int n = (int)(Math.sqrt((double)this.anMax * 1.0) + 1.0);
        this.an = 1;
        double d = (double)this.iwidth / ((double)n + 1.0);
        double d2 = (double)this.iheight / ((double)n + 1.0);
        int n2 = 0;
        while (this.an < this.anMax + 1) {
            int n3 = (this.an - 1) % n;
            if (n3 == 0) {
                ++n2;
            }
            this.ax[this.an] = (double)(n3 + 1) * d + 10.0;
            this.ay[this.an] = (double)n2 * d2 + 10.0;
            double d3 = (Math.random() - 0.5) * 2.0;
            this.avx[this.an] = d3 * this.vMinit;
            d3 = (Math.random() - 0.5) * 2.0;
            this.avy[this.an] = d3 * this.vMinit;
            if (this.atomFixed[this.an]) {
                this.avx[this.an] = 0.0;
                this.avy[this.an] = 0.0;
            }
            ++this.an;
        }
        this.an = 1;
        this.energyCalls = 0;
    }

    public void setAtomNum(int n) {
        if (n > 99) {
            n = 99;
            System.out.println("Number of atoms cannot be greater than 99");
        }
        this.mn = 1;
        this.an = 1;
        this.anMax = n;
        this.InitSemiRandMValues();
        this.InitSemiRandDValues();
        this.mn = 1;
        this.an = 1;
        this.KinEnTotal();
    }

    public void setAtomRad(int n) {
        this.radiusM = Math.max(1, n);
        int n2 = this.an;
        this.an = 1;
        this.theTime = 0.0;
        this.tcount = 0;
        this.tEnerAv = 0;
        this.keRot_keTrans = 0.0;
        this.energyCalls = 0;
        this.an = n2;
        this.KinEnTotal();
    }

    void setAtomFixed(int n, boolean bl) {
        if (n >= this.atomFixed.length || this.atomFixed[n] == bl) {
            return;
        }
        this.atomFixed[n] = bl;
        if (this.atomFixed[n]) {
            this.avx[n] = 0.0;
            this.avy[n] = 0.0;
        }
        this.KinEnTotal();
    }

    void setMolNum(int n) {
        if (n > 99) {
            n = 99;
            System.out.println("Number of diatomics cannot be greater than 99");
        }
        this.mn = 1;
        this.an = 1;
        this.mnMax = n;
        this.InitSemiRandMValues();
        this.InitSemiRandDValues();
        this.mn = 1;
        this.an = 1;
        this.KinEnTotal();
    }

    public void setMolRad(int n) {
        this.radiusD = Math.max(1, n);
        int n2 = this.mn;
        this.mn = 1;
        this.d = (double)this.radiusD * this.separationD;
        this.IM = this.mD * this.d * this.d;
        this.theTime = 0.0;
        this.tcount = 0;
        this.tEnerAv = 0;
        this.keRot_keTrans = 0.0;
        this.energyCalls = 0;
        while (this.mn < this.mnMax + 1) {
            this.BallDValues(this.mn);
            ++this.mn;
        }
        this.mn = n2;
        this.KinEnTotal();
    }

    public void setMolSeparation(double d) {
        int n = this.mn;
        this.separationD = Math.max(d, 0.001);
        this.mn = 1;
        this.d = (double)this.radiusD * this.separationD;
        this.IM = this.mD * this.d * this.d;
        this.theTime = 0.0;
        this.tcount = 0;
        this.tEnerAv = 0;
        this.keRot_keTrans = 0.0;
        this.energyCalls = 0;
        while (this.mn < this.mnMax + 1) {
            this.BallDValues(this.mn);
            ++this.mn;
        }
        this.mn = n;
        this.KinEnTotal();
    }

    void initialize() {
        this.theTime = 0.0;
        this.dt = 0.1;
        this.x = new double[220][3];
        this.y = new double[220][3];
        this.vx = new double[220][3];
        this.vy = new double[220][3];
        this.xcm = new double[110];
        this.ycm = new double[110];
        this.vxcm = new double[110];
        this.vycm = new double[110];
        this.teta = new double[110];
        this.w = new double[110];
        this.xcm0 = new double[110];
        this.ycm0 = new double[110];
        this.vxcm0 = new double[110];
        this.vycm0 = new double[110];
        this.w0 = new double[110];
        this.teta0 = new double[110];
        this.molColor = new Color[110];
        this.radiusD = 10;
        this.atomFixed = new boolean[100];
        this.atomColor = new Color[100];
        this.ax = new double[100];
        this.ay = new double[100];
        this.avx = new double[100];
        this.avy = new double[100];
        this.ax0 = new double[100];
        this.ay0 = new double[100];
        this.avx0 = new double[100];
        this.avy0 = new double[100];
        this.radiusM = 10;
        this.mD = 2.0;
        this.mM = 1.0;
        this.d = (double)this.radiusD * this.separationD;
        this.IM = this.mD * this.d * this.d;
        this.tcount = 0;
        this.tEnerAv = 0;
        this.wc1 = 0;
        this.wc = 0;
        this.wcn = 0;
        this.MDcol = 1;
        this.setDefault();
    }

    public void setDefault() {
        int n;
        this.theTime = 0.0;
        this.tcount = 0;
        this.energyCalls = 0;
        this.mn = 1;
        this.an = 1;
        this.dt = 0.1;
        this.mD = 2.0;
        this.mM = 1.0;
        this.radiusD = 8;
        this.radiusM = 8;
        double d = 5.0;
        this.vMinit = 250.0 / d;
        this.vDinit = 250.0 / d;
        this.wDinit = 50.0 / d;
        this.tetaDinit = 7.0;
        this.d = (double)this.radiusD * this.separationD;
        this.IM = this.mD * this.d * this.d;
        for (n = 0; n < this.atomFixed.length; ++n) {
            this.atomFixed[n] = false;
        }
        for (n = 0; n < this.atomColor.length; ++n) {
            this.atomColor[n] = Color.red;
        }
        for (n = 0; n < this.molColor.length; ++n) {
            this.molColor[n] = Color.green;
        }
    }

    public void monodiLoop() {
        ++this.tcount;
        this.theTime += this.dt;
        int n = this.tcount % 30;
        int n2 = this.tcount % 10;
        int n3 = this.tcount % 10 + 1;
        this.mn = 1;
        while (this.mn < this.mnMax + 1) {
            this.teta0[this.mn] = this.teta[this.mn];
            this.xcm0[this.mn] = this.xcm[this.mn];
            this.ycm0[this.mn] = this.ycm[this.mn];
            this.vxcm0[this.mn] = this.vxcm[this.mn];
            this.vycm0[this.mn] = this.vycm[this.mn];
            this.w0[this.mn] = this.w[this.mn];
            this.teta[this.mn] = this.teta0[this.mn] + this.w[this.mn] * this.dt;
            this.xcm[this.mn] = this.xcm0[this.mn] + this.vxcm[this.mn] * this.dt;
            this.ycm[this.mn] = this.ycm0[this.mn] + this.vycm[this.mn] * this.dt;
            this.BallDValues(this.mn);
            this.dwContact();
            this.mnC = 0;
            this.ddContact();
            this.anC = 0;
            if (this.MDcol == 1) {
                this.dmContact();
            }
            if (this.anC > 0) {
                this.BallBounceDM();
            }
            ++this.mn;
        }
        this.an = 1;
        while (this.an < this.anMax + 1) {
            this.ax0[this.an] = this.ax[this.an];
            this.ay0[this.an] = this.ay[this.an];
            this.avx0[this.an] = this.avx[this.an];
            this.avy0[this.an] = this.avy[this.an];
            this.ax[this.an] = this.ax[this.an] + this.avx[this.an] * this.dt;
            this.ay[this.an] = this.ay[this.an] + this.avy[this.an] * this.dt;
            this.mwContact();
            this.anC = 0;
            this.mmContact();
            if (this.anC != 0) {
                this.BallBounceMM();
            }
            this.mnC = 0;
            ++this.an;
        }
        if (this.tcount == 1) {
            this.KinEnTotal();
        }
    }

    public void BallBounceDD() {
        int n = this.mn_cb == 1 ? 2 : 1;
        int n2 = this.mnC_cb == 1 ? 2 : 1;
        double d = this.x[this.mnC][this.mnC_cb] - this.x[this.mn][this.mn_cb];
        double d2 = this.y[this.mnC][this.mnC_cb] - this.y[this.mn][this.mn_cb];
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = (this.vx[this.mn][this.mn_cb] * d + this.vy[this.mn][this.mn_cb] * d2) / d3;
        double d5 = (this.vx[this.mnC][this.mnC_cb] * d + this.vy[this.mnC][this.mnC_cb] * d2) / d3;
        double d6 = (d * (this.y[this.mn][n] - this.y[this.mn][this.mn_cb]) - d2 * (this.x[this.mn][n] - this.x[this.mn][this.mn_cb])) / (2.0 * d3);
        double d7 = (d * (this.y[this.mnC][n2] - this.y[this.mnC][this.mnC_cb]) - d2 * (this.x[this.mnC][n2] - this.x[this.mnC][this.mnC_cb])) / (2.0 * d3);
        double d8 = 2.0 * (d5 - d4) / (1.0 + d6 / this.d * (d6 / this.d) + this.mD / this.mD * (1.0 + d7 / this.d * (d7 / this.d)));
        double d9 = 2.0 * (d4 - d5) / (1.0 + d7 / this.d * (d7 / this.d) + this.mD / this.mD * (1.0 + d6 / this.d * (d6 / this.d)));
        double d10 = d6 / (this.d * this.d) * d8;
        double d11 = d7 / (this.d * this.d) * d9;
        this.vxcm0[this.mn] = this.vxcm[this.mn];
        this.vycm0[this.mn] = this.vycm[this.mn];
        this.vxcm0[this.mnC] = this.vxcm[this.mnC];
        this.vycm0[this.mnC] = this.vycm[this.mnC];
        this.w0[this.mn] = this.w[this.mn];
        this.w0[this.mnC] = this.w[this.mnC];
        this.vxcm[this.mn] = this.vxcm0[this.mn] + d8 * d / d3;
        this.vycm[this.mn] = this.vycm0[this.mn] + d8 * d2 / d3;
        this.vxcm[this.mnC] = this.vxcm0[this.mnC] + d9 * d / d3;
        this.vycm[this.mnC] = this.vycm0[this.mnC] + d9 * d2 / d3;
        this.w[this.mn] = this.w0[this.mn] + d10;
        this.w[this.mnC] = this.w0[this.mnC] + d11;
        double d12 = 0.0;
        double d13 = 0.0;
        this.BallDVelValues(this.mn);
        this.BallDVelValues(this.mnC);
        d12 = 0.5 * this.mD * (this.vxcm[this.mn] * this.vxcm[this.mn] - this.vxcm0[this.mn] * this.vxcm0[this.mn]);
        d12 += 0.5 * this.mD * (this.vycm[this.mn] * this.vycm[this.mn] - this.vycm0[this.mn] * this.vycm0[this.mn]);
        d12 += 0.5 * this.mD * (this.vxcm[this.mnC] * this.vxcm[this.mnC] - this.vxcm0[this.mnC] * this.vxcm0[this.mnC]);
        d13 = 0.5 * this.IM * (this.w[this.mn] * this.w[this.mn] - this.w0[this.mn] * this.w0[this.mn]);
        this.KinEnDiatTrans += (d12 += 0.5 * this.mD * (this.vycm[this.mnC] * this.vycm[this.mnC] - this.vycm0[this.mnC] * this.vycm0[this.mnC]));
        this.KinEnDiatRot += (d13 += 0.5 * this.IM * (this.w[this.mnC] * this.w[this.mnC] - this.w0[this.mnC] * this.w0[this.mnC]));
        this.KinEnDiat = this.KinEnDiatTrans + this.KinEnDiatRot;
        this.KinEnTotalMD = this.KinEnMonoat + this.KinEnDiat;
    }

    public void BallBounceDM() {
        double d;
        double d2;
        int n = this.mn_cb == 1 ? 2 : 1;
        double d3 = this.x[this.mn][this.mn_cb] - this.ax[this.anC];
        double d4 = this.y[this.mn][this.mn_cb] - this.ay[this.anC];
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        double d6 = (this.vx[this.mn][this.mn_cb] * d3 + this.vy[this.mn][this.mn_cb] * d4) / d5;
        double d7 = (this.avx[this.anC] * d3 + this.avy[this.anC] * d4) / d5;
        double d8 = (d3 * (this.y[this.mn][n] - this.y[this.mn][this.mn_cb]) - d4 * (this.x[this.mn][n] - this.x[this.mn][this.mn_cb])) / (2.0 * d5);
        double d9 = 0.0;
        if (this.atomFixed[this.anC]) {
            d7 = 0.0;
            d2 = 2.0 * (d7 - d6) / (1.0 + d8 / this.d * (d8 / this.d));
            d = 0.0;
        } else {
            d2 = 2.0 * (d7 - d6) / (1.0 + d8 / this.d * (d8 / this.d) + this.mD / this.mM * (1.0 + d9 / this.d * (d9 / this.d)));
            d = 2.0 * (d6 - d7) / (1.0 + d9 / this.d * (d9 / this.d) + this.mM / this.mD * (1.0 + d8 / this.d * (d8 / this.d)));
        }
        double d10 = d8 / (this.d * this.d) * d2;
        this.avx0[this.anC] = this.avx[this.anC];
        this.avy0[this.anC] = this.avy[this.anC];
        this.vxcm0[this.mn] = this.vxcm[this.mn];
        this.vycm0[this.mn] = this.vycm[this.mn];
        this.w0[this.mn] = this.w[this.mn];
        this.avx[this.anC] = this.avx0[this.anC] + d * d3 / d5;
        this.avy[this.anC] = this.avy0[this.anC] + d * d4 / d5;
        this.vxcm[this.mn] = this.vxcm0[this.mn] + d2 * d3 / d5;
        this.vycm[this.mn] = this.vycm0[this.mn] + d2 * d4 / d5;
        this.w[this.mn] = this.w0[this.mn] + d10;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        this.BallDVelValues(this.mn);
        d11 = 0.5 * this.mD * (this.vxcm[this.mn] * this.vxcm[this.mn] - this.vxcm0[this.mn] * this.vxcm0[this.mn]);
        d12 = 0.5 * this.IM * (this.w[this.mn] * this.w[this.mn] - this.w0[this.mn] * this.w0[this.mn]);
        this.KinEnDiatTrans += (d11 += 0.5 * this.mD * (this.vycm[this.mn] * this.vycm[this.mn] - this.vycm0[this.mn] * this.vycm0[this.mn]));
        this.KinEnDiatRot += d12;
        this.KinEnDiat = this.KinEnDiatTrans + this.KinEnDiatRot;
        d13 = 0.5 * this.mM * (this.avx[this.anC] * this.avx[this.anC] - this.avx0[this.anC] * this.avx0[this.anC]);
        this.KinEnMonoat += (d13 += 0.5 * this.mM * (this.avy[this.anC] * this.avy[this.anC] - this.avy0[this.anC] * this.avy0[this.anC]));
        this.KinEnTotalMD = this.KinEnMonoat + this.KinEnDiat;
    }

    public void BallBounceMM() {
        double d;
        double d2;
        double d3 = this.ax[this.anC] - this.ax[this.an];
        double d4 = this.ay[this.anC] - this.ay[this.an];
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        double d6 = (this.avx[this.an] * d3 + this.avy[this.an] * d4) / d5;
        double d7 = (this.avx[this.anC] * d3 + this.avy[this.anC] * d4) / d5;
        if (this.atomFixed[this.anC]) {
            d7 = 0.0;
            d2 = 2.0 * (d7 - d6);
            d = 0.0;
        } else if (this.atomFixed[this.an]) {
            d6 = 0.0;
            d = 2.0 * (d6 - d7);
            d2 = 0.0;
        } else {
            d2 = 2.0 * (d7 - d6) / (1.0 + this.mM / this.mM);
            d = 2.0 * (d6 - d7) / (1.0 + this.mM / this.mM);
        }
        this.avx0[this.an] = this.avx[this.an];
        this.avy0[this.an] = this.avy[this.an];
        this.avx0[this.anC] = this.avx[this.anC];
        this.avy0[this.anC] = this.avy[this.anC];
        this.avx[this.an] = this.avx0[this.an] + d2 * d3 / d5;
        this.avy[this.an] = this.avy0[this.an] + d2 * d4 / d5;
        this.avx[this.anC] = this.avx0[this.anC] + d * d3 / d5;
        this.avy[this.anC] = this.avy0[this.anC] + d * d4 / d5;
        double d8 = 0.0;
        d8 = 0.5 * this.mM * (this.avx[this.an] * this.avx[this.an] - this.avx0[this.an] * this.avx0[this.an]);
        d8 += 0.5 * this.mM * (this.avy[this.an] * this.avy[this.an] - this.avy0[this.an] * this.avy0[this.an]);
        d8 += 0.5 * this.mM * (this.avx[this.anC] * this.avx[this.anC] - this.avx0[this.anC] * this.avx0[this.anC]);
        this.KinEnMonoat += (d8 += 0.5 * this.mM * (this.avy[this.anC] * this.avy[this.anC] - this.avy0[this.anC] * this.avy0[this.anC]));
        this.KinEnTotalMD = this.KinEnMonoat + this.KinEnDiat;
    }

    public void ddContact() {
        int n = this.mn + 1;
        this.mnC = 0;
        for (n = this.mn + 1; n < this.mnMax + 1; ++n) {
            for (int i = 1; i < 3; ++i) {
                for (int j = 1; j < 3; ++j) {
                    this.dotProduct = (this.x[n][j] - this.x[this.mn][i]) * (this.vx[n][j] - this.vx[this.mn][i]) + (this.y[n][j] - this.y[this.mn][i]) * (this.vy[n][j] - this.vy[this.mn][i]);
                    double d = (this.x[this.mn][i] - this.x[n][j]) * (this.x[this.mn][i] - this.x[n][j]) + (this.y[this.mn][i] - this.y[n][j]) * (this.y[this.mn][i] - this.y[n][j]);
                    if (!(d < (double)(4 * this.radiusD * this.radiusD)) || !(this.dotProduct < 0.0)) continue;
                    this.mnC = n;
                    this.mn_cb = i;
                    this.mnC_cb = j;
                    this.BallBounceDD();
                }
            }
        }
    }

    public void mmContact() {
        int n = this.an + 1;
        this.anC = 0;
        for (n = this.an + 1; n < this.anMax + 1; ++n) {
            this.dotProduct = (this.ax[n] - this.ax[this.an]) * (this.avx[n] - this.avx[this.an]) + (this.ay[n] - this.ay[this.an]) * (this.avy[n] - this.avy[this.an]);
            double d = (this.ax[this.an] - this.ax[n]) * (this.ax[this.an] - this.ax[n]) + (this.ay[this.an] - this.ay[n]) * (this.ay[this.an] - this.ay[n]);
            if (this.atomFixed[n] && this.atomFixed[this.an] || !(d < (double)(4 * this.radiusM * this.radiusM)) || !(this.dotProduct < 0.0)) continue;
            this.anC = n;
            return;
        }
    }

    public void mwContact() {
        this.mwc = 0;
        if (this.ax[this.an] + (double)this.radiusM > (double)this.iwidth && this.avx[this.an] > 0.0) {
            this.avx[this.an] = -this.avx[this.an];
        }
        if (this.ay[this.an] + (double)this.radiusM > (double)this.iheight && this.avy[this.an] > 0.0) {
            this.avy[this.an] = -this.avy[this.an];
        }
        if (this.ax[this.an] - (double)this.radiusM < 0.0 && this.avx[this.an] < 0.0) {
            this.avx[this.an] = -this.avx[this.an];
        }
        if (this.ay[this.an] - (double)this.radiusM < 0.0 && this.avy[this.an] < 0.0) {
            this.avy[this.an] = -this.avy[this.an];
        }
        double d = 0.0;
        d = 0.5 * this.mM * (this.avx[this.an] * this.avx[this.an] - this.avx0[this.an] * this.avx0[this.an]);
        this.KinEnMonoat += (d += 0.5 * this.mM * (this.avy[this.an] * this.avy[this.an] - this.avy0[this.an] * this.avy0[this.an]));
        this.KinEnTotalMD = this.KinEnMonoat + this.KinEnDiat;
    }

    public void dmContact() {
        int n = 1;
        double d = this.radiusD + this.radiusM;
        this.anC = 0;
        for (n = 1; n < this.anMax + 1; ++n) {
            int n2 = 1;
            for (n2 = 1; n2 < 3; ++n2) {
                this.dotProduct = (this.ax[n] - this.x[this.mn][n2]) * (this.avx[n] - this.vx[this.mn][n2]) + (this.ay[n] - this.y[this.mn][n2]) * (this.avy[n] - this.vy[this.mn][n2]);
                double d2 = (this.ax[n] - this.x[this.mn][n2]) * (this.ax[n] - this.x[this.mn][n2]) + (this.ay[n] - this.y[this.mn][n2]) * (this.ay[n] - this.y[this.mn][n2]);
                if (!(d2 < d * d) || !(this.dotProduct < 0.0)) continue;
                this.anC = n;
                this.mn_cb = n2;
                return;
            }
        }
    }

    public void dwContact() {
        this.wc1 = 0;
        this.wc2 = 0;
        this.cb = 0;
        this.cb0 = 0;
        this.wcn = 0;
        if (this.x[this.mn][1] + (double)this.radiusD > (double)this.iwidth && this.vx[this.mn][1] > 0.0) {
            this.wc = 1;
            this.cb = 1;
            this.WallBounceD();
        }
        if (this.y[this.mn][1] + (double)this.radiusD > (double)this.iheight && this.vy[this.mn][1] > 0.0) {
            this.wc = 2;
            this.cb = 1;
            this.WallBounceD();
        }
        if (this.x[this.mn][1] - (double)this.radiusD < 0.0 && this.vx[this.mn][1] < 0.0) {
            this.wc = 3;
            this.cb = 1;
            this.WallBounceD();
        }
        if (this.y[this.mn][1] - (double)this.radiusD < 0.0 && this.vy[this.mn][1] < 0.0) {
            this.wc = 4;
            this.cb = 1;
            this.WallBounceD();
        }
        if (this.x[this.mn][2] + (double)this.radiusD > (double)this.iwidth && this.vx[this.mn][2] > 0.0) {
            this.wc = 1;
            this.cb = 2;
            this.WallBounceD();
        }
        if (this.y[this.mn][2] + (double)this.radiusD > (double)this.iheight && this.vy[this.mn][2] > 0.0) {
            this.wc = 2;
            this.cb = 2;
            this.WallBounceD();
        }
        if (this.x[this.mn][2] - (double)this.radiusD < 0.0 && this.vx[this.mn][2] < 0.0) {
            this.wc = 3;
            this.cb = 2;
            this.WallBounceD();
        }
        if (this.y[this.mn][2] - (double)this.radiusD < 0.0 && this.vy[this.mn][2] < 0.0) {
            this.wc = 4;
            this.cb = 2;
            this.WallBounceD();
        }
    }

    public void BallDValues(int n) {
        double d = this.d * Math.cos(this.teta[n]);
        double d2 = this.d * Math.sin(this.teta[n]);
        this.x[n][1] = this.xcm[n] - d;
        this.y[n][1] = this.ycm[n] - d2;
        this.x[n][2] = this.xcm[n] + d;
        this.y[n][2] = this.ycm[n] + d2;
        this.vx[n][1] = this.vxcm[n] + this.w[n] * this.d * Math.sin(this.teta[n]);
        this.vx[n][2] = this.vxcm[n] - this.w[n] * this.d * Math.sin(this.teta[n]);
        this.vy[n][1] = this.vycm[n] - this.w[n] * this.d * Math.cos(this.teta[n]);
        this.vy[n][2] = this.vycm[n] + this.w[n] * this.d * Math.cos(this.teta[n]);
    }

    public void BallDVelValues(int n) {
        this.vx[n][1] = this.vxcm[n] + this.w[n] * this.d * Math.sin(this.teta[n]);
        this.vx[n][2] = this.vxcm[n] - this.w[n] * this.d * Math.sin(this.teta[n]);
        this.vy[n][1] = this.vycm[n] - this.w[n] * this.d * Math.cos(this.teta[n]);
        this.vy[n][2] = this.vycm[n] + this.w[n] * this.d * Math.cos(this.teta[n]);
    }

    public void WallBounceD() {
        double d = 0.0;
        double d2 = 0.0;
        this.mn_cb = this.cb;
        int n = 3 - this.cb;
        if (this.wc == 1) {
            d = 1.0;
            d2 = 0.0;
        }
        if (this.wc == 2) {
            d = 0.0;
            d2 = 1.0;
        }
        if (this.wc == 3) {
            d = -1.0;
            d2 = 0.0;
        }
        if (this.wc == 4) {
            d = 0.0;
            d2 = -1.0;
        }
        double d3 = this.w[this.mn];
        double d4 = Math.sqrt(d * d + d2 * d2);
        double d5 = (this.vxcm[this.mn] * d + this.vycm[this.mn] * d2) / d4;
        double d6 = (d * (this.y[this.mn][n] - this.y[this.mn][this.mn_cb]) - d2 * (this.x[this.mn][n] - this.x[this.mn][this.mn_cb])) / (2.0 * d4);
        double d7 = -2.0 * (d5 + d6 * d3) / (1.0 + d6 / this.d * (d6 / this.d));
        double d8 = d6 / (this.d * this.d) * d7;
        this.vxcm0[this.mn] = this.vxcm[this.mn];
        this.vycm0[this.mn] = this.vycm[this.mn];
        this.w0[this.mn] = this.w[this.mn];
        this.w0[this.mnC] = this.w[this.mnC];
        this.vxcm[this.mn] = this.vxcm0[this.mn] + d7 * d / d4;
        this.vycm[this.mn] = this.vycm0[this.mn] + d7 * d2 / d4;
        this.w[this.mn] = this.w0[this.mn] + d8;
        this.wc = 0;
        this.BallDVelValues(this.mn);
        double d9 = 0.0;
        double d10 = 0.0;
        d9 = 0.5 * this.mD * (this.vxcm[this.mn] * this.vxcm[this.mn] - this.vxcm0[this.mn] * this.vxcm0[this.mn]);
        d10 = 0.5 * this.IM * (this.w[this.mn] * this.w[this.mn] - this.w0[this.mn] * this.w0[this.mn]);
        this.KinEnDiatTrans += (d9 += 0.5 * this.mD * (this.vycm[this.mn] * this.vycm[this.mn] - this.vycm0[this.mn] * this.vycm0[this.mn]));
        this.KinEnDiatRot += d10;
        this.KinEnDiat = this.KinEnDiatTrans + this.KinEnDiatRot;
        this.KinEnTotalMD = this.KinEnMonoat + this.KinEnDiat;
    }

    public void WallBounceM() {
        if (this.mwc == 1) {
            this.avx[this.an] = -this.avx[this.an];
        }
        if (this.mwc == 3) {
            this.avx[this.an] = -this.avx[this.an];
        }
        if (this.mwc == 2) {
            this.avy[this.an] = -this.avy[this.an];
        }
        if (this.mwc == 4) {
            this.avy[this.an] = -this.avy[this.an];
        }
    }

    public void KinEnTotal() {
        ++this.energyCalls;
        double d = this.KinEnTotalMD;
        this.KinEnDiatTrans = 0.0;
        this.KinEnDiatRot = 0.0;
        this.KinEnDiat = 0.0;
        this.KinEnMonoat = 0.0;
        this.KinEnD();
        this.KinEnM();
        this.KinEnTotalMD = this.KinEnMonoat + this.KinEnDiat;
    }

    public void KinEnM() {
        this.KinEnMonoat = 0.0;
        for (int i = 1; i < this.anMax + 1; ++i) {
            this.KinEnMonoat += 0.5 * this.mM * (this.avx[i] * this.avx[i] + this.avy[i] * this.avy[i]);
        }
    }

    public void KinEnD() {
        this.KinEnDiatTrans = 0.0;
        this.KinEnDiatRot = 0.0;
        for (int i = 1; i < this.mnMax + 1; ++i) {
            this.vx[i][1] = this.vxcm[i] + this.w[i] * this.d * Math.sin(this.teta[i]);
            this.vx[i][2] = this.vxcm[i] - this.w[i] * this.d * Math.sin(this.teta[i]);
            this.vy[i][1] = this.vycm[i] - this.w[i] * this.d * Math.cos(this.teta[i]);
            this.vy[i][2] = this.vycm[i] + this.w[i] * this.d * Math.cos(this.teta[i]);
            this.KinEnDiatTrans += 0.5 * this.mD * (this.vxcm[i] * this.vxcm[i] + this.vycm[i] * this.vycm[i]);
            this.KinEnDiatRot += 0.5 * this.IM * this.w[i] * this.w[i];
        }
        this.KinEnDiat = this.KinEnDiatTrans + this.KinEnDiatRot;
        this.keRot_keTrans += this.KinEnDiatRot / this.KinEnDiatTrans;
        ++this.tEnerAv;
        this.tempD = this.mnMax != 0 ? this.KinEnDiatTrans / (double)this.mnMax : 0.0;
    }
}

