/*
 * Decompiled with CFR 0.152.
 */
package diatomic;

import diatomic.EnsemblePanel;
import edu.davidson.display.Format;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class PhysletPanel
extends EnsemblePanel
implements SStepable,
SDataSource {
    private int boxWidth = 0;
    private Format mouseFormat = new Format("%-+6.3g");
    private int mouseX = 0;
    private int mouseY = 0;
    double scale = 10.0;
    int numSteps = 1;
    Color backgroundColor = Color.lightGray;
    boolean mouseDown = false;
    Image osi;
    SApplet owner = null;
    Font boldFont = new Font("Helvetica", 1, 14);
    boolean timeDisplay = true;
    String[] varStrings = new String[]{"t", "ke", "ke_atom", "ke_mol", "ke_mol_rot", "ke_mol_trans", "n_atom", "n_mol"};
    double[][] ds = new double[1][8];

    public PhysletPanel(SApplet sApplet) {
        this();
        this.owner = sApplet;
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PhysletPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                PhysletPanel.this.this_mouseDragged(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PhysletPanel.this.this_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PhysletPanel.this.this_mouseReleased(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                PhysletPanel.this.this_mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                PhysletPanel.this.this_mouseExited(mouseEvent);
            }
        });
    }

    public void step(double d, double d2) {
        int n = this.numSteps;
        this.dt = d / (double)n;
        for (int i = 0; i < n; ++i) {
            this.monodiLoop();
        }
        this.theTime = d2 + d;
        this.paintOSI();
        Graphics graphics = this.getGraphics();
        graphics.drawImage(this.osi, 0, 0, this);
        graphics.dispose();
        this.KinEnTotal();
        this.owner.updateDataConnections();
    }

    void createOSI() {
        this.iwidth = this.getSize().width;
        this.iheight = this.getSize().height;
        this.osi = this.createImage(this.iwidth, this.iheight);
    }

    void paintOSI() {
        if (this.osi == null) {
            return;
        }
        Image image = this.osi;
        synchronized (image) {
            Graphics graphics = this.osi.getGraphics();
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
            this.paintMonoat(graphics);
            this.paintDiat(graphics);
            this.paintTime(graphics);
            if (this.mouseDown) {
                this.paintCoords(graphics, this.mouseX, this.mouseY);
            }
            graphics.dispose();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.getSize().width == 0 || this.getSize().height == 0) {
            return;
        }
        if (this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.iwidth = this.getSize().width;
            this.iheight = this.getSize().height;
            this.osi = this.createImage(this.iwidth, this.iheight);
            this.paintOSI();
        }
        if (this.owner.isClockRunning()) {
            return;
        }
        if (this.osi == null) {
            return;
        }
        Image image = this.osi;
        synchronized (image) {
            graphics.drawImage(this.osi, 0, 0, this);
        }
    }

    void paintDiat(Graphics graphics) {
        int n = 2 * this.radiusD;
        for (int i = 1; i <= this.mnMax; ++i) {
            graphics.setColor(Color.black);
            graphics.drawLine((int)this.x[i][1], (int)this.y[i][1], (int)this.x[i][2], (int)this.y[i][2]);
            if (this.molColor[i] == Color.green) {
                graphics.setColor(Color.green);
                graphics.fillOval((int)(this.x[i][1] - (double)this.radiusD), (int)(this.y[i][1] - (double)this.radiusD), n, n);
                graphics.setColor(Color.yellow);
                graphics.fillOval((int)(this.x[i][2] - (double)this.radiusD), (int)(this.y[i][2] - (double)this.radiusD), n, n);
                continue;
            }
            graphics.setColor(this.molColor[i]);
            graphics.fillOval((int)(this.x[i][1] - (double)this.radiusD), (int)(this.y[i][1] - (double)this.radiusD), n, n);
            graphics.fillOval((int)(this.x[i][2] - (double)this.radiusD), (int)(this.y[i][2] - (double)this.radiusD), n, n);
        }
    }

    void paintMonoat(Graphics graphics) {
        int n = 2 * this.radiusM;
        for (int i = 1; i <= this.anMax; ++i) {
            if (this.atomFixed[i]) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(this.atomColor[i]);
            }
            graphics.fillOval((int)(this.ax[i] - (double)this.radiusM), (int)(this.ay[i] - (double)this.radiusM), n, n);
        }
    }

    void paintTime(Graphics graphics) {
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(this.boldFont);
        String string = new Format("%7.4g").form(SUtil.chop((double)this.theTime, (double)1.0E-12));
        if (this.timeDisplay) {
            if (this.iwidth > 150) {
                graphics.drawString("Time: ".concat(String.valueOf(String.valueOf(string))), 10, 15);
            } else {
                graphics.drawString("Time: ".concat(String.valueOf(String.valueOf(string))), 10, this.iheight - 40);
            }
        }
        graphics.setFont(font);
    }

    public double[][] getVariables() {
        double d = this.scale * this.scale;
        this.ds[0][0] = this.theTime;
        this.ds[0][1] = this.KinEnTotalMD / d;
        this.ds[0][2] = this.KinEnMonoat / d;
        this.ds[0][3] = this.KinEnDiat / d;
        this.ds[0][4] = this.KinEnDiatRot / d;
        this.ds[0][5] = this.KinEnDiatTrans / d;
        this.ds[0][6] = this.anMax;
        this.ds[0][7] = this.mnMax;
        return this.ds;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public int addAtomDataSource(int n) {
        AtomSource atomSource = new AtomSource(n);
        return atomSource.hashCode();
    }

    public int addDiatomicDataSource(int n) {
        DiatomicSource diatomicSource = new DiatomicSource(n);
        return diatomicSource.hashCode();
    }

    void paintCoords(Graphics graphics) {
        this.paintCoords(graphics, this.mouseX, this.mouseY);
    }

    void paintCoords(int n, int n2) {
        Graphics graphics = this.getGraphics();
        this.paintCoords(graphics, n, n2);
        graphics.dispose();
    }

    void paintCoords(Graphics graphics, int n, int n2) {
        String string = String.valueOf(String.valueOf(new StringBuffer("").append(this.mouseFormat.form((double)n / this.scale)).append(" , ").append(this.mouseFormat.form((double)(this.iheight - n2) / this.scale))));
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
        graphics.drawRect(0, rectangle.height - 20, this.boxWidth - 1, 20);
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) == 0) {
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.mouseDown = true;
            if (!this.owner.clock.isRunning()) {
                this.paintCoords(this.mouseX, this.mouseY);
            }
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (!this.owner.clock.isRunning()) {
            this.paintCoords(this.mouseX, this.mouseY);
        }
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.mouseDown = false;
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        Rectangle rectangle = this.getBounds();
        if (!this.owner.clock.isRunning()) {
            this.repaint(0, rectangle.height - 20, this.boxWidth, 20);
        }
        this.boxWidth = 0;
    }

    void this_mouseEntered(MouseEvent mouseEvent) {
        this.owner.setCursor(Cursor.getPredefinedCursor(1));
    }

    void this_mouseExited(MouseEvent mouseEvent) {
        this.owner.setCursor(Cursor.getPredefinedCursor(0));
    }

    public class DiatomicSource
    implements SDataSource {
        String[] varStrings = new String[]{"t", "x", "y", "vx", "vy", "m", "theta", "w", "inertia"};
        double[][] ds = new double[1][9];
        int index = 0;

        DiatomicSource(int n) {
            this.index = n;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            this.ds[0][0] = PhysletPanel.this.theTime;
            if (this.index > PhysletPanel.this.mnMax || this.index < 1) {
                System.out.println("ERROR: Atom index is out of range .");
                this.ds[0][1] = 0.0;
                this.ds[0][2] = 0.0;
                this.ds[0][3] = 0.0;
                this.ds[0][4] = 0.0;
                this.ds[0][5] = 0.0;
                this.ds[0][6] = 0.0;
                this.ds[0][7] = 0.0;
                this.ds[0][8] = 0.0;
                return this.ds;
            }
            this.ds[0][1] = PhysletPanel.this.xcm[this.index] / PhysletPanel.this.scale;
            this.ds[0][2] = ((double)PhysletPanel.this.iheight - PhysletPanel.this.ycm[this.index]) / PhysletPanel.this.scale;
            this.ds[0][3] = PhysletPanel.this.vxcm[this.index] / PhysletPanel.this.scale;
            this.ds[0][4] = -PhysletPanel.this.vycm[this.index] / PhysletPanel.this.scale;
            this.ds[0][5] = PhysletPanel.this.mD;
            this.ds[0][6] = PhysletPanel.this.teta[this.index];
            this.ds[0][7] = PhysletPanel.this.w[this.index];
            this.ds[0][8] = PhysletPanel.this.IM / PhysletPanel.this.scale / PhysletPanel.this.scale;
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return PhysletPanel.this.owner;
        }
    }

    public class AtomSource
    implements SDataSource {
        String[] varStrings = new String[]{"t", "x", "y", "vx", "vy", "m"};
        double[][] ds = new double[1][6];
        int index = 0;

        AtomSource(int n) {
            this.index = n;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            this.ds[0][0] = PhysletPanel.this.theTime;
            if (this.index > PhysletPanel.this.anMax || this.index < 1) {
                System.out.println("ERROR: Atom index is out of range .");
                this.ds[0][1] = 0.0;
                this.ds[0][2] = 0.0;
                this.ds[0][3] = 0.0;
                this.ds[0][4] = 0.0;
                this.ds[0][5] = 0.0;
                return this.ds;
            }
            this.ds[0][1] = PhysletPanel.this.ax[this.index] / PhysletPanel.this.scale;
            this.ds[0][2] = ((double)PhysletPanel.this.iheight - PhysletPanel.this.ay[this.index]) / PhysletPanel.this.scale;
            this.ds[0][3] = PhysletPanel.this.avx[this.index] / PhysletPanel.this.scale;
            this.ds[0][4] = -PhysletPanel.this.avy[this.index] / PhysletPanel.this.scale;
            this.ds[0][5] = PhysletPanel.this.mM;
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return PhysletPanel.this.owner;
        }
    }
}

