/*
 * Decompiled with CFR 0.152.
 */
package jep;

import com.borland.jbcl.layout.VerticalFlowLayout;
import edu.davidson.display.SInteger;
import edu.davidson.display.SNumber;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import jep.JEParser;
import org.netlib.math.complex.Complex;

public class JEP
extends SApplet
implements SDataSource,
SStepable {
    boolean isStandalone = false;
    double min;
    double max;
    int numPts;
    String functionStr;
    String variableStr;
    boolean showControls;
    boolean explicitTime = false;
    boolean validFunction = false;
    double dx;
    String[] varStrings = new String[]{"x", "re", "im", "n"};
    double[][] ds = null;
    private JEParser parser;
    EtchedBorder etchedBorder1 = new EtchedBorder();
    Button setBtn = new Button();
    Label maxLabel = new Label();
    FlowLayout flowLayout1 = new FlowLayout();
    Panel buttonPanel = new Panel();
    Label numLabel = new Label();
    SNumber maxField = new SNumber();
    SNumber minField = new SNumber();
    Panel panel3 = new Panel();
    Panel panel2 = new Panel();
    Panel panel1 = new Panel();
    SInteger numField = new SInteger();
    Label minLabel2 = new Label();
    Panel panel4 = new Panel();
    Label label1 = new Label();
    TextField funcField = new TextField();
    BorderLayout borderLayout1 = new BorderLayout();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.min = Double.valueOf(this.getParameter("Min", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.max = Double.valueOf(this.getParameter("Max", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.numPts = Integer.parseInt(this.getParameter("NumPts", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.functionStr = this.getParameter("Function", "sin(x)/x");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.variableStr = this.getParameter("Variable", "x");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.buttonPanel.setVisible(this.showControls);
        this.funcField.setText(this.functionStr);
        this.setFunction(this.functionStr, this.variableStr);
        this.setNumPts(this.numPts);
        SApplet.addDataSource((Object)((Object)this));
        this.clock.addClockListener((SStepable)this);
    }

    private void jbInit() throws Exception {
        this.setBtn.setLabel("Set");
        this.setBtn.setBackground(Color.lightGray);
        this.setBtn.setLabel("Set");
        this.setBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JEP.this.setBtn_actionPerformed(actionEvent);
            }
        });
        this.maxLabel.setAlignment(2);
        this.maxLabel.setText("Max");
        this.maxLabel.setAlignment(2);
        this.maxLabel.setBackground(Color.lightGray);
        this.maxLabel.setText("Max");
        this.buttonPanel.setBackground(Color.lightGray);
        this.buttonPanel.setLayout(this.flowLayout1);
        this.numLabel.setAlignment(2);
        this.numLabel.setText("#");
        this.numLabel.setAlignment(2);
        this.numLabel.setBackground(Color.lightGray);
        this.numLabel.setText("#");
        this.maxField.setValue(100.0);
        this.numField.setValue(10);
        this.minLabel2.setText("Min");
        this.minLabel2.setAlignment(2);
        this.minLabel2.setAlignment(2);
        this.minLabel2.setBackground(Color.lightGray);
        this.minLabel2.setText("Min");
        this.etchedBorder1.setBackground(Color.lightGray);
        this.etchedBorder1.setLayout(this.verticalFlowLayout1);
        this.label1.setAlignment(2);
        this.label1.setBackground(Color.lightGray);
        this.label1.setText("f(x,t) = ");
        this.funcField.setText("textField1");
        this.panel4.setLayout(this.borderLayout1);
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.panel3.setBackground(Color.lightGray);
        this.panel2.setBackground(Color.lightGray);
        this.panel1.setBackground(Color.lightGray);
        this.panel4.setBackground(Color.lightGray);
        ((Container)((Object)this)).add((Component)this.etchedBorder1, null);
        this.etchedBorder1.add((Component)this.buttonPanel, null);
        this.buttonPanel.add((Component)this.setBtn, null);
        this.buttonPanel.add((Component)this.panel3, null);
        this.panel3.add((Component)this.minLabel2, null);
        this.panel3.add((Component)this.minField, null);
        this.buttonPanel.add((Component)this.panel2, null);
        this.panel2.add((Component)this.maxLabel, null);
        this.panel2.add((Component)this.maxField, null);
        this.buttonPanel.add((Component)this.panel1, null);
        this.panel1.add((Component)this.numLabel, null);
        this.panel1.add((Component)this.numField, null);
        this.etchedBorder1.add((Component)this.panel4, null);
        this.panel4.add((Component)this.label1, "West");
        this.panel4.add((Component)this.funcField, "Center");
    }

    public String getAppletInfo() {
        return "Analytic Physlet evaluates an analytic function at a specified number of points.";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Min", "double", "Minimum value"}, {"Max", "double", "Maximum value"}, {"NumPts", "int", "Number of Points"}, {"Function", "String", "The function string"}, {"Variable", "String", "The independent variable."}, {"ShowControls", "boolean", "Show the user interface"}};
        return stringArray;
    }

    public static void main(String[] stringArray) {
        JEP jEP = new JEP();
        jEP.isStandalone = true;
        Frame frame = new Frame(){

            protected void processWindowEvent(WindowEvent windowEvent) {
                super.processWindowEvent(windowEvent);
                if (windowEvent.getID() == 201) {
                    System.exit(0);
                }
            }

            public synchronized void setTitle(String string) {
                super.setTitle(string);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("Applet Frame");
        frame.add((Component)((Object)jEP), "Center");
        jEP.init();
        jEP.start();
        ((Component)frame).setSize(400, 320);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation((dimension.width - frame.getSize().width) / 2, (dimension.height - frame.getSize().height) / 2);
        ((Component)frame).setVisible(true);
    }

    public double[][] getVariables() {
        return this.ds;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    public synchronized void setNumPts(int n) {
        if (n < 1) {
            System.out.println("Number of points must be >0.");
        }
        this.numPts = Math.max(1, n);
        this.dx = (this.max - this.min) / (double)(this.numPts - 1);
        this.ds = new double[this.numPts][4];
        this.setMinMax(this.min, this.max);
        if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
            this.numField.setValue(this.numPts);
        }
    }

    public synchronized void setMinMax(double d, double d2) {
        double d3;
        if (this.parser == null || !this.validFunction) {
            System.out.println("Invalid function.");
            return;
        }
        this.max = d2;
        this.min = d;
        if (this.max < this.min) {
            System.out.println("Maximum must be >  minimum.");
            d3 = this.max;
            this.max = this.min;
            this.min = d3;
        }
        if (this.max == this.min) {
            System.out.println("Maximum cannot be =  minimum.");
            this.max += 1.0;
        }
        this.dx = (this.max - this.min) / (double)(this.numPts - 1);
        d3 = this.min;
        double d4 = this.clock.getTime();
        for (int i = 0; i < this.numPts; ++i) {
            this.ds[i][0] = d3;
            Complex complex = this.explicitTime ? this.parser.evaluateComplex(d3, d4) : this.parser.evaluateComplex(d3);
            this.ds[i][1] = complex.re();
            this.ds[i][2] = complex.im();
            this.ds[i][3] = i;
            d3 += this.dx;
        }
        if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
            this.minField.setValue(this.min);
            this.maxField.setValue(this.max);
        }
        this.updateDataConnections();
    }

    public double getReValue(double d) {
        if (this.parser == null) {
            return 0.0;
        }
        Complex complex = this.explicitTime ? this.parser.evaluateComplex(d, this.clock.getTime()) : this.parser.evaluateComplex(d);
        return complex.re();
    }

    public double getImValue(double d) {
        if (this.parser == null) {
            return 0.0;
        }
        Complex complex = this.explicitTime ? this.parser.evaluateComplex(d, this.clock.getTime()) : this.parser.evaluateComplex(d);
        return complex.im();
    }

    synchronized void evaluate() {
        double d = this.clock.getTime();
        for (int i = 0; i < this.numPts; ++i) {
            Complex complex = this.explicitTime ? this.parser.evaluateComplex(this.ds[i][0], d) : this.parser.evaluateComplex(this.ds[i][0]);
            this.ds[i][1] = complex.re();
            this.ds[i][2] = complex.im();
        }
    }

    private boolean parseOneVariable(String string) {
        JEParser jEParser = new JEParser(string, this.variableStr, true);
        if (jEParser.hasError()) {
            this.validFunction = false;
            return false;
        }
        this.validFunction = true;
        this.explicitTime = false;
        this.parser = jEParser;
        this.functionStr = string;
        return true;
    }

    private boolean parseTwoVariables(String string) {
        JEParser jEParser = new JEParser(string, this.variableStr, "t", true);
        if (jEParser.hasError()) {
            System.out.println("Failed to parse f(x,t)): ".concat(String.valueOf(String.valueOf(string))));
            this.parseOneVariable("0");
            this.validFunction = false;
            return false;
        }
        this.validFunction = true;
        this.explicitTime = true;
        this.parser = jEParser;
        this.functionStr = string;
        return true;
    }

    public void reset() {
        this.clock.stopClock();
        this.clock.setTime(0.0);
        this.evaluate();
        this.updateDataConnections();
    }

    public boolean isValidCFunction(String string, String string2) {
        JEParser jEParser = new JEParser(string, string2, "t", true);
        return !jEParser.hasError();
    }

    public boolean setFunction(String string, String string2) {
        this.variableStr = new String(string2.trim().toLowerCase());
        String string3 = string.trim();
        if (!this.parseOneVariable(string3)) {
            this.parseTwoVariables(string3);
        }
        if (this.ds == null) {
            this.setNumPts(this.numPts);
        } else {
            this.setMinMax(this.min, this.max);
        }
        return this.validFunction;
    }

    public boolean setFunctionStr(String string) {
        String string2 = string.trim();
        this.setFunction(string2, this.variableStr);
        return this.validFunction;
    }

    public String getFunctionStr(String string) {
        return this.functionStr;
    }

    public void stepForward() {
        this.stepTimeForward();
    }

    public void stepTimeForward() {
        if (this.clock.isRunning()) {
            this.pause();
            return;
        }
        boolean bl = this.clock.getDt() < 0.0;
        this.clock.setDt(Math.abs(this.clock.getDt()));
        this.clock.doStep();
        if (bl) {
            this.clock.setDt(-Math.abs(this.clock.getDt()));
        }
    }

    public void stepTimeBack() {
        if (this.clock.isRunning()) {
            this.pause();
            return;
        }
        boolean bl = this.clock.getDt() < 0.0;
        this.clock.setDt(-Math.abs(this.clock.getDt()));
        this.clock.doStep();
        if (!bl) {
            this.clock.setDt(Math.abs(this.clock.getDt()));
        }
    }

    public void stepBack() {
        this.stepTimeBack();
    }

    public void step(double d, double d2) {
        if (this.parser == null || !this.validFunction) {
            System.out.println("Invalid function.");
            return;
        }
        if (this.explicitTime) {
            this.evaluate();
        }
        this.updateDataConnections();
    }

    void setBtn_actionPerformed(ActionEvent actionEvent) {
        this.min = this.minField.getValue();
        this.max = this.maxField.getValue();
        this.setFunctionStr(this.funcField.getText());
        this.setNumPts(this.numField.getValue());
    }
}

