/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.util.Stack;
import org.netlib.math.complex.Complex;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;

public class JEParser {
    public static final boolean MAKE_COMPLEX = true;
    public static final double SQRT2;
    public static final double COS45;
    JEP jep = new JEP();
    String[] variables;

    public JEParser(String string, String string2) {
        this(string, string2, false);
    }

    public JEParser(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public JEParser(String string, String string2, boolean bl) {
        this.variables = new String[1];
        this.variables[0] = string2;
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
        this.jep.addFunction("sqrt", new SquareRoot(this));
        this.jep.addFunction("exp", new Exp(this));
        this.jep.addFunction("step", new Step(this));
        if (bl) {
            this.jep.addComplex();
        }
        this.jep.addVariable(string2, 0.0);
        this.jep.parseExpression(string);
    }

    public JEParser(String string, String string2, String string3, boolean bl) {
        this.variables = new String[2];
        this.variables[0] = string2;
        this.variables[1] = string3;
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
        this.jep.addFunction("sqrt", new SquareRoot(this));
        this.jep.addFunction("exp", new Exp(this));
        this.jep.addFunction("step", new Step(this));
        if (bl) {
            this.jep.addComplex();
        }
        this.jep.addVariable(string2, 0.0);
        this.jep.addVariable(string3, 0.0);
        this.jep.parseExpression(string);
    }

    public void setFunction(String string) {
        this.jep.parseExpression(string);
    }

    public boolean hasError() {
        return this.jep.hasError();
    }

    public double evaluate(double d) {
        this.jep.addVariable(this.variables[0], d);
        return this.jep.getValue();
    }

    public double evaluate(double d, double d2) {
        if (this.variables.length < 1) {
            System.out.println("JEParser Error: Only one variable has been defined.");
            return 0.0;
        }
        this.jep.addVariable(this.variables[0], d);
        this.jep.addVariable(this.variables[1], d2);
        return this.jep.getValue();
    }

    public Complex evaluateComplex(double d) {
        this.jep.addVariable(this.variables[0], d);
        return this.jep.getComplexValue();
    }

    public Complex evaluateComplex(double d, double d2) {
        this.jep.addVariable(this.variables[0], d);
        this.jep.addVariable(this.variables[1], d2);
        return this.jep.getComplexValue();
    }

    static {
        MAKE_COMPLEX = true;
        SQRT2 = Math.sqrt(2.0);
        COS45 = 1.0 / SQRT2;
    }

    public class Step
    extends PostfixMathCommand
    implements PostfixMathCommandI {
        public Step(JEParser jEParser) {
            this.numberOfParameters = 1;
        }

        public void run(Stack stack) throws ParseException {
            this.checkStack(stack);
            Object e = stack.pop();
            if (!(e instanceof Double)) {
                throw new ParseException("Invalid parameter type");
            }
            stack.push(new Double(!((Double)e < 0.0) ? 1 : 0));
        }
    }

    public class Exp
    extends PostfixMathCommand
    implements PostfixMathCommandI {
        public Exp(JEParser jEParser) {
            this.numberOfParameters = 1;
        }

        public void run(Stack stack) throws ParseException {
            this.checkStack(stack);
            Object e = stack.pop();
            if (e instanceof Double) {
                stack.push(new Double(Math.exp((Double)e)));
            } else if (e instanceof Complex) {
                stack.push(((Complex)e).exp());
            } else {
                throw new ParseException("Invalid parameter type");
            }
        }
    }

    public class SquareRoot
    extends PostfixMathCommand
    implements PostfixMathCommandI {
        public SquareRoot(JEParser jEParser) {
            this.numberOfParameters = 1;
        }

        public void run(Stack stack) throws ParseException {
            this.checkStack(stack);
            Object e = stack.pop();
            if (e instanceof Double) {
                double d = (Double)e;
                if (d >= 0.0) {
                    stack.push(new Double(Math.sqrt(d)));
                } else {
                    stack.push(new Complex(0.0, Math.sqrt(-d)));
                }
            } else if (e instanceof Complex) {
                stack.push(((Complex)e).sqrt());
            } else {
                throw new ParseException("Invalid parameter type");
            }
        }
    }
}

