/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.math.complex;

import java.io.Serializable;

public class Complex
implements Cloneable,
Serializable {
    public static final String VERSION = "1.0.1";
    public static final String DATE = "Fri 23-Mar-2001 8:56 pm";
    public static final String AUTHOR = "sandy@almide.demon.co.uk";
    public static final String REMARK = "Class available from http://www.netlib.org/";
    protected static final double TWO_PI = Math.PI * 2;
    public static final Complex i;
    private double re;
    private double im;
    static Class class$org$netlib$math$complex$Complex;

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double d) {
        this(d, 0.0);
    }

    public Complex(Complex complex) {
        this(complex.re, complex.im);
    }

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public static void main(String[] stringArray) {
        System.out.println();
        System.out.println("Module : ".concat(String.valueOf(String.valueOf((class$org$netlib$math$complex$Complex == null ? (class$org$netlib$math$complex$Complex = Complex.class$("org.netlib.math.complex.Complex")) : class$org$netlib$math$complex$Complex).getName()))));
        System.out.println("Version: 1.0.1");
        System.out.println("Date   : Fri 23-Mar-2001 8:56 pm");
        System.out.println("Author : sandy@almide.demon.co.uk");
        System.out.println("Remark : Class available from http://www.netlib.org/");
        System.out.println();
        System.out.println("Hint:  use TestComplex to test the class.");
        System.out.println();
    }

    public static Complex real(double d) {
        return new Complex(d, 0.0);
    }

    public static Complex cart(double d, double d2) {
        return new Complex(d, d2);
    }

    public static Complex polar(double d, double d2) {
        if (d < 0.0) {
            d2 += Math.PI;
            d = -d;
        }
        return Complex.cart(d * Math.cos(d2 %= Math.PI * 2), d * Math.sin(d2));
    }

    public static Complex pow(Complex complex, double d) {
        double d2 = d * Math.log(complex.abs());
        double d3 = d * complex.arg();
        double d4 = Math.exp(d2);
        return Complex.cart(d4 * Math.cos(d3), d4 * Math.sin(d3));
    }

    public static Complex pow(double d, Complex complex) {
        double d2 = Math.log(Math.abs(d));
        double d3 = Math.atan2(0.0, d);
        double d4 = d2 * complex.re - d3 * complex.im;
        double d5 = d2 * complex.im + d3 * complex.re;
        double d6 = Math.exp(d4);
        return Complex.cart(d6 * Math.cos(d5), d6 * Math.sin(d5));
    }

    public static Complex pow(Complex complex, Complex complex2) {
        double d = Math.log(complex.abs());
        double d2 = complex.arg();
        double d3 = d * complex2.re - d2 * complex2.im;
        double d4 = d * complex2.im + d2 * complex2.re;
        double d5 = Math.exp(d3);
        return Complex.cart(d5 * Math.cos(d4), d5 * Math.sin(d4));
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public boolean equals(Complex complex, double d) {
        return Complex.abs(this.re - complex.re, this.im - complex.im) <= Math.abs(d);
    }

    public Object clone() {
        try {
            Object object = super.clone();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Object var2_3 = null;
            return var2_3;
        }
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public double norm() {
        return this.re * this.re + this.im * this.im;
    }

    public double abs() {
        return Complex.abs(this.re, this.im);
    }

    private static double abs(double d, double d2) {
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        if (d3 == 0.0 && d4 == 0.0) {
            return 0.0;
        }
        if (d3 >= d4) {
            double d5 = d2 / d;
            return d3 * Math.sqrt(1.0 + d5 * d5);
        }
        double d6 = d / d2;
        return d4 * Math.sqrt(1.0 + d6 * d6);
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public Complex neg() {
        return this.scale(-1.0);
    }

    public Complex conj() {
        return Complex.cart(this.re, -this.im);
    }

    private static void inv(Complex complex) {
        double d;
        double d2;
        if (Math.abs(complex.re) >= Math.abs(complex.im)) {
            double d3;
            d2 = d3 = 1.0 / (complex.re + complex.im * (complex.im / complex.re));
            d = d3 * (-complex.im / complex.re);
        } else {
            double d4 = 1.0 / (complex.re * (complex.re / complex.im) + complex.im);
            d2 = d4 * (complex.re / complex.im);
            d = -d4;
        }
        complex.re = d2;
        complex.im = d;
    }

    public Complex scale(double d) {
        return Complex.cart(d * this.re, d * this.im);
    }

    public Complex add(Complex complex) {
        return Complex.cart(this.re + complex.re, this.im + complex.im);
    }

    public Complex sub(Complex complex) {
        return Complex.cart(this.re - complex.re, this.im - complex.im);
    }

    public Complex mul(Complex complex) {
        return Complex.cart(this.re * complex.re - this.im * complex.im, this.re * complex.im + this.im * complex.re);
    }

    public Complex div(Complex complex) {
        Complex complex2 = new Complex(this);
        Complex.div(complex2, complex.re, complex.im);
        return complex2;
    }

    private static void div(Complex complex, double d, double d2) {
        double d3;
        double d4;
        if (Math.abs(d) >= Math.abs(d2)) {
            double d5 = d2 / d;
            double d6 = 1.0 / (d + d2 * d5);
            d4 = d6 * (complex.re + complex.im * d5);
            d3 = d6 * (complex.im - complex.re * d5);
        } else {
            double d7 = d / d2;
            double d8 = 1.0 / (d * d7 + d2);
            d4 = d8 * (complex.re * d7 + complex.im);
            d3 = d8 * (complex.im * d7 - complex.re);
        }
        complex.re = d4;
        complex.im = d3;
    }

    public Complex sqrt() {
        Complex complex = new Complex(this);
        Complex.sqrt(complex);
        return complex;
    }

    private static void sqrt(Complex complex) {
        double d = complex.abs();
        if (d > 0.0) {
            if (complex.re > 0.0) {
                double d2;
                complex.re = d2 = Math.sqrt(0.5 * (d + complex.re));
                complex.im = 0.5 * complex.im / d2;
            } else {
                double d3 = Math.sqrt(0.5 * (d - complex.re));
                if (complex.im < 0.0) {
                    d3 = -d3;
                }
                complex.re = 0.5 * complex.im / d3;
                complex.im = d3;
            }
        } else {
            complex.re = 0.0;
            complex.im = 0.0;
        }
    }

    public Complex pow(Complex complex) {
        return Complex.pow(this, complex);
    }

    public Complex exp() {
        double d = Math.exp(this.re);
        return Complex.cart(d * Math.cos(this.im), d * Math.sin(this.im));
    }

    public Complex log() {
        return Complex.cart(Math.log(this.abs()), this.arg());
    }

    public Complex sin() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        Complex complex = Complex.cart(0.5 * (d5 -= d7), -0.5 * (d4 -= d6));
        return complex;
    }

    public Complex cos() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        Complex complex = Complex.cart(0.5 * (d4 += d6), 0.5 * (d5 += d7));
        return complex;
    }

    public Complex tan() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        double d8 = d4 - d6;
        double d9 = d5 - d7;
        Complex complex = Complex.cart(0.5 * d9, -0.5 * d8);
        d8 = d4 + d6;
        d9 = d5 + d7;
        double d10 = 0.5 * d8;
        double d11 = 0.5 * d9;
        Complex.div(complex, d10, d11);
        return complex;
    }

    public Complex cosec() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        Complex complex = Complex.cart(0.5 * (d5 -= d7), -0.5 * (d4 -= d6));
        Complex.inv(complex);
        return complex;
    }

    public Complex sec() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        Complex complex = Complex.cart(0.5 * (d4 += d6), 0.5 * (d5 += d7));
        Complex.inv(complex);
        return complex;
    }

    public Complex cot() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        double d8 = d4 + d6;
        double d9 = d5 + d7;
        Complex complex = Complex.cart(0.5 * d8, 0.5 * d9);
        d8 = d4 - d6;
        d9 = d5 - d7;
        double d10 = 0.5 * d9;
        double d11 = -0.5 * d8;
        Complex.div(complex, d10, d11);
        return complex;
    }

    public Complex sinh() {
        double d = Math.exp(this.re);
        double d2 = d * Math.cos(this.im);
        double d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        double d4 = d * Math.cos(-this.im);
        double d5 = d * Math.sin(-this.im);
        Complex complex = Complex.cart(0.5 * (d2 -= d4), 0.5 * (d3 -= d5));
        return complex;
    }

    public Complex cosh() {
        double d = Math.exp(this.re);
        double d2 = d * Math.cos(this.im);
        double d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        double d4 = d * Math.cos(-this.im);
        double d5 = d * Math.sin(-this.im);
        Complex complex = Complex.cart(0.5 * (d2 += d4), 0.5 * (d3 += d5));
        return complex;
    }

    public Complex tanh() {
        double d = Math.exp(this.re);
        double d2 = d * Math.cos(this.im);
        double d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        double d4 = d * Math.cos(-this.im);
        double d5 = d * Math.sin(-this.im);
        double d6 = d2 - d4;
        double d7 = d3 - d5;
        Complex complex = Complex.cart(0.5 * d6, 0.5 * d7);
        d6 = d2 + d4;
        d7 = d3 + d5;
        double d8 = 0.5 * d6;
        double d9 = 0.5 * d7;
        Complex.div(complex, d8, d9);
        return complex;
    }

    public Complex asin() {
        double d = 1.0 - (this.re * this.re - this.im * this.im);
        double d2 = 0.0 - (this.re * this.im + this.im * this.re);
        Complex complex = Complex.cart(d, d2);
        Complex.sqrt(complex);
        d = -this.im;
        d2 = this.re;
        complex.re = d + complex.re;
        complex.im = d2 + complex.im;
        d = Math.log(complex.abs());
        complex.re = d2 = complex.arg();
        complex.im = -d;
        return complex;
    }

    public Complex acos() {
        double d = 1.0 - (this.re * this.re - this.im * this.im);
        double d2 = 0.0 - (this.re * this.im + this.im * this.re);
        Complex complex = Complex.cart(d, d2);
        Complex.sqrt(complex);
        d = -complex.im;
        d2 = complex.re;
        complex.re = this.re + d;
        complex.im = this.im + d2;
        d = Math.log(complex.abs());
        complex.re = d2 = complex.arg();
        complex.im = -d;
        return complex;
    }

    public Complex atan() {
        Complex complex = Complex.cart(-this.re, 1.0 - this.im);
        double d = this.re;
        double d2 = 1.0 + this.im;
        Complex.div(complex, d, d2);
        d = Math.log(complex.abs());
        d2 = complex.arg();
        complex.re = 0.5 * d2;
        complex.im = -0.5 * d;
        return complex;
    }

    public Complex asinh() {
        double d = this.re * this.re - this.im * this.im + 1.0;
        double d2 = this.re * this.im + this.im * this.re + 0.0;
        Complex complex = Complex.cart(d, d2);
        Complex.sqrt(complex);
        complex.re = this.re + complex.re;
        complex.im = this.im + complex.im;
        d = Math.log(complex.abs());
        d2 = complex.arg();
        complex.re = d;
        complex.im = d2;
        return complex;
    }

    public Complex acosh() {
        double d = this.re * this.re - this.im * this.im - 1.0;
        double d2 = this.re * this.im + this.im * this.re - 0.0;
        Complex complex = Complex.cart(d, d2);
        Complex.sqrt(complex);
        complex.re = this.re + complex.re;
        complex.im = this.im + complex.im;
        d = Math.log(complex.abs());
        d2 = complex.arg();
        complex.re = d;
        complex.im = d2;
        return complex;
    }

    public Complex atanh() {
        Complex complex = Complex.cart(1.0 + this.re, this.im);
        double d = 1.0 - this.re;
        double d2 = -this.im;
        Complex.div(complex, d, d2);
        d = Math.log(complex.abs());
        d2 = complex.arg();
        complex.re = 0.5 * d;
        complex.im = 0.5 * d2;
        return complex;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.re);
        if (this.im < 0.0) {
            stringBuffer.append(" - ").append(-this.im);
        } else if (1.0 / this.im == Double.NEGATIVE_INFINITY) {
            stringBuffer.append(" - ").append(0.0);
        } else {
            stringBuffer.append(" + ").append(this.im);
        }
        stringBuffer.append("i)");
        return stringBuffer.toString();
    }

    public void setRe(double d) {
        this.re = d;
    }

    public void setIm(double d) {
        this.im = d;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        VERSION = VERSION;
        DATE = DATE;
        AUTHOR = AUTHOR;
        REMARK = REMARK;
        TWO_PI = Math.PI * 2;
        i = new Complex(0.0, 1.0);
    }
}

