/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.io.StringReader;
import org.netlib.math.complex.Complex;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Parser;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.function.Abs;
import org.nfunk.jep.function.Angle;
import org.nfunk.jep.function.ArcCosine;
import org.nfunk.jep.function.ArcCosineH;
import org.nfunk.jep.function.ArcSine;
import org.nfunk.jep.function.ArcSineH;
import org.nfunk.jep.function.ArcTanH;
import org.nfunk.jep.function.ArcTangent;
import org.nfunk.jep.function.Cosine;
import org.nfunk.jep.function.CosineH;
import org.nfunk.jep.function.Imaginary;
import org.nfunk.jep.function.Logarithm;
import org.nfunk.jep.function.Modulus;
import org.nfunk.jep.function.NaturalLogarithm;
import org.nfunk.jep.function.Random;
import org.nfunk.jep.function.Real;
import org.nfunk.jep.function.Sine;
import org.nfunk.jep.function.SineH;
import org.nfunk.jep.function.TanH;
import org.nfunk.jep.function.Tangent;

public class JEP {
    private SymbolTable symTab;
    private FunctionTable funTab;
    private Node topNode = null;
    private boolean traverse = false;
    private Parser parser;
    private boolean hasError = true;
    private ParseException lastError = null;
    private Object lastValue;

    public JEP() {
        this.initSymTab();
        this.initFunTab();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    public void initSymTab() {
        this.symTab = new SymbolTable();
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    public void addStandardFunctions() {
        this.funTab.put("sin", new Sine());
        this.funTab.put("cos", new Cosine());
        this.funTab.put("tan", new Tangent());
        this.funTab.put("asin", new ArcSine());
        this.funTab.put("acos", new ArcCosine());
        this.funTab.put("atan", new ArcTangent());
        this.funTab.put("sinh", new SineH());
        this.funTab.put("cosh", new CosineH());
        this.funTab.put("tanh", new TanH());
        this.funTab.put("asinh", new ArcSineH());
        this.funTab.put("acosh", new ArcCosineH());
        this.funTab.put("atanh", new ArcTanH());
        this.funTab.put("log", new Logarithm());
        this.funTab.put("ln", new NaturalLogarithm());
        this.funTab.put("angle", new Angle());
        this.funTab.put("abs", new Abs());
        this.funTab.put("mod", new Modulus());
        this.funTab.put("rand", new Random());
    }

    public void addStandardConstants() {
        this.symTab.put("pi", new Double(Math.PI));
        this.symTab.put("e", new Double(Math.E));
    }

    public void addComplex() {
        this.symTab.put("i", new Complex(0.0, 1.0));
        this.funTab.put("re", new Real());
        this.funTab.put("im", new Imaginary());
    }

    public void parseExpression(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            this.topNode = this.parser.parseStream(stringReader, this.symTab, this.funTab, this.traverse);
            this.hasError = false;
        }
        catch (Throwable throwable) {
            this.topNode = null;
            this.hasError = true;
            this.lastError = throwable instanceof ParseException ? (ParseException)throwable : null;
        }
    }

    public boolean hasError() {
        return this.hasError;
    }

    public String getErrorInfo() {
        if (this.hasError) {
            if (this.lastError != null) {
                return this.lastError.getErrorInfo();
            }
            return "Illegal character in expression";
        }
        return "";
    }

    public int getErrorColumn() {
        if (this.hasError && this.lastError != null) {
            return this.lastError.getColumn();
        }
        return 0;
    }

    public int getErrorLine() {
        if (this.hasError && this.lastError != null) {
            return this.lastError.getLine();
        }
        return 0;
    }

    public double getValue() {
        if (!this.hasError && this.topNode != null) {
            this.lastValue = this.topNode.getValue();
            if (this.lastValue instanceof Double) {
                return (Double)this.lastValue;
            }
            if (this.lastValue instanceof Complex) {
                return ((Complex)this.lastValue).re();
            }
            return 0.0;
        }
        return 0.0;
    }

    public Complex getComplexValue() {
        if (!this.hasError && this.topNode != null) {
            this.lastValue = this.topNode.getValue();
            if (this.lastValue instanceof Double) {
                return new Complex((Double)this.lastValue, 0.0);
            }
            if (this.lastValue instanceof Complex) {
                return (Complex)this.lastValue;
            }
            return new Complex(0.0, 0.0);
        }
        return new Complex(0.0, 0.0);
    }

    public void addFunction(String string, Object object) {
        this.funTab.put(string, object);
    }

    public Double addVariable(String string, double d) {
        Double d2 = new Double(d);
        this.symTab.put(string, d2);
        return d2;
    }

    public Complex addComplexVariable(String string, double d, double d2) {
        Complex complex = new Complex(d, d2);
        this.symTab.put(string, complex);
        return complex;
    }

    public void addVariableAsObject(String string, Object object) {
        this.symTab.put(string, object);
    }

    public void setTraverse(boolean bl) {
        this.traverse = bl;
    }
}

