/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import org.nfunk.jep.Node;
import org.nfunk.jep.Parser;
import org.nfunk.jep.ParserTreeConstants;
import org.nfunk.jep.ParserVisitor;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Parser parser, int n) {
        this(n);
        this.parser = parser;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(ParserVisitor parserVisitor, Object object) {
        return parserVisitor.visit(this, object);
    }

    public Object childrenAccept(ParserVisitor parserVisitor, Object object) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(parserVisitor, object);
            }
        }
        return object;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.toString())));
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(String.valueOf(String.valueOf(string)).concat(" "));
            }
        }
    }

    public Object getValue() {
        return new Double(0.0);
    }
}

