/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.netlib.math.complex.Complex;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;

public class Multiply
extends PostfixMathCommand
implements PostfixMathCommandI {
    public Multiply() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        Object e2 = stack.pop();
        stack.push(this.mul(e2, e));
    }

    public Object mul(Object object, Object object2) throws ParseException {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return this.mul((Double)object, (Double)object2);
            }
            if (object2 instanceof Complex) {
                return this.mul((Complex)object2, (Double)object);
            }
        } else if (object instanceof Complex) {
            if (object2 instanceof Double) {
                return this.mul((Complex)object, (Double)object2);
            }
            if (object2 instanceof Complex) {
                return this.mul((Complex)object, (Complex)object2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double mul(Double d, Double d2) {
        return new Double(d * d2);
    }

    public Complex mul(Complex complex, Complex complex2) {
        double d = complex.re() * complex2.re() - complex.im() * complex2.im();
        double d2 = complex.im() * complex2.re() + complex.re() * complex2.im();
        return new Complex(d, d2);
    }

    public Complex mul(Complex complex, Double d) {
        return new Complex(complex.re() * d, complex.im() * d);
    }
}

