/*
 * Decompiled with CFR 0.152.
 */
package hydrogenic;

import edu.davidson.display.SGraph;
import edu.davidson.display.SNumber;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import hydrogenic.SpecialFunctions;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Angular
extends SApplet {
    boolean sa = false;
    boolean openned = true;
    SGraph graph = new SGraph();
    private double[] datax = new double[210];
    private double[] datay = new double[210];
    private double[] ndatax = new double[210];
    private double[] ndatay = new double[210];
    private boolean compare = false;
    private int numpoints = 210;
    private int l;
    private int seriesnum = 0;
    private boolean normal;
    private int m;
    public boolean sc;
    public boolean multi;
    private boolean graphon = false;
    private Color forrest = new Color(0, 128, 0);
    private boolean limit = false;
    public static final double p = Math.PI;
    EtchedBorder controlPan = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Button clearbtn = new Button();
    Button gobtn = new Button();
    BorderLayout borderLayout2 = new BorderLayout();
    EtchedBorder etchedBorder4 = new EtchedBorder();
    Checkbox comparebox = new Checkbox();
    BorderLayout borderLayout1 = new BorderLayout();
    EtchedBorder etchedBorder5 = new EtchedBorder();
    SNumber lfield = new SNumber();
    Label label1 = new Label();
    SNumber mfield = new SNumber();
    Label llabel = new Label();
    FlowLayout flowLayout2 = new FlowLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();

    public void init() {
        this.initResources(null);
        try {
            this.l = Integer.parseInt(this.getParameter("l", "2"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.m = Integer.parseInt(this.getParameter("m", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sc = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.normal = Boolean.valueOf(this.getParameter("Normalize", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.multi = Boolean.valueOf(this.getParameter("MultPlot", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.showPanel(this.sc);
        this.comparebox.setState(this.multi);
        this.setLM(this.l, this.m);
        this.graph.setEnableMouse(true);
        this.graph.setGraphBackground((Color)SystemColor.control);
        this.graph.setAutoscaleX(false);
        this.graph.setAutoscaleY(false);
        this.graph.setMinMaxX(-1.0, 1.0);
        this.graph.setMinMaxY(-1.0, 1.0);
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setSize(new Dimension(257, 264));
        ((Container)((Object)this)).setLayout(this.borderLayout5);
        this.graph.setBackground(SystemColor.control);
        this.graph.setMarkers(null);
        this.graph.setDataBackground(Color.white);
        this.graph.setSampleData(false);
        this.graph.setBorders("0,7,10,0");
        this.graph.setDrawZero(true);
        this.graph.setLabelY("Z");
        this.controlPan.setLayout(this.borderLayout4);
        this.graph.setLabelX("X");
        this.etchedBorder2.setLayout(this.borderLayout3);
        this.etchedBorder3.setLayout(this.borderLayout2);
        this.clearbtn.setLabel("Clear");
        this.gobtn.setLabel("Go!");
        this.etchedBorder4.setLayout(this.borderLayout1);
        this.comparebox.setBackground(SystemColor.control);
        this.comparebox.setLabel("Multiple");
        this.etchedBorder5.setLayout(this.flowLayout2);
        this.lfield.setText("0");
        this.label1.setBackground(SystemColor.control);
        this.label1.setAlignment(2);
        this.label1.setText("m =");
        this.mfield.setText("0");
        this.llabel.setText("l =");
        this.llabel.setBackground(SystemColor.control);
        this.llabel.setAlignment(2);
        this.gobtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Angular.this.gobtn_actionPerformed(actionEvent);
            }
        });
        this.clearbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Angular.this.clearbtn_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this)).add((Component)this.graph, "Center");
        ((Container)((Object)this)).add((Component)this.controlPan, "South");
        this.controlPan.add((Component)this.etchedBorder3, "West");
        this.etchedBorder3.add((Component)this.gobtn, "North");
        this.etchedBorder3.add((Component)this.clearbtn, "Center");
        this.controlPan.add((Component)this.etchedBorder2, "Center");
        this.etchedBorder2.add((Component)this.etchedBorder4, "Center");
        this.etchedBorder4.add((Component)this.comparebox, "Center");
        this.etchedBorder2.add((Component)this.etchedBorder5, "North");
        this.etchedBorder5.add((Component)this.llabel, null);
        this.etchedBorder5.add((Component)this.lfield, null);
        this.etchedBorder5.add((Component)this.label1, null);
        this.etchedBorder5.add((Component)this.mfield, null);
    }

    public void start() {
        if (this.firstTime) {
            this.setLM(this.l, this.m);
        }
        this.firstTime = false;
        super.start();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public void calcdata() {
        int n;
        double d = 2.0;
        if (this.m < 0) {
            this.m = -this.m;
        }
        d = Math.sqrt((double)(2 * this.l + 1) * SpecialFunctions.factorial(this.l - this.m) / (SpecialFunctions.factorial(this.l + this.m) * (double)4 * Math.PI));
        for (n = 0; n < this.numpoints; ++n) {
            double d2 = SpecialFunctions.legendre(this.l, this.m, Math.cos(Math.PI * (double)n / (2.0 * (double)this.numpoints)));
            if (this.sa) {
                this.datax[n] = d * d2 * Math.sin(Math.PI * (double)n / (2.0 * (double)this.numpoints)) * (d * d2) * Math.sin(Math.PI * (double)n / (2.0 * (double)this.numpoints));
                this.datay[n] = d * d2 * Math.cos(Math.PI * (double)n / (2.0 * (double)this.numpoints)) * (d * d2) * Math.cos(Math.PI * (double)n / (2.0 * (double)this.numpoints));
                continue;
            }
            this.datax[n] = d * d2 * Math.sin(Math.PI * (double)n / (2.0 * (double)this.numpoints));
            this.datay[n] = d * d2 * Math.cos(Math.PI * (double)n / (2.0 * (double)this.numpoints));
        }
        this.unitScale();
        for (n = 0; n < this.numpoints; ++n) {
            this.ndatax[n] = -this.datax[n];
            this.ndatay[n] = -this.datay[n];
        }
    }

    private void unitScale() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.numpoints; ++n) {
            d = Math.sqrt(this.datax[n] * this.datax[n] + this.datay[n] * this.datay[n]);
            if (!(d > d2)) continue;
            d2 = d;
        }
        n = 0;
        while (n < this.numpoints) {
            int n2 = n;
            this.datax[n2] = this.datax[n2] / d2;
            int n3 = n++;
            this.datay[n3] = this.datay[n3] / d2;
        }
    }

    public void setLM(int n, int n2) {
        if (this.openned) {
            this.seriesnum = 0;
            this.graph.deleteAllSeries();
            this.openned = false;
        }
        ++this.seriesnum;
        this.l = n;
        this.m = n2;
        this.mfield.setValue((double)n2);
        this.lfield.setValue((double)n);
        this.compare = this.comparebox.getState();
        this.calcdata();
        this.graphdata();
        this.graph.square = true;
    }

    public void showPanel(boolean bl) {
        this.controlPan.setVisible(bl);
        this.controlPan.setBackground(SystemColor.control);
    }

    public void graphdata() {
        Color color = Color.red;
        if (!this.compare) {
            this.graph.deleteAllSeries();
            this.seriesnum = 0;
        }
        switch (this.seriesnum) {
            case 0: {
                color = Color.red;
                break;
            }
            case 1: {
                color = Color.black;
                break;
            }
            case 2: {
                color = Color.blue;
                break;
            }
            case 3: {
                color = this.forrest;
                break;
            }
            case 4: {
                color = Color.gray;
                break;
            }
            case 5: {
                color = Color.red;
                this.seriesnum = 0;
            }
        }
        this.graph.deleteSeries(4 * this.seriesnum + 1);
        this.graph.deleteSeries(4 * this.seriesnum + 2);
        this.graph.deleteSeries(4 * this.seriesnum + 3);
        this.graph.deleteSeries(4 * this.seriesnum + 4);
        this.graph.setSeriesStyle(4 * this.seriesnum + 1, color, true, 0);
        this.graph.setSeriesStyle(4 * this.seriesnum + 2, color, true, 0);
        this.graph.setSeriesStyle(4 * this.seriesnum + 3, color, true, 0);
        this.graph.setSeriesStyle(4 * this.seriesnum + 4, color, true, 0);
        this.graph.addData(4 * this.seriesnum + 1, this.datax, this.datay);
        this.graph.addData(4 * this.seriesnum + 2, this.ndatax, this.datay);
        this.graph.addData(4 * this.seriesnum + 3, this.ndatax, this.ndatay);
        this.graph.addData(4 * this.seriesnum + 4, this.datax, this.ndatay);
        if (this.graph.getSize().width > 150) {
            this.graph.setSeriesLegend(this.seriesnum + 1, color, 25 + this.graph.getSize().width / 2, 30 + this.seriesnum * 11, String.valueOf(String.valueOf(new StringBuffer("l = ").append(this.l).append(" m = ").append(this.m))));
        } else {
            this.graph.setSeriesLegend(this.seriesnum + 1, color, this.graph.getSize().width / 4, 30 + this.seriesnum * 11, String.valueOf(String.valueOf(new StringBuffer("l = ").append(this.l).append(" m = ").append(this.m))));
        }
    }

    void gobtn_actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2 = (int)this.lfield.getValue();
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 < Math.abs(n = (int)this.mfield.getValue())) {
            this.mfield.setBackground(Color.red);
        } else {
            this.setLM(n2, n);
        }
    }

    void clearbtn_actionPerformed(ActionEvent actionEvent) {
        this.mfield.setValue((double)this.m);
        this.lfield.setValue((double)this.l);
        this.graph.deleteAllSeries();
        this.seriesnum = 0;
    }

    static {
        p = Math.PI;
    }
}

