/*
 * Decompiled with CFR 0.152.
 */
package hydrogenic;

import edu.davidson.display.SInteger;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import hydrogenic.DensityCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Density
extends SApplet {
    int m;
    int n;
    int l;
    boolean sc;
    boolean ph;
    EtchedBorder southetchdbrdr = new EtchedBorder();
    DensityCanvas densityCanvas = new DensityCanvas();
    BorderLayout borderLayout1 = new BorderLayout();
    CheckboxGroup phasegroup = new CheckboxGroup();
    Panel panel1 = new Panel();
    FlowLayout flowLayout2 = new FlowLayout();
    Button plotBtn = new Button();
    Checkbox yphase = new Checkbox();
    Checkbox nphase = new Checkbox();
    Label label4 = new Label();
    Panel panel2 = new Panel();
    FlowLayout flowLayout3 = new FlowLayout();
    SInteger nValue = new SInteger();
    SInteger mValue = new SInteger();
    SInteger lValue = new SInteger();
    Label label1 = new Label();
    Label label2 = new Label();
    Label label3 = new Label();
    BorderLayout borderLayout2 = new BorderLayout();

    public void init() {
        this.initResources(null);
        try {
            this.m = Integer.parseInt(this.getParameter("m", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.n = Integer.parseInt(this.getParameter("n", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sc = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.l = Integer.parseInt(this.getParameter("l", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            try {
                this.ph = Boolean.valueOf(this.getParameter("ShowPhase", "false"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mValue.setValue(this.m);
        this.nValue.setValue(this.n);
        this.lValue.setValue(this.l);
        this.yphase.setState(this.ph);
        this.nphase.setState(!this.ph);
        this.densityCanvas.setM(this.mValue.getValue());
        this.densityCanvas.setN(this.nValue.getValue());
        this.densityCanvas.setL(this.lValue.getValue());
        this.densityCanvas.setPhase(this.ph);
        this.southetchdbrdr.setVisible(this.sc);
    }

    public void setShowControls(boolean bl) {
        this.southetchdbrdr.setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setSize(new Dimension(359, 343));
        this.flowLayout2.setVgap(2);
        this.flowLayout2.setHgap(2);
        this.plotBtn.setLabel("Plot");
        this.yphase.setCheckboxGroup(this.phasegroup);
        this.nphase.setCheckboxGroup(this.phasegroup);
        this.label4.setText("Phase:");
        this.flowLayout3.setVgap(2);
        this.flowLayout3.setHgap(2);
        this.label1.setAlignment(2);
        this.label1.setText("m=");
        this.label2.setText("n=");
        this.label3.setText("l=");
        this.label3.setAlignment(2);
        this.label2.setAlignment(2);
        this.panel2.setLayout(this.flowLayout3);
        this.label4.setAlignment(2);
        this.nphase.setLabel("N");
        this.yphase.setLabel("Y");
        this.plotBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Density.this.plotBtn_actionPerformed(actionEvent);
            }
        });
        this.panel1.setLayout(this.flowLayout2);
        this.southetchdbrdr.setLayout(this.borderLayout2);
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        ((Container)((Object)this)).add((Component)this.southetchdbrdr, "South");
        this.southetchdbrdr.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.label2, null);
        this.panel2.add((Component)this.nValue, null);
        this.panel2.add((Component)this.label3, null);
        this.panel2.add((Component)this.lValue, null);
        this.panel2.add((Component)this.label1, null);
        this.panel2.add((Component)this.mValue, null);
        this.southetchdbrdr.add((Component)this.panel1, "South");
        this.panel1.add((Component)this.label4, null);
        this.panel1.add((Component)this.yphase, null);
        this.panel1.add((Component)this.nphase, null);
        this.panel1.add((Component)this.plotBtn, null);
        ((Container)((Object)this)).add(this.densityCanvas, "Center");
    }

    public void start() {
        if (this.firstTime) {
            this.setNLM(this.n, this.l, this.m);
        }
        this.firstTime = false;
        super.start();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"m", "int", "magnetic quantum number"}, {"n", "int", "principle quantum number"}, {"l", "int", "angular quantum number"}};
        return stringArray;
    }

    public void recalculate() {
        this.densityCanvas.stop();
        this.densityCanvas.start();
    }

    public void setNLM(int n, int n2, int n3) {
        this.nValue.setValue(n);
        this.lValue.setValue(n2);
        this.mValue.setValue(n3);
        this.densityCanvas.setM(this.mValue.getValue());
        this.densityCanvas.setN(this.nValue.getValue());
        this.densityCanvas.setL(this.lValue.getValue());
        this.recalculate();
    }

    void plotBtn_actionPerformed(ActionEvent actionEvent) {
        this.n = this.nValue.getValue();
        this.l = this.lValue.getValue();
        this.m = this.mValue.getValue();
        if (this.n > 50) {
            this.nValue.setBackground(Color.red);
        } else if (this.l > this.n - 1 | this.l < 0) {
            this.lValue.setBackground(Color.red);
        } else if (Math.abs(this.m) > this.l) {
            this.mValue.setBackground(Color.red);
        } else {
            this.densityCanvas.setM(this.mValue.getValue());
            this.densityCanvas.setN(this.nValue.getValue());
            this.densityCanvas.setL(this.lValue.getValue());
            this.densityCanvas.setPhase(this.yphase.getState());
            this.recalculate();
        }
    }
}

