/*
 * Decompiled with CFR 0.152.
 */
package hydrogenic;

import edu.davidson.display.Format;
import hydrogenic.DensityFrame;
import hydrogenic.SpecialFunctions;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public final class DensityCanvas
extends Canvas
implements Runnable {
    Image img = null;
    static String calcString = "Please Wait...";
    private Thread calcThread;
    int[] red = new int[256];
    int[] green = new int[256];
    int[] blue = new int[256];
    int m = 0;
    int n = 0;
    int l = 0;
    int ao;
    double[] magx = null;
    double[] modRnl = null;
    double[] modYlm = null;
    double pi = Math.PI;
    double ylm;
    double rnl;
    boolean showPhaseColor;
    double[] amp = new double[2];
    double leg;
    double datamaxR;
    double datamaxY;
    double brightness;
    int originx;
    int originy;
    int theta;
    int radius;
    double rx;
    double ry;
    double val;
    int npr = 0;
    int npa = 181;
    Format format = new Format("%-+6.3g");
    int boxWidth = 0;
    private boolean invokedStandalone = false;

    public DensityCanvas() {
        this.makePallet();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = Math.max(n, n2);
        int n4 = Math.min(n, n2);
        int n5 = (n3 - n4) / 2;
        if (this.img == null) {
            super.paint(graphics);
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n6 = (n - fontMetrics.stringWidth(calcString)) / 2;
            int n7 = n2 / 2;
            graphics.drawString(calcString, n6, n7);
        } else {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n, n2);
            n = Math.min(n, n2);
            n2 = Math.min(n, n2);
            if (this.getSize().width < this.getSize().height) {
                graphics.drawImage(this.img, 0, n5, n, n2, this);
            } else {
                graphics.drawImage(this.img, n5, 0, n, n2, this);
            }
        }
    }

    public synchronized void stop() {
        if (this.calcThread == null) {
            return;
        }
        this.calcThread.stop();
        try {
            this.calcThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.calcThread = null;
    }

    public void start() {
        if (this.calcThread == null) {
            this.calcThread = new Thread(this);
        }
        this.calcThread.start();
    }

    public void run() {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[4];
        int n3 = 0;
        this.originx = n / 2;
        this.originy = n2 / 2;
        this.npr = (int)Math.sqrt((this.originx + 1) * (this.originx + 1) + (this.originy + 1) * (this.originy + 1)) + 1;
        this.modRnl = new double[this.npr];
        this.modYlm = new double[this.npa];
        this.magx = new double[this.npr];
        this.calcRnl(this.modRnl);
        this.calcYlm(this.modYlm);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2[2] = 0;
                nArray2[1] = 0;
                nArray2[0] = 0;
                nArray2[3] = 255;
                this.colorFunction(nArray2, j, i, n, n2, this.modRnl, this.modYlm);
                nArray[n3++] = nArray2[3] << 24 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2] << 0;
            }
        }
        this.newImage(n, n2, nArray);
        this.repaint();
        this.stop();
    }

    synchronized void newImage(int n, int n2, int[] nArray) {
        this.img = this.createImage(new MemoryImageSource(n, n2, ColorModel.getRGBdefault(), nArray, 0, n));
    }

    public double[] calcYlm(double[] dArray) {
        double[] dArray2 = new double[this.npa];
        double d = Math.sqrt((double)(2 * this.l + 1) * SpecialFunctions.factorial(this.l - this.m) / (SpecialFunctions.factorial(this.l + this.m) * 4.0 * this.pi));
        this.datamaxY = 0.0;
        if (this.l == 0 && this.m == 0) {
            for (int i = 0; i < this.npa; ++i) {
                dArray[i] = Math.sqrt(1.0 / (4.0 * this.pi));
            }
            this.datamaxY = Math.sqrt(1.0 / (4.0 * this.pi));
        } else {
            for (int i = 0; i < this.npa; ++i) {
                dArray2[i] = this.leg = SpecialFunctions.legendre(this.l, this.m, Math.cos(this.pi * (double)i / 180.0));
                dArray[i] = d * this.leg;
                if (!(this.datamaxY < Math.abs(dArray[i]))) continue;
                this.datamaxY = Math.abs(dArray[i]);
            }
        }
        return dArray;
    }

    public double[] calcRnl(double[] dArray) {
        double d = 0.0;
        double d2 = 4 * this.n * this.n + 2;
        double d3 = d2 / (double)this.npr;
        double d4 = SpecialFunctions.factorial(this.n - this.l - 1);
        double d5 = SpecialFunctions.factorial(this.n + this.l);
        double d6 = 2.0 / (double)(this.n * this.n) * Math.sqrt(d4 / d5);
        this.datamaxR = 0.0;
        this.brightness = 0.0;
        if (this.n == 1 && this.l == 0) {
            for (int i = 0; i < this.npr; ++i) {
                dArray[i] = this.rnl = 2.0 * Math.exp(-d);
                this.brightness += Math.abs(this.rnl * (double)i);
                this.magx[i] = d;
                d += d3;
                if (!(this.datamaxR < Math.abs(dArray[i]))) continue;
                this.datamaxR = Math.abs(dArray[i]);
            }
        } else {
            for (int i = 0; i < this.npr; ++i) {
                dArray[i] = this.rnl = d6 * Math.pow(2.0 * d / (double)this.n, this.l) * Math.exp(-d / (double)this.n) * SpecialFunctions.laguerre(2 * this.l + 1, this.n - this.l - 1, 2.0 * d / (double)this.n);
                this.brightness += Math.abs(this.rnl * (double)i);
                this.magx[i] = d;
                d += d3;
                if (!(this.datamaxR < Math.abs(dArray[i]))) continue;
                this.datamaxR = Math.abs(dArray[i]);
            }
        }
        this.brightness = this.brightness / 7000.0 / this.datamaxR;
        return dArray;
    }

    public double[] amplitude(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        this.getWaveFunction(n, n2);
        d = dArray[this.radius];
        double d2 = dArray2[this.radius] * dArray3[this.theta];
        if ((this.m & 1) == 1) {
            d2 = -d2;
        }
        if (this.m < 0) {
            d2 = -d2;
        }
        if (n - this.originx < 0 && (this.m & 1) == 1) {
            d2 = -d2;
        }
        this.amp[0] = d;
        this.amp[1] = d2;
        return this.amp;
    }

    double[] getWaveFunction(int n, int n2) {
        this.rx = n - this.originx;
        this.ry = n2 - this.originy;
        this.radius = (int)Math.round(Math.sqrt(this.rx * this.rx + this.ry * this.ry));
        this.theta = (int)((this.pi / (double)2 - Math.atan2(this.originy - n2, Math.abs(this.rx))) * (180.0 / this.pi));
        this.val = 255.0 * (this.modRnl[this.radius] / this.datamaxR * (this.modYlm[this.theta] / this.datamaxY));
        if ((this.m & 1) == 1) {
            this.val = -this.val;
        }
        if (this.m < 0) {
            this.val = -this.val;
        }
        this.amp[0] = this.val;
        this.amp[1] = 0.0;
        return this.amp;
    }

    void colorFunction(int[] nArray, int n, int n2, int n3, int n4, double[] dArray, double[] dArray2) {
        this.amp = this.getWaveFunction(n, n2);
        double d = this.amp[0];
        if (n - this.originx < 0 && (this.m & 1) == 1) {
            d = -d;
        }
        boolean bl = d < 0.0;
        d = (double)255 * (1.0 - Math.exp(-Math.abs(d) / (this.brightness * 255.0)));
        int n5 = (int)Math.round(d);
        n5 = Math.min(n5, 255);
        if (!this.showPhaseColor) {
            nArray[0] = n5;
            nArray[1] = n5;
            nArray[2] = n5;
        } else if (bl) {
            nArray[0] = 0;
            nArray[1] = this.green[n5];
            nArray[2] = this.blue[n5];
        } else {
            nArray[0] = this.red[n5];
            nArray[1] = this.green[n5];
            nArray[2] = 0;
        }
    }

    void makePallet() {
        for (int i = 0; i < 256; ++i) {
            this.red[i] = i;
            this.blue[i] = i;
            this.green[i] = i;
        }
    }

    void setM(int n) {
        this.m = n;
    }

    void setN(int n) {
        this.n = n;
    }

    void setL(int n) {
        this.l = n;
    }

    void setPhase(boolean bl) {
        this.showPhaseColor = bl;
    }

    private void jbInit() throws Exception {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                DensityCanvas.this.this_mouseDragged(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DensityCanvas.this.this_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DensityCanvas.this.this_mouseReleased(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                DensityCanvas.this.this_mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                DensityCanvas.this.this_mouseExited(mouseEvent);
            }
        });
    }

    double xFromPix(int n) {
        return n;
    }

    double yFromPix(int n) {
        return n;
    }

    public void drawCoords(int n, int n2) {
        this.amplitude(n, n2, this.magx, this.modRnl, this.modYlm);
        String string = String.valueOf(String.valueOf(new StringBuffer("Bohr radii:").append(this.format.form(this.amp[0])).append(" Amplitude:").append(this.format.form(this.amp[1]))));
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
        graphics.dispose();
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            if (this.img == null) {
                return;
            }
            DensityFrame densityFrame = new DensityFrame(this.img);
            densityFrame.setTitle(String.valueOf(String.valueOf(new StringBuffer("Psi (n, l, m) = Psi (").append(this.n).append(", ").append(this.l).append(", ").append(this.m).append(")"))));
            densityFrame.show();
        } else {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.drawCoords(n, n2);
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.drawCoords(n, n2);
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        this.repaint(0, rectangle.height - 20, this.boxWidth, 20);
        this.boxWidth = 0;
    }

    void this_mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    void this_mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void main(String[] stringArray) {
        DensityCanvas densityCanvas = new DensityCanvas();
        densityCanvas.invokedStandalone = true;
    }
}

