/*
 * Decompiled with CFR 0.152.
 */
package hydrogenic;

import edu.davidson.display.SGraph;
import edu.davidson.display.SInteger;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import hydrogenic.SpecialFunctions;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Radial
extends SApplet {
    Panel optionpnl = new Panel();
    SGraph radialgr = new SGraph();
    EtchedBorder etchedbrdr = new EtchedBorder();
    BorderLayout borderLayout1 = new BorderLayout();
    private int sc = 1;
    private int px;
    private int py;
    private int py2 = 20;
    private boolean multi = false;
    int l;
    int n;
    boolean s;
    boolean sp;
    boolean phase = true;
    FlowLayout flowLayout2 = new FlowLayout();
    SInteger angqnnb = new SInteger();
    Panel panel2 = new Panel();
    FlowLayout flowLayout4 = new FlowLayout();
    Label label1 = new Label();
    Label label2 = new Label();
    SInteger prinqnnb = new SInteger();
    Panel panel1 = new Panel();
    Checkbox multiplecb = new Checkbox();
    Button resetbtn = new Button();
    FlowLayout flowLayout3 = new FlowLayout();
    Button plotbtn = new Button();
    BorderLayout borderLayout2 = new BorderLayout();

    public void init() {
        this.initResources(null);
        try {
            this.l = Integer.parseInt(this.getParameter("l", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.n = Integer.parseInt(this.getParameter("n", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.s = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.multi = Boolean.valueOf(this.getParameter("MultPlot", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sp = Boolean.valueOf(this.getParameter("ShowAmplitude", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setShowControls(this.s);
        this.angqnnb.setValue(this.l);
        this.prinqnnb.setValue(this.n);
        this.multiplecb.setState(this.multi);
        this.radialgr.setGraphBackground((Color)SystemColor.control);
    }

    private void jbInit() throws Exception {
        this.optionpnl.setLayout(this.flowLayout2);
        ((Component)((Object)this)).setBackground(Color.white);
        ((Component)((Object)this)).setSize(new Dimension(371, 333));
        this.optionpnl.setBackground(SystemColor.control);
        this.radialgr.setLabelY("[Rnl(r)*r]^2");
        this.radialgr.setEnableMouse(true);
        this.radialgr.setBorders("0,12,10,0");
        this.etchedbrdr.setBackground(SystemColor.control);
        this.etchedbrdr.setThickness(3);
        this.flowLayout2.setVgap(0);
        this.angqnnb.setBackground(SystemColor.control);
        this.panel2.setLayout(this.flowLayout4);
        this.flowLayout4.setHgap(3);
        this.flowLayout4.setVgap(2);
        this.label1.setText("n=");
        this.label2.setText("l=");
        this.prinqnnb.setValue(1);
        this.panel1.setLayout(this.flowLayout3);
        this.multiplecb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Radial.this.multiplecb_itemStateChanged(itemEvent);
            }
        });
        this.multiplecb.setLabel("Show Multiple");
        this.resetbtn.setLabel("Reset");
        this.flowLayout3.setHgap(2);
        this.flowLayout3.setVgap(1);
        this.plotbtn.setLabel("Plot");
        this.plotbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Radial.this.plotbtn_actionPerformed(actionEvent);
            }
        });
        this.resetbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Radial.this.resetbtn_actionPerformed(actionEvent);
            }
        });
        this.label2.setAlignment(2);
        this.label1.setAlignment(2);
        this.etchedbrdr.setLayout(this.borderLayout2);
        this.radialgr.setBackground(SystemColor.control);
        this.radialgr.setDataBackground(Color.white);
        this.radialgr.setSampleData(false);
        this.radialgr.setLabelX(" r/ao ");
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        ((Container)((Object)this)).add((Component)this.radialgr, "Center");
        ((Container)((Object)this)).add(this.optionpnl, "North");
        ((Container)((Object)this)).add((Component)this.etchedbrdr, "South");
        this.etchedbrdr.add((Component)this.panel1, "South");
        this.panel1.add((Component)this.multiplecb, null);
        this.panel1.add((Component)this.resetbtn, null);
        this.panel1.add((Component)this.plotbtn, null);
        this.etchedbrdr.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.label1, null);
        this.panel2.add((Component)this.prinqnnb, null);
        this.panel2.add((Component)this.label2, null);
        this.panel2.add((Component)this.angqnnb, null);
    }

    public void start() {
        if (this.firstTime) {
            this.setNL(this.n, this.l);
        }
        this.firstTime = false;
        super.start();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public void setShowControls(boolean bl) {
        this.etchedbrdr.setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void showAmplitude(boolean bl) {
        this.phase = bl;
    }

    public void clearGraph() {
        this.radialgr.deleteAllSeries();
        this.multiplecb.setState(false);
        this.sc = 1;
        this.py2 = 20;
    }

    public void setNL(int n, int n2) {
        this.angqnnb.setValue(n2);
        this.prinqnnb.setValue(n);
        double d = n < 3 ? (double)(2 * ((n + 1) * (n + 1))) : (double)(2 * ((n + 2) * (n + 2)));
        double d2 = 0.0;
        int n3 = this.radialgr.getSize().width;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double d3 = d / (double)n3;
        int n4 = 0;
        double d4 = 0.0;
        this.px = this.radialgr.getSize().width - 100;
        this.py = this.radialgr.getSize().height - (this.radialgr.getSize().height - this.py2);
        this.radialgr.setSeriesStyle(1, Color.black, true, 0);
        this.radialgr.setSeriesStyle(2, Color.red, true, 0);
        this.radialgr.setSeriesStyle(3, Color.green, true, 0);
        this.radialgr.setSeriesStyle(4, Color.blue, true, 0);
        this.radialgr.setAutoscaleX(false);
        this.radialgr.setAutoscaleY(false);
        this.radialgr.setMinMaxX(0.0, d);
        if (this.sc >= 5) {
            this.sc = 1;
            this.py2 = 20;
        }
        double d5 = SpecialFunctions.factorial(n - n2 - 1);
        double d6 = SpecialFunctions.factorial(n + n2);
        double d7 = 2.0 / (double)(n * n) * Math.sqrt(d5 / d6);
        if (n == 1 && n2 == 0) {
            for (n4 = 1; n4 < n3; ++n4) {
                d2 = (double)2 * Math.exp(-d4);
                dArray2[n4] = !this.phase ? d2 * d2 * d4 * d4 : d2;
                dArray[n4] = d4;
                d4 += d3;
            }
        } else if (n == 2 && n2 == 0) {
            for (n4 = 1; n4 < n3; ++n4) {
                d2 = 0.7071067812 * (1.0 - d4 / (double)2) * Math.exp(-d4 / (double)2);
                dArray2[n4] = !this.phase ? d2 * d2 * d4 * d4 : d2;
                dArray[n4] = d4;
                d4 += d3;
            }
        } else if (n == 2 && n2 == 1) {
            for (n4 = 1; n4 < n3; ++n4) {
                d2 = 0.2041241452 * d4 * Math.exp(-d4 / (double)2);
                dArray2[n4] = !this.phase ? d2 * d2 * d4 * d4 : d2;
                dArray[n4] = d4;
                d4 += d3;
            }
        } else {
            for (n4 = 1; n4 < n3; ++n4) {
                d2 = d7 * Math.pow(2.0 * d4 / (double)n, n2) * Math.exp(-d4 / (double)n) * SpecialFunctions.laguerre(2 * n2 + 1, n - n2 - 1, 2.0 * d4 / (double)n);
                dArray2[n4] = !this.phase ? d2 * d2 * d4 * d4 : d2;
                dArray[n4] = d4;
                d4 += d3;
            }
        }
        if (this.multiplecb.getState()) {
            this.radialgr.clearSeriesData(this.sc);
            if (this.phase) {
                this.radialgr.setAutoscaleY(true);
            } else {
                this.radialgr.setAutoscaleY(false);
            }
            this.radialgr.addData(this.sc, dArray, dArray2);
            this.radialgr.setMinMaxY(0.0, this.radialgr.getYmax() + 0.1 * this.radialgr.getYmax());
            if (!this.phase) {
                this.radialgr.setLabelY("[Rnl(r)*r]^2", Color.black);
            } else {
                this.radialgr.setLabelY("Rnl(r)", Color.black);
            }
            this.radialgr.setSeriesLegend(this.sc, Color.black, this.px, this.py, String.valueOf(String.valueOf(new StringBuffer("n=").append(n).append("  l=").append(n2))));
            ++this.sc;
            this.py2 += 15;
        } else {
            this.radialgr.clearSeriesData(1);
            if (this.phase) {
                this.radialgr.setAutoscaleY(true);
            } else {
                this.radialgr.setAutoscaleY(false);
            }
            this.radialgr.addData(1, dArray, dArray2);
            this.radialgr.setMinMaxY(0.0, this.radialgr.getYmax() + 0.05 * this.radialgr.getYmax());
            if (!this.phase) {
                this.radialgr.setLabelY("[Rnl(r)*r]^2", Color.black);
            } else {
                this.radialgr.setLabelY("Rnl(r)", Color.black);
            }
            this.radialgr.setSeriesLegend(1, Color.black, this.px, this.py, String.valueOf(String.valueOf(new StringBuffer("n=").append(n).append("  l=").append(n2))));
        }
    }

    void plotbtn_actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2 = this.angqnnb.getValue();
        if (n2 > (n = this.prinqnnb.getValue()) - 1 | n2 < 0) {
            this.angqnnb.setBackground(Color.red);
        } else if (n > 50) {
            this.prinqnnb.setBackground(Color.red);
        } else {
            this.setNL(n, n2);
        }
    }

    void resetbtn_actionPerformed(ActionEvent actionEvent) {
        this.clearGraph();
    }

    void multiplecb_itemStateChanged(ItemEvent itemEvent) {
        if (this.multiplecb.getState()) {
            this.sc = 2;
        } else {
            this.sc = 2;
            this.radialgr.deleteAllSeries();
            this.py2 = 20;
            this.setNL(this.prinqnnb.getValue(), this.angqnnb.getValue());
        }
    }
}

