/*
 * Decompiled with CFR 0.152.
 */
package filters;

import edu.davidson.display.SInteger;
import edu.davidson.display.SNumber;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Accumulator
extends SApplet
implements SDataListener,
SDataSource {
    boolean isStandalone = false;
    int numPts = 100;
    boolean showControls = true;
    boolean autoReplace = true;
    String[] varStrings = new String[]{"x", "y"};
    double[][] ds = null;
    private int nextIndex = 0;
    EtchedBorder controlPanel = new EtchedBorder();
    BorderLayout borderLayout1 = new BorderLayout();
    SNumber yField = new SNumber();
    Panel panel3 = new Panel();
    Label minLabel2 = new Label();
    SNumber xField = new SNumber();
    Panel panel4 = new Panel();
    Label minLabel3 = new Label();
    FlowLayout flowLayout1 = new FlowLayout();
    Button resetBtn = new Button();
    Label numLabel = new Label();
    Panel panel1 = new Panel();
    SInteger numField = new SInteger();
    Toolkit tk = Toolkit.getDefaultToolkit();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.numPts = Integer.parseInt(this.getParameter("NumPts", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.controlPanel.setVisible(this.showControls);
        this.setNumPts(this.numPts);
        SApplet.addDataListener((Object)((Object)this));
        SApplet.addDataSource((Object)((Object)this));
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.minLabel2.setText("Last Y");
        this.minLabel2.setAlignment(2);
        this.minLabel3.setText("Last X");
        this.minLabel3.setAlignment(2);
        this.controlPanel.setLayout(this.flowLayout1);
        this.resetBtn.setLabel("Reset");
        this.resetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Accumulator.this.resetBtn_actionPerformed(actionEvent);
            }
        });
        this.numLabel.setAlignment(2);
        this.numLabel.setText("Max #");
        this.xField.setEditable(false);
        this.xField.setText("??");
        this.yField.setEditable(false);
        this.yField.setText("??");
        this.controlPanel.setBackground(Color.lightGray);
        this.controlPanel.setFillColor(Color.lightGray);
        ((Container)((Object)this)).add((Component)this.controlPanel, "Center");
        this.controlPanel.add((Component)this.resetBtn, null);
        this.controlPanel.add((Component)this.panel1, null);
        this.panel1.add((Component)this.numLabel, null);
        this.panel1.add((Component)this.numField, null);
        this.controlPanel.add((Component)this.panel4, null);
        this.panel4.add((Component)this.minLabel3, null);
        this.panel4.add((Component)this.xField, null);
        this.controlPanel.add((Component)this.panel3, null);
        this.panel3.add((Component)this.minLabel2, null);
        this.panel3.add((Component)this.yField, null);
    }

    public String getAppletInfo() {
        return "Accumulator Physlet written by W. Christian.  Accumulate datum to produce a data set.";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"NumPts", "int", "The number of points to put into data set."}, {"ShowControls", "boolean", "Show the user interface."}};
        return stringArray;
    }

    public synchronized void setNumPts(int n) {
        if (n < 1) {
            System.out.println("Number of points must be >0.");
        }
        this.numPts = Math.max(1, n);
        this.ds = new double[this.numPts][2];
        for (int i = 0; i < this.numPts; ++i) {
            this.ds[i][0] = 0.0;
            this.ds[i][1] = 0.0;
        }
        this.nextIndex = 0;
        if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
            this.xField.setText("??");
            this.xField.setText("??");
            this.numField.setValue(0);
        }
        this.updateDataConnections();
    }

    public double[][] getVariables() {
        return this.ds;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    public synchronized void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        if (this.autoReplace) {
            this.ds[this.nextIndex][0] = d;
            this.ds[this.nextIndex][1] = d2;
            ++this.nextIndex;
            if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
                this.xField.setValue(d);
                this.yField.setValue(d2);
                this.numField.setValue(this.nextIndex);
            }
            if (this.nextIndex == this.numPts) {
                this.nextIndex = 0;
                this.updateDataConnections();
                return;
            }
        } else {
            if (this.nextIndex == 0) {
                this.nextIndex = this.numPts;
                for (int i = 0; i < this.numPts; ++i) {
                    this.ds[i][0] = d;
                    this.ds[i][1] = d2;
                }
            } else {
                for (int i = 1; i < this.numPts; ++i) {
                    this.ds[i - 1][0] = this.ds[i][0];
                    this.ds[i - 1][1] = this.ds[i][1];
                }
            }
            this.ds[this.numPts - 1][0] = d;
            this.ds[this.numPts - 1][1] = d2;
            if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
                this.xField.setValue(d);
                this.yField.setValue(d2);
                this.numField.setValue(this.nextIndex);
                this.tk.sync();
            }
            this.updateDataConnections();
        }
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
            this.xField.setValue(dArray[0]);
            this.yField.setValue(dArray2[0]);
            this.numField.setValue(this.nextIndex);
        }
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!this.autoReplace) continue;
            this.ds[this.nextIndex][0] = dArray[i];
            this.ds[this.nextIndex][1] = dArray2[i];
            ++this.nextIndex;
            if (this.nextIndex != this.numPts) continue;
            this.nextIndex = 0;
            this.updateDataConnections();
            return;
        }
    }

    public synchronized void reset() {
        for (int i = 0; i < this.numPts; ++i) {
            this.ds[i][0] = 0.0;
            this.ds[i][1] = 0.0;
        }
        this.nextIndex = 0;
        if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
            this.xField.setText("??");
            this.xField.setText("??");
            this.numField.setValue(this.nextIndex);
        }
        this.updateDataConnections();
    }

    public void deleteSeries(int n) {
        this.reset();
    }

    public void clearSeries(int n) {
        if (this.autoReplace) {
            this.reset();
        }
    }

    public synchronized void setAutoReplaceData(int n, boolean bl) {
        this.autoReplace = bl;
        if (this.autoReplace && this.nextIndex >= this.numPts) {
            this.reset();
        }
    }

    void resetBtn_actionPerformed(ActionEvent actionEvent) {
        this.reset();
        this.tk.beep();
    }
}

