/*
 * Decompiled with CFR 0.152.
 */
package filters;

import com.borland.jbcl.layout.VerticalFlowLayout;
import edu.davidson.display.SInteger;
import edu.davidson.display.SNumber;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import filters.FFTransform;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class FFT
extends SApplet
implements SDataListener,
SDataSource {
    static final int REALMODE = 0;
    static final int SINMODE = 1;
    static final int COSMODE = 2;
    int transformMode = 0;
    boolean isStandalone = false;
    int fftPts = 128;
    boolean showControls;
    String funcStr;
    String transformType;
    double xmin;
    double xmax;
    double[] x = new double[this.fftPts + 1];
    double[] y = new double[this.fftPts + 1];
    double[] fft = new double[this.fftPts + 1];
    private Parser function = null;
    String[] varStrings = new String[]{"x", "y", "n", "fft"};
    double[][] variables = new double[this.fftPts][4];
    EtchedBorder etchedBorder1 = new EtchedBorder();
    Panel panel1 = new Panel();
    Button transBtn = new Button();
    Panel panel2 = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    Label label1 = new Label();
    Panel panel4 = new Panel();
    TextField funcField = new TextField();
    BorderLayout borderLayout2 = new BorderLayout();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    EtchedBorder paramPanel = new EtchedBorder();
    Label label3 = new Label();
    Panel panel6 = new Panel();
    SInteger ptsField = new SInteger();
    Label label4 = new Label();
    Panel panel7 = new Panel();
    SNumber minField = new SNumber();
    Label label5 = new Label();
    Panel panel8 = new Panel();
    SNumber maxField = new SNumber();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    Choice choice = new Choice();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.fftPts = Integer.parseInt(this.getParameter("NumPts", "256"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.funcStr = this.getParameter("Function", "sin(pi*x)");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.transformType = this.getParameter("Type", "Real");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xmin = Double.valueOf(this.getParameter("XMin", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xmax = Double.valueOf(this.getParameter("XMax", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.choice.addItem("Real");
        this.choice.addItem("Sin");
        this.choice.addItem("Cos");
        this.transformType = this.transformType.toLowerCase();
        if (this.transformType.equals("sin")) {
            this.choice.select("Sin");
            this.transformMode = 1;
        } else if (this.transformType.equals("cos")) {
            this.choice.select("Cos");
            this.transformMode = 2;
        } else if (this.transformType.equals("real")) {
            this.choice.select("Real");
            this.transformMode = 0;
        }
        this.ptsField.setValue(this.fftPts);
        this.funcField.setText(this.funcStr);
        this.minField.setValue(this.xmin);
        this.maxField.setValue(this.xmax);
        this.variables = new double[this.fftPts][4];
        this.x = new double[this.fftPts + 1];
        this.y = new double[this.fftPts + 1];
        this.fft = new double[this.fftPts + 1];
        this.parseFunction();
        this.packRealData(this.ptsField.getValue());
        SApplet.addDataListener((Object)((Object)this));
        SApplet.addDataSource((Object)((Object)this));
        this.doFFT();
    }

    private void jbInit() throws Exception {
        this.transBtn.setLabel("FFT");
        this.transBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFT.this.transBtn_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.label1.setAlignment(2);
        this.label1.setText("F(x)=");
        this.panel2.setLayout(this.borderLayout2);
        this.funcField.setText("textField1");
        this.panel4.setLayout(this.verticalFlowLayout1);
        this.etchedBorder1.setLayout(this.borderLayout3);
        this.label3.setText("# Pts");
        this.label3.setAlignment(2);
        this.ptsField.setColumns(5);
        this.label4.setText("Min");
        this.label4.setAlignment(2);
        this.minField.setColumns(5);
        this.minField.setValue(-1.0);
        this.label5.setText("Max");
        this.label5.setAlignment(2);
        this.maxField.setColumns(5);
        this.maxField.setValue(1.0);
        this.panel6.setLayout(this.flowLayout1);
        this.paramPanel.setLayout(this.flowLayout2);
        this.choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FFT.this.choice_itemStateChanged(itemEvent);
            }
        });
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "North");
        this.etchedBorder1.add((Component)this.panel1, "West");
        this.panel1.add((Component)this.transBtn, null);
        this.etchedBorder1.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.label1, "West");
        this.panel2.add((Component)this.panel4, "Center");
        this.panel4.add((Component)this.funcField, null);
        ((Container)((Object)this)).add((Component)this.paramPanel, "South");
        this.paramPanel.add((Component)this.choice, null);
        this.paramPanel.add((Component)this.panel7, null);
        this.panel7.add((Component)this.label4, null);
        this.panel7.add((Component)this.minField, null);
        this.paramPanel.add((Component)this.panel8, null);
        this.panel8.add((Component)this.label5, null);
        this.panel8.add((Component)this.maxField, null);
        this.paramPanel.add((Component)this.panel6, null);
        this.panel6.add((Component)this.label3, null);
        this.panel6.add((Component)this.ptsField, null);
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"NumPts", "int", "Number of points"}, {"ShowControls", "boolean", "Show the unser interface."}, {"Function", "String", "Function string"}, {"Type", "String", "Type of tranform"}, {"XMin", "double", "Minimum value for x"}, {"XMax", "double", "Maximum value for x"}};
        return stringArray;
    }

    private boolean parseFunction() {
        this.funcStr = this.funcStr.trim();
        this.funcStr = this.funcStr.toLowerCase();
        this.function = new Parser(1);
        this.function.defineVariable(1, "x");
        this.function.define(this.funcStr);
        this.function.parse();
        if (this.function.getErrorCode() != 0) {
            System.out.println("Failed to parse the function in FFT: ".concat(String.valueOf(String.valueOf(this.funcStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.function.getErrorString()).append(" at function 1, position ").append(this.function.getErrorPosition()))));
            this.function = null;
            return false;
        }
        return true;
    }

    private void sinTransform() {
        FFTransform.sinft(this.fft, this.fftPts, 1);
        for (int i = 0; i < this.fftPts - 1; ++i) {
            this.variables[i][2] = i + 1;
            this.variables[i][3] = (double)2 * this.fft[i + 2] / (double)this.fftPts;
        }
        this.variables[this.fftPts - 1][2] = this.fftPts;
        this.variables[this.fftPts - 1][3] = 0.0;
        this.updateDataConnections();
    }

    private void cosTransform() {
        FFTransform.cosft(this.fft, this.fftPts, 1);
        for (int i = 0; i < this.fftPts - 1; ++i) {
            this.variables[i][2] = i + 1;
            this.variables[i][3] = (double)2 * this.fft[i + 2] / (double)this.fftPts;
        }
        this.variables[this.fftPts - 1][2] = this.fftPts;
        this.variables[this.fftPts - 1][3] = 0.0;
        this.updateDataConnections();
    }

    private void realTransform() {
        int n;
        FFTransform.realft(this.fft, this.fftPts / 2, 1);
        for (n = 2; n < this.fftPts / 2; ++n) {
            double d = this.fft[2 * n - 1];
            double d2 = this.fft[2 * n];
            this.variables[n - 2][2] = n - 1;
            this.variables[n - 2][3] = (double)2 * Math.sqrt(d * d + d2 * d2) / (double)this.fftPts;
        }
        for (n = this.fftPts / 2; n < this.fftPts; ++n) {
            this.variables[n - 2][2] = n - 1;
            this.variables[n - 2][3] = 0.0;
        }
        this.updateDataConnections();
    }

    public void packRealData(int n) {
        double d = (this.xmax - this.xmin) / (double)(n - 1);
        for (int i = 1; i <= this.fftPts; ++i) {
            this.x[i] = (double)(i - 1) * d + this.xmin;
            this.y[i] = this.function.evaluate(this.x[i]);
            this.fft[i] = this.y[i];
            this.variables[i - 1][0] = this.x[i];
            this.variables[i - 1][1] = this.y[i];
        }
    }

    public synchronized void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        if (this.function == null && this.funcStr != null) {
            this.parseFunction();
        }
        this.updateDataConnections();
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        if (this.function == null && this.funcStr != null) {
            this.parseFunction();
        }
        this.ptsField.setValue(dArray.length);
        this.xmin = dArray[0];
        this.minField.setValue(this.xmin);
        int n2 = this.calcPoints(dArray.length);
        this.xmax = dArray[n2];
        this.maxField.setValue(this.xmax);
        if (n2 != this.fftPts) {
            this.fftPts = n2;
            this.variables = new double[this.fftPts][4];
            this.x = new double[this.fftPts + 1];
            this.y = new double[this.fftPts + 1];
            this.fft = new double[this.fftPts + 1];
        }
        for (int i = 1; i <= this.fftPts; ++i) {
            this.x[i] = dArray[i];
            this.y[i] = dArray2[i];
            this.fft[i] = dArray2[i];
            this.variables[i - 1][0] = dArray[i];
            this.variables[i - 1][1] = dArray2[i];
        }
        switch (this.transformMode) {
            case 0: {
                this.realTransform();
                break;
            }
            case 1: {
                this.sinTransform();
                break;
            }
            case 2: {
                this.cosTransform();
            }
        }
        this.updateDataConnections();
    }

    public void deleteSeries(int n) {
        this.reset();
    }

    public void clearSeries(int n) {
        this.reset();
    }

    public double[][] getVariables() {
        return this.variables;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    private int calcPoints(int n) {
        int n2;
        n = Math.max(1, n);
        for (n2 = 1; n >= n2; n2 *= 2) {
        }
        return n2 / 2;
    }

    public boolean setFunction(String string) {
        this.funcStr = string;
        this.funcField.setText(string);
        if (!this.parseFunction()) {
            this.funcField.setBackground(Color.red);
            return false;
        }
        this.funcField.setBackground(Color.white);
        return true;
    }

    public void setTransformType(String string) {
        this.transformType = string;
        this.transformType = this.transformType.toLowerCase();
        if (this.transformType.equals("sin")) {
            this.choice.select("Sin");
            this.transformMode = 1;
        } else if (this.transformType.equals("cos")) {
            this.choice.select("Cos");
            this.transformMode = 2;
        } else {
            this.transformType = "real";
            this.choice.select("Real");
            this.transformMode = 0;
        }
    }

    public void doFFT() {
        int n = this.ptsField.getValue();
        if ((n = this.calcPoints(n)) != this.fftPts) {
            this.fftPts = n;
            this.variables = new double[this.fftPts][4];
            this.x = new double[this.fftPts + 1];
            this.y = new double[this.fftPts + 1];
            this.fft = new double[this.fftPts + 1];
        }
        if (!this.parseFunction()) {
            this.funcField.setBackground(Color.red);
            return;
        }
        this.funcField.setBackground(Color.white);
        switch (this.transformMode) {
            case 0: {
                this.packRealData(this.ptsField.getValue());
                this.realTransform();
                break;
            }
            case 1: {
                this.packRealData(this.ptsField.getValue());
                this.sinTransform();
                break;
            }
            case 2: {
                this.packRealData(this.ptsField.getValue());
                this.cosTransform();
            }
        }
    }

    void transBtn_actionPerformed(ActionEvent actionEvent) {
        this.xmax = this.maxField.getValue();
        this.xmin = this.minField.getValue();
        this.funcStr = this.funcField.getText();
        this.doFFT();
    }

    void choice_itemStateChanged(ItemEvent itemEvent) {
        this.transformMode = this.choice.getSelectedItem().equals("Real") ? 0 : (this.choice.getSelectedItem().equals("Sin") ? 1 : 2);
    }

    static {
        REALMODE = 0;
        SINMODE = 1;
        COSMODE = 2;
    }
}

