/*
 * Decompiled with CFR 0.152.
 */
package filters;

import edu.davidson.display.SInteger;
import edu.davidson.display.SNumber;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Histrogram
extends SApplet
implements SDataListener,
SDataSource {
    boolean isStandalone = false;
    int numberOfBins;
    double minBin;
    double maxBin;
    double binSize;
    boolean showControls;
    boolean autoReplace = true;
    String[] varStrings = new String[]{"x", "y"};
    double[][] ds = null;
    EtchedBorder controlPanel = new EtchedBorder();
    BorderLayout borderLayout1 = new BorderLayout();
    Button setBtn = new Button();
    FlowLayout flowLayout1 = new FlowLayout();
    Panel panel1 = new Panel();
    Label numLabel = new Label();
    SInteger numField = new SInteger();
    Label minLabel1 = new Label();
    SNumber maxField = new SNumber();
    Panel panel2 = new Panel();
    Label minLabel2 = new Label();
    SNumber minField = new SNumber();
    Panel panel3 = new Panel();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.numberOfBins = Integer.parseInt(this.getParameter("NumBins", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.minBin = Double.valueOf(this.getParameter("Min", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.maxBin = Double.valueOf(this.getParameter("Max", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.controlPanel.setVisible(this.showControls);
        this.setNumBins(this.numberOfBins);
        this.minField.setValue(this.minBin);
        this.maxField.setValue(this.maxBin);
        this.numField.setValue(this.numberOfBins);
        SApplet.addDataListener((Object)((Object)this));
        SApplet.addDataSource((Object)((Object)this));
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.setBtn.setLabel("Set");
        this.setBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Histrogram.this.setBtn_actionPerformed(actionEvent);
            }
        });
        this.controlPanel.setLayout(this.flowLayout1);
        this.numLabel.setAlignment(2);
        this.numLabel.setText("#");
        this.minLabel1.setText("Max");
        this.minLabel1.setAlignment(2);
        this.minLabel2.setText("Min");
        this.minLabel2.setAlignment(2);
        this.maxField.setValue(100.0);
        this.numField.setValue(10);
        ((Container)((Object)this)).add((Component)this.controlPanel, "Center");
        this.controlPanel.add((Component)this.setBtn, null);
        this.controlPanel.add((Component)this.panel3, null);
        this.panel3.add((Component)this.minLabel2, null);
        this.panel3.add((Component)this.minField, null);
        this.controlPanel.add((Component)this.panel2, null);
        this.panel2.add((Component)this.minLabel1, null);
        this.panel2.add((Component)this.maxField, null);
        this.controlPanel.add((Component)this.panel1, null);
        this.panel1.add((Component)this.numLabel, null);
        this.panel1.add((Component)this.numField, null);
    }

    public String getAppletInfo() {
        return "Histogram Physlet written by W. Christian.  Sort data from a data sourct into bins.";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"NumBins", "int", "Number of bins."}, {"Min", "double", "Minimum value for data sorting."}, {"Max", "double", "Maximum value for data sortting."}, {"ShowControls", "boolean", "Show user inteface."}};
        return stringArray;
    }

    public synchronized void setNumBins(int n) {
        double d;
        if (n < 1) {
            System.out.println("Number of bins must be >0.");
        }
        this.numberOfBins = Math.max(1, n);
        if (this.maxBin < this.minBin) {
            System.out.println("Bin maximum must be > bin minimum.");
            d = this.maxBin;
            this.maxBin = this.minBin;
            this.minBin = d;
        }
        if (this.maxBin == this.minBin) {
            System.out.println("Bin maximum cannot be = bin minimum.");
            this.maxBin += 1.0;
        }
        this.binSize = (this.maxBin - this.minBin) / (double)this.numberOfBins;
        this.ds = new double[this.numberOfBins][2];
        d = this.minBin + this.binSize / 2.0;
        for (int i = 0; i < this.numberOfBins; ++i) {
            this.ds[i][0] = d;
            d += this.binSize;
        }
        if (this.showControls) {
            this.minField.setValue(this.minBin);
            this.maxField.setValue(this.maxBin);
            this.numField.setValue(this.numberOfBins);
        }
        this.updateDataConnections();
    }

    public synchronized void setMinMaxBins(double d, double d2) {
        double d3;
        this.maxBin = d2;
        this.minBin = d;
        if (this.maxBin < this.minBin) {
            System.out.println("Bin maximum must be > bin minimum.");
            d3 = this.maxBin;
            this.maxBin = this.minBin;
            this.minBin = d3;
        }
        if (this.maxBin == this.minBin) {
            System.out.println("Bin maximum cannot be = bin minimum.");
            this.maxBin += 1.0;
        }
        this.binSize = (this.maxBin - this.minBin) / (double)this.numberOfBins;
        d3 = this.minBin + this.binSize / 2.0;
        for (int i = 0; i < this.numberOfBins; ++i) {
            this.ds[i][0] = d3;
            this.ds[i][1] = 0.0;
            d3 += this.binSize;
        }
        if (this.showControls) {
            this.minField.setValue(this.minBin);
            this.maxField.setValue(this.maxBin);
        }
        this.updateDataConnections();
    }

    public double[][] getVariables() {
        return this.ds;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    public synchronized void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        int n2 = (int)((d - this.minBin) / this.binSize);
        if (n2 < 0) {
            return;
        }
        if (n2 > this.numberOfBins - 1) {
            return;
        }
        double[] dArray = this.ds[n2];
        dArray[1] = dArray[1] + d2;
        this.updateDataConnections();
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        int n2;
        if (this.autoReplace) {
            for (n2 = 0; n2 < this.numberOfBins; ++n2) {
                this.ds[n2][1] = 0.0;
            }
        }
        n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)((dArray[i] - this.minBin) / this.binSize);
            if (n3 < 0 || n3 >= this.numberOfBins) continue;
            double[] dArray3 = this.ds[n3];
            dArray3[1] = dArray3[1] + dArray2[i];
        }
    }

    public synchronized void reset() {
        for (int i = 0; i < this.numberOfBins; ++i) {
            this.ds[i][1] = 0.0;
        }
        this.updateDataConnections();
    }

    public void deleteSeries(int n) {
        this.reset();
    }

    public void clearSeries(int n) {
        if (this.autoReplace) {
            this.reset();
        }
    }

    public synchronized void setAutoReplaceData(int n, boolean bl) {
        this.autoReplace = bl;
    }

    void setBtn_actionPerformed(ActionEvent actionEvent) {
        this.minBin = this.minField.getValue();
        this.maxBin = this.maxField.getValue();
        this.numberOfBins = this.numField.getValue();
        if (this.numberOfBins != this.numField.getValue()) {
            this.setNumBins(this.numField.getValue());
        } else {
            this.setMinMaxBins(this.minBin, this.maxBin);
        }
    }
}

