/*
 * Decompiled with CFR 0.152.
 */
package filters;

import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;

public final class Integrator
extends SApplet
implements SDataListener,
SDataSource {
    private String xiStr;
    private Parser xIntegrand = null;
    private String yiStr;
    private Parser yIntegrand = null;
    String[] varStrings = new String[]{"x", "y", "n", "integral", "ds"};
    double[][] variables = new double[1][5];
    int n = 0;
    double sumX = 0.0;
    double sumY = 0.0;
    double lastX = 0.0;
    double lastY = 0.0;
    double lastXIntegrand;
    double lastYIntegrand;
    double dx = 0.0;
    double dy = 0.0;
    double ds = 0.0;
    boolean isStandalone = false;
    int mode = 0;

    public void init() {
        String string = "dx";
        try {
            this.varStrings[0] = this.getParameter("Independent", "x");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string = this.getParameter("Differential", "dx");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xiStr = this.getParameter("Integrand", this.varStrings[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.yiStr = new String(this.xiStr);
        string = string.toLowerCase();
        if (string.equals("dx")) {
            this.mode = 0;
        } else if (string.equals("dy")) {
            this.mode = 1;
        } else if (string.equals("ds")) {
            this.mode = 2;
        } else {
            this.mode = 0;
            System.out.println("Differential parameter invalid. Use dx, dy or ds.");
        }
        SApplet.addDataListener((Object)((Object)this));
        SApplet.addDataSource((Object)((Object)this));
    }

    private boolean parseXIntegrand(SDataSource sDataSource) {
        this.xiStr = this.xiStr.trim();
        this.xiStr = this.xiStr.toLowerCase();
        int n = sDataSource.getVarStrings().length;
        this.xIntegrand = new Parser(n);
        for (int i = 0; i < n; ++i) {
            this.xIntegrand.defineVariable(1 + i, sDataSource.getVarStrings()[i]);
        }
        this.xIntegrand.define(this.xiStr);
        this.xIntegrand.parse();
        if (this.xIntegrand.getErrorCode() != 0) {
            System.out.println("Failed to parse the x integrand in filters.Integrator: ".concat(String.valueOf(String.valueOf(this.xiStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.xIntegrand.getErrorString()).append(" at function 1, position ").append(this.xIntegrand.getErrorPosition()))));
            this.xIntegrand = null;
            return false;
        }
        return true;
    }

    private boolean parseYIntegrand(SDataSource sDataSource) {
        this.yiStr = this.yiStr.trim();
        this.yiStr = this.yiStr.toLowerCase();
        int n = sDataSource.getVarStrings().length;
        this.yIntegrand = new Parser(n);
        for (int i = 0; i < n; ++i) {
            this.yIntegrand.defineVariable(1 + i, sDataSource.getVarStrings()[i]);
        }
        this.yIntegrand.define(this.yiStr);
        this.yIntegrand.parse();
        if (this.yIntegrand.getErrorCode() != 0) {
            System.out.println("Failed to parse the y integrand in filters.Integrator: ".concat(String.valueOf(String.valueOf(this.yiStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.yIntegrand.getErrorString()).append(" at function 1, position ").append(this.yIntegrand.getErrorPosition()))));
            this.yIntegrand = null;
            return false;
        }
        return true;
    }

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public String getAppletInfo() {
        return "Integrator Physlets";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Integrand", "String", "Integrand"}, {"Differential", "String", "Differential"}};
        return stringArray;
    }

    public double[][] getVariables() {
        this.variables[0][0] = this.lastX;
        this.variables[0][1] = this.lastY;
        this.variables[0][2] = this.n;
        this.variables[0][3] = this.sumX + this.sumY;
        this.variables[0][4] = this.ds;
        return this.variables;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    public void reset() {
        this.sumX = 0.0;
        this.sumY = 0.0;
        this.n = 0;
        this.updateDataConnections();
    }

    public synchronized void setLineIntegralMode(String string, String string2) {
        this.mode = 3;
        this.xIntegrand = null;
        this.yIntegrand = null;
        this.xiStr = string;
        this.yiStr = string2;
        this.sumX = 0.0;
        this.sumY = 0.0;
        this.n = 0;
    }

    public synchronized void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        if (this.xIntegrand == null && this.xiStr != null) {
            this.parseXIntegrand(sDataSource);
        }
        if (this.yIntegrand == null && this.yiStr != null) {
            this.parseYIntegrand(sDataSource);
        }
        this.dx = d - this.lastX;
        this.dy = d2 - this.lastY;
        this.ds = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        double d3 = 0.0;
        if (this.n > 0) {
            switch (this.mode) {
                case 0: {
                    if (this.xIntegrand == null) break;
                    d3 = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += (d3 + this.lastXIntegrand) * this.dx / (double)2;
                    this.lastXIntegrand = d3;
                    break;
                }
                case 1: {
                    if (this.yIntegrand == null) break;
                    d3 = this.yIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumY += (d3 + this.lastYIntegrand) * this.dy / (double)2;
                    this.lastYIntegrand = d3;
                    break;
                }
                case 2: {
                    if (this.xIntegrand == null) break;
                    d3 = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += (d3 + this.lastXIntegrand) * this.ds / (double)2;
                    this.lastXIntegrand = d3;
                    break;
                }
                case 3: {
                    if (this.xIntegrand == null) break;
                    d3 = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += (d3 + this.lastXIntegrand) * this.dx / (double)2;
                    this.lastXIntegrand = d3;
                    if (this.yIntegrand == null) break;
                    d3 = this.yIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumY += (d3 + this.lastYIntegrand) * this.dy / (double)2;
                    this.lastYIntegrand = d3;
                    break;
                }
                default: {
                    if (this.xIntegrand == null) break;
                    d3 = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += (d3 + this.lastXIntegrand) * this.dx / (double)2;
                    this.lastXIntegrand = d3;
                }
            }
        }
        this.lastX = d;
        this.lastY = d2;
        ++this.n;
        this.updateDataConnections();
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        if (this.xIntegrand == null && this.xiStr != null) {
            this.parseXIntegrand(sDataSource);
        }
        if (this.yIntegrand == null && this.yiStr != null) {
            this.parseYIntegrand(sDataSource);
        }
        this.sumX = 0.0;
        this.sumY = 0.0;
        this.n = dArray.length;
        if (this.n < 2) {
            return;
        }
        double d = 0.0;
        this.dx = (dArray[1] - dArray[0]) / (double)2;
        this.dy = (dArray2[1] - dArray2[0]) / (double)2;
        for (int i = 0; i < this.n; ++i) {
            this.ds = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
            switch (this.mode) {
                case 0: {
                    if (this.xIntegrand == null) break;
                    d = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += d * this.dx;
                    break;
                }
                case 1: {
                    if (this.yIntegrand == null) break;
                    d = this.yIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumY += d * this.dy;
                    break;
                }
                case 2: {
                    if (this.xIntegrand == null) break;
                    d = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += d * this.ds;
                    break;
                }
                case 3: {
                    if (this.xIntegrand == null) break;
                    d = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += d * this.dx;
                    if (this.yIntegrand == null) break;
                    d = this.yIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumY += d * this.dy;
                    break;
                }
                default: {
                    if (this.xIntegrand == null) break;
                    d = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += d * this.dx;
                }
            }
            if (i < this.n - 3) {
                this.dx = dArray[i + 2] - dArray[i + 1];
                this.dy = dArray2[i + 2] - dArray2[i + 1];
                continue;
            }
            if (i >= this.n - 2) continue;
            this.dx = (dArray[i + 2] - dArray[i + 1]) / (double)2;
            this.dy = (dArray2[i + 2] - dArray2[i + 1]) / (double)2;
        }
        this.updateDataConnections();
    }

    public void deleteSeries(int n) {
        this.reset();
    }

    public void clearSeries(int n) {
        this.reset();
    }
}

