/*
 * Decompiled with CFR 0.152.
 */
package filters;

import edu.davidson.display.SInteger;
import edu.davidson.display.SNumber;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Moments
extends SApplet
implements SDataListener,
SDataSource {
    boolean isStandalone = false;
    boolean showControls;
    boolean autoReplace = true;
    String[] varStrings = new String[]{"ave", "std", "n"};
    double[][] ds = new double[1][3];
    private double sumX = 0.0;
    private double sumXX = 0.0;
    private int numPts = 0;
    EtchedBorder controlPanel = new EtchedBorder();
    BorderLayout borderLayout1 = new BorderLayout();
    Button resetBtn = new Button();
    FlowLayout flowLayout1 = new FlowLayout();
    Label numLabel = new Label();
    Panel panel1 = new Panel();
    SInteger numField = new SInteger();
    SNumber stdField = new SNumber();
    Panel panel4 = new Panel();
    Label minLabel3 = new Label();
    SNumber aveField = new SNumber();
    Panel panel5 = new Panel();
    Label minLabel4 = new Label();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.controlPanel.setVisible(this.showControls);
        SApplet.addDataListener((Object)((Object)this));
        SApplet.addDataSource((Object)((Object)this));
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.resetBtn.setLabel("Reset");
        this.resetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Moments.this.resetBtn_actionPerformed(actionEvent);
            }
        });
        this.controlPanel.setLayout(this.flowLayout1);
        this.numLabel.setAlignment(2);
        this.numLabel.setText("#");
        this.stdField.setEditable(false);
        this.stdField.setColumns(8);
        this.stdField.setText("??");
        this.minLabel3.setText("Std");
        this.minLabel3.setAlignment(2);
        this.aveField.setEditable(false);
        this.aveField.setColumns(8);
        this.aveField.setText("??");
        this.minLabel4.setText("Ave");
        this.minLabel4.setAlignment(2);
        this.numField.setEditable(false);
        this.controlPanel.setBackground(Color.lightGray);
        this.controlPanel.setFillColor(Color.lightGray);
        ((Component)((Object)this)).setBackground(Color.lightGray);
        ((Container)((Object)this)).add((Component)this.controlPanel, "Center");
        this.controlPanel.add((Component)this.resetBtn, null);
        this.controlPanel.add((Component)this.panel5, null);
        this.panel5.add((Component)this.minLabel4, null);
        this.panel5.add((Component)this.aveField, null);
        this.controlPanel.add((Component)this.panel4, null);
        this.panel4.add((Component)this.minLabel3, null);
        this.panel4.add((Component)this.stdField, null);
        this.controlPanel.add((Component)this.panel1, null);
        this.panel1.add((Component)this.numLabel, null);
        this.panel1.add((Component)this.numField, null);
    }

    public String getAppletInfo() {
        return "Moments Physlet written by W. Christian.  Calculates the moments of a distribution.";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"ShowControls", "boolean", "Show the user interface."}};
        return stringArray;
    }

    public double getAve() {
        if (this.numPts < 1) {
            return 0.0;
        }
        return this.sumX / (double)this.numPts;
    }

    public double getNumPts() {
        return this.numPts;
    }

    public double getStd() {
        if (this.numPts < 2) {
            return 0.0;
        }
        return Math.sqrt((this.sumXX - this.sumX * this.sumX / (double)this.numPts) / (double)(this.numPts - 1));
    }

    public double[][] getVariables() {
        double d;
        if (this.numPts < 1) {
            this.ds[0][0] = 0.0;
            this.ds[0][1] = 0.0;
            this.ds[0][2] = 0.0;
            return this.ds;
        }
        if (this.numPts < 2) {
            this.ds[0][0] = this.sumX / (double)this.numPts;
            this.ds[0][1] = 0.0;
            this.ds[0][2] = this.numPts;
            return this.ds;
        }
        this.ds[0][0] = d = this.sumX / (double)this.numPts;
        this.ds[0][1] = Math.sqrt((this.sumXX - d * d * (double)this.numPts) / (double)(this.numPts - 1));
        this.ds[0][2] = this.numPts;
        return this.ds;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    public synchronized void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        this.sumX += d;
        this.sumXX += d * d;
        ++this.numPts;
        if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
            this.numField.setValue(this.numPts);
            this.aveField.setValue(this.getAve());
            this.stdField.setValue(this.getStd());
        }
        this.updateDataConnections();
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        if (this.autoReplace) {
            this.sumX = 0.0;
            this.sumXX = 0.0;
            this.numPts = 0;
        }
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            this.sumX += dArray[i];
            this.sumXX += dArray[i] * dArray[i];
            ++this.numPts;
        }
        if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
            this.numField.setValue(this.numPts);
            this.aveField.setValue(this.getAve());
            this.stdField.setValue(this.getStd());
        }
        this.updateDataConnections();
    }

    public void deleteSeries(int n) {
        this.reset();
    }

    public void clearSeries(int n) {
        if (this.autoReplace) {
            this.reset();
        }
    }

    public synchronized void reset() {
        this.sumX = 0.0;
        this.sumXX = 0.0;
        this.numPts = 0;
        if (this.showControls && ((Component)((Object)this)).getBounds().width > 50) {
            this.numField.setValue(0);
            this.aveField.setValue(0.0);
            this.stdField.setValue(0.0);
        }
        this.updateDataConnections();
    }

    public synchronized void setAutoReplaceData(int n, boolean bl) {
        this.autoReplace = bl;
        if (this.autoReplace) {
            this.reset();
        }
    }

    void resetBtn_actionPerformed(ActionEvent actionEvent) {
        this.reset();
    }
}

