/*
 * Decompiled with CFR 0.152.
 */
package filters;

import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.util.Vector;

public class Multiplexer
extends SApplet
implements SDataSource {
    boolean isStandalone = false;
    String[] varStrings = new String[]{"x", "y"};
    double[][] ds = new double[1][2];
    Vector listeners = new Vector();
    String[] parserVars = null;
    double[] parserValues = null;
    Parser xParser = null;
    String xFunc = "0";
    Parser yParser = null;
    String yFunc = "0";

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.xFunc = "0";
        this.xParser = new Parser(1);
        this.xParser.defineVariable(1, "x");
        this.xParser.define(this.xFunc);
        this.xParser.parse();
        this.yFunc = "0";
        this.yParser = new Parser(1);
        this.yParser.define(this.yFunc);
        this.yParser.defineVariable(1, "y");
        this.yParser.parse();
        SApplet.addDataSource((Object)((Object)this));
    }

    private void jbInit() throws Exception {
    }

    public String getAppletInfo() {
        return "Multiplexer Physlet writen by Wolfgang Christian.  wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public synchronized double[][] getVariables() {
        if (this.listeners.size() <= 0) {
            System.out.println("Warning: no data listeners in Multiplexer Physlet.");
            this.ds = new double[1][2];
            this.ds[0][0] = 0.0;
            this.ds[0][1] = 0.0;
            return this.ds;
        }
        int n = this.getNumValues();
        if (n != this.ds.length) {
            this.ds = new double[n][2];
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.listeners.size(); ++j) {
                Listener listener = (Listener)this.listeners.elementAt(j);
                if (i < listener.lastValues.length) {
                    this.parserValues[2 * j] = listener.lastValues[i][0];
                    this.parserValues[2 * j + 1] = listener.lastValues[i][1];
                    continue;
                }
                this.parserValues[2 * j] = listener.lastValues[0][0];
                this.parserValues[2 * j + 1] = listener.lastValues[0][1];
            }
            this.ds[i][0] = this.xParser.evaluate(this.parserValues);
            this.ds[i][1] = this.yParser.evaluate(this.parserValues);
        }
        return this.ds;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    public synchronized void setDefault() {
        this.clock.stopClock();
        this.deleteDataConnections();
        this.clock.setContinuous();
        this.clock.setTime(0.0);
        this.listeners.removeAllElements();
        this.xFunc = "0";
        this.xParser = new Parser(1);
        this.xParser.defineVariable(1, "x");
        this.xParser.define(this.xFunc);
        this.xParser.parse();
        this.yFunc = "0";
        this.yParser = new Parser(1);
        this.yParser.defineVariable(1, "y");
        this.yParser.define(this.yFunc);
        this.yParser.parse();
    }

    public synchronized boolean setFunctions(String string, String string2) {
        if (this.listeners.size() <= 0) {
            System.out.println("Create data listeners before you define the output function.");
            string = "0";
            string2 = "0";
        }
        this.xFunc = string;
        this.xParser.defineVariables(this.parserVars);
        this.xParser.define(this.xFunc);
        this.xParser.parse();
        if (this.xParser.getErrorCode() != 0) {
            System.out.println("Failed to parse function: ".concat(String.valueOf(String.valueOf(this.xFunc))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in Multiplexer x function: ").append(this.xParser.getErrorString()).append(" at math fuinction, position ").append(this.xParser.getErrorPosition()))));
            System.out.println("Create data listeners before you define the output function.");
            return false;
        }
        this.yFunc = string2;
        this.yParser.defineVariables(this.parserVars);
        this.yParser.define(this.yFunc);
        this.yParser.parse();
        if (this.yParser.getErrorCode() != 0) {
            System.out.println("Failed to parse function: ".concat(String.valueOf(String.valueOf(this.yFunc))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in Multiplexer y function: ").append(this.yParser.getErrorString()).append(" at math fuinction, position ").append(this.yParser.getErrorPosition()))));
            System.out.println("Create data listeners before you define the output function.");
            return false;
        }
        return true;
    }

    public synchronized boolean setActiveListener(int n, boolean bl) {
        Listener listener = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            listener = (Listener)this.listeners.elementAt(i);
            if (listener.index != n) continue;
            listener.active = bl;
            return true;
        }
        return false;
    }

    public synchronized int addMultiplexListener(int n) {
        Listener listener = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            listener = (Listener)this.listeners.elementAt(i);
            if (listener.index != n) continue;
            return listener.getID();
        }
        listener = new Listener(n);
        this.listeners.addElement(listener);
        this.setParserVars();
        return listener.getID();
    }

    public int addDataListener(int n) {
        return this.addMultiplexListener(n);
    }

    private synchronized void setParserVars() {
        int n = 2 * this.listeners.size();
        this.xParser = new Parser(n);
        this.yParser = new Parser(n);
        this.parserVars = new String[n];
        this.parserValues = new double[n];
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.elementAt(i);
            this.parserVars[2 * i] = listener.xStr;
            this.parserVars[2 * i + 1] = listener.yStr;
        }
    }

    private synchronized int getNumValues() {
        int n = 0;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.elementAt(i);
            n = Math.max(n, listener.lastValues.length);
        }
        return n;
    }

    class Listener
    implements SDataListener {
        int index = 0;
        String xStr = "x0";
        String yStr = "y0";
        boolean active = false;
        double[][] lastValues = new double[1][2];

        public Listener(int n) {
            this.index = n;
            this.xStr = "x".concat(String.valueOf(String.valueOf(n)));
            this.yStr = "y".concat(String.valueOf(String.valueOf(n)));
            try {
                SApplet.addDataListener((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return Multiplexer.this;
        }

        public String[] getVarStrings() {
            return Multiplexer.this.varStrings;
        }

        public final int getID() {
            return this.hashCode();
        }

        public void deleteSeries(int n) {
        }

        public void clearSeries(int n) {
        }

        public synchronized void addDatum(SDataSource sDataSource, int n, double d, double d2) {
            this.lastValues[0][0] = d;
            this.lastValues[0][1] = d2;
            if (this.active) {
                Multiplexer.this.updateDataConnections();
            }
        }

        public synchronized void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
            if (dArray.length != this.lastValues.length) {
                this.lastValues = new double[dArray.length][2];
            }
            for (int i = 0; i < dArray.length; ++i) {
                this.lastValues[i][0] = dArray[i];
                this.lastValues[i][1] = dArray2[i];
            }
            if (this.active) {
                Multiplexer.this.updateDataConnections();
            }
        }
    }
}

