/*
 * Decompiled with CFR 0.152.
 */
package doppler;

import doppler.Doppler;
import doppler.DopplerWaveCrest;
import edu.davidson.display.Format;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

final class DopplerCanvas
extends Canvas {
    Doppler applet = null;
    private double xs = 0.0;
    private double ys;
    private double vxs;
    private double vys;
    private Vector genVec = new Vector();
    private double sourceTime = 0.0;
    private double labTime = 0.0;
    private Image buff_image = null;
    private int buff_width = 0;
    private int buff_height = 0;
    private boolean relativistic = false;
    private boolean showCoord = false;
    private int xCoord;
    private int yCoord;
    int pixPerUnit = 10;
    Font f = new Font("Helvetica", 1, 14);
    boolean timeDisplay = true;

    public DopplerCanvas(Doppler doppler) {
        this.applet = doppler;
    }

    public void reset() {
        this.xs = 0.0;
        this.ys = this.size().height / 2;
        this.labTime = 0.0;
        this.sourceTime = 10.0;
        this.genVec.removeAllElements();
    }

    public synchronized void resetSource() {
        this.xs = 0.0;
        this.ys = this.size().height / 2;
        this.labTime = 0.0;
        this.sourceTime = 0.0;
        this.genVec.removeAllElements();
    }

    public synchronized void setX(int n) {
        this.xs = n;
        this.ys = this.size().height / 2;
        this.labTime = 0.0;
        this.sourceTime = 0.0;
        this.genVec.removeAllElements();
    }

    public synchronized void translateSource(int n) {
        int n2 = this.genVec.size();
        this.xs += (double)n;
        this.ys = this.size().height / 2;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                DopplerWaveCrest dopplerWaveCrest = (DopplerWaveCrest)this.genVec.elementAt(i);
                dopplerWaveCrest.translate(n);
            }
        }
    }

    public void setSpeed(double d, double d2) {
        this.vxs = d;
        this.vys = d2;
    }

    public void setRelativistic(boolean bl) {
        if (this.relativistic != bl) {
            this.reset();
        }
        this.relativistic = bl;
    }

    public synchronized void incTime(double d) {
        this.labTime += 1.0;
        this.sourceTime = this.relativistic ? (this.sourceTime += 1.0 * Math.sqrt(1.0 - d * d)) : (this.sourceTime += 1.0);
        this.xs += this.vxs;
        if (this.xs > (double)this.size().width) {
            this.translateSource(-this.size().width);
        }
        if (this.sourceTime > (double)this.pixPerUnit) {
            this.sourceTime -= (double)this.pixPerUnit;
            if (this.genVec.size() > 10) {
                this.genVec.removeElementAt(0);
            }
            this.genVec.addElement(new DopplerWaveCrest(this.labTime, (int)this.xs, (int)this.ys, this.vxs, this.vxs));
        }
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
    }

    private void calcBuffImage() {
        int n = this.genVec.size();
        Graphics graphics = this.buff_image.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.buff_width, this.buff_height);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                graphics.setColor(new Color(255 * (n - i) / n, 255 * (n - i) / n, 255 * (n - i) / n));
                DopplerWaveCrest dopplerWaveCrest = (DopplerWaveCrest)this.genVec.elementAt(i);
                dopplerWaveCrest.draw(this.labTime, graphics);
            }
        }
        graphics.setColor(Color.red);
        graphics.fillOval((int)(this.xs - (double)2), (int)(this.ys - (double)2), 4, 4);
        graphics.setColor(Color.black);
        graphics.setFont(this.f);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        graphics.drawString(this.applet.label_caption, (this.buff_width - fontMetrics.stringWidth(this.applet.label_caption)) / 2, 20);
        graphics.dispose();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        try {
            if (this.buff_image == null || this.size().width != this.buff_width || this.size().height != this.buff_height) {
                this.ys = this.size().height / 2;
                this.buff_width = this.size().width;
                this.buff_height = this.size().height;
                this.buff_image = this.createImage(this.buff_width, this.buff_height);
                this.reset();
            }
            this.calcBuffImage();
            graphics.drawImage(this.buff_image, 0, 0, this);
            String string = new Format("%7.4g").form(this.labTime / (double)this.pixPerUnit);
            String string2 = new Format("%7.4g").form(this.pixToX((int)this.xs));
            if (this.timeDisplay) {
                graphics.drawString(String.valueOf(String.valueOf(this.applet.label_time)).concat(String.valueOf(String.valueOf(string))), 10, 15);
                if (!this.showCoord) {
                    graphics.drawString(String.valueOf(String.valueOf(this.applet.label_position)).concat(String.valueOf(String.valueOf(string2))), 10, this.buff_height - 15);
                }
            }
        }
        catch (Exception exception) {
            this.buff_image = null;
        }
    }

    private double pixToX(int n) {
        int n2 = this.buff_width / 2;
        return (double)(n - n2) / (1.0 * (double)this.pixPerUnit);
    }

    private double pixToY(int n) {
        int n2 = this.buff_height / 2;
        return (double)(-(n - n2)) / (1.0 * (double)this.pixPerUnit);
    }

    public void startDrawCoord(int n, int n2) {
        this.applet.stop();
        this.xCoord = n;
        this.yCoord = n2;
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.clearRect(8, this.buff_height - 30, 150, 20);
        graphics.drawString(String.valueOf(String.valueOf(new StringBuffer("X: ").append(this.pixToX(this.xCoord)).append("  Y: ").append(this.pixToY(this.yCoord)))), 10, this.buff_height - 15);
        graphics.setColor(Color.red);
        graphics.drawLine(this.xCoord - 10, this.yCoord, this.xCoord + 10, this.yCoord);
        graphics.drawLine(this.xCoord, this.yCoord - 10, this.xCoord, this.yCoord + 10);
        graphics.dispose();
        this.showCoord = true;
    }

    public void endDrawCoord(int n, int n2) {
        this.applet.start();
        this.showCoord = false;
        this.repaint();
    }

    public void drawCoord(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
        if (this.showCoord) {
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            graphics.clearRect(8, this.buff_height - 30, 150, 20);
            graphics.drawString(String.valueOf(String.valueOf(new StringBuffer("X: ").append(this.pixToX(this.xCoord)).append("  Y: ").append(this.pixToY(this.yCoord)))), 10, this.buff_height - 15);
            graphics.setColor(Color.red);
            graphics.drawLine(this.xCoord - 10, this.yCoord, this.xCoord + 10, this.yCoord);
            graphics.drawLine(this.xCoord, this.yCoord - 10, this.xCoord, this.yCoord + 10);
            graphics.dispose();
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        this.startDrawCoord(n, n2);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        this.endDrawCoord(n, n2);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        this.drawCoord(n, n2);
        return true;
    }
}

