/*
 * Decompiled with CFR 0.152.
 */
package bfield;

import bfield.FieldPanel;
import bfield.Wire;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public final class Coil
extends Wire {
    static int n = 6;
    static double theta = Math.PI / (double)n;
    int ptY1 = 0;
    int ptY2 = 0;
    private double[] lastBReading = new double[2];
    private double[] lastPosition = new double[2];

    public Coil(FieldPanel fieldPanel, double d, double d2, double d3) {
        super(fieldPanel, d, d2, d3);
        this.s = 10;
        this.radius = 0.5;
        this.color = null;
        this.showF = false;
        this.showFComponents = false;
    }

    double[] getB(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = theta / (double)2;
        double d4 = this.radius * Math.sqrt((double)2 * (1.0 - Math.cos(theta)));
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d7 = -Math.sin(d3);
            double d8 = Math.cos(d3);
            double d9 = d - this.x + this.xo;
            double d10 = d2 - this.y - this.radius * Math.cos(d3) + this.yo;
            double d11 = -this.radius * Math.sin(d3);
            double d12 = d9 * d9 + d10 * d10 + d11 * d11;
            double d13 = Math.sqrt(d12) * d12;
            d5 += d11 * d7 / d13 - d10 * d8 / d13;
            d6 += d9 * d8 / d13;
            d3 += theta;
        }
        dArray[0] = (double)2 * this.current * d4 * d5;
        dArray[1] = (double)2 * this.current * d4 * d6;
        return dArray;
    }

    double getWireBx(double d, double d2) {
        this.lastPosition[0] = d;
        this.lastPosition[1] = d2;
        this.lastBReading = this.getB(this.lastPosition);
        return this.lastBReading[0];
    }

    double getWireBy(double d, double d2) {
        this.lastPosition[0] = d;
        this.lastPosition[1] = d2;
        this.lastBReading = this.getB(this.lastPosition);
        return this.lastBReading[1];
    }

    public final void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.xPix = this.p.pixFromX(this.x) + this.xDisplayOff;
        this.ptY1 = this.p.pixFromY(this.y - this.radius) - this.yDisplayOff;
        this.ptY2 = this.p.pixFromY(this.y + this.radius) - this.yDisplayOff;
        this.yPix = (this.ptY1 + this.ptY2) / 2 - this.yDisplayOff;
        graphics.setColor(new Color(192, 128, 192));
        graphics.fillRect(this.xPix - this.s / 2 + 1, this.ptY2, this.s - 2, this.ptY1 - this.ptY2);
        if (this.color != null) {
            graphics.setColor(this.color);
        } else if (this.current > 0.0) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(Color.red);
        }
        graphics.fillOval(this.xPix - this.s / 2, this.ptY1 - this.s / 2, this.s, this.s);
        if (this.color != null) {
            graphics.setColor(this.color);
        } else if (this.current > 0.0) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.blue);
        }
        graphics.fillOval(this.xPix - this.s / 2, this.ptY2 - this.s / 2, this.s, this.s);
        if (this.label != null) {
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            graphics.setColor(Color.white);
            graphics.drawString(this.label, this.xPix - 4, this.yPix + 5);
            graphics.setColor(Color.black);
            graphics.setFont(font);
        }
    }

    void setShowF(boolean bl) {
    }

    void setShowFComponents(boolean bl) {
    }

    boolean isInsidePix(int n, int n2) {
        if (!this.noDrag && Math.abs(this.xPix - n) < this.s + 1 && Math.abs(this.yPix - n2) < this.s + 1) {
            return true;
        }
        return !this.noOptionDrag && Math.abs(this.xPix - n) < this.s + 1 && (Math.abs(this.ptY2 - n2) < this.s + 1 || Math.abs(this.ptY1 - n2) < this.s + 1);
    }

    boolean isInsideWire(double d, double d2, int n) {
        int n2;
        int n3 = this.p.pixFromX(d);
        if (this.getHotSpot(n3, n2 = this.p.pixFromY(d2)) != n) {
            return false;
        }
        return this.isInsidePix(n3, n2);
    }

    public boolean isInsideThing(int n, int n2) {
        return this.isInsidePix(n, n2);
    }

    final int getHotSpot(int n, int n2) {
        if (!this.noOptionDrag && Math.abs(this.ptY2 - n2) < this.s + 1) {
            return 1;
        }
        if (!this.noOptionDrag && Math.abs(this.ptY1 - n2) < this.s + 1) {
            return -1;
        }
        return 0;
    }
}

