/*
 * Decompiled with CFR 0.152.
 */
package bfield;

import bfield.ArrowHead;
import bfield.BField;
import bfield.Coil;
import bfield.FieldPanel_mouseAdapter;
import bfield.FieldPanel_mouseMotionAdapter;
import bfield.FieldThing;
import bfield.SketchThing;
import bfield.VectorField;
import bfield.Wire;
import edu.davidson.display.Format;
import edu.davidson.display.SGraph;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.graph.DataSet;
import edu.davidson.graphics.Util;
import edu.davidson.numerics.Parser;
import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SRK45;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class FieldPanel
extends Panel
implements SScalable {
    double tolerance = 1.0E-5;
    private Vector fieldSolvers = new Vector();
    Vector arrowHeads = new Vector();
    Format format = new Format("%-+8.4g");
    VectorField field = new VectorField(4, 4);
    Rectangle fieldBounds = null;
    SGraph graph = new SGraph();
    FieldThing fieldThing = null;
    Image osi = null;
    private String message = null;
    private String caption = null;
    private boolean showTime = true;
    private Vector wires = new Vector();
    private Vector things = new Vector();
    private Font f = new Font("Helvetica", 1, 14);
    private boolean osiInvalid = true;
    private int iwidth = 0;
    private int iheight = 0;
    private int xOffset = 0;
    private int yOffset = 0;
    private int boxWidth = 0;
    private boolean isDrag = false;
    private int hotSpot = 0;
    private Wire dragWire = null;
    private Thing dragThing = null;
    private double xmin = -1.0;
    private double xmax = 1.0;
    private double ymin = -1.0;
    private double ymax = 1.0;
    private boolean showFieldVectors = true;
    private boolean showWires = true;
    private boolean showCoordOnDrag = true;
    private boolean showBOnDrag = false;
    private boolean showFieldLineOnClick = false;
    private boolean showFieldLineOnDoubleClick = false;
    private BField owner;
    private double maxB = 0.0;
    private String bxStr = "0";
    private String byStr = "0";
    private Parser parserBx = null;
    private Parser parserBy = null;
    private int gridSize = 32;
    private boolean autoRefresh = true;
    private boolean sketchMode = false;
    private SketchThing trailThing = null;
    private Cursor sketchCursor = null;
    Image sketchImage = null;

    public FieldPanel(BField bField) {
        this.owner = bField;
        this.graph.setAutoscaleX(false);
        this.graph.setAutoscaleY(false);
        this.graph.setMinMaxX(this.xmin, this.xmax);
        this.graph.setMinMaxY(this.ymin, this.ymax);
        this.graph.setShowAxis(false);
        this.graph.setDataBackground(Color.white);
        this.addMouseMotionListener(new FieldPanel_mouseMotionAdapter(this));
        this.addMouseListener(new FieldPanel_mouseAdapter(this));
    }

    SApplet getOwner() {
        return this.owner;
    }

    public int getPixWidth() {
        return this.iwidth;
    }

    public int getPixHeight() {
        return this.iheight;
    }

    public void addThing(Thing thing) {
        this.things.addElement(thing);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public Wire addWire(double d) {
        double d2 = this.xmin + (this.xmax - this.xmin) * Math.random();
        double d3 = this.ymin + (this.ymax - this.ymin) * Math.random();
        Wire wire = this.addWire(d2, d3, d);
        wire.setDragable(true);
        wire.noOptionDrag = false;
        return wire;
    }

    public Wire addWire(double d, double d2, double d3) {
        this.owner.lock.getBusyFlag();
        this.stopFieldThreads();
        if (this.hasCoils()) {
            this.fieldThing = null;
            this.wires.removeAllElements();
            this.things.removeAllElements();
        }
        Wire wire = new Wire(this, d, d2, d3);
        this.wires.addElement(wire);
        this.things.addElement(wire);
        this.owner.lock.freeBusyFlag();
        if (this.autoRefresh) {
            this.setFields();
            this.repaint();
        }
        return wire;
    }

    public Wire addCoil(double d) {
        double d2 = this.xmin + (this.xmax - this.xmin) * Math.random();
        double d3 = this.ymin + (this.ymax - this.ymin) * Math.random();
        Wire wire = this.addCoil(d2, d3, d);
        wire.setDragable(true);
        wire.noOptionDrag = false;
        return wire;
    }

    public Wire addCoil(double d, double d2, double d3) {
        this.owner.lock.getBusyFlag();
        this.stopFieldThreads();
        if (this.hasWires()) {
            this.fieldThing = null;
            this.wires.removeAllElements();
            this.things.removeAllElements();
        }
        Coil coil = new Coil(this, d, d2, d3);
        this.wires.addElement(coil);
        this.things.addElement(coil);
        this.owner.lock.freeBusyFlag();
        if (this.autoRefresh) {
            this.setFields();
            this.repaint();
        }
        return coil;
    }

    public FieldThing addField() {
        FieldThing fieldThing;
        this.owner.lock.getBusyFlag();
        this.stopFieldThreads();
        this.fieldThing = fieldThing = new FieldThing(this);
        this.things.addElement(fieldThing);
        this.owner.lock.freeBusyFlag();
        if (this.autoRefresh) {
            this.repaint();
        }
        return fieldThing;
    }

    void clearAll() {
        this.owner.lock.getBusyFlag();
        this.stopFieldThreads();
        this.fieldThing = null;
        this.wires.removeAllElements();
        this.things.removeAllElements();
        this.arrowHeads.removeAllElements();
        this.owner.lock.freeBusyFlag();
        if (this.autoRefresh) {
            this.setFields();
            this.repaint();
        }
    }

    void setWireXY(Wire wire, double d, double d2) {
        this.owner.lock.getBusyFlag();
        this.stopFieldThreads();
        wire.setXY(d, d2);
        this.owner.lock.freeBusyFlag();
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.setFields();
            this.repaint();
        }
    }

    void invalidateOSI() {
        this.osiInvalid = true;
    }

    boolean isInsideDragableThing(int n, int n2) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.isNoDrag() || !thing.isInsideThing(n, n2)) continue;
            return true;
        }
        return false;
    }

    boolean hasCoils() {
        int n = this.wires.size();
        for (int i = 0; i < n; ++i) {
            Wire wire = (Wire)((Object)this.wires.elementAt(i));
            if (!(wire instanceof Coil)) continue;
            return true;
        }
        return false;
    }

    boolean hasWires() {
        int n = this.wires.size();
        for (int i = 0; i < n; ++i) {
            Wire wire = (Wire)((Object)this.wires.elementAt(i));
            if (wire instanceof Coil) continue;
            return true;
        }
        return false;
    }

    boolean isInsideAnyWire(double d, double d2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.wires.size();
        for (int i = 0; i < n; ++i) {
            Wire wire = (Wire)((Object)this.wires.elementAt(i));
            bl2 = wire.isNoDrag();
            bl = wire.noOptionDrag;
            wire.setNoDrag(false);
            wire.noOptionDrag = false;
            if (!(wire instanceof Coil) && wire.isInsideWire(d, d2, 0) && wire != this.dragWire) {
                wire.setNoDrag(bl2);
                wire.noOptionDrag = bl;
                return true;
            }
            if (wire instanceof Coil && (wire.isInsideWire(d, d2, -1) || wire.isInsideWire(d, d2, 1)) && wire != this.dragWire) {
                wire.setNoDrag(bl2);
                wire.noOptionDrag = bl;
                return true;
            }
            wire.setNoDrag(bl2);
            wire.noOptionDrag = bl;
        }
        return false;
    }

    public Thing getThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        if (this.trailThing != null && ((Object)((Object)this.trailThing)).hashCode() == n) {
            return this.trailThing;
        }
        return null;
    }

    public Wire getWireFromID(int n) {
        for (int i = 0; i < this.wires.size(); ++i) {
            Wire wire = (Wire)((Object)this.wires.elementAt(i));
            if (wire.getID() != n) continue;
            return wire;
        }
        return null;
    }

    final double getCurl(double d, double d2, Wire wire) {
        double d3 = 1.0E-8;
        double d4 = (this.getBy(d + d3, d2, wire) - this.getBy(d - d3, d2, wire)) / (double)2 / d3;
        double d5 = (this.getBx(d, d2 + d3, wire) - this.getBx(d, d2 - d3, wire)) / (double)2 / d3;
        return d4 - d5;
    }

    final double[] getB(double d, double d2, Wire wire) {
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = new double[2];
        if (this.parserBx != null) {
            d3 = this.parserBx.evaluate(d, d2);
        }
        if (this.parserBy != null) {
            d4 = this.parserBy.evaluate(d, d2);
        }
        if (this.wires == null) {
            return new double[]{d3, d4};
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n = this.wires.size();
        for (int i = 0; i < n; ++i) {
            Wire wire2 = (Wire)((Object)this.wires.elementAt(i));
            if (wire == wire2) continue;
            dArray[0] = d;
            dArray[1] = d2;
            dArray = wire2.getB(dArray);
            d3 += dArray[0];
            d4 += dArray[1];
        }
        return new double[]{d3, d4};
    }

    final double getBx(double d, double d2, Wire wire) {
        double d3 = 0.0;
        if (this.parserBx != null) {
            d3 = this.parserBx.evaluate(d, d2);
        }
        if (this.wires == null) {
            return d3;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = this.wires.size();
        for (int i = 0; i < n; ++i) {
            Wire wire2 = (Wire)((Object)this.wires.elementAt(i));
            if (wire == wire2) continue;
            d3 += wire2.getWireBx(d, d2);
        }
        return d3;
    }

    final double getBy(double d, double d2, Wire wire) {
        double d3 = 0.0;
        if (this.parserBy != null) {
            d3 = this.parserBy.evaluate(d, d2);
        }
        if (this.wires == null) {
            return d3;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = this.wires.size();
        for (int i = 0; i < n; ++i) {
            Wire wire2 = (Wire)((Object)this.wires.elementAt(i));
            if (wire == wire2) continue;
            d3 += wire2.getWireBy(d, d2);
        }
        return d3;
    }

    public void paint(Graphics graphics) {
        if (this.getSize().width == 0 || this.getSize().height == 0) {
            return;
        }
        if (this.osi == null || this.osiInvalid || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            if (this.getSize().width == 0) {
                return;
            }
            this.paintOSI();
        }
        if (!this.autoRefresh) {
            return;
        }
        graphics.drawImage(this.osi, 0, 0, this);
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        this.paintMessage(graphics, this.message);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        if (this.caption != null) {
            graphics.drawString(this.caption, (this.iwidth - fontMetrics.stringWidth(this.caption)) / 2, 25);
        }
        graphics.setFont(font);
    }

    public void paintMessage(Graphics graphics, String string) {
        if (string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        graphics.setColor(Color.yellow);
        int n = 15 + fontMetrics.stringWidth(string);
        graphics.fillRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, this.iwidth - n + 2, this.iheight - 3);
    }

    public void paintThings(Graphics graphics) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.paint(graphics);
            if (!(thing instanceof Wire) || !((Wire)thing).isShowF()) continue;
            this.paintForceOnWire(graphics, (Wire)thing);
        }
    }

    public void paintArrowHeads(Graphics graphics, Rectangle rectangle) {
        int n = this.arrowHeads.size();
        for (int i = 0; i < n; ++i) {
            ArrowHead arrowHead = (ArrowHead)this.arrowHeads.elementAt(i);
            arrowHead.paint(graphics, rectangle);
        }
    }

    void paintForceOnWire(Graphics graphics, Wire wire) {
        double d = wire.getX() - wire.xo;
        double d2 = wire.getY() - wire.yo;
        double d3 = wire.getCurrent();
        double[] dArray = this.getB(d, d2, wire);
        double d4 = dArray[0];
        double d5 = dArray[1];
        int n = this.pixFromX(d);
        int n2 = this.pixFromY(d2);
        int n3 = this.pixFromX(d - d3 * d5);
        int n4 = this.pixFromY(d2 + d3 * d4);
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        SUtil.drawArrow((Graphics)graphics, (int)n, (int)n2, (int)n3, (int)n4);
        graphics.setColor(color);
    }

    void paintCoordinates(Graphics graphics, double d, double d2) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        String string = "";
        if (this.showCoordOnDrag) {
            string = String.valueOf(String.valueOf(new StringBuffer("x=").append(this.format.form(d)).append(" y=").append(this.format.form(d2))));
        }
        boolean bl = this.isInsideAnyWire(d, d2);
        if (this.dragWire != null && this.dragWire.isShowF()) {
            double[] dArray = this.getB(d, d2, this.dragWire);
            double d3 = dArray[0];
            double d4 = dArray[1];
            double d5 = Math.abs(this.dragWire.getCurrent()) * Math.sqrt(d3 * d3 + d4 * d4);
            string = bl ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.owner.label_force_undefined))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" |F|=").append(this.format.form(d5)).append("N/m ")));
        } else if (this.showBOnDrag) {
            double[] dArray = this.getB(d, d2, null);
            double d6 = dArray[0];
            double d7 = dArray[1];
            string = this.dragWire != null && !(this.dragWire instanceof Coil) || bl ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.owner.label_field_undefined))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" |B|=").append(this.format.form(Math.sqrt(d6 * d6 + d7 * d7)))));
        }
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, this.getBounds().height - 15, this.boxWidth, 15);
        this.boxWidth = 20 + fontMetrics.stringWidth(string);
        graphics.fillRect(0, this.getBounds().height - 15, this.boxWidth, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, 8, this.getBounds().height - 2);
    }

    public void paintOSI() {
        Object object;
        this.owner.lock.getBusyFlag();
        if (this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.iwidth = this.getSize().width;
            this.iheight = this.getSize().height;
            this.osi = object = this.createImage(this.iwidth, this.iheight);
            this.setXRange(this.xmin, this.xmax);
            this.setFields();
        }
        if (this.osi == null) {
            this.owner.lock.freeBusyFlag();
            return;
        }
        object = this.osi.getGraphics();
        if (object == null) {
            this.owner.lock.freeBusyFlag();
            return;
        }
        ((Graphics)object).setColor(Color.white);
        ((Graphics)object).fillRect(0, 0, this.iwidth, this.iheight);
        this.osiInvalid = false;
        if (this.graph != null) {
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            this.graph.paint((Graphics)object, rectangle);
            rectangle.width = this.pixFromX(this.xFromPix(this.iwidth)) - this.pixFromX(this.xFromPix(0));
            rectangle.height = this.pixFromY(this.yFromPix(this.iheight)) - this.pixFromY(this.yFromPix(0));
            this.fieldBounds = rectangle;
            this.paintArrowHeads((Graphics)object, rectangle);
            if (this.showWires) {
                this.paintThings((Graphics)object);
            }
            if (this.showFieldVectors && this.fieldThing == null) {
                this.field.paint((Graphics)object, rectangle);
            }
        } else {
            ((Graphics)object).setColor(this.getBackground());
            ((Graphics)object).fillRect(0, 0, this.iwidth, this.iheight);
            ((Graphics)object).setColor(((Graphics)object).getColor());
        }
        ((Graphics)object).setColor(Color.black);
        ((Graphics)object).drawRect(0, 0, this.iwidth - 1, this.iheight - 1);
        ((Graphics)object).dispose();
        this.owner.lock.freeBusyFlag();
    }

    public double xFromPix(int n) {
        if (this.graph != null) {
            return this.graph.xFromPix(n);
        }
        return n;
    }

    public int pixFromX(double d) {
        if (this.graph != null) {
            return this.graph.pixFromX(d);
        }
        return (int)Math.round(d);
    }

    public double yFromPix(int n) {
        if (this.graph != null) {
            return this.graph.yFromPix(n);
        }
        return n;
    }

    public int pixFromY(double d) {
        if (this.graph != null) {
            return this.graph.pixFromY(d);
        }
        return (int)Math.round(d);
    }

    void wire_Dragged(MouseEvent mouseEvent, boolean bl) {
        int n = mouseEvent.getX();
        if (n < 1) {
            n = 1;
        } else if (n > this.iwidth - 2) {
            n = this.iwidth - 2;
        }
        int n2 = mouseEvent.getY();
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.iheight - 2) {
            n2 = this.iheight - 2;
        }
        double d = this.xFromPix(n);
        double d2 = this.yFromPix(n2);
        if (this.isDrag) {
            Graphics graphics = this.getGraphics();
            if (this.dragWire != null) {
                this.owner.lock.getBusyFlag();
                if (this.osi == null) {
                    this.osi = this.createImage(this.iwidth, this.iheight);
                }
                this.osiInvalid = false;
                Graphics graphics2 = this.osi.getGraphics();
                Rectangle rectangle = this.getBounds();
                rectangle.x = 0;
                rectangle.y = 0;
                graphics2.setColor(Color.white);
                graphics2.fillRect(0, 0, this.iwidth, this.iheight);
                if (this.hotSpot == 0) {
                    this.dragWire.setXY(d, d2);
                    this.dragWire.updateMySlaves();
                } else if (this.hotSpot == 1) {
                    this.dragWire.radius = Math.abs(d2 - this.dragWire.getY());
                    if (d2 < this.dragWire.getY()) {
                        this.hotSpot = -1;
                        this.dragWire.current = -this.dragWire.current;
                    }
                } else if (this.hotSpot == -1) {
                    this.dragWire.radius = Math.abs(d2 - this.dragWire.getY());
                    if (d2 > this.dragWire.getY()) {
                        this.hotSpot = 1;
                        this.dragWire.current = -this.dragWire.current;
                    }
                }
                if (bl || this.fieldThing != null && this.fieldThing.isVisible()) {
                    this.setDirectionVectors();
                    rectangle.width = this.pixFromX(this.xFromPix(this.iwidth)) - this.pixFromX(this.xFromPix(0));
                    rectangle.height = this.pixFromY(this.yFromPix(this.iheight)) - this.pixFromY(this.yFromPix(0));
                }
                if (this.showWires) {
                    this.paintThings(graphics2);
                }
                if (bl && this.fieldThing == null) {
                    this.field.paint(graphics2, rectangle);
                }
                this.dragWire.paintInfo(graphics2, this.hotSpot);
                if (this.dragWire.isShowF()) {
                    this.paintForceOnWire(graphics2, this.dragWire);
                }
                graphics2.dispose();
                graphics.drawImage(this.osi, 0, 0, this);
                this.owner.lock.freeBusyFlag();
                if (this.owner != null) {
                    this.owner.updateDataConnections();
                }
            }
            graphics.setPaintMode();
            this.paintCoordinates(graphics, d, d2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.iwidth - 1, this.iheight - 1);
            graphics.dispose();
        }
    }

    void wire_Moved(double d, double d2) {
        Graphics graphics = this.getGraphics();
        this.owner.lock.getBusyFlag();
        if (this.osi == null) {
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        this.osiInvalid = false;
        Graphics graphics2 = this.osi.getGraphics();
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, this.iwidth, this.iheight);
        this.setDirectionVectors();
        rectangle.width = this.pixFromX(this.xFromPix(this.iwidth)) - this.pixFromX(this.xFromPix(0));
        rectangle.height = this.pixFromY(this.yFromPix(this.iheight)) - this.pixFromY(this.yFromPix(0));
        if (this.showWires) {
            this.paintThings(graphics2);
        }
        if (this.fieldThing == null) {
            this.field.paint(graphics2, rectangle);
        }
        graphics2.dispose();
        graphics.drawImage(this.osi, 0, 0, this);
        this.owner.lock.freeBusyFlag();
        graphics.setPaintMode();
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.iwidth - 1, this.iheight - 1);
        this.paintCoordinates(graphics, d, d2);
        graphics.dispose();
    }

    void setShowFieldVectors(boolean bl) {
        this.showFieldVectors = bl;
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    void setShowFieldLineOnClick(boolean bl) {
        this.showFieldLineOnClick = bl;
        this.showFieldLineOnDoubleClick = false;
    }

    void setShowFieldLineOnDoubleClick(boolean bl) {
        this.showFieldLineOnDoubleClick = bl;
        this.showFieldLineOnClick = false;
    }

    boolean setLabel(int n, String string) {
        Wire wire = this.getWireFromID(n);
        if (wire == null) {
            return false;
        }
        wire.setLabel(string);
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
    }

    boolean setColor(int n, Color color) {
        Thing thing = this.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setColor(color);
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    public boolean setCurrent(int n, double d) {
        Wire wire = this.getWireFromID(n);
        if (wire == null) {
            return false;
        }
        wire.setCurrent(d);
        if (this.autoRefresh) {
            this.setFields();
        }
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    public boolean setRadius(int n, double d) {
        Wire wire = this.getWireFromID(n);
        if (wire == null) {
            return false;
        }
        wire.setRadius(d);
        if (this.autoRefresh) {
            this.setFields();
        }
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    public boolean setDragable(int n, boolean bl) {
        Thing thing = this.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDragable(bl);
        return true;
    }

    boolean setOptionDrag(int n, boolean bl) {
        Wire wire = this.getWireFromID(n);
        if (wire == null) {
            return false;
        }
        wire.noOptionDrag = !bl;
        return true;
    }

    boolean setVisibility(int n, boolean bl) {
        Thing thing = this.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setVisible(bl);
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    boolean setShowForce(int n, boolean bl) {
        Wire wire = this.getWireFromID(n);
        if (wire == null) {
            return false;
        }
        wire.setShowF(bl);
        return true;
    }

    boolean setShowFComponents(int n, boolean bl) {
        Wire wire = this.getWireFromID(n);
        if (wire == null) {
            return false;
        }
        wire.setShowFComponents(bl);
        return true;
    }

    boolean setShowInfo(int n, boolean bl) {
        Wire wire = this.getWireFromID(n);
        if (wire == null) {
            return false;
        }
        wire.showInfo = bl;
        return true;
    }

    void setShowCoordOnDrag(boolean bl) {
        this.showCoordOnDrag = bl;
    }

    void setShowBOnDrag(boolean bl) {
        this.showBOnDrag = bl;
    }

    void setDefault() {
        this.owner.lock.getBusyFlag();
        this.stopFieldThreads();
        this.tolerance = 1.0E-5;
        this.message = null;
        this.showFieldLineOnClick = false;
        this.showFieldLineOnDoubleClick = false;
        this.showTime = true;
        this.showCoordOnDrag = true;
        this.showBOnDrag = false;
        this.setXRange(this.xmin, this.xmax);
        this.message = null;
        this.fieldThing = null;
        this.wires.removeAllElements();
        this.things.removeAllElements();
        this.arrowHeads.removeAllElements();
        this.owner.lock.freeBusyFlag();
        if (this.autoRefresh) {
            this.setFields();
        }
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    void reset() {
        this.owner.lock.getBusyFlag();
        this.stopFieldThreads();
        this.owner.lock.freeBusyFlag();
        if (this.autoRefresh) {
            this.setFields();
        }
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public int setSketchMode(boolean bl) {
        this.sketchImage = Util.getImage((String)"pencil.gif", (Applet)((Object)this.owner));
        boolean bl2 = false;
        int n = 29;
        this.sketchMode = bl;
        if (!bl) {
            this.trailThing = null;
            return 0;
        }
        this.trailThing = new SketchThing(this.owner, this, 1);
        this.trailThing.setTrailSize(2000);
        return ((Object)((Object)this.trailThing)).hashCode();
    }

    void setGridSize(int n) {
        this.gridSize = n;
        if (this.autoRefresh) {
            this.setFields();
        }
        this.osiInvalid = true;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    void setDirectionVectors() {
        int n = this.gridSize;
        int n2 = this.gridSize;
        double[][][] dArray = this.field.resize(n2, n);
        double d = this.xFromPix(0);
        double d2 = this.xFromPix(this.iwidth);
        double d3 = this.yFromPix(this.iheight);
        double d4 = this.yFromPix(0);
        for (int i = 0; i < n; ++i) {
            double d5 = (d2 - d) * (double)i / (double)(n - 1) + d;
            for (int j = 0; j < n2; ++j) {
                double d6;
                double d7 = (d4 - d3) * (double)j / (double)(n2 - 1) + d3;
                double[] dArray2 = this.getB(d5, d7, null);
                double d8 = dArray2[0];
                double d9 = Math.sqrt(d8 * d8 + (d6 = dArray2[1]) * d6);
                if (d9 > 0.0) {
                    dArray[j][i][0] = d8 / d9;
                    dArray[j][i][1] = d6 / d9;
                    dArray[j][i][2] = d9;
                    continue;
                }
                dArray[j][i][0] = 0.0;
                dArray[j][i][1] = 0.0;
                dArray[j][i][2] = 0.0;
            }
        }
    }

    public final boolean setFormat(String string) {
        try {
            this.format = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public synchronized boolean swapZOrder(int n, int n2) {
        Thing thing = this.getThing(n);
        Thing thing2 = this.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        int n3 = this.things.indexOf(thing);
        int n4 = this.things.indexOf(thing2);
        this.things.removeElementAt(n3);
        this.things.insertElementAt(thing2, n3);
        this.things.removeElementAt(n4);
        this.things.insertElementAt(thing, n4);
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    void stopFieldThreads() {
        Vector vector;
        Vector vector2 = this.fieldSolvers;
        synchronized (vector2) {
            vector = (Vector)this.fieldSolvers.clone();
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            FieldSolver fieldSolver = (FieldSolver)vector.elementAt(i);
            fieldSolver.interrupted = true;
        }
        this.arrowHeads.removeAllElements();
        vector = null;
    }

    void setFields() {
        this.owner.lock.getBusyFlag();
        this.stopFieldThreads();
        int n = this.gridSize;
        int n2 = this.gridSize;
        this.graph.deleteAllSeries();
        this.arrowHeads.removeAllElements();
        double d = this.xFromPix(0);
        double d2 = this.xFromPix(this.iwidth);
        double d3 = this.yFromPix(this.iheight);
        double d4 = this.yFromPix(0);
        double[][][] dArray = this.field.resize(n2, n);
        for (int i = 0; i < n; ++i) {
            double d5 = (d2 - d) * (double)i / (double)(n - 1) + d;
            for (int j = 0; j < n2; ++j) {
                double d6;
                double d7 = (d4 - d3) * (double)j / (double)(n2 - 1) + d3;
                double[] dArray2 = this.getB(d5, d7, null);
                double d8 = dArray2[0];
                double d9 = Math.sqrt(d8 * d8 + (d6 = dArray2[1]) * d6);
                if (d9 > 0.0) {
                    dArray[j][i][0] = d8 / d9;
                    dArray[j][i][1] = d6 / d9;
                    dArray[j][i][2] = d9;
                    continue;
                }
                dArray[j][i][0] = 0.0;
                dArray[j][i][1] = 0.0;
                dArray[j][i][2] = 0.0;
            }
        }
        this.osiInvalid = true;
        this.owner.lock.freeBusyFlag();
    }

    public void setXRange(double d, double d2) {
        if (d2 == d) {
            this.xmin = d - 0.5;
            this.xmax = d2 + 0.5;
        } else if (d2 > d) {
            this.xmin = d;
            this.xmax = d2;
        } else {
            this.xmin = d2;
            this.xmax = d;
        }
        if (this.iwidth == 0) {
            return;
        }
        double d3 = (this.xmax - this.xmin) / (double)this.iwidth;
        this.ymin = (this.ymax + this.ymin) / (double)2 - d3 * (double)this.iheight / 2.0;
        this.ymax = this.ymin + d3 * (double)this.iheight;
        this.graph.setMinMaxX(this.xmin, this.xmax);
        this.graph.setMinMaxY(this.ymin, this.ymax);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        if (this.isInsideDragableThing(mouseEvent.getX(), mouseEvent.getY())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (this.sketchMode) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.boxWidth = 0;
        int n = mouseEvent.getX();
        if (n < 1) {
            n = 1;
        } else if (n > this.iwidth - 2) {
            n = this.iwidth - 2;
        }
        int n2 = mouseEvent.getY();
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.iheight - 2) {
            n2 = this.iheight - 2;
        }
        double d = this.xFromPix(n);
        double d2 = this.yFromPix(n2);
        if (this.dragWire != null) {
            if (this.hotSpot == 0) {
                this.dragWire.setXY(d, d2);
                this.dragWire.updateMySlaves();
            } else if (this.hotSpot == 1) {
                this.dragWire.radius = Math.abs(d2 - this.dragWire.getY());
                if (d2 < this.dragWire.getY()) {
                    this.hotSpot = -1;
                    this.dragWire.current = -this.dragWire.current;
                }
            } else if (this.hotSpot == -1) {
                this.dragWire.radius = Math.abs(d2 - this.dragWire.getY());
                if (d2 > this.dragWire.getY()) {
                    this.hotSpot = 1;
                    this.dragWire.current = -this.dragWire.current;
                }
            }
            this.setFields();
            if (this.owner != null) {
                this.owner.updateDataConnections();
            }
        } else if (this.dragThing != null) {
            if (this.containsWires(this.dragThing)) {
                this.setFields();
            }
            this.dragThing.setXY(d, d2);
            this.dragThing.updateMySlaves();
            this.osiInvalid = true;
            if (this.owner != null) {
                this.owner.updateDataConnections();
            }
        }
        this.isDrag = false;
        this.dragWire = null;
        this.dragThing = null;
        this.hotSpot = 0;
        if (this.sketchMode && this.trailThing != null) {
            DataSet dataSet = this.trailThing.getDataSet();
            this.graph.attachDataSet(dataSet);
            this.graph.xaxis.attachDataSet(dataSet);
            this.graph.yaxis.attachDataSet(dataSet);
            this.osiInvalid = true;
        }
        this.this_mouseMoved(mouseEvent);
        this.repaint();
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        double d = this.xFromPix(n);
        double d2 = this.yFromPix(n2);
        if (this.showFieldLineOnClick || mouseEvent.getClickCount() == 2 && this.showFieldLineOnDoubleClick) {
            new FieldSolver(d, d2, true);
            return;
        }
        this.isDrag = true;
        this.dragWire = null;
        this.dragThing = null;
        Object object = this.things.elements();
        while (object.hasMoreElements()) {
            Thing thing = (Thing)object.nextElement();
            if (thing.isNoDrag() || !thing.isInsideThing(n, n2)) continue;
            this.dragThing = thing;
        }
        if (this.dragThing instanceof Wire) {
            this.dragWire = (Wire)this.dragThing;
        }
        if (this.dragWire != null) {
            this.hotSpot = this.dragWire.getHotSpot(n, n2);
            if (this.hotSpot == 0) {
                this.dragWire.setXY(d, d2);
                this.dragWire.updateMySlaves();
            } else if (this.hotSpot == 1) {
                this.dragWire.radius = Math.abs(d2 - this.dragWire.getY());
                if (d2 < this.dragWire.getY()) {
                    this.hotSpot = -1;
                    this.dragWire.current = -this.dragWire.current;
                }
            } else if (this.hotSpot == -1) {
                this.dragWire.radius = Math.abs(d2 - this.dragWire.getY());
                if (d2 > this.dragWire.getY()) {
                    this.hotSpot = 1;
                    this.dragWire.current = -this.dragWire.current;
                }
            }
            if (this.owner != null) {
                this.owner.updateDataConnections();
            }
        } else if (this.dragThing != null) {
            this.dragThing.setXY(d, d2);
            this.dragThing.updateMySlaves();
            if (this.owner != null) {
                this.owner.updateDataConnections();
            }
        }
        this.paintOSI();
        object = this.getGraphics();
        this.paint((Graphics)object);
        this.paintCoordinates((Graphics)object, d, d2);
        ((Graphics)object).dispose();
        if (this.sketchMode && this.trailThing != null) {
            this.trailThing.clearTrail();
            this.owner.clearData(((Object)((Object)this.trailThing)).hashCode());
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.this_mouseDragged(mouseEvent);
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        if (this.dragWire != null) {
            this.wire_Dragged(mouseEvent, this.showFieldVectors);
            return;
        }
        int n = mouseEvent.getX();
        if (n < 1) {
            n = 1;
        } else if (n > this.iwidth - 2) {
            n = this.iwidth - 2;
        }
        int n2 = mouseEvent.getY();
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.iheight - 2) {
            n2 = this.iheight - 2;
        }
        double d = this.xFromPix(n);
        double d2 = this.yFromPix(n2);
        Graphics graphics = null;
        if (this.isDrag && !this.sketchMode) {
            if (this.dragThing != null) {
                this.dragThing.setXY(d, d2);
                this.dragThing.updateMySlaves();
                this.owner.updateDataConnection(this.dragThing.hashCode());
            }
            if (this.dragThing != null && this.containsWires(this.dragThing)) {
                this.wire_Moved(d, d2);
                return;
            }
            this.paintOSI();
            graphics = this.getGraphics();
            this.paint(graphics);
            this.paintCoordinates(graphics, d, d2);
            graphics.dispose();
        }
        if (this.sketchMode && this.trailThing != null) {
            graphics = this.getGraphics();
            this.trailThing.incTrail(d, d2);
            graphics = this.getGraphics();
            this.paint(graphics);
            this.trailThing.paint(graphics);
            this.paintCoordinates(graphics, d, d2);
            if (this.sketchImage != null) {
                graphics.drawImage(this.sketchImage, n, n2 - this.sketchImage.getHeight(this), this);
            }
            graphics.dispose();
            this.owner.updateDataConnection(((Object)((Object)this.trailThing)).hashCode());
        }
    }

    private boolean containsWires(Thing thing) {
        if (thing == null) {
            return false;
        }
        Vector vector = thing.getSlaves();
        if (vector == null) {
            return false;
        }
        Thing thing2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            thing2 = (Thing)enumeration.nextElement();
            if (!(thing2 instanceof Wire)) continue;
            return true;
        }
        return false;
    }

    boolean setRange(String string) {
        boolean bl = false;
        double[] dArray = new double[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ", ; / \\ ( { [ ) } ] \t \n \r");
        if (stringTokenizer.countTokens() < 4) {
            bl = true;
        } else {
            for (int i = 0; i < 4; ++i) {
                try {
                    dArray[i] = Double.valueOf(stringTokenizer.nextToken().trim());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Error setting range:".concat(String.valueOf(String.valueOf(string))));
                    bl = true;
                }
            }
        }
        if (bl) {
            return false;
        }
        this.xmin = dArray[0];
        this.xmax = dArray[1];
        this.ymin = dArray[2];
        this.ymax = dArray[3];
        return true;
    }

    private boolean parseBx(String string) {
        this.bxStr = string.trim();
        if (this.bxStr.equals("") || this.bxStr.equals("0")) {
            this.parserBx = null;
            return true;
        }
        this.parserBx = new Parser(2);
        this.parserBx.defineVariable(1, "x");
        this.parserBx.defineVariable(2, "y");
        this.parserBx.define(this.bxStr);
        this.parserBx.parse();
        if (this.parserBx.getErrorCode() != 0) {
            System.out.println("Failed to parse Bx(x,y): ".concat(String.valueOf(String.valueOf(this.bxStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parserBx.getErrorString()).append(" at function 1, position ").append(this.parserBx.getErrorPosition()))));
            return false;
        }
        return true;
    }

    private boolean parseBy(String string) {
        this.byStr = string.trim();
        if (this.byStr.equals("") || this.byStr.equals("0")) {
            this.parserBy = null;
            return true;
        }
        this.parserBy = new Parser(2);
        this.parserBy.defineVariable(1, "x");
        this.parserBy.defineVariable(2, "y");
        this.parserBy.define(this.byStr);
        this.parserBy.parse();
        if (this.parserBy.getErrorCode() != 0) {
            System.out.println("Failed to parse By(x,y): ".concat(String.valueOf(String.valueOf(this.byStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parserBy.getErrorString()).append(" at function 1, position ").append(this.parserBy.getErrorPosition()))));
            return false;
        }
        return true;
    }

    boolean setBFunctions(String string, String string2) {
        this.owner.lock.getBusyFlag();
        if (this.parseBx(string) && this.parseBy(string2)) {
            if (this.autoRefresh) {
                this.setFields();
                this.repaint();
            }
            this.owner.lock.freeBusyFlag();
            return true;
        }
        this.owner.lock.freeBusyFlag();
        return false;
    }

    public boolean setBFunctions(String string, String string2, double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
        return this.setBFunctions(string, string2);
    }

    class FieldSolver
    implements Runnable,
    SDifferentiable {
        Color fieldColor = Color.black;
        SRK45 odeSolver = new SRK45();
        Thread fieldThread = null;
        double[] fieldLine = new double[2];
        boolean plus = true;
        boolean keepRunning = true;
        boolean outOfBounds = false;
        boolean interrupted = false;
        DataSet data;
        int np = 0;
        int maxPts = 150;
        double[] points = new double[2 * this.maxPts];
        int scale = 1;
        private double[] dydx = new double[2];
        private double res = 0.0;

        FieldSolver(double d, double d2, boolean bl) {
            this.plus = bl;
            this.fieldLine[0] = d;
            this.fieldLine[1] = d2;
            this.points[this.np] = d;
            this.points[this.np + 1] = d2;
            this.np += 2;
            this.odeSolver.setDifferentials((SDifferentiable)this);
            this.odeSolver.setTol(FieldPanel.this.tolerance);
            if (this.fieldThread == null) {
                this.fieldThread = new Thread(this);
                this.fieldThread.start();
            }
            FieldPanel.this.fieldSolvers.addElement(this);
            this.res = FieldPanel.this.graph.xFromPix(3) - FieldPanel.this.graph.xFromPix(0);
        }

        public int getNumEqu() {
            return 2;
        }

        public double[] rate(double[] dArray) {
            double[] dArray2 = FieldPanel.this.getB(dArray[0], dArray[1], null);
            double d = dArray2[0];
            double d2 = dArray2[1];
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (!this.plus) {
                d2 = -d2;
                d = -d;
            }
            if (d3 <= 0.0) {
                this.dydx[0] = 0.0;
                this.dydx[1] = 0.0;
                this.keepRunning = false;
            } else {
                this.dydx[0] = (double)this.scale * d / d3;
                this.dydx[1] = (double)this.scale * d2 / d3;
            }
            return this.dydx;
        }

        boolean stepField() {
            double d = (FieldPanel.this.xmax - FieldPanel.this.xmin) / 25.0;
            this.odeSolver.setH(d);
            this.odeSolver.stepRK45(this.fieldLine);
            int n = FieldPanel.this.pixFromX(this.fieldLine[0]);
            int n2 = FieldPanel.this.pixFromY(this.fieldLine[1]);
            if (this.np < this.maxPts * 2) {
                this.points[this.np] = this.fieldLine[0];
                this.points[this.np + 1] = this.fieldLine[1];
                this.np += 2;
            }
            if (n < -30 || n2 < -30 || n > FieldPanel.this.iwidth + 30 || n2 > FieldPanel.this.iheight + 30) {
                this.outOfBounds = true;
                return false;
            }
            if (this.np > 4 && this.insideBox(this.fieldLine[0], this.fieldLine[1], this.points[0], this.points[1], this.points[2], this.points[3])) {
                this.outOfBounds = false;
                return false;
            }
            return true;
        }

        boolean insideBox(double d, double d2, double d3, double d4, double d5, double d6) {
            double d7;
            if (d3 > d5) {
                d7 = d5;
                d5 = d3;
                d3 = d7;
            }
            if (d4 > d6) {
                d7 = d6;
                d6 = d4;
                d4 = d7;
            }
            return d >= d3 - this.res && d <= d5 + this.res && d2 >= d4 - this.res && d2 <= d6 + this.res;
        }

        public void run() {
            int n = 0;
            this.keepRunning = true;
            while (this.keepRunning && !this.interrupted) {
                try {
                    while (FieldPanel.this.osi == null) {
                        Thread.sleep(50L);
                    }
                    if (!this.interrupted) {
                        this.keepRunning = this.stepField();
                    }
                    if (!this.interrupted) {
                        Thread.sleep(20L);
                    }
                    if (++n < this.maxPts) continue;
                    this.keepRunning = false;
                    this.outOfBounds = true;
                }
                catch (InterruptedException interruptedException) {}
            }
            FieldPanel.this.fieldSolvers.removeElement(this);
            if (this.interrupted) {
                this.fieldThread.stop();
                this.fieldThread = null;
                return;
            }
            ((FieldPanel)FieldPanel.this).owner.lock.getBusyFlag();
            this.data = FieldPanel.this.graph.addDataSet(this.points, n);
            this.data.linecolor = this.fieldColor;
            ((FieldPanel)FieldPanel.this).owner.lock.freeBusyFlag();
            int n2 = 0;
            double d = this.points[n2 * 2];
            double d2 = this.points[n2 * 2 + 1];
            double[] dArray = FieldPanel.this.getB(d, d2, null);
            double d3 = dArray[0];
            double d4 = dArray[1];
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            FieldPanel.this.arrowHeads.addElement(new ArrowHead(FieldPanel.this, d, d2, d3 / d5, d4 / d5, this.fieldColor));
            n2 = n / 2;
            if (n2 > 20) {
                d = this.points[n2 * 2];
                d2 = this.points[n2 * 2 + 1];
                if (d > FieldPanel.this.xmin && d < FieldPanel.this.xmax && d2 > FieldPanel.this.ymin && d2 < FieldPanel.this.ymax) {
                    dArray = FieldPanel.this.getB(d, d2, null);
                    d3 = dArray[0];
                    d4 = dArray[1];
                    d5 = Math.sqrt(d3 * d3 + d4 * d4);
                    FieldPanel.this.arrowHeads.addElement(new ArrowHead(FieldPanel.this, d, d2, d3 / d5, d4 / d5, this.fieldColor));
                }
            }
            FieldPanel.this.osiInvalid = true;
            FieldPanel.this.repaint();
            if (this.plus && this.outOfBounds && this.points != null) {
                new FieldSolver(this.points[0], this.points[1], false);
            }
            this.points = null;
            this.fieldThread.stop();
            this.fieldThread = null;
        }
    }
}

