/*
 * Decompiled with CFR 0.152.
 */
package bfield;

import bfield.FieldPanel;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class Wire
extends Thing {
    boolean noOptionDrag = true;
    boolean showInfo = false;
    protected boolean showF = true;
    protected boolean showFComponents = false;
    double xo = 0.0;
    double yo = 0.0;
    FieldPanel p;
    double current = 1.0;
    double radius = 0.0;
    int xPix = 0;
    int yPix = 0;

    public Wire(FieldPanel fieldPanel, double d, double d2, double d3) {
        super((SScalable)fieldPanel, d, d2);
        this.s = 10;
        this.p = fieldPanel;
        this.current = d3;
        if (d3 < 0.0) {
            this.color = Color.blue;
        } else if (d3 > 0.0) {
            this.color = Color.red;
        }
        this.varStrings = new String[]{"x", "y", "bx", "by", "i"};
        this.ds = new double[1][5];
    }

    public void setDisplayOff(int n, int n2) {
        this.xDisplayOff = n;
        this.yDisplayOff = n2;
        this.xo = this.p.xFromPix(0) - this.p.xFromPix(n);
        this.yo = this.p.yFromPix(0) - this.p.yFromPix(-n2);
    }

    double[] getB(double[] dArray) {
        double d = this.x - this.xo;
        double d2 = this.y - this.yo;
        double d3 = (d - dArray[0]) * (d - dArray[0]) + (d2 - dArray[1]) * (d2 - dArray[1]);
        double d4 = -this.current * (dArray[1] - d2) / d3;
        double d5 = this.current * (dArray[0] - d) / d3;
        dArray[0] = d4;
        dArray[1] = d5;
        return dArray;
    }

    double getWireBx(double d, double d2) {
        double d3 = this.x - this.xo;
        double d4 = this.y - this.yo;
        return -this.current * (d2 - d4) / ((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
    }

    double getWireBy(double d, double d2) {
        double d3 = this.x - this.xo;
        double d4 = this.y - this.yo;
        return this.current * (d - d3) / ((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
    }

    final double getCurrent() {
        return this.current;
    }

    final void setCurrent(double d) {
        this.current = d;
    }

    public final int getID() {
        return ((Object)((Object)this)).hashCode();
    }

    public SApplet getOwner() {
        return this.p.getOwner();
    }

    public void setOwner(SApplet sApplet) {
    }

    final double getRadius() {
        return this.radius;
    }

    final void setRadius(double d) {
        this.radius = d;
    }

    void setShowF(boolean bl) {
        this.showF = bl;
    }

    boolean isShowF() {
        return this.showF;
    }

    void setShowFComponents(boolean bl) {
        this.showFComponents = bl;
    }

    boolean isShowFComponents() {
        return this.showFComponents;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public final double[][] getVariables() {
        this.ds[0][0] = this.x;
        this.ds[0][1] = this.y;
        this.ds[0][2] = this.p.getBx(this.x, this.y, this);
        this.ds[0][3] = this.p.getBy(this.x, this.y, this);
        this.ds[0][4] = this.current;
        return this.ds;
    }

    final double getMaxB() {
        double d;
        double d2 = this.p.xFromPix(0);
        double d3 = d2 - (d = this.p.xFromPix(this.s));
        if (d3 != 0.0) {
            return Math.abs(this.current / d3);
        }
        return 0.0;
    }

    boolean isInsidePix(int n, int n2) {
        if (this.noDrag) {
            return false;
        }
        return Math.abs(this.xPix - n) < this.s + 1 && Math.abs(this.yPix - n2) < this.s + 1;
    }

    public boolean isInsideThing(int n, int n2) {
        return this.isInsidePix(n, n2);
    }

    int getHotSpot(int n, int n2) {
        return 0;
    }

    boolean isInsideWire(double d, double d2, int n) {
        if (n != 0) {
            return false;
        }
        return this.isInsidePix(this.p.pixFromX(d), this.p.pixFromY(d2));
    }

    final boolean isInsideWire(double d, double d2) {
        return this.isInsidePix(this.p.pixFromX(d), this.p.pixFromY(d2));
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.xPix = this.p.pixFromX(this.x) + this.xDisplayOff;
        this.yPix = this.p.pixFromY(this.y) - this.yDisplayOff;
        graphics.setColor(this.color);
        graphics.fillOval(this.xPix - this.s / 2, this.yPix - this.s / 2, this.s, this.s);
        if (this.label != null) {
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            graphics.setColor(Color.white);
            graphics.drawString(this.label, this.xPix - 4, this.yPix + 5);
            graphics.setColor(Color.black);
            graphics.setFont(font);
        }
    }

    public void paintInfo(Graphics graphics, int n) {
        if (!this.showInfo && n == 0) {
            return;
        }
        graphics.setColor(Color.yellow);
        graphics.fillRect(this.xPix + 15, this.yPix - 8, 60, 15);
        graphics.setColor(Color.black);
        if (!this.noOptionDrag && Math.abs(n) == 1) {
            graphics.drawString("R =".concat(String.valueOf(String.valueOf(this.format.form(this.radius)))), this.xPix + 20, this.yPix + 5);
        }
        if (Math.abs(n) == 0) {
            graphics.drawString("I =".concat(String.valueOf(String.valueOf(this.format.form(this.current)))), this.xPix + 20, this.yPix + 5);
        }
    }
}

