/*
 * Decompiled with CFR 0.152.
 */
package minkowski;

import edu.davidson.display.SNumber;
import edu.davidson.display.SSlider;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.graphics.SPanel;
import edu.davidson.tools.SApplet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeListener;
import minkowski.MinkowskiCanvas;
import minkowski.VerticalFlowLayout;

public class Minkowski
extends SApplet {
    private String button_clear = "Clear";
    private String button_add = "Add";
    private String label_speed = "speed =";
    double speed;
    String mode;
    boolean showControls;
    EtchedBorder etchedBorder1 = new EtchedBorder();
    BorderLayout borderLayout1 = new BorderLayout();
    SPanel coordPanel = new SPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    MinkowskiCanvas minkowskiCanvas = new MinkowskiCanvas(this);
    Panel panel2 = new Panel();
    EtchedBorder box2 = new EtchedBorder();
    Panel panel4 = new Panel();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    Button addMovingBtn = new Button();
    Button clearMovingBtn = new Button();
    Panel panel8 = new Panel();
    Label yPrimeLabel = new Label();
    SNumber yPrimeField = new SNumber();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    Label label1 = new Label();
    SNumber xPrimeField = new SNumber();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Label label5 = new Label();
    Label yLabel = new Label();
    Button addLabBtn = new Button();
    Button clearLabBtn = new Button();
    SNumber yField = new SNumber();
    SNumber xField = new SNumber();
    VerticalFlowLayout verticalFlowLayout4 = new VerticalFlowLayout();
    EtchedBorder box4 = new EtchedBorder();
    Panel panel10 = new Panel();
    Panel panel6 = new Panel();
    BorderLayout borderLayout6 = new BorderLayout();
    EtchedBorder etchedBorder6 = new EtchedBorder();
    EtchedBorder etchedBorder7 = new EtchedBorder();
    EtchedBorder sliderPanel = new EtchedBorder();
    EtchedBorder box1 = new EtchedBorder();
    Panel panel3 = new Panel();
    VerticalFlowLayout verticalFlowLayout2 = new VerticalFlowLayout();
    SSlider speedSlider = new SSlider();
    BorderLayout borderLayout3 = new BorderLayout();
    Label speedLabel = new Label();
    SNumber speedField = new SNumber();
    GridLayout gridLayout1 = new GridLayout();

    protected void setResources() {
        this.button_add = this.localProperties.getProperty("button.add", this.button_add);
        this.button_clear = this.localProperties.getProperty("button.clear", this.button_clear);
        this.label_speed = this.localProperties.getProperty("label.speed", this.label_speed);
    }

    public void init() {
        this.initResources(null);
        try {
            this.speed = Double.valueOf(this.getParameter("Speed", "0.0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.mode = this.getParameter("Mode", "Lorentz");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mode = this.mode.toLowerCase();
        if (this.mode.equals("galilean")) {
            this.minkowskiCanvas.setType('G');
        } else if (this.mode.equals("rotation")) {
            this.minkowskiCanvas.setType('R');
        } else {
            this.minkowskiCanvas.setType('L');
        }
        this.speedField.addPropertyChangeListener((PropertyChangeListener)this.speedSlider);
        this.speedSlider.addPropertyChangeListener((PropertyChangeListener)this.speedField);
        this.coordPanel.setVisible(this.showControls);
        this.sliderPanel.setVisible(this.showControls);
        this.speedField.setNoColor(true);
        this.speedField.setValue(this.speed);
        this.speedSlider.setDValue(this.speed);
        this.minkowskiCanvas.setSpeed(this.speed);
        this.setLabels();
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.etchedBorder1.setLayout(this.borderLayout2);
        this.coordPanel.setBackground(SystemColor.control);
        this.coordPanel.setMinimumSize(new Dimension(150, 200));
        this.coordPanel.setPreferredSize(new Dimension(150, 200));
        this.coordPanel.setLayout(this.borderLayout7);
        this.panel2.setLayout(this.gridLayout1);
        this.panel4.setLayout(this.verticalFlowLayout1);
        this.box2.setLayout(this.borderLayout4);
        this.panel4.setBackground(SystemColor.controlHighlight);
        this.addMovingBtn.setLabel(this.button_add);
        this.addMovingBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Minkowski.this.addMovingBtn_actionPerformed(actionEvent);
            }
        });
        this.clearMovingBtn.setLabel(this.button_clear);
        this.clearMovingBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Minkowski.this.clearMovingBtn_actionPerformed(actionEvent);
            }
        });
        this.yPrimeLabel.setText("y' = ");
        this.yPrimeLabel.setAlignment(2);
        this.label1.setAlignment(2);
        this.label1.setText("x' = ");
        this.label5.setAlignment(2);
        this.label5.setText("x =");
        this.yLabel.setText("y =");
        this.yLabel.setAlignment(2);
        this.addLabBtn.setLabel(this.button_add);
        this.addLabBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Minkowski.this.addLabBtn_actionPerformed(actionEvent);
            }
        });
        this.clearLabBtn.setLabel(this.button_clear);
        this.clearLabBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Minkowski.this.clearLabBtn_actionPerformed(actionEvent);
            }
        });
        this.box4.setLayout(this.borderLayout6);
        this.panel6.setLayout(this.verticalFlowLayout4);
        this.panel6.setBackground(SystemColor.controlHighlight);
        this.box1.setLayout(this.verticalFlowLayout2);
        this.panel3.setLayout(this.borderLayout3);
        this.speedLabel.setAlignment(2);
        this.speedLabel.setText(String.valueOf(String.valueOf(this.label_speed)).concat(" "));
        this.verticalFlowLayout2.setVgap(0);
        this.panel2.setBackground(SystemColor.control);
        this.speedSlider.setDValue(0.5);
        this.speedSlider.setDMin(-0.99);
        this.speedSlider.setDMax(0.99);
        this.speedSlider.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Minkowski.this.speedSlider_adjustmentValueChanged(adjustmentEvent);
            }
        });
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.speedField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Minkowski.this.speedField_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "Center");
        this.etchedBorder1.add((Component)this.coordPanel, "West");
        this.coordPanel.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.box4, null);
        this.box4.add((Component)this.panel6, "Center");
        this.panel6.add((Component)this.etchedBorder7, null);
        this.etchedBorder7.add((Component)this.xField, "Center");
        this.etchedBorder7.add((Component)this.label5, "West");
        this.panel6.add((Component)this.etchedBorder6, null);
        this.etchedBorder6.add((Component)this.yField, "Center");
        this.etchedBorder6.add((Component)this.yLabel, "West");
        this.panel6.add((Component)this.panel10, null);
        this.panel10.add((Component)this.addLabBtn, null);
        this.panel10.add((Component)this.clearLabBtn, null);
        this.panel2.add((Component)this.box2, null);
        this.box2.add((Component)this.panel4, "Center");
        this.panel4.add((Component)this.etchedBorder3, null);
        this.etchedBorder3.add((Component)this.xPrimeField, "Center");
        this.etchedBorder3.add((Component)this.label1, "West");
        this.panel4.add((Component)this.etchedBorder2, null);
        this.etchedBorder2.add((Component)this.yPrimeField, "Center");
        this.etchedBorder2.add((Component)this.yPrimeLabel, "West");
        this.panel4.add((Component)this.panel8, null);
        this.panel8.add((Component)this.addMovingBtn, null);
        this.panel8.add((Component)this.clearMovingBtn, null);
        this.etchedBorder1.add((Component)this.minkowskiCanvas, "Center");
        ((Container)((Object)this)).add((Component)this.sliderPanel, "South");
        this.sliderPanel.add((Component)this.box1, "North");
        this.box1.add((Component)this.panel3, null);
        this.sliderPanel.setBackground(SystemColor.control);
        this.box1.setBackground(SystemColor.control);
        this.panel3.setBackground(SystemColor.control);
        this.panel3.add((Component)this.speedSlider, "Center");
        this.panel3.add((Component)this.speedLabel, "West");
        this.panel3.add((Component)this.speedField, "East");
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Speed", "double", "Speed"}, {"Mode", "String", "Transformation type"}, {"ShowControls", "boolean", "Show tihe user interface."}};
        return stringArray;
    }

    void speedSlider_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.minkowskiCanvas.setSpeed(this.speedSlider.getDValue());
    }

    void addLabBtn_actionPerformed(ActionEvent actionEvent) {
        this.minkowskiCanvas.addLabPoint(this.xField.getValue(), this.yField.getValue());
    }

    void clearLabBtn_actionPerformed(ActionEvent actionEvent) {
        this.minkowskiCanvas.clearLabCoords();
    }

    void addMovingBtn_actionPerformed(ActionEvent actionEvent) {
        this.minkowskiCanvas.addMovPoint(this.xPrimeField.getValue(), this.yPrimeField.getValue());
    }

    void clearMovingBtn_actionPerformed(ActionEvent actionEvent) {
        this.minkowskiCanvas.clearMovCoords();
    }

    void speedField_actionPerformed(ActionEvent actionEvent) {
        this.minkowskiCanvas.setSpeed(this.speedField.getValue());
        this.speedField.setValue(this.minkowskiCanvas.getSpeed());
    }

    private void setLabels() {
        if (this.mode.equals("galilean")) {
            this.yPrimeLabel.setText("t' = ");
            this.yLabel.setText("t = ");
            this.speedLabel.setText(String.valueOf(String.valueOf(this.label_speed)).concat(" "));
        } else if (this.mode.equals("rotation")) {
            this.yPrimeLabel.setText("y' = ");
            this.yLabel.setText("y = ");
            this.speedLabel.setText(" ");
        } else {
            this.yPrimeLabel.setText("t' = ");
            this.yLabel.setText("t = ");
            this.speedLabel.setText(String.valueOf(String.valueOf(this.label_speed)).concat(" "));
        }
    }

    public void setPixPerUnit(int n) {
        this.minkowskiCanvas.pixPerUnit = n;
        if (this.autoRefresh) {
            ((Component)((Object)this)).repaint();
        }
    }

    public boolean setShowCoordinates(int n, boolean bl) {
        if (n == 0 || n == this.minkowskiCanvas.hashCode()) {
            this.minkowskiCanvas.coordDisplay = bl;
            return true;
        }
        return false;
    }

    public void setMode(String string) {
        this.mode = string = string.toLowerCase();
        if (string.equals("galilean")) {
            this.minkowskiCanvas.setType('G');
        } else if (string.equals("rotation")) {
            this.minkowskiCanvas.setType('R');
        } else {
            this.minkowskiCanvas.setType('L');
        }
        this.setLabels();
    }

    public void reset() {
        super.reset();
    }

    public synchronized void setDefault() {
        this.deleteDataConnections();
        this.reset();
        this.minkowskiCanvas.clearLabCoords();
        this.minkowskiCanvas.clearMovCoords();
    }

    public void setVelocity(double d) {
        this.speed = d;
        this.speedField.setValue(this.speed);
        this.speedSlider.setDValue(this.speed);
        this.minkowskiCanvas.setSpeed(this.speed);
    }

    public int addLabPoint(double d, double d2) {
        if (this.showControls) {
            this.xField.setValue(d);
            this.yField.setValue(d);
        }
        return this.minkowskiCanvas.addLabPoint(d, d2);
    }

    public int addMovingPoint(double d, double d2) {
        if (this.showControls) {
            this.xPrimeField.setValue(d);
            this.yPrimeField.setValue(d);
        }
        return this.minkowskiCanvas.addMovPoint(d, d2);
    }
}

