/*
 * Decompiled with CFR 0.152.
 */
package minkowski;

import edu.davidson.display.Format;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;
import minkowski.Transformation;

public final class MinkowskiCanvas
extends Canvas {
    Image osi = null;
    int iwidth = 0;
    int iheight = 0;
    double v;
    Vector labVec = new Vector();
    Vector movVec = new Vector();
    private Transformation tr = new Transformation('L');
    private Color primeColor = new Color(0, 128, 0);
    private int boxWidth = 0;
    Format format = new Format("%-+6.2f");
    boolean coordDisplay = true;
    boolean mouseDown = false;
    SApplet owner = null;
    int pixPerUnit = 20;
    int radius = 4;

    public MinkowskiCanvas() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MinkowskiCanvas(SApplet sApplet) {
        this();
        this.owner = sApplet;
        this.setBackground(Color.white);
        this.v = 0.5;
    }

    public final void setType(char c) {
        this.tr.setType(c);
        this.clearLabCoords();
        this.clearMovCoords();
    }

    public void setSpeed(double d) {
        this.v = d;
        if (this.v < -0.99) {
            this.v = -0.99;
        }
        if (this.v > 0.99) {
            this.v = 0.99;
        }
        this.repaint();
    }

    public double getSpeed() {
        return this.v;
    }

    public Dimension preferredSize() {
        return new Dimension(200, 200);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.iwidth = this.getSize().width;
            this.iheight = this.getSize().height;
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        if (this.osi == null) {
            return;
        }
        Graphics graphics2 = this.osi.getGraphics();
        this.paintOSI(graphics2);
        graphics2.dispose();
        graphics.drawImage(this.osi, 0, 0, this);
    }

    public void paintOSI(Graphics graphics) {
        DPoint dPoint;
        int n;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iwidth, this.iheight);
        this.paintXGrid(graphics);
        this.paintXPGrid(graphics);
        this.paintX(graphics);
        this.paintT(graphics);
        graphics.setColor(Color.red);
        for (n = 0; n < this.labVec.size(); ++n) {
            dPoint = (DPoint)this.labVec.elementAt(n);
            this.paintPoint(graphics, dPoint.x, dPoint.y);
        }
        graphics.setColor(this.primeColor);
        for (n = 0; n < this.movVec.size(); ++n) {
            dPoint = (DPoint)this.movVec.elementAt(n);
            double d = this.tr.transformH(dPoint.x, dPoint.y, -this.v);
            double d2 = this.tr.transformV(dPoint.x, dPoint.y, -this.v);
            this.paintPoint(graphics, d, d2);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.iwidth - 1, this.iheight - 1);
    }

    public final void paintXPGrid(Graphics graphics) {
        int n;
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        int n4 = n2 / 2;
        int n5 = n3 / 2;
        int n6 = n3 / 2 % this.pixPerUnit;
        Color color = new Color(128, 128, 255);
        Color color2 = new Color(0, 0, 128);
        graphics.setColor(color);
        int n7 = n + this.pixPerUnit;
        int n8 = n6 + this.pixPerUnit;
        for (n = n2 / 2 % this.pixPerUnit; n < n2; n += this.pixPerUnit) {
            n8 = n6 + this.pixPerUnit;
            for (n6 = n3 / 2 % this.pixPerUnit; n6 < n3; n6 += this.pixPerUnit) {
                int n9 = n4 + (int)this.tr.transformH(n - n4, n6 - n5, this.v);
                int n10 = n5 + (int)this.tr.transformV(n - n4, n6 - n5, this.v);
                int n11 = n4 + (int)this.tr.transformH(n - n4, n8 - n5, this.v);
                int n12 = n5 + (int)this.tr.transformV(n - n4, n8 - n5, this.v);
                int n13 = n4 + (int)this.tr.transformH(n7 - n4, n6 - n5, this.v);
                int n14 = n5 + (int)this.tr.transformV(n7 - n4, n6 - n5, this.v);
                if (n == n4) {
                    graphics.setColor(color2);
                } else {
                    graphics.setColor(color);
                }
                graphics.drawLine(n9, n10, n11, n12);
                if (n6 == n5) {
                    graphics.setColor(color2);
                } else {
                    graphics.setColor(color);
                }
                graphics.drawLine(n9, n10, n13, n14);
                n8 = n6;
            }
            n7 = n;
        }
        graphics.setColor(Color.black);
    }

    public final void paintXGrid(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = n2 / 2 % this.pixPerUnit;
        Color color = Color.white.darker();
        graphics.setColor(color);
        for (int i = n / 2 % this.pixPerUnit; i < n; i += this.pixPerUnit) {
            graphics.drawLine(i, 0, i, n2);
        }
        while (n3 < n2) {
            graphics.drawLine(0, n3, n, n3);
            n3 += this.pixPerUnit;
        }
        graphics.setColor(Color.black);
    }

    public final void paintX(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.drawLine(0, n2 / 2, n, n2 / 2);
        for (int i = n / 2 % this.pixPerUnit; i < n; i += this.pixPerUnit) {
            graphics.drawLine(i, n2 / 2 - 5, i, n2 / 2 + 5);
        }
    }

    public final void paintT(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.drawLine(n / 2, 0, n / 2, n2);
        for (int i = n2 / 2 % this.pixPerUnit; i < n2; i += this.pixPerUnit) {
            graphics.drawLine(n / 2 - 5, i, n / 2 + 5, i);
        }
    }

    public void paintPoint(Graphics graphics, double d, double d2) {
        int n = this.getSize().width / 2;
        int n2 = this.getSize().height / 2;
        graphics.fillOval((int)((double)n + d * (double)this.pixPerUnit - (double)this.radius), (int)((double)n2 - d2 * (double)this.pixPerUnit - (double)this.radius), 1 + 2 * this.radius, 1 + 2 * this.radius);
    }

    public final synchronized int addLabPoint(double d, double d2) {
        Graphics graphics = this.getGraphics();
        DPoint dPoint = new DPoint(d, d2, this.owner);
        this.labVec.addElement(dPoint);
        graphics.setColor(Color.red);
        this.paintPoint(graphics, d, d2);
        graphics.setColor(Color.black);
        graphics.dispose();
        return dPoint.getID();
    }

    public final synchronized int addMovPoint(double d, double d2) {
        Graphics graphics = this.getGraphics();
        DPoint dPoint = new DPoint(d, d2, this.owner);
        this.movVec.addElement(dPoint);
        graphics.setColor(this.primeColor);
        double d3 = this.tr.transformH(d, d2, -this.v);
        double d4 = this.tr.transformV(d, d2, -this.v);
        dPoint.xprime = d3;
        dPoint.yprime = d4;
        this.paintPoint(graphics, d3, d4);
        graphics.setColor(Color.black);
        graphics.dispose();
        return dPoint.getID();
    }

    public final synchronized void clearLabCoords() {
        Enumeration enumeration = this.labVec.elements();
        while (enumeration.hasMoreElements()) {
            DPoint dPoint = (DPoint)enumeration.nextElement();
            this.owner.removeDataSource(dPoint.getID());
        }
        this.labVec.removeAllElements();
        this.repaint();
    }

    public final synchronized void clearMovCoords() {
        Enumeration enumeration = this.movVec.elements();
        while (enumeration.hasMoreElements()) {
            DPoint dPoint = (DPoint)enumeration.nextElement();
            this.owner.removeDataSource(dPoint.getID());
        }
        this.movVec.removeAllElements();
        this.repaint();
    }

    void paintCoords(int n, int n2) {
        if (!this.coordDisplay) {
            return;
        }
        Graphics graphics = this.getGraphics();
        this.paintCoords(graphics, n, n2);
        graphics.dispose();
    }

    void paintCoords(Graphics graphics, int n, int n2) {
        String string;
        if (!this.coordDisplay) {
            return;
        }
        double d = this.xFromPix(n);
        double d2 = this.yFromPix(n2);
        if (this.tr.getType() == 'R') {
            string = String.valueOf(String.valueOf(new StringBuffer("x=").append(this.format.form(d)).append("  y=").append(this.format.form(d2))));
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("  x'=").append(this.format.form(this.tr.transformH(d, d2, this.v))).append("  y'=").append(this.format.form(this.tr.transformV(d, d2, this.v)))));
        } else {
            string = String.valueOf(String.valueOf(new StringBuffer("x=").append(this.format.form(d)).append("  t=").append(this.format.form(d2))));
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("  x'=").append(this.format.form(this.tr.transformH(d, d2, this.v))).append("  t'=").append(this.format.form(this.tr.transformV(d, d2, this.v)))));
        }
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(1, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
        graphics.drawRect(1, rectangle.height - 20, this.boxWidth - 1, 19);
    }

    private void jbInit() throws Exception {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                MinkowskiCanvas.this.this_mouseDragged(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MinkowskiCanvas.this.this_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                MinkowskiCanvas.this.this_mouseReleased(mouseEvent);
            }
        });
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.mouseDown = true;
        this.paintCoords(n, n2);
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.mouseDown = false;
        Rectangle rectangle = this.getBounds();
        this.repaint(1, rectangle.height - 20, this.boxWidth, 20);
        this.boxWidth = 0;
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.iwidth;
        int n4 = 0;
        if (n < n4) {
            n = n4;
        } else if (n > n3 - 2) {
            n = n3 - 2;
        }
        double d = this.xFromPix(n);
        n4 = 0;
        n3 = this.iheight;
        if (n2 < n4) {
            n2 = n4;
        } else if (n2 > n3 - 2) {
            n2 = n3 - 2;
        }
        double d2 = this.yFromPix(n2);
        this.paintCoords(n, n2);
    }

    public double xFromPix(int n) {
        return (double)(n - this.iwidth / 2) / (double)this.pixPerUnit;
    }

    public double yFromPix(int n) {
        return (double)(-(n - this.iheight / 2)) / (double)this.pixPerUnit;
    }

    class DPoint
    implements SDataSource {
        double x;
        double y;
        double xprime;
        double yprime;
        String[] varStrings = new String[]{"x", "t", "xprime", "tprime", "v"};
        double[][] ds = new double[1][5];

        DPoint(double d, double d2, SApplet sApplet) {
            this.x = d;
            this.y = d2;
            MinkowskiCanvas.this.owner = sApplet;
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return MinkowskiCanvas.this.owner;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public double[][] getVariables() {
            this.ds[0][0] = this.x;
            this.ds[0][1] = this.y;
            this.ds[0][2] = this.xprime;
            this.ds[0][3] = this.yprime;
            this.ds[0][4] = MinkowskiCanvas.this.v;
            return this.ds;
        }
    }
}

