/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.surfaceplotter;

public class Controller {
    public static final int INIT_CALC_DIV = 20;
    public static final int INIT_DISP_DIV = 20;
    public static final int OPT_WIREFRAME = 0;
    public static final int OPT_HIDDEN = 1;
    public static final int OPT_SPECTRUM = 2;
    public static final int OPT_GRAYSCALE = 3;
    public static final int OPT_DUALSHADES = 4;
    protected int calc_divisions = 20;
    protected int disp_divisions = 20;
    boolean delay_regen = false;
    boolean boxed = true;
    boolean showMesh = true;
    boolean autoScale = false;
    boolean displayXYTicks = true;
    boolean displayZTicks = true;
    boolean showFaceGrids = false;
    String minStr = "";
    String maxStr = "";
    String function1Str = "x*y";
    String function2Str = null;
    boolean showFunction1 = true;
    boolean showFunction2 = false;
    float xmin = -1.0f;
    float xmax = 1.0f;
    float ymin = -1.0f;
    float ymax = 1.0f;
    float zmin = -1.0f;
    float zmax = 1.0f;
    int numContourLines = 10;
    int plotMode = 4;
    boolean autoScaleHeigth = false;
    float hmin = 0.0f;
    float hmax = 0.0f;

    Controller() {
    }

    public void setDefault() {
        this.delay_regen = false;
        this.boxed = true;
        this.showMesh = true;
        this.autoScale = false;
        this.displayXYTicks = true;
        this.displayZTicks = true;
        this.showFaceGrids = false;
        this.numContourLines = 10;
        this.plotMode = 4;
        this.function1Str = null;
        this.function2Str = null;
        this.showFunction1 = false;
        this.showFunction2 = false;
    }

    public boolean isExpectDelay() {
        return this.delay_regen;
    }

    public void rotationStarts() {
    }

    public void rotationStops() {
    }

    public int getPlotMode() {
        return this.plotMode;
    }

    public boolean isPlotFunction1() {
        if (this.function1Str == null) {
            return false;
        }
        return this.showFunction1;
    }

    public boolean isPlotFunction2() {
        if (this.function2Str == null) {
            return false;
        }
        return this.showFunction2;
    }

    public String getFunction1Definition() {
        return this.function1Str;
    }

    public String getFunction2Definition() {
        return this.function2Str;
    }

    public int getContourLines() {
        return this.numContourLines;
    }

    public int getCalcDivisions() {
        return this.calc_divisions;
    }

    public int getDispDivisions() {
        int n = this.disp_divisions;
        if (n > this.calc_divisions) {
            n = this.calc_divisions;
        }
        while (this.calc_divisions % n != 0) {
            ++n;
        }
        return n;
    }

    public void setDispDivisions(int n) {
        this.disp_divisions = n;
    }

    public void setFunction1(String string) {
        this.function1Str = string;
        this.showFunction1 = this.function1Str != null;
    }

    public void setFunction2(String string) {
        this.function2Str = string;
        this.showFunction2 = this.function2Str != null;
    }

    public void setMinimumResult(float f) {
        this.minStr = Float.toString(f);
        this.hmin = f;
    }

    public void setMinimumResult(String string) {
        this.minStr = string;
        this.hmin = 0.0f;
    }

    public void setMaximumResult(float f) {
        this.maxStr = Float.toString(f);
        this.hmax = f;
    }

    public void setMaximumResult(String string) {
        this.maxStr = string;
        this.hmax = 0.0f;
    }

    public float getXMin() {
        return this.xmin;
    }

    public float getYMin() {
        return this.ymin;
    }

    public float getZMin() {
        if (this.autoScaleHeigth) {
            return this.hmin;
        }
        return this.zmin;
    }

    public float getXMax() {
        return this.xmax;
    }

    public float getYMax() {
        return this.ymax;
    }

    public float getZMax() {
        if (this.autoScaleHeigth) {
            return this.hmax;
        }
        return this.zmax;
    }

    public boolean isBoxed() {
        return this.boxed;
    }

    public boolean isMesh() {
        return this.showMesh;
    }

    public boolean isScaleBox() {
        return this.autoScale;
    }

    public boolean isDisplayXY() {
        return this.displayXYTicks;
    }

    public boolean isDisplayZ() {
        return this.displayZTicks;
    }

    public boolean isDisplayGrids() {
        return this.showFaceGrids;
    }

    static {
        INIT_CALC_DIV = 20;
        INIT_DISP_DIV = 20;
        OPT_WIREFRAME = 0;
        OPT_HIDDEN = 1;
        OPT_SPECTRUM = 2;
        OPT_GRAYSCALE = 3;
        OPT_DUALSHADES = 4;
    }
}

