/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.surfaceplotter;

import edu.davidson.numerics.Parser;
import edu.davidson.surfaceplotter.SurfaceCanvas;
import edu.davidson.surfaceplotter.SurfaceVertex;

public class DataGenerator
implements Runnable {
    private Thread calcThread;
    private Parser parser1;
    private Parser parser2;
    private Object runLock = new Object();
    private boolean shouldRun = true;
    private boolean abort = false;
    private boolean running = false;
    SurfaceCanvas surfaceCanvas;
    private double[][] externalData = null;
    private boolean newData = false;
    private double[][] newDataArray = null;
    private double time = 0.0;
    private int totalMemory = 0;
    private SurfaceVertex[][] vertex = null;
    private SurfaceVertex[][] vertexCalc = null;
    private SurfaceVertex[][] vertexDraw = null;

    public DataGenerator(SurfaceCanvas surfaceCanvas) {
        this.surfaceCanvas = surfaceCanvas;
        this.parser1 = new Parser(3);
        this.parser1.defineVariable(1, "x");
        this.parser1.defineVariable(2, "y");
        this.parser1.defineVariable(3, "t");
        this.parser2 = new Parser(3);
        this.parser2.defineVariable(1, "x");
        this.parser2.defineVariable(2, "y");
        this.parser2.defineVariable(3, "t");
        this.calcThread = new Thread(this);
        this.calcThread.start();
    }

    boolean isExternalData() {
        return this.externalData != null;
    }

    void setDataArray(double[][] dArray) {
        if (dArray == null && this.externalData == null) {
            return;
        }
        this.newData = true;
        this.newDataArray = dArray;
        if (dArray != null) {
            this.createData();
        }
    }

    public void run() {
        while (this.shouldRun) {
            Object object = this.runLock;
            synchronized (object) {
                while (!this.running) {
                    try {
                        this.runLock.wait();
                    }
                    catch (Exception exception) {}
                }
                this.running = false;
                if (this.shouldRun) {
                    this.doCalc();
                }
                if (this.newData) {
                    this.newData = false;
                    this.running = true;
                    this.externalData = this.newDataArray;
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
        this.calcThread = null;
    }

    private void doCalc() {
        boolean bl;
        float f;
        float f2;
        float f3;
        float f4;
        Object var17_1 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            f4 = this.surfaceCanvas.controller.getXMin();
            f3 = this.surfaceCanvas.controller.getYMin();
            f2 = this.surfaceCanvas.controller.getXMax();
            f = this.surfaceCanvas.controller.getYMax();
            if (f4 >= f2 || f3 >= f) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.surfaceCanvas.setMessage("Error in ranges");
            return;
        }
        this.surfaceCanvas.setRanges(f4, f2, f3, f);
        this.surfaceCanvas.setMessage("parsing ...");
        boolean bl4 = this.surfaceCanvas.controller.isPlotFunction1();
        if (bl4 && this.externalData == null) {
            this.parser1.define(this.surfaceCanvas.controller.getFunction1Definition());
            this.parser1.parse();
            if (this.parser1.getErrorCode() != 0) {
                this.surfaceCanvas.setMessage(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parser1.getErrorString()).append(" at function 1, position ").append(this.parser1.getErrorPosition()))));
                return;
            }
        }
        if (bl = this.surfaceCanvas.controller.isPlotFunction2()) {
            this.parser2.define(this.surfaceCanvas.controller.getFunction2Definition());
            this.parser2.parse();
            if (this.parser2.getErrorCode() != 0) {
                this.surfaceCanvas.setMessage(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parser2.getErrorString()).append(" at function 2, position ").append(this.parser2.getErrorPosition()))));
                return;
            }
        }
        if (!bl4 && !bl && this.externalData == null) {
            this.surfaceCanvas.setMessage("No function selected");
            return;
        }
        Thread.yield();
        if (this.abort) {
            return;
        }
        int n = this.surfaceCanvas.controller.getCalcDivisions();
        if (this.externalData != null && (n + 1 != this.externalData.length || n + 1 != this.externalData[0].length)) {
            return;
        }
        float f5 = (f2 - f4) / (float)n;
        float f6 = (f - f3) / (float)n;
        int n2 = (n + 1) * (n + 1);
        boolean bl5 = bl4 || this.externalData != null;
        this.totalMemory = n2;
        this.vertexCalc = this.allocateMemory(bl5, bl, this.totalMemory);
        this.vertexDraw = this.allocateMemory(bl5, bl, this.totalMemory);
        this.vertex = this.vertexCalc;
        if (this.vertex == null) {
            return;
        }
        float f7 = Float.NaN;
        float f8 = Float.NaN;
        this.surfaceCanvas.controller.setMinimumResult("");
        this.surfaceCanvas.controller.setMaximumResult("");
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        float f9 = f4;
        float f10 = f3;
        float f11 = (float)20 / (f2 - f4);
        float f12 = (float)20 / (f - f3);
        while (n3 <= n) {
            if (bl4 && this.externalData == null) {
                this.parser1.setVariable(1, (double)f9);
                this.parser1.setVariable(2, (double)f10);
                this.parser1.setVariable(3, this.time);
            }
            if (bl) {
                this.parser2.setVariable(1, (double)f9);
                this.parser2.setVariable(2, (double)f10);
                this.parser2.setVariable(3, this.time);
            }
            while (n4 <= n) {
                float f13;
                Thread.yield();
                if (this.abort) {
                    return;
                }
                if (bl5) {
                    f13 = this.externalData != null ? (float)this.externalData[n3][n4] : (bl4 ? (float)this.parser1.evaluate() : 0.0f);
                    if (Float.isInfinite(f13)) {
                        f13 = Float.NaN;
                    }
                    if (!Float.isNaN(f13)) {
                        if (Float.isNaN(f7) || f13 > f7) {
                            f7 = f13;
                        } else if (Float.isNaN(f8) || f13 < f8) {
                            f8 = f13;
                        }
                    }
                    this.vertex[0][n5] = new SurfaceVertex((f9 - f4) * f11 - (float)10, (f10 - f3) * f12 - (float)10, f13, this.surfaceCanvas);
                }
                if (bl) {
                    f13 = (float)this.parser2.evaluate();
                    if (Float.isInfinite(f13)) {
                        f13 = Float.NaN;
                    }
                    if (!Float.isNaN(f13)) {
                        if (Float.isNaN(f7) || f13 > f7) {
                            f7 = f13;
                        } else if (Float.isNaN(f8) || f13 < f8) {
                            f8 = f13;
                        }
                    }
                    this.vertex[1][n5] = new SurfaceVertex((f9 - f4) * f11 - (float)10, (f10 - f3) * f12 - (float)10, f13, this.surfaceCanvas);
                }
                ++n4;
                f10 += f6;
                if (bl4) {
                    this.parser1.setVariable(2, (double)f10);
                }
                if (bl) {
                    this.parser2.setVariable(2, (double)f10);
                }
                ++n5;
            }
            if (this.abort) {
                return;
            }
            n4 = 0;
            f10 = f3;
            ++n3;
            f9 += f5;
        }
        if (this.abort) {
            return;
        }
        this.surfaceCanvas.controller.setMinimumResult(f8);
        this.surfaceCanvas.controller.setMaximumResult(f7);
        SurfaceVertex[][] surfaceVertexArray = this.surfaceCanvas.setNewData(this.vertex);
        if (surfaceVertexArray == this.vertexCalc) {
            this.vertexCalc = this.vertexDraw;
            this.vertexDraw = surfaceVertexArray;
            this.vertex = this.vertexCalc;
        }
    }

    private SurfaceVertex[][] allocateMemory(boolean bl, boolean bl2, int n) {
        SurfaceVertex[][] surfaceVertexArray = null;
        try {
            surfaceVertexArray = new SurfaceVertex[2][n];
            if (!bl) {
                surfaceVertexArray[0] = null;
            }
            if (!bl2) {
                surfaceVertexArray[1] = null;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.surfaceCanvas.setMessage("Not enough memory");
        }
        catch (Exception exception) {
            this.surfaceCanvas.setMessage("Error: ".concat(String.valueOf(String.valueOf(exception.toString()))));
        }
        return surfaceVertexArray;
    }

    public void createData() {
        Object object = this.runLock;
        synchronized (object) {
            this.running = true;
            this.runLock.notify();
        }
    }

    public void destroyThread() {
        this.calcThread.stop();
        this.shouldRun = false;
        this.abort = true;
        this.calcThread.interrupt();
        this.running = true;
        this.runLock.notify();
    }

    void setTime(double d) {
        if (this.time == d) {
            return;
        }
        Object object = this.runLock;
        synchronized (object) {
            this.time = d;
            this.running = true;
            this.runLock.notify();
        }
    }

    void interrupt() {
        this.abort = true;
        Object object = this.runLock;
        synchronized (object) {
            this.surfaceCanvas.setDataAvailability(false);
            this.abort = false;
        }
    }
}

