/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.surfaceplotter;

import edu.davidson.surfaceplotter.Controller;
import edu.davidson.surfaceplotter.DataGenerator;
import edu.davidson.surfaceplotter.LineAccumulator;
import edu.davidson.surfaceplotter.Projector;
import edu.davidson.surfaceplotter.SurfaceVertex;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;

public final class SurfaceCanvas
extends Canvas
implements Runnable {
    int gutter = 0;
    public Controller controller = new Controller();
    public DataGenerator dataGenerator = new DataGenerator(this);
    String message = null;
    int calc_divisions;
    boolean mouseDown = false;
    Font defaultFont = null;
    boolean forceNewImage = true;
    private static final int WIREFRAME = 0;
    private static final int NORENDER = 1;
    private static final int SPECTRUM = 2;
    private static final int GRAYSCALE = 3;
    private static final int DUALSHADE = 4;
    private static final int TOP = 0;
    private static final int CENTER = 1;
    private static final int UPPER = 1;
    private static final int COINCIDE = 0;
    private static final int LOWER = -1;
    private Image Buffer = null;
    private Graphics BufferGC = null;
    private boolean image_drawn = false;
    private Thread paintThread;
    private SurfaceVertex[][] vertex;
    private SurfaceVertex[][] vertex_new = null;
    private boolean shouldRun = true;
    private boolean running = false;
    private boolean abort = false;
    private Object runLock = new Object();
    private Object vertexLock = new Object();
    private boolean data_available = false;
    private boolean interrupted = false;
    private boolean critical;
    private boolean rotate = false;
    private boolean printing = false;
    private int prevwidth = -1;
    private int prevheight = -1;
    private int printwidth;
    private int printheight;
    private float color;
    private SurfaceVertex cop;
    boolean contour = false;
    boolean density = false;
    boolean noDrawing = false;
    Projector projector;
    private int plot_mode;
    private boolean plotfunc1;
    private boolean plotfunc2;
    private boolean plotboth;
    private boolean isBoxed;
    private boolean isMesh;
    private boolean isScaleBox;
    private boolean isDisplayXY;
    private boolean isDisplayZ;
    private boolean isDisplayGrids;
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private float zmin;
    private float zmax;
    float zminV;
    float zmaxV;
    float zfactorV;
    int master_project_indexV = 0;
    private boolean is_data_available;
    private boolean dragged;
    private int click_x;
    private int click_y;
    private int factor_x;
    private int factor_y;
    private int t_x;
    private int t_y;
    private int t_z;
    private float color_factor;
    private Point projection;
    private Color line_color;
    private final int[] poly_x = new int[9];
    private final int[] poly_y = new int[9];
    private final SurfaceVertex[] upperpart = new SurfaceVertex[8];
    private final SurfaceVertex[] lowerpart = new SurfaceVertex[8];
    private final SurfaceVertex[] values1 = new SurfaceVertex[4];
    private final SurfaceVertex[] values2 = new SurfaceVertex[4];
    private final Point[] testpoint = new Point[5];
    private int contour_center_x = 0;
    private int contour_center_y = 0;
    private int contour_space_x = 0;
    private int legend_width = 0;
    private int legend_space = 0;
    private int legend_length = 0;
    private String[] legend_label = null;
    private float contour_width_x = 0.0f;
    private float contour_width_y = 0.0f;
    private Color[] contour_color = null;
    private String[] ylabels = null;
    private int[] xpoints = new int[8];
    private int[] ypoints = new int[8];
    private int[] contour_x = new int[8];
    private int[] contour_y = new int[8];
    private int contour_n = 0;
    private int contour_lines = 10;
    private float[] delta = new float[4];
    private float[] intersection = new float[4];
    private float contour_stepz;
    private SurfaceVertex[] contour_vertex = new SurfaceVertex[4];
    private LineAccumulator accumulator = new LineAccumulator();

    public void setMessage(String string) {
        this.message = string == null || string.trim().equals("") ? null : string;
    }

    public SurfaceCanvas() {
        this.projector = new Projector();
        this.projector.setDistance(200.0f);
        this.projector.set2DScaling(10.0f);
        this.projector.setRotationAngle(125.0f);
        this.projector.setElevationAngle(10.0f);
        this.vertex = new SurfaceVertex[2][];
        this.paintThread = new Thread(this);
        this.paintThread.start();
    }

    public void destroyThread() {
        this.paintThread.stop();
        this.shouldRun = false;
        this.rotate = false;
        this.paintThread.interrupt();
        this.running = true;
        this.runLock.notify();
    }

    public void destroyImage() {
        this.image_drawn = false;
    }

    public void setContour(boolean bl) {
        this.noDrawing = false;
        if (this.contour == bl) {
            return;
        }
        Object object = this.runLock;
        synchronized (object) {
            this.contour = bl;
            if (bl) {
                this.density = false;
            }
        }
    }

    public void setNoDrawing(boolean bl) {
        Object object = this.runLock;
        synchronized (object) {
            this.noDrawing = bl;
        }
    }

    public void setDensity(boolean bl) {
        this.noDrawing = false;
        if (this.density == bl) {
            return;
        }
        Object object = this.runLock;
        synchronized (object) {
            this.density = bl;
            if (bl) {
                this.contour = false;
            }
        }
    }

    public void setRanges(float f, float f2, float f3, float f4) {
        this.xmin = f;
        this.xmax = f2;
        this.ymin = f3;
        this.ymax = f4;
    }

    public float[] getRanges() {
        float[] fArray = new float[]{this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax};
        return fArray;
    }

    public void setDataAvailability(boolean bl) {
        this.data_available = bl;
        this.is_data_available = bl;
        if (bl) {
            this.image_drawn = false;
            this.repaint();
        }
    }

    public SurfaceVertex[][] setNewData(SurfaceVertex[][] surfaceVertexArray) {
        Object object = this.vertexLock;
        synchronized (object) {
            if (this.vertex_new == null) {
                this.vertex = surfaceVertexArray;
            }
            this.vertex_new = surfaceVertexArray;
            this.data_available = true;
            this.is_data_available = true;
            this.image_drawn = false;
            this.repaint();
            SurfaceVertex[][] surfaceVertexArray2 = this.vertex;
            return surfaceVertexArray2;
        }
    }

    private void syncNewData() {
        Object object = this.vertexLock;
        synchronized (object) {
            if (this.vertex_new != null) {
                this.vertex = this.vertex_new;
            }
        }
    }

    public SurfaceVertex[][] getValuesArray() {
        if (!this.data_available) {
            return null;
        }
        return this.vertex;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.click_x = n;
        this.click_y = n2;
        this.mouseDown = true;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.destroyImage();
        this.data_available = this.is_data_available;
        this.repaint();
        this.dragged = false;
        this.mouseDown = false;
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.repaint();
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        float f = 0.0f;
        if (this.rotate || this.contour || this.density) {
            return true;
        }
        if (!this.running || !this.data_available) {
            if (event != null && event.controlDown()) {
                this.projector.set2D_xTranslation(this.projector.get2D_xTranslation() + (n - this.click_x));
                this.projector.set2D_yTranslation(this.projector.get2D_yTranslation() + (n2 - this.click_y));
            } else if (event != null && event.shiftDown()) {
                f = this.projector.get2DScaling() + (float)(n2 - this.click_y) * 0.5f;
                if (f > 60.0f) {
                    f = 60.0f;
                }
                if (f < 2.0f) {
                    f = 2.0f;
                }
                this.projector.set2DScaling(f);
            } else {
                for (f = this.projector.getRotationAngle() + (float)(n - this.click_x); f > (float)360; f -= (float)360) {
                }
                while (f < 0.0f) {
                    f += (float)360;
                }
                this.projector.setRotationAngle(f);
                f = this.projector.getElevationAngle() + (float)(n2 - this.click_y);
                if (f > (float)90) {
                    f = 90.0f;
                } else if (f < 0.0f) {
                    f = 0.0f;
                }
                this.projector.setElevationAngle(f);
            }
            this.image_drawn = false;
            if (!this.controller.isExpectDelay()) {
                this.repaint();
            } else {
                if (!this.dragged) {
                    this.is_data_available = this.data_available;
                    this.dragged = true;
                }
                this.data_available = false;
                this.repaint();
            }
        }
        this.click_x = n;
        this.click_y = n2;
        return true;
    }

    public void paint(Graphics graphics) {
        Object object;
        if (this.getBounds().width <= 0 || this.getBounds().height <= 0) {
            return;
        }
        if (this.noDrawing) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            return;
        }
        if (this.getBounds().width != this.prevwidth || this.getBounds().height != this.prevheight || this.BufferGC == null) {
            this.setMessage(String.valueOf(String.valueOf(new StringBuffer("New image size: ").append(this.getBounds().width).append("x").append(this.getBounds().height))));
            this.projector.setProjectionArea(new Rectangle(0, 0, this.getBounds().width, this.getBounds().height));
            this.image_drawn = false;
            if (this.Buffer != null) {
                this.Buffer.flush();
            }
            this.Buffer = this.createImage(this.getBounds().width, this.getBounds().height);
            if (this.BufferGC != null) {
                this.BufferGC.dispose();
            }
            this.BufferGC = this.Buffer.getGraphics();
            this.setFont(this.defaultFont);
            this.prevwidth = this.getBounds().width;
            this.prevheight = this.getBounds().height;
        }
        this.importVariables();
        if (this.printing) {
            Graphics graphics2 = this.BufferGC;
            this.BufferGC = graphics;
            Dimension dimension = ((PrintGraphics)((Object)graphics)).getPrintJob().getPageDimension();
            this.printwidth = dimension.width;
            this.printheight = this.prevheight * this.printwidth / this.prevwidth;
            if (this.printheight > dimension.height) {
                this.printheight = dimension.height;
                this.printwidth = this.prevwidth * this.printheight / this.prevheight;
            }
            float f = this.projector.get2DScaling();
            this.rotate = false;
            this.running = false;
            Object object2 = this.runLock;
            synchronized (object2) {
                this.projector.setProjectionArea(new Rectangle(0, 0, this.printwidth, this.printheight));
                this.projector.set2DScaling(f * (float)this.printwidth / (float)this.prevwidth);
                this.BufferGC.clipRect(0, 0, this.printwidth, this.printheight);
                if (!this.data_available) {
                    this.drawBoxGridsTicksLabels(this.BufferGC, true);
                }
                this.BufferGC.drawRect(0, 0, this.printwidth - 1, this.printheight - 1);
                this.projector.set2DScaling(f);
                this.projector.setProjectionArea(new Rectangle(0, 0, this.getBounds().width, this.getBounds().height));
                this.BufferGC = graphics2;
            }
            return;
        }
        if (this.image_drawn && this.Buffer != null) {
            if (graphics == null) {
                return;
            }
            graphics.drawImage(this.Buffer, 0, 0, this);
        } else if (this.data_available && !this.interrupted) {
            object = this.runLock;
            synchronized (object) {
                this.running = true;
                this.runLock.notify();
            }
        } else if (this.Buffer == null) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            if (!this.contour && !this.density) {
                this.drawBoxGridsTicksLabels(graphics, true);
            }
        }
        this.interrupted = false;
        object = this.getBounds();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setFont(Font font) {
        this.defaultFont = font;
        int n = (int)Math.round((double)this.projector.get2DScaling() * 0.5);
        n = Math.max(n, 10);
        if (this.defaultFont == null) {
            this.BufferGC.setFont(new Font("Helvetica", 0, n));
        } else {
            this.BufferGC.setFont(this.defaultFont);
        }
    }

    public void run() {
        while (this.shouldRun) {
            Object object = this.runLock;
            synchronized (object) {
                while (!this.running) {
                    try {
                        this.runLock.wait();
                    }
                    catch (Exception exception) {}
                }
                if (this.shouldRun) {
                    this.running = this.doCalc();
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
        this.paintThread = null;
    }

    private boolean doCalc() {
        this.syncNewData();
        ++this.master_project_indexV;
        if (this.contour) {
            this.plotContour();
        } else if (this.density) {
            this.plotDensity();
        } else if (this.plot_mode == 0) {
            this.plotWireframe();
        } else {
            this.plotSurface();
        }
        this.cleanUpMemory();
        if (this.printing) {
            return false;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return false;
        }
        this.paint(graphics);
        graphics.dispose();
        if (this.rotate) {
            float f;
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (f = this.projector.getRotationAngle() + (float)5; f > (float)360; f -= (float)360) {
            }
            while (f < 0.0f) {
                f += (float)360;
            }
            this.projector.setRotationAngle(f);
        }
        return this.rotate;
    }

    public void startRotation() {
        Object object = this.runLock;
        synchronized (object) {
            this.rotate = true;
            this.destroyImage();
            this.controller.rotationStarts();
        }
        this.repaint();
    }

    public void stopRotation() {
        if (!this.rotate) {
            return;
        }
        this.rotate = false;
        Object object = this.runLock;
        synchronized (object) {
            this.controller.rotationStops();
        }
    }

    public synchronized void interrupt() {
        this.running = false;
        this.rotate = false;
        Object object = this.runLock;
        synchronized (object) {
            this.abort = true;
            this.setMessage("Interrupted");
            this.cleanUpMemory();
            this.image_drawn = false;
            this.interrupted = true;
        }
        this.repaint();
    }

    public Dimension preferredSize() {
        return new Dimension(550, 550);
    }

    private final void drawBoundingBox() {
        Point point = this.projector.project(this.factor_x * 10, this.factor_y * 10, 10.0f);
        this.BufferGC.setColor(Color.black);
        Point point2 = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
        this.BufferGC.drawLine(point.x, point.y, point2.x, point2.y);
        point2 = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
        this.BufferGC.drawLine(point.x, point.y, point2.x, point2.y);
        point2 = this.projector.project(this.factor_x * 10, this.factor_y * 10, -10.0f);
        this.BufferGC.drawLine(point.x, point.y, point2.x, point2.y);
    }

    private final void drawBase(Graphics graphics, int[] nArray, int[] nArray2) {
        Point point = this.projector.project(-10.0f, -10.0f, -10.0f);
        nArray[0] = point.x;
        nArray2[0] = point.y;
        point = this.projector.project(-10.0f, 10.0f, -10.0f);
        nArray[1] = point.x;
        nArray2[1] = point.y;
        point = this.projector.project(10.0f, 10.0f, -10.0f);
        nArray[2] = point.x;
        nArray2[2] = point.y;
        point = this.projector.project(10.0f, -10.0f, -10.0f);
        nArray[3] = point.x;
        nArray2[3] = point.y;
        nArray[4] = nArray[0];
        nArray2[4] = nArray2[0];
        if (this.plot_mode != 0) {
            if (this.plot_mode == 1) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(new Color(192, 220, 192));
            }
            graphics.fillPolygon(nArray, nArray2, 4);
        }
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, 5);
    }

    private final void drawBoxGridsTicksLabels(Graphics graphics, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        if (this.projector == null) {
            return;
        }
        if (bl) {
            this.drawBase(graphics, nArray, nArray2);
            Point point = this.projector.project(0.0f, 0.0f, -10.0f);
            nArray[0] = point.x;
            nArray2[0] = point.y;
            point = this.projector.project(10.5f, 0.0f, -10.0f);
            graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
            if (point.x < nArray[0]) {
                this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], "x", 2, 0);
            } else {
                this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], "x", 0, 0);
            }
            point = this.projector.project(0.0f, 11.5f, -10.0f);
            graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
            if (point.x < nArray[0]) {
                this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], "y", 2, 0);
            } else {
                this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], "y", 0, 0);
            }
            point = this.projector.project(0.0f, 0.0f, 10.5f);
            graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
            this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], "z", 1, 1);
        } else {
            this.factor_y = 1;
            this.factor_x = 1;
            Point point = this.projector.project(0.0f, 0.0f, -10.0f);
            nArray[0] = point.x;
            point = this.projector.project(10.5f, 0.0f, -10.0f);
            bl3 = point.x > nArray[0];
            int n = point.y;
            point = this.projector.project(-10.5f, 0.0f, -10.0f);
            if (point.y > n) {
                this.factor_x = -1;
                bl3 = point.x > nArray[0];
            }
            point = this.projector.project(0.0f, 10.5f, -10.0f);
            bl2 = point.x > nArray[0];
            n = point.y;
            point = this.projector.project(0.0f, -10.5f, -10.0f);
            if (point.y > n) {
                this.factor_y = -1;
                bl2 = point.x > nArray[0];
            }
            this.setAxesScale();
            this.drawBase(graphics, nArray, nArray2);
            if (this.isBoxed) {
                point = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, -10.0f);
                nArray[0] = point.x;
                nArray2[0] = point.y;
                point = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, 10.0f);
                nArray[1] = point.x;
                nArray2[1] = point.y;
                point = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
                nArray[2] = point.x;
                nArray2[2] = point.y;
                point = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0f);
                nArray[3] = point.x;
                nArray2[3] = point.y;
                nArray[4] = nArray[0];
                nArray2[4] = nArray2[0];
                if (this.plot_mode != 0) {
                    if (this.plot_mode == 1) {
                        graphics.setColor(Color.lightGray);
                    } else {
                        graphics.setColor(new Color(192, 220, 192));
                    }
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
                graphics.setColor(Color.black);
                graphics.drawPolygon(nArray, nArray2, 5);
                point = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
                nArray[2] = point.x;
                nArray2[2] = point.y;
                point = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0f);
                nArray[3] = point.x;
                nArray2[3] = point.y;
                nArray[4] = nArray[0];
                nArray2[4] = nArray2[0];
                if (this.plot_mode != 0) {
                    if (this.plot_mode == 1) {
                        graphics.setColor(Color.lightGray);
                    } else {
                        graphics.setColor(new Color(192, 220, 192));
                    }
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
                graphics.setColor(Color.black);
                graphics.drawPolygon(nArray, nArray2, 5);
            } else if (this.isDisplayZ) {
                point = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0f);
                nArray[0] = point.x;
                nArray2[0] = point.y;
                point = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
                graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
                point = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0f);
                nArray[0] = point.x;
                nArray2[0] = point.y;
                point = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
                graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
            }
            for (n = -9; n <= 9; ++n) {
                Point point2;
                if (this.isDisplayXY || this.isDisplayGrids) {
                    if (!this.isDisplayGrids || n % (this.t_y / 2) == 0 || this.isDisplayXY) {
                        point = this.isDisplayGrids && n % this.t_y == 0 ? this.projector.project(-this.factor_x * 10, n, -10.0f) : (n % this.t_y != 0 ? this.projector.project((float)this.factor_x * 9.8f, n, -10.0f) : this.projector.project((float)this.factor_x * 9.5f, n, -10.0f));
                        point2 = this.projector.project(this.factor_x * 10, n, -10.0f);
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        if (n % this.t_y == 0 && this.isDisplayXY) {
                            point2 = this.projector.project((float)this.factor_x * 10.5f, n, -10.0f);
                            if (bl3) {
                                this.outFloat(graphics, point2.x, point2.y, (float)((double)(n + 10) / (double)20 * (double)(this.ymax - this.ymin) + (double)this.ymin), 0, 0);
                            } else {
                                this.outFloat(graphics, point2.x, point2.y, (float)((double)(n + 10) / (double)20 * (double)(this.ymax - this.ymin) + (double)this.ymin), 2, 0);
                            }
                        }
                    }
                    if (!this.isDisplayGrids || n % (this.t_x / 2) == 0 || this.isDisplayXY) {
                        point = this.isDisplayGrids && n % this.t_x == 0 ? this.projector.project(n, -this.factor_y * 10, -10.0f) : (n % this.t_x != 0 ? this.projector.project(n, (float)this.factor_y * 9.8f, -10.0f) : this.projector.project(n, (float)this.factor_y * 9.5f, -10.0f));
                        point2 = this.projector.project(n, this.factor_y * 10, -10.0f);
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        if (n % this.t_x == 0 && this.isDisplayXY) {
                            point2 = this.projector.project(n, (float)this.factor_y * 10.5f, -10.0f);
                            if (bl2) {
                                this.outFloat(graphics, point2.x, point2.y, (float)((double)(n + 10) / (double)20 * (double)(this.xmax - this.xmin) + (double)this.xmin), 0, 0);
                            } else {
                                this.outFloat(graphics, point2.x, point2.y, (float)((double)(n + 10) / (double)20 * (double)(this.xmax - this.xmin) + (double)this.xmin), 2, 0);
                            }
                        }
                    }
                }
                if (this.isDisplayXY) {
                    point2 = this.projector.project(0.0f, this.factor_y * 14, -10.0f);
                    this.outString(graphics, point2.x, point2.y, "X", 1, 0);
                    point2 = this.projector.project(this.factor_x * 14, 0.0f, -10.0f);
                    this.outString(graphics, point2.x, point2.y, "Y", 1, 0);
                }
                if (!this.isDisplayZ && (!this.isDisplayGrids || !this.isBoxed) || this.isDisplayGrids && n % (this.t_z / 2) != 0 && !this.isDisplayZ) continue;
                if (this.isBoxed && this.isDisplayGrids && n % this.t_z == 0) {
                    point = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, n);
                    point2 = this.projector.project(-this.factor_x * 10, this.factor_y * 10, n);
                } else {
                    point = n % this.t_z == 0 ? this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.5f, n) : this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.8f, n);
                    point2 = this.projector.project(-this.factor_x * 10, this.factor_y * 10, n);
                }
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                if (this.isDisplayZ) {
                    point2 = this.projector.project(-this.factor_x * 10, (float)this.factor_y * 10.5f, n);
                    if (n % this.t_z == 0) {
                        if (bl2) {
                            this.outFloat(graphics, point2.x, point2.y, (float)((double)(n + 10) / (double)20 * (double)(this.zmax - this.zmin) + (double)this.zmin), 0, 1);
                        } else {
                            this.outFloat(graphics, point2.x, point2.y, (float)((double)(n + 10) / (double)20 * (double)(this.zmax - this.zmin) + (double)this.zmin), 2, 1);
                        }
                    }
                }
                if (this.isDisplayGrids && this.isBoxed && n % this.t_z == 0) {
                    point = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, n);
                    point2 = this.projector.project(this.factor_x * 10, -this.factor_y * 10, n);
                } else {
                    point = n % this.t_z == 0 ? this.projector.project((float)this.factor_x * 9.5f, -this.factor_y * 10, n) : this.projector.project((float)this.factor_x * 9.8f, -this.factor_y * 10, n);
                    point2 = this.projector.project(this.factor_x * 10, -this.factor_y * 10, n);
                }
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                if (this.isDisplayZ) {
                    point2 = this.projector.project((float)this.factor_x * 10.5f, -this.factor_y * 10, n);
                    if (n % this.t_z == 0) {
                        if (bl3) {
                            this.outFloat(graphics, point2.x, point2.y, (float)((double)(n + 10) / (double)20 * (double)(this.zmax - this.zmin) + (double)this.zmin), 0, 1);
                        } else {
                            this.outFloat(graphics, point2.x, point2.y, (float)((double)(n + 10) / (double)20 * (double)(this.zmax - this.zmin) + (double)this.zmin), 2, 1);
                        }
                    }
                }
                if (!this.isDisplayGrids || !this.isBoxed) continue;
                if (n % this.t_y == 0) {
                    point = this.projector.project(-this.factor_x * 10, n, -10.0f);
                    point2 = this.projector.project(-this.factor_x * 10, n, 10.0f);
                    graphics.drawLine(point.x, point.y, point2.x, point2.y);
                }
                if (n % this.t_x != 0) continue;
                point = this.projector.project(n, -this.factor_y * 10, -10.0f);
                point2 = this.projector.project(n, -this.factor_y * 10, 10.0f);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
        }
    }

    private void importVariables() {
        this.plot_mode = this.controller.getPlotMode();
        if (this.mouseDown && !this.contour && !this.density) {
            this.plot_mode = 0;
        }
        this.isBoxed = this.controller.isBoxed();
        this.isMesh = this.controller.isMesh();
        this.isScaleBox = this.controller.isScaleBox();
        this.isDisplayXY = this.controller.isDisplayXY();
        this.isDisplayZ = this.controller.isDisplayZ();
        this.isDisplayGrids = this.controller.isDisplayGrids();
        this.calc_divisions = this.controller.getCalcDivisions();
        this.plotfunc1 = this.controller.isPlotFunction1() || this.dataGenerator.isExternalData();
        this.plotfunc2 = this.controller.isPlotFunction2();
        this.plotboth = this.plotfunc1 && this.plotfunc2;
    }

    private final void setAxesScale() {
        float f;
        int n;
        if (!this.isScaleBox) {
            this.projector.setScaling(1.0f);
            this.t_z = 4;
            this.t_y = 4;
            this.t_x = 4;
            return;
        }
        float f2 = this.xmax - this.xmin;
        float f3 = this.ymax - this.ymin;
        float f4 = this.zmax - this.zmin;
        if (f2 < f3) {
            if (f3 < f4) {
                n = 3;
                f = f4;
            } else {
                n = 2;
                f = f3;
            }
        } else if (f2 < f4) {
            n = 3;
            f = f4;
        } else {
            n = 1;
            f = f2;
        }
        f3 /= f;
        f4 /= f;
        if ((f2 /= f) < 0.2f || f3 < 0.2f && f4 < 0.2f) {
            switch (n) {
                case 1: {
                    if (f3 < f4) {
                        f3 /= f4;
                        f4 = 1.0f;
                        break;
                    }
                    f4 /= f3;
                    f3 = 1.0f;
                    break;
                }
                case 2: {
                    if (f2 < f4) {
                        f2 /= f4;
                        f4 = 1.0f;
                        break;
                    }
                    f4 /= f2;
                    f2 = 1.0f;
                    break;
                }
                case 3: {
                    if (f3 < f2) {
                        f3 /= f2;
                        f2 = 1.0f;
                        break;
                    }
                    f2 /= f3;
                    f3 = 1.0f;
                }
            }
        }
        if (f2 < 0.2f) {
            f2 = 1.0f;
        }
        this.projector.setXScaling(f2);
        if (f3 < 0.2f) {
            f3 = 1.0f;
        }
        this.projector.setYScaling(f3);
        if (f4 < 0.2f) {
            f4 = 1.0f;
        }
        this.projector.setZScaling(f4);
        this.t_x = f2 < 0.5f ? 8 : 4;
        this.t_y = f3 < 0.5f ? 8 : 4;
        this.t_z = f4 < 0.5f ? 8 : 4;
    }

    private final void outString(Graphics graphics, int n, int n2, String string, int n3, int n4) {
        switch (n4) {
            case 0: {
                n2 += graphics.getFontMetrics(graphics.getFont()).getAscent();
                break;
            }
            case 1: {
                n2 += graphics.getFontMetrics(graphics.getFont()).getAscent() / 2;
            }
        }
        switch (n3) {
            case 0: {
                graphics.drawString(string, n, n2);
                break;
            }
            case 2: {
                graphics.drawString(string, n - graphics.getFontMetrics(graphics.getFont()).stringWidth(string), n2);
                break;
            }
            case 1: {
                graphics.drawString(string, n - graphics.getFontMetrics(graphics.getFont()).stringWidth(string) / 2, n2);
            }
        }
    }

    private final void outFloat(Graphics graphics, int n, int n2, float f, int n3, int n4) {
        String string = Float.toString(f);
        this.outString(graphics, n, n2, string, n3, n4);
    }

    private final void plotPlane(SurfaceVertex[] surfaceVertexArray, int n) {
        if (n < 3) {
            return;
        }
        int n2 = 0;
        float f = 0.0f;
        this.line_color = Color.black;
        boolean bl = surfaceVertexArray[0].z < this.zmin;
        boolean bl2 = !bl && surfaceVertexArray[0].z <= this.zmax;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            boolean bl3;
            boolean bl4 = surfaceVertexArray[n3].z < this.zmin;
            boolean bl5 = bl3 = !bl4 && surfaceVertexArray[n3].z <= this.zmax;
            if (bl2 || bl3 || bl ^ bl4) {
                float f2;
                float f3;
                float f4;
                float f5;
                if (!bl2) {
                    f5 = bl ? this.zmin : this.zmax;
                    f4 = (f5 - surfaceVertexArray[n3].z) / (surfaceVertexArray[i].z - surfaceVertexArray[n3].z);
                    f3 = f4 * (surfaceVertexArray[i].x - surfaceVertexArray[n3].x) + surfaceVertexArray[n3].x;
                    f2 = f4 * (surfaceVertexArray[i].y - surfaceVertexArray[n3].y) + surfaceVertexArray[n3].y;
                    this.projection = bl ? this.projector.project(f3, f2, -10.0f) : this.projector.project(f3, f2, 10.0f);
                    this.poly_x[n2] = this.projection.x;
                    this.poly_y[n2] = this.projection.y;
                    ++n2;
                    f += f5;
                }
                if (bl3) {
                    this.projection = surfaceVertexArray[n3].projection();
                    this.poly_x[n2] = this.projection.x;
                    this.poly_y[n2] = this.projection.y;
                    ++n2;
                    f += surfaceVertexArray[n3].z;
                } else {
                    f5 = bl4 ? this.zmin : this.zmax;
                    f4 = (f5 - surfaceVertexArray[i].z) / (surfaceVertexArray[n3].z - surfaceVertexArray[i].z);
                    f3 = f4 * (surfaceVertexArray[n3].x - surfaceVertexArray[i].x) + surfaceVertexArray[i].x;
                    f2 = f4 * (surfaceVertexArray[n3].y - surfaceVertexArray[i].y) + surfaceVertexArray[i].y;
                    this.projection = bl4 ? this.projector.project(f3, f2, -10.0f) : this.projector.project(f3, f2, 10.0f);
                    this.poly_x[n2] = this.projection.x;
                    this.poly_y[n2] = this.projection.y;
                    ++n2;
                    f += f5;
                }
            }
            if (++n3 == n) {
                n3 = 0;
            }
            bl2 = bl3;
            bl = bl4;
        }
        if (n2 > 0) {
            switch (this.plot_mode) {
                case 1: {
                    this.BufferGC.setColor(Color.lightGray);
                    break;
                }
                case 2: {
                    f = 0.8f - (f / (float)n2 - this.zmin) * this.color_factor;
                    this.BufferGC.setColor(Color.getHSBColor(f, 1.0f, 1.0f));
                    break;
                }
                case 3: {
                    f = (f / (float)n2 - this.zmin) * this.color_factor;
                    this.BufferGC.setColor(Color.getHSBColor(0.0f, 0.0f, f));
                    if (!(f < 0.3f)) break;
                    this.line_color = new Color(0.6f, 0.6f, 0.6f);
                    break;
                }
                case 4: {
                    f = (f / (float)n2 - this.zmin) * this.color_factor + 0.4f;
                    this.BufferGC.setColor(Color.getHSBColor(this.color, 0.7f, f));
                }
            }
            this.BufferGC.fillPolygon(this.poly_x, this.poly_y, n2);
            this.BufferGC.setColor(this.line_color);
            if (this.isMesh || this.plot_mode == 1) {
                this.poly_x[n2] = this.poly_x[0];
                this.poly_y[n2] = this.poly_y[0];
                this.BufferGC.drawPolygon(this.poly_x, this.poly_y, ++n2);
            }
        }
    }

    private final void splitPlotPlane(SurfaceVertex[] surfaceVertexArray, SurfaceVertex[] surfaceVertexArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i <= 4; ++i) {
            float f;
            float f2;
            float f3;
            float f4;
            if (surfaceVertexArray[n4].z < surfaceVertexArray2[n4].z) {
                bl = false;
                if (n == 0) {
                    n = 1;
                    this.upperpart[n2++] = surfaceVertexArray2[n4];
                } else if (n != 1) {
                    f4 = (surfaceVertexArray[n4].z - surfaceVertexArray2[n4].z) / (surfaceVertexArray[n4].z - surfaceVertexArray2[n4].z + surfaceVertexArray2[n5].z - surfaceVertexArray[n5].z);
                    if (surfaceVertexArray[n4].x == surfaceVertexArray[n5].x) {
                        f3 = f4 * (surfaceVertexArray[n5].y - surfaceVertexArray[n4].y) + surfaceVertexArray[n4].y;
                        f2 = surfaceVertexArray[n4].x;
                    } else {
                        f2 = f4 * (surfaceVertexArray[n5].x - surfaceVertexArray[n4].x) + surfaceVertexArray[n4].x;
                        f3 = surfaceVertexArray[n4].y;
                    }
                    f = f4 * (surfaceVertexArray2[n5].z - surfaceVertexArray2[n4].z) + surfaceVertexArray2[n4].z;
                    int n6 = n2++;
                    int n7 = n3++;
                    SurfaceVertex surfaceVertex = new SurfaceVertex(f2, f3, f, this);
                    this.lowerpart[n7] = surfaceVertex;
                    this.upperpart[n6] = surfaceVertex;
                    this.upperpart[n2++] = surfaceVertexArray2[n4];
                    n = 1;
                } else {
                    this.upperpart[n2++] = surfaceVertexArray2[n4];
                }
            } else if (surfaceVertexArray[n4].z > surfaceVertexArray2[n4].z) {
                bl = false;
                if (n == 0) {
                    n = -1;
                    this.lowerpart[n3++] = surfaceVertexArray2[n4];
                } else if (n != -1) {
                    f4 = (surfaceVertexArray[n4].z - surfaceVertexArray2[n4].z) / (surfaceVertexArray[n4].z - surfaceVertexArray2[n4].z + surfaceVertexArray2[n5].z - surfaceVertexArray[n5].z);
                    if (surfaceVertexArray[n4].x == surfaceVertexArray[n5].x) {
                        f3 = f4 * (surfaceVertexArray[n5].y - surfaceVertexArray[n4].y) + surfaceVertexArray[n4].y;
                        f2 = surfaceVertexArray[n4].x;
                    } else {
                        f2 = f4 * (surfaceVertexArray[n5].x - surfaceVertexArray[n4].x) + surfaceVertexArray[n4].x;
                        f3 = surfaceVertexArray[n4].y;
                    }
                    f = f4 * (surfaceVertexArray2[n5].z - surfaceVertexArray2[n4].z) + surfaceVertexArray2[n4].z;
                    int n8 = n3++;
                    int n9 = n2++;
                    SurfaceVertex surfaceVertex = new SurfaceVertex(f2, f3, f, this);
                    this.upperpart[n9] = surfaceVertex;
                    this.lowerpart[n8] = surfaceVertex;
                    this.lowerpart[n3++] = surfaceVertexArray2[n4];
                    n = -1;
                } else {
                    this.lowerpart[n3++] = surfaceVertexArray2[n4];
                }
            } else {
                this.upperpart[n2++] = surfaceVertexArray2[n4];
                this.lowerpart[n3++] = surfaceVertexArray2[n4];
                n = 0;
            }
            n5 = n4;
            n4 = (n4 + 1) % 4;
        }
        if (bl) {
            this.plotPlane(surfaceVertexArray, 4);
        } else {
            if (this.critical) {
                bl2 = false;
            } else if (surfaceVertexArray[1].x == surfaceVertexArray[2].x) {
                bl2 = (surfaceVertexArray[2].z - surfaceVertexArray[3].z) * (this.cop.x - surfaceVertexArray[3].x) / (surfaceVertexArray[2].x - surfaceVertexArray[3].x) + surfaceVertexArray[3].z + (surfaceVertexArray[2].z - surfaceVertexArray[1].z) * (this.cop.y - surfaceVertexArray[1].y) / (surfaceVertexArray[2].y - surfaceVertexArray[1].y) + surfaceVertexArray[1].z - surfaceVertexArray[2].z > this.cop.z;
            } else {
                boolean bl3 = bl2 = (surfaceVertexArray[2].z - surfaceVertexArray[1].z) * (this.cop.x - surfaceVertexArray[1].x) / (surfaceVertexArray[2].x - surfaceVertexArray[1].x) + surfaceVertexArray[1].z + (surfaceVertexArray[2].z - surfaceVertexArray[3].z) * (this.cop.y - surfaceVertexArray[3].y) / (surfaceVertexArray[2].y - surfaceVertexArray[3].y) + surfaceVertexArray[3].z - surfaceVertexArray[2].z > this.cop.z;
            }
            if (n3 < 3) {
                if (bl2) {
                    this.color = 0.7f;
                    this.plotPlane(this.upperpart, n2);
                    this.color = 0.2f;
                    this.plotPlane(surfaceVertexArray, 4);
                } else {
                    this.color = 0.2f;
                    this.plotPlane(surfaceVertexArray, 4);
                    this.color = 0.7f;
                    this.plotPlane(this.upperpart, n2);
                }
            } else if (n2 < 3) {
                if (bl2) {
                    this.color = 0.2f;
                    this.plotPlane(surfaceVertexArray, 4);
                    this.color = 0.7f;
                    this.plotPlane(this.lowerpart, n3);
                } else {
                    this.color = 0.7f;
                    this.plotPlane(this.lowerpart, n3);
                    this.color = 0.2f;
                    this.plotPlane(surfaceVertexArray, 4);
                }
            } else if (bl2) {
                this.color = 0.7f;
                this.plotPlane(this.upperpart, n2);
                this.color = 0.2f;
                this.plotPlane(surfaceVertexArray, 4);
                this.color = 0.7f;
                this.plotPlane(this.lowerpart, n3);
            } else {
                this.color = 0.7f;
                this.plotPlane(this.lowerpart, n3);
                this.color = 0.2f;
                this.plotPlane(surfaceVertexArray, 4);
                this.color = 0.7f;
                this.plotPlane(this.upperpart, n2);
            }
        }
    }

    private final boolean plottable(SurfaceVertex[] surfaceVertexArray) {
        return !surfaceVertexArray[0].isInvalid() && !surfaceVertexArray[1].isInvalid() && !surfaceVertexArray[2].isInvalid() && !surfaceVertexArray[3].isInvalid();
    }

    private final void plotArea(int n, int n2, int n3, int n4, int n5, int n6) {
        n5 *= this.calc_divisions + 1;
        n3 *= this.calc_divisions + 1;
        int n7 = n *= this.calc_divisions + 1;
        for (int i = n2; i != n4; i += n6) {
            if (this.plotfunc1) {
                this.values1[1] = this.vertex[0][n7 + i];
                this.values1[2] = this.vertex[0][n7 + i + n6];
            }
            if (this.plotfunc2) {
                this.values2[1] = this.vertex[1][n7 + i];
                this.values2[2] = this.vertex[1][n7 + i + n6];
            }
            while (n7 != n3) {
                if (this.plotfunc1) {
                    this.values1[0] = this.values1[1];
                    this.values1[1] = this.vertex[0][n7 + n5 + i];
                    this.values1[3] = this.values1[2];
                    this.values1[2] = this.vertex[0][n7 + n5 + i + n6];
                }
                if (this.plotfunc2) {
                    this.values2[0] = this.values2[1];
                    this.values2[1] = this.vertex[1][n7 + n5 + i];
                    this.values2[3] = this.values2[2];
                    this.values2[2] = this.vertex[1][n7 + n5 + i + n6];
                }
                if (!this.plotboth) {
                    if (this.plotfunc1) {
                        if (this.plot_mode == 4) {
                            this.color = 0.2f;
                        }
                        if (this.plottable(this.values1)) {
                            this.plotPlane(this.values1, 4);
                        }
                    } else {
                        if (this.plot_mode == 4) {
                            this.color = 0.7f;
                        }
                        if (this.plottable(this.values2)) {
                            this.plotPlane(this.values2, 4);
                        }
                    }
                } else if (this.plottable(this.values1)) {
                    if (this.plottable(this.values2)) {
                        this.splitPlotPlane(this.values1, this.values2);
                    } else {
                        this.plotPlane(this.values1, 4);
                    }
                } else if (this.plottable(this.values2)) {
                    this.plotPlane(this.values2, 4);
                }
                n7 += n5;
            }
            n7 = n;
        }
    }

    private final void plotSurface() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        float f;
        float f2;
        this.image_drawn = false;
        try {
            f2 = this.controller.getZMin();
            f = this.controller.getZMax();
            if (f2 >= f) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Error in ranges");
            this.rotate = false;
            return;
        }
        int n7 = this.controller.getDispDivisions();
        int n8 = this.calc_divisions / n7;
        this.controller.setDispDivisions(n7);
        this.zmin = f2;
        this.zmax = f;
        if (this.rotate) {
            this.setMessage("rotating ...");
        } else {
            this.setMessage("regenerating ...");
        }
        this.color_factor = 0.8f / (this.zmax - this.zmin);
        if (this.plot_mode == 4) {
            this.color_factor *= 0.75f;
        }
        if (!this.printing) {
            this.BufferGC.setColor(Color.lightGray);
            this.BufferGC.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        this.drawBoxGridsTicksLabels(this.BufferGC, false);
        if (!this.plotfunc1 && !this.plotfunc2) {
            if (this.isBoxed) {
                this.drawBoundingBox();
            }
            if (!this.rotate) {
                this.setMessage("completed");
            }
            this.image_drawn = true;
            return;
        }
        this.zmaxV = this.zmax;
        this.zminV = this.zmin;
        this.zfactorV = (float)20 / (this.zmaxV - this.zminV);
        float f3 = this.projector.getDistance() * this.projector.getCosElevationAngle();
        this.cop = new SurfaceVertex(f3 * this.projector.getSinRotationAngle(), f3 * this.projector.getCosRotationAngle(), this.projector.getDistance() * this.projector.getSinElevationAngle(), this);
        this.cop.transform();
        boolean bl = this.cop.x > 0.0f;
        boolean bl2 = this.cop.y > 0.0f;
        this.critical = false;
        if (bl) {
            n6 = 0;
            n5 = this.calc_divisions;
            n4 = n8;
        } else {
            n6 = this.calc_divisions;
            n5 = 0;
            n4 = -n8;
        }
        if (bl2) {
            n3 = 0;
            n2 = this.calc_divisions;
            n = n8;
        } else {
            n3 = this.calc_divisions;
            n2 = 0;
            n = -n8;
        }
        if (this.cop.x > (float)10 || this.cop.x < (float)-10) {
            if (this.cop.y > (float)10 || this.cop.y < (float)-10) {
                this.plotArea(n6, n3, n5, n2, n4, n);
            } else {
                int n9 = (int)((this.cop.y + (float)10) * (float)n7 / (float)20) * n8;
                this.plotArea(n6, 0, n5, n9, n4, n8);
                this.plotArea(n6, this.calc_divisions, n5, n9, n4, -n8);
            }
        } else if (this.cop.y > (float)10 || this.cop.y < (float)-10) {
            int n10 = (int)((this.cop.x + (float)10) * (float)n7 / (float)20) * n8;
            this.plotArea(0, n3, n10, n2, n8, n);
            this.plotArea(this.calc_divisions, n3, n10, n2, -n8, n);
        } else {
            int n11 = (int)((this.cop.x + (float)10) * (float)n7 / (float)20) * n8;
            int n12 = (int)((this.cop.y + (float)10) * (float)n7 / (float)20) * n8;
            this.critical = true;
            this.plotArea(0, 0, n11, n12, n8, n8);
            this.plotArea(0, this.calc_divisions, n11, n12, n8, -n8);
            this.plotArea(this.calc_divisions, 0, n11, n12, -n8, n8);
            this.plotArea(this.calc_divisions, this.calc_divisions, n11, n12, -n8, -n8);
        }
        if (this.isBoxed) {
            this.drawBoundingBox();
        }
        if (!this.rotate) {
            this.setMessage("completed");
        }
        this.image_drawn = true;
    }

    private final int contourConvertX(float f) {
        return Math.round(f * this.contour_width_x + (float)this.contour_center_x);
    }

    private final int contourConvertY(float f) {
        return Math.round(-f * this.contour_width_y + (float)this.contour_center_y);
    }

    private final void drawBoundingRect() {
        int n;
        int n2;
        int n3;
        int n4;
        this.BufferGC.setColor(Color.black);
        int n5 = this.contourConvertX(-10.0f);
        int n6 = this.contourConvertY(10.0f);
        int n7 = this.contourConvertX(10.0f);
        int n8 = this.contourConvertY(-10.0f);
        this.BufferGC.drawRect(n5, n6, n7 - n5, n8 - n6);
        if (this.isDisplayXY || this.isDisplayGrids) {
            if (this.isDisplayXY) {
                n5 = this.contourConvertX(-10.5f);
                n6 = this.contourConvertY(10.5f);
                n7 = this.contourConvertX(10.5f);
                n8 = this.contourConvertY(-10.5f);
                this.BufferGC.drawRect(n5, n6, n7 - n5, n8 - n6);
            }
            n4 = 0;
            for (n3 = -10; n3 <= 10; ++n3) {
                if (!this.isDisplayGrids || n3 % (this.t_y / 2) == 0 || this.isDisplayXY) {
                    n2 = this.contourConvertY(n3);
                    if (this.isDisplayGrids && n3 % this.t_y == 0) {
                        this.BufferGC.drawLine(this.contourConvertX(-10.0f), n2, this.contourConvertX(10.0f), n2);
                    }
                    if (this.isDisplayXY) {
                        if (n3 % this.t_y != 0) {
                            this.BufferGC.drawLine(this.contourConvertX(10.3f), n2, n7, n2);
                            this.BufferGC.drawLine(this.contourConvertX(-10.3f), n2, n5, n2);
                        } else {
                            this.BufferGC.drawLine(this.contourConvertX(10.0f), n2, n7, n2);
                            this.BufferGC.drawLine(this.contourConvertX(-10.0f), n2, n5, n2);
                        }
                    }
                    if (n3 % this.t_y == 0 && this.isDisplayXY) {
                        this.outString(this.BufferGC, this.contourConvertX(10.7f), n2, this.ylabels[n4++], 0, 1);
                    }
                }
                if (!this.isDisplayGrids || n3 % (this.t_x / 2) == 0 || this.isDisplayXY) {
                    n = this.contourConvertX(n3);
                    if (this.isDisplayGrids && n3 % this.t_x == 0) {
                        this.BufferGC.drawLine(n, this.contourConvertY(-10.0f), n, this.contourConvertY(10.0f));
                    }
                    if (this.isDisplayXY) {
                        if (n3 % this.t_x != 0) {
                            this.BufferGC.drawLine(n, this.contourConvertY(-10.3f), n, n8);
                            this.BufferGC.drawLine(n, this.contourConvertY(10.3f), n, n6);
                        } else {
                            this.BufferGC.drawLine(n, this.contourConvertY(-10.0f), n, n8);
                            this.BufferGC.drawLine(n, this.contourConvertY(10.0f), n, n6);
                        }
                    }
                    if (n3 % this.t_x == 0 && this.isDisplayXY) {
                        this.outFloat(this.BufferGC, n, this.contourConvertY(-10.7f), (float)((double)(n3 + 10) / (double)20 * (double)(this.xmax - this.xmin) + (double)this.xmin), 1, 0);
                    }
                }
                if (!this.isDisplayXY) continue;
                this.outString(this.BufferGC, (n5 + n7) / 2, this.contourConvertY(-11.4f), "X", 1, 0);
                this.outString(this.BufferGC, this.contourConvertX(10.7f), this.contourConvertY(-1.0f), "Y", 0, 1);
            }
        }
        if (this.isDisplayZ) {
            n = n8;
            n2 = n8 - n6;
            n4 = this.contour_lines;
            n5 = (n7 += this.contour_space_x) - (this.legend_space + this.legend_width + this.legend_length);
            this.BufferGC.setColor(Color.black);
            this.outString(this.BufferGC, n7 -= this.legend_length, n8, this.legend_label[0], 0, 1);
            for (n3 = 1; n3 <= n4 + 1; ++n3) {
                int n9 = n8 - n3 * n2 / (n4 + 1);
                this.BufferGC.setColor(this.contour_color[n3 - 1]);
                this.BufferGC.fillRect(n5, n9, this.legend_width, n - n9);
                this.BufferGC.setColor(Color.black);
                this.BufferGC.drawRect(n5, n9, this.legend_width, n - n9);
                this.outString(this.BufferGC, n7, n9, this.legend_label[n3], 0, 1);
                n = n9;
            }
        }
    }

    private final void cleanUpMemory() {
        this.legend_label = null;
        this.contour_color = null;
        this.ylabels = null;
        this.accumulator.clearAccumulator();
    }

    private final void computePlotArea() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.setAxesScale();
        this.contour_lines = this.controller.getContourLines();
        float f = this.projector.getYScaling() / this.projector.getXScaling();
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.printing) {
            f2 = this.printwidth;
            f3 = this.printheight;
        } else {
            f2 = this.getBounds().width;
            f3 = this.getBounds().height;
        }
        int n6 = 0;
        n6 = f2 < f3 ? (int)(f2 / (float)48) : (int)(f3 / (float)48);
        n6 = Math.max(n6, 10);
        if (this.defaultFont == null) {
            this.BufferGC.setFont(new Font("Helvetica", 0, n6));
        } else {
            this.BufferGC.setFont(this.defaultFont);
        }
        FontMetrics fontMetrics = this.BufferGC.getFontMetrics();
        f2 -= (float)this.gutter;
        f3 -= (float)this.gutter;
        int n7 = 0;
        int n8 = 0;
        if (this.isDisplayXY) {
            n5 = 0;
            n4 = 0;
            n3 = 0;
            for (n2 = -10; n2 < 10; ++n2) {
                if (n2 % this.t_y != 0) continue;
                ++n5;
            }
            this.ylabels = new String[n5];
            for (n2 = -10; n2 < 10; ++n2) {
                if (n2 % this.t_y != 0) continue;
                this.ylabels[n4] = new String(Float.toString((float)((double)(n2 + 10) / (double)20 * (double)(this.ymax - this.ymin) + (double)this.ymin)));
                if ((n = fontMetrics.stringWidth(this.ylabels[n4++])) <= n3) continue;
                n3 = n;
            }
            n7 += n3;
            n8 += fontMetrics.getMaxAscent();
        }
        if (this.isDisplayZ) {
            if ((this.plot_mode == 0 || this.plot_mode == 1) && this.contour) {
                this.isDisplayZ = false;
            } else {
                this.legend_width = (int)((double)f2 * 0.05);
                n7 += this.legend_width * 2;
                this.legend_space = n6;
                n5 = this.contour_lines;
                this.legend_length = 0;
                this.legend_label = new String[n5 += 2];
                for (n4 = 0; n4 < n5; ++n4) {
                    float f4 = (float)((double)n4 / (double)(n5 - 1) * (double)(this.zmax - this.zmin) + (double)this.zmin);
                    this.legend_label[n4] = new String(Float.toString(f4));
                    n2 = fontMetrics.stringWidth(this.legend_label[n4]);
                    if (n2 <= this.legend_length) continue;
                    this.legend_length = n2;
                }
                n7 += this.legend_length + this.legend_space;
            }
        }
        f3 -= (float)n8;
        this.contour_width_x = f2 -= (float)n7;
        this.contour_width_y = f2 * f;
        if (this.contour_width_y > f3) {
            this.contour_width_y = f3;
            this.contour_width_x = f3 / f;
        }
        float f5 = 10.0f;
        if (this.isDisplayXY) {
            f5 = 10.7f;
        }
        this.contour_width_x = this.contour_width_x / f5 / (float)2;
        this.contour_width_y = this.contour_width_y / f5 / (float)2;
        this.contour_center_x = 0;
        this.contour_center_y = 0;
        n4 = this.contourConvertX(-f5);
        n3 = this.contourConvertY(f5);
        n2 = this.contourConvertX(f5) + n7;
        n = this.contourConvertY(-f5) + n8;
        this.contour_center_x = (this.getBounds().width - (n4 + n2)) / 2;
        this.contour_center_y = (this.getBounds().height - (n3 + n)) / 2;
        this.contour_space_x = n7;
        this.setContourColor();
    }

    void setContourColor() {
        this.contour_color = new Color[this.contour_lines + 1];
        block4: for (int i = 0; i <= this.contour_lines; ++i) {
            float f = (float)i / (float)this.contour_lines * 0.8f;
            int n = 0;
            int n2 = 0;
            switch (this.plot_mode) {
                case 4: {
                    n = Math.max(0, -this.contour_lines + i * 2) * 255 / this.contour_lines;
                    n2 = Math.max(0, this.contour_lines - i * 2) * 255 / this.contour_lines;
                    this.contour_color[i] = new Color(n, 0, n2);
                    continue block4;
                }
                case 2: {
                    f = 0.8f - f;
                    this.contour_color[i] = Color.getHSBColor(f, 1.0f, 1.0f);
                    continue block4;
                }
                default: {
                    this.contour_color[i] = Color.getHSBColor(0.0f, 0.0f, f);
                }
            }
        }
    }

    private final void createContour() {
        float f = this.zmin;
        boolean bl = true;
        int n = this.xpoints[0] = this.contourConvertX(this.contour_vertex[0].x);
        int n2 = this.xpoints[4] = this.contourConvertX(this.contour_vertex[2].x);
        this.ypoints[0] = this.contourConvertY(this.contour_vertex[0].y);
        this.xpoints[2] = this.contourConvertX(this.contour_vertex[1].x);
        this.ypoints[4] = this.contourConvertY(this.contour_vertex[2].y);
        this.xpoints[6] = this.contourConvertX(this.contour_vertex[3].x);
        this.ypoints[2] = this.ypoints[3] = this.contourConvertY(this.contour_vertex[1].y);
        this.ypoints[6] = this.ypoints[7] = this.contourConvertY(this.contour_vertex[3].y);
        this.xpoints[7] = -1;
        this.xpoints[5] = -1;
        this.xpoints[3] = -1;
        this.xpoints[1] = -1;
        for (int i = 0; i <= this.contour_lines + 1; ++i) {
            int n3;
            int n4;
            int n5;
            block7: for (n5 = 0; n5 < 4; ++n5) {
                n4 = (n5 << 1) + 1;
                n3 = n5 + 1 & 3;
                if (f > this.contour_vertex[n5].z) {
                    this.xpoints[n4 - 1] = -2;
                    if (f > this.contour_vertex[n3].z) {
                        this.xpoints[n4 + 1 & 7] = -2;
                        this.xpoints[n4] = -2;
                    }
                } else if (f > this.contour_vertex[n3].z) {
                    this.xpoints[n4 + 1 & 7] = -2;
                }
                if (this.xpoints[n4] == -2) continue;
                if (this.xpoints[n4] != -1) {
                    int n6 = n5;
                    this.intersection[n6] = this.intersection[n6] + this.delta[n5];
                    if (n4 == 1 || n4 == 5) {
                        this.ypoints[n4] = this.contourConvertY(this.intersection[n5]);
                        continue;
                    }
                    this.xpoints[n4] = this.contourConvertX(this.intersection[n5]);
                    continue;
                }
                if (!(f > this.contour_vertex[n5].z) && !(f > this.contour_vertex[n3].z)) continue;
                switch (n4) {
                    case 1: {
                        this.delta[n5] = (this.contour_vertex[n3].y - this.contour_vertex[n5].y) * this.contour_stepz / (this.contour_vertex[n3].z - this.contour_vertex[n5].z);
                        this.intersection[n5] = (this.contour_vertex[n3].y * (f - this.contour_vertex[n5].z) + this.contour_vertex[n5].y * (this.contour_vertex[n3].z - f)) / (this.contour_vertex[n3].z - this.contour_vertex[n5].z);
                        this.xpoints[n4] = n;
                        this.ypoints[n4] = this.contourConvertY(this.intersection[n5]);
                        continue block7;
                    }
                    case 3: {
                        this.delta[n5] = (this.contour_vertex[n3].x - this.contour_vertex[n5].x) * this.contour_stepz / (this.contour_vertex[n3].z - this.contour_vertex[n5].z);
                        this.intersection[n5] = (this.contour_vertex[n3].x * (f - this.contour_vertex[n5].z) + this.contour_vertex[n5].x * (this.contour_vertex[n3].z - f)) / (this.contour_vertex[n3].z - this.contour_vertex[n5].z);
                        this.xpoints[n4] = this.contourConvertX(this.intersection[n5]);
                        continue block7;
                    }
                    case 5: {
                        this.delta[n5] = (this.contour_vertex[n5].y - this.contour_vertex[n3].y) * this.contour_stepz / (this.contour_vertex[n5].z - this.contour_vertex[n3].z);
                        this.intersection[n5] = (this.contour_vertex[n5].y * (f - this.contour_vertex[n3].z) + this.contour_vertex[n3].y * (this.contour_vertex[n5].z - f)) / (this.contour_vertex[n5].z - this.contour_vertex[n3].z);
                        this.xpoints[n4] = n2;
                        this.ypoints[n4] = this.contourConvertY(this.intersection[n5]);
                        continue block7;
                    }
                    case 7: {
                        this.delta[n5] = (this.contour_vertex[n5].x - this.contour_vertex[n3].x) * this.contour_stepz / (this.contour_vertex[n5].z - this.contour_vertex[n3].z);
                        this.intersection[n5] = (this.contour_vertex[n5].x * (f - this.contour_vertex[n3].z) + this.contour_vertex[n3].x * (this.contour_vertex[n5].z - f)) / (this.contour_vertex[n5].z - this.contour_vertex[n3].z);
                        this.xpoints[n4] = this.contourConvertX(this.intersection[n5]);
                    }
                }
            }
            this.contour_n = 0;
            for (n5 = 0; n5 < 8; ++n5) {
                if (this.xpoints[n5] < 0) continue;
                this.contour_x[this.contour_n] = this.xpoints[n5];
                this.contour_y[this.contour_n] = this.ypoints[n5];
                ++this.contour_n;
            }
            if (this.plot_mode != 0 && this.plot_mode != 1) {
                if (i > this.contour_lines) {
                    if (this.printing) {
                        this.BufferGC.setColor(Color.white);
                    } else {
                        this.BufferGC.setColor(Color.lightGray);
                    }
                } else {
                    this.BufferGC.setColor(this.contour_color[i]);
                }
                this.BufferGC.fillPolygon(this.contour_x, this.contour_y, this.contour_n);
            }
            if (this.isMesh || !bl) {
                n5 = -1;
                n4 = -1;
                for (n3 = 1; n3 < 8; n3 += 2) {
                    if (this.xpoints[n3] < 0) continue;
                    if (n5 != -1) {
                        this.accumulator.addLine(n5, n4, this.xpoints[n3], this.ypoints[n3]);
                    }
                    n5 = this.xpoints[n3];
                    n4 = this.ypoints[n3];
                }
                if (this.xpoints[1] > 0 && n5 != -1) {
                    this.accumulator.addLine(n5, n4, this.xpoints[1], this.ypoints[1]);
                }
            }
            if (this.contour_n < 3) break;
            f += this.contour_stepz;
        }
    }

    private final void plotContour() {
        float f;
        float f2;
        this.image_drawn = false;
        this.accumulator.clearAccumulator();
        try {
            f2 = this.controller.getZMin();
            f = this.controller.getZMax();
            if (f2 >= f) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Error in ranges");
            this.rotate = false;
            return;
        }
        this.zmin = f2;
        this.zmax = f;
        this.computePlotArea();
        int n = this.controller.getDispDivisions();
        int n2 = this.calc_divisions / n;
        this.controller.setDispDivisions(n);
        this.contour_stepz = (f - f2) / (float)(this.contour_lines + 1);
        this.setMessage("regenerating ...");
        if (!this.printing) {
            this.BufferGC.setColor(Color.lightGray);
            this.BufferGC.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        if (this.plotfunc1 || this.plotfunc2) {
            int n3 = 0;
            int n4 = 0;
            if (!this.plotfunc1) {
                n4 = 1;
            }
            int n5 = (this.calc_divisions + 1) * n2;
            for (int i = 0; i < this.calc_divisions; i += n2) {
                n3 = i * (this.calc_divisions + 1);
                for (int j = 0; j < this.calc_divisions; j += n2) {
                    this.contour_vertex[0] = this.vertex[n4][n3];
                    this.contour_vertex[1] = this.vertex[n4][n3 + n2];
                    this.contour_vertex[2] = this.vertex[n4][n3 + n5 + n2];
                    this.contour_vertex[3] = this.vertex[n4][n3 + n5];
                    this.createContour();
                    n3 += n2;
                }
            }
        }
        if (this.plot_mode == 4) {
            this.BufferGC.setColor(new Color(0, 64, 0));
        } else {
            this.BufferGC.setColor(Color.black);
        }
        this.accumulator.drawAll(this.BufferGC);
        this.drawBoundingRect();
        this.setMessage("completed");
        this.image_drawn = true;
    }

    private final void plotDensity() {
        float f;
        float f2;
        this.image_drawn = false;
        try {
            f2 = this.controller.getZMin();
            f = this.controller.getZMax();
            if (f2 >= f) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Error in ranges");
            this.rotate = false;
            return;
        }
        this.zmin = f2;
        this.zmax = f;
        this.computePlotArea();
        int n = this.controller.getDispDivisions();
        int n2 = this.calc_divisions / n;
        this.controller.setDispDivisions(n);
        this.setMessage("regenerating ...");
        this.color_factor = 0.8f / (f - f2);
        if (this.plot_mode == 4) {
            this.color_factor *= 0.75f;
        }
        if (!this.printing) {
            this.BufferGC.setColor(Color.lightGray);
            this.BufferGC.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        if (this.plotfunc1 || this.plotfunc2) {
            int n3 = 0;
            int n4 = 0;
            if (!this.plotfunc1) {
                n4 = 1;
            }
            int n5 = (this.calc_divisions + 1) * n2;
            for (int i = 0; i < this.calc_divisions; i += n2) {
                n3 = i * (this.calc_divisions + 1);
                for (int j = 0; j < this.calc_divisions; j += n2) {
                    this.contour_vertex[0] = this.vertex[n4][n3];
                    this.contour_vertex[1] = this.vertex[n4][n3 + n2];
                    this.contour_vertex[2] = this.vertex[n4][n3 + n5 + n2];
                    this.contour_vertex[3] = this.vertex[n4][n3 + n5];
                    int n6 = this.contourConvertX(this.contour_vertex[1].x);
                    int n7 = this.contourConvertY(this.contour_vertex[1].y);
                    int n8 = this.contourConvertX(this.contour_vertex[3].x) - n6;
                    int n9 = this.contourConvertY(this.contour_vertex[3].y) - n7;
                    float f3 = 0.0f;
                    boolean bl = false;
                    for (int k = 0; k < 4; ++k) {
                        if (Float.isNaN(this.contour_vertex[k].z)) {
                            bl = true;
                            break;
                        }
                        f3 += this.contour_vertex[k].z;
                    }
                    if (bl) {
                        n3 += n2;
                        continue;
                    }
                    f3 /= (float)4;
                    this.line_color = Color.black;
                    switch (this.plot_mode) {
                        case 2: 
                        case 4: {
                            f3 = 0.8f - (f3 - f2) * this.color_factor;
                            this.BufferGC.setColor(Color.getHSBColor(f3, 1.0f, 1.0f));
                            break;
                        }
                        default: {
                            f3 = (f3 - f2) * this.color_factor;
                            this.BufferGC.setColor(Color.getHSBColor(0.0f, 0.0f, f3));
                            if (!(f3 < 0.3f)) break;
                            this.line_color = new Color(0.6f, 0.6f, 0.6f);
                        }
                    }
                    this.BufferGC.fillRect(n6, n7, n8, n9);
                    if (this.isMesh) {
                        this.BufferGC.setColor(this.line_color);
                        this.BufferGC.drawRect(n6, n7, n8, n9);
                    }
                    n3 += n2;
                }
            }
        }
        this.drawBoundingRect();
        this.setMessage("completed");
        this.image_drawn = true;
    }

    private final void plotWireframe() {
        float f;
        float f2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        Point point = new Point(0, 0);
        this.image_drawn = false;
        this.projection = new Point(0, 0);
        try {
            f2 = this.controller.getZMin();
            f = this.controller.getZMax();
            if (f2 >= f) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Error in ranges");
            this.rotate = false;
            return;
        }
        int n = this.controller.getDispDivisions();
        int n2 = this.calc_divisions / n;
        this.controller.setDispDivisions(n);
        this.zmin = f2;
        this.zmax = f;
        if (this.rotate) {
            this.setMessage("rotating ...");
        } else {
            this.setMessage("regenerating ...");
        }
        if (!this.printing) {
            this.BufferGC.setColor(Color.lightGray);
            this.BufferGC.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        this.drawBoxGridsTicksLabels(this.BufferGC, false);
        this.BufferGC.setColor(Color.black);
        this.zmaxV = this.zmax;
        this.zminV = this.zmin;
        this.zfactorV = (float)20 / (this.zmaxV - this.zminV);
        for (int i = 0; i < 2; ++i) {
            float f6;
            boolean bl;
            boolean bl2;
            float f7;
            boolean bl3;
            int n3;
            if (i == 0 && !this.plotfunc1 || i == 1 && !this.plotfunc2) continue;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (n3 = 0; n3 <= this.calc_divisions; ++n3) {
                bl3 = true;
                if (n6 == 0) {
                    while (n4 <= this.calc_divisions) {
                        f7 = this.vertex[i][n5].z;
                        bl2 = Float.isNaN(f7);
                        if (!bl2) {
                            if (f7 < this.zmin) {
                                bl = true;
                                f6 = (this.zmin - f5) / (f7 - f5);
                                this.projection = this.projector.project(f6 * (this.vertex[i][n5].x - f3) + f3, f6 * (this.vertex[i][n5].y - f4) + f4, -10.0f);
                            } else if (f7 > this.zmax) {
                                bl = true;
                                f6 = (this.zmax - f5) / (f7 - f5);
                                this.projection = this.projector.project(f6 * (this.vertex[i][n5].x - f3) + f3, f6 * (this.vertex[i][n5].y - f4) + f4, 10.0f);
                            } else {
                                bl = false;
                                this.projection = this.vertex[i][n5].projection();
                            }
                            if (bl3 && !bl && n4 != 0) {
                                if (f5 > this.zmax) {
                                    f6 = (this.zmax - f7) / (f5 - f7);
                                    point = this.projector.project(f6 * (f3 - this.vertex[i][n5].x) + this.vertex[i][n5].x, f6 * (f4 - this.vertex[i][n5].y) + this.vertex[i][n5].y, 10.0f);
                                } else if (f5 < this.zmin) {
                                    f6 = (this.zmin - f7) / (f5 - f7);
                                    point = this.projector.project(f6 * (f3 - this.vertex[i][n5].x) + this.vertex[i][n5].x, f6 * (f4 - this.vertex[i][n5].y) + this.vertex[i][n5].y, -10.0f);
                                }
                            } else {
                                bl2 = bl && bl3;
                            }
                        } else {
                            bl = true;
                        }
                        if (!bl2 && n4 != 0) {
                            this.BufferGC.drawLine(point.x, point.y, this.projection.x, this.projection.y);
                        }
                        point = this.projection;
                        bl3 = bl;
                        f3 = this.vertex[i][n5].x;
                        f4 = this.vertex[i][n5].y;
                        f5 = f7;
                        ++n4;
                        ++n5;
                    }
                } else {
                    n5 += this.calc_divisions + 1;
                }
                n4 = 0;
                n6 = (n6 + 1) % n2;
            }
            n3 = 0;
            n4 = 0;
            n5 = 0;
            n6 = 0;
            while (n4 <= this.calc_divisions) {
                bl3 = true;
                if (n6 == 0) {
                    while (n3 <= this.calc_divisions) {
                        f7 = this.vertex[i][n5].z;
                        bl2 = Float.isNaN(f7);
                        if (!bl2) {
                            if (f7 < this.zmin) {
                                bl = true;
                                f6 = (this.zmin - f5) / (f7 - f5);
                                this.projection = this.projector.project(f6 * (this.vertex[i][n5].x - f3) + f3, f6 * (this.vertex[i][n5].y - f4) + f4, -10.0f);
                            } else if (f7 > this.zmax) {
                                bl = true;
                                f6 = (this.zmax - f5) / (f7 - f5);
                                this.projection = this.projector.project(f6 * (this.vertex[i][n5].x - f3) + f3, f6 * (this.vertex[i][n5].y - f4) + f4, 10.0f);
                            } else {
                                bl = false;
                                this.projection = this.vertex[i][n5].projection();
                            }
                            if (bl3 && !bl && n3 != 0) {
                                if (f5 > this.zmax) {
                                    f6 = (this.zmax - f7) / (f5 - f7);
                                    point = this.projector.project(f6 * (f3 - this.vertex[i][n5].x) + this.vertex[i][n5].x, f6 * (f4 - this.vertex[i][n5].y) + this.vertex[i][n5].y, 10.0f);
                                } else if (f5 < this.zmin) {
                                    f6 = (this.zmin - f7) / (f5 - f7);
                                    point = this.projector.project(f6 * (f3 - this.vertex[i][n5].x) + this.vertex[i][n5].x, f6 * (f4 - this.vertex[i][n5].y) + this.vertex[i][n5].y, -10.0f);
                                }
                            } else {
                                bl2 = bl && bl3;
                            }
                        } else {
                            bl = true;
                        }
                        if (!bl2 && n3 != 0) {
                            this.BufferGC.drawLine(point.x, point.y, this.projection.x, this.projection.y);
                        }
                        point = this.projection;
                        bl3 = bl;
                        f3 = this.vertex[i][n5].x;
                        f4 = this.vertex[i][n5].y;
                        f5 = f7;
                        ++n3;
                        n5 += this.calc_divisions + 1;
                    }
                }
                n3 = 0;
                n5 = ++n4;
                n6 = (n6 + 1) % n2;
            }
        }
        if (this.isBoxed) {
            this.drawBoundingBox();
        }
        if (!this.rotate) {
            this.setMessage("completed");
        }
        this.image_drawn = true;
    }

    static {
        WIREFRAME = 0;
        NORENDER = 1;
        SPECTRUM = 2;
        GRAYSCALE = 3;
        DUALSHADE = 4;
        TOP = 0;
        CENTER = 1;
        UPPER = 1;
        COINCIDE = 0;
        LOWER = -1;
    }
}

