/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.surfaceplotter;

import edu.davidson.surfaceplotter.Controller;
import edu.davidson.surfaceplotter.SurfaceCanvas;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;

public class SurfacePanel
extends Panel
implements SDataListener {
    BorderLayout borderLayout1 = new BorderLayout();
    public SurfaceCanvas surfaceCanvas = new SurfaceCanvas();
    SApplet sapplet = null;
    boolean autoRefresh = true;

    public SurfacePanel() {
        this((SApplet)null);
    }

    public SurfacePanel(SApplet sApplet) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sapplet = sApplet;
        SApplet.addDataListener((Object)this);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.surfaceCanvas, "Center");
    }

    public boolean setFunction1(String string) {
        this.stop();
        if (string == null || string.equals("")) {
            string = null;
        }
        this.surfaceCanvas.dataGenerator.setDataArray(null);
        this.surfaceCanvas.controller.setFunction1(string);
        this.surfaceCanvas.dataGenerator.createData();
        return true;
    }

    public boolean setFunction2(String string) {
        this.stop();
        if (string == null || string.equals("")) {
            string = null;
        }
        this.surfaceCanvas.controller.setFunction2(string);
        this.surfaceCanvas.dataGenerator.createData();
        return true;
    }

    public void setScaleFactor(int n) {
        this.surfaceCanvas.projector.set2DScaling(n);
    }

    public void setDistance(int n) {
        this.surfaceCanvas.projector.setDistance(n);
    }

    public void setRotationAngle(double d) {
        this.surfaceCanvas.projector.setRotationAngle((float)d);
    }

    public double getRotationAngle() {
        return this.surfaceCanvas.projector.getRotationAngle();
    }

    public void setElevationAngle(double d) {
        this.surfaceCanvas.projector.setElevationAngle((float)d);
    }

    public double getElevationAngle() {
        return this.surfaceCanvas.projector.getElevationAngle();
    }

    public void startRotate() {
        this.surfaceCanvas.startRotation();
    }

    public void stopRotate() {
        this.surfaceCanvas.stopRotation();
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
        this.sapplet = sApplet;
    }

    public SApplet getOwner() {
        return this.sapplet;
    }

    public void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        System.out.println("addDatum Series not supported.");
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("x=").append(d).append("    y=").append(d2))));
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        double[][] dArray3 = null;
        String[] stringArray = sDataSource.getVarStrings();
        if (stringArray == null || stringArray[0] == null || stringArray[0].equals("surfacedata")) {
            dArray3 = sDataSource.getVariables();
            if (dArray3[0].length != dArray3.length) {
                System.out.println("Surface data array is not square");
                return;
            }
            this.setGridPts(dArray3.length - 1);
            this.surfaceCanvas.dataGenerator.setDataArray(dArray3);
            this.surfaceCanvas.dataGenerator.createData();
        }
    }

    public void addData(int n, double[][] dArray) {
        if (dArray == null) {
            System.out.println("null data");
            return;
        }
        if (dArray[0].length != dArray.length) {
            System.out.println("Surface data array is not square");
            return;
        }
        this.setGridPts(dArray.length - 1);
        this.surfaceCanvas.dataGenerator.setDataArray(dArray);
        this.surfaceCanvas.dataGenerator.createData();
    }

    public void deleteSeries(int n) {
        this.stop();
        this.surfaceCanvas.dataGenerator.setDataArray(null);
    }

    public void clearSeries(int n) {
        this.stop();
        this.surfaceCanvas.dataGenerator.setDataArray(null);
    }

    public void destroyThread() {
        try {
            this.surfaceCanvas.destroyThread();
            this.surfaceCanvas.dataGenerator.destroyThread();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double getMinX() {
        return this.surfaceCanvas.controller.getXMin();
    }

    public double getMaxX() {
        return this.surfaceCanvas.controller.getXMax();
    }

    public double getMinY() {
        return this.surfaceCanvas.controller.getYMin();
    }

    public double getMaxY() {
        return this.surfaceCanvas.controller.getYMax();
    }

    public double getMinZ() {
        return this.surfaceCanvas.controller.getZMin();
    }

    public double getMaxZ() {
        return this.surfaceCanvas.controller.getZMax();
    }

    public void setMinX(double d) {
        this.surfaceCanvas.controller.xmin = (float)d;
    }

    public void setMaxX(double d) {
        this.surfaceCanvas.controller.xmax = (float)d;
    }

    public void setMinY(double d) {
        this.surfaceCanvas.controller.ymin = (float)d;
    }

    public void setMaxY(double d) {
        this.surfaceCanvas.controller.ymax = (float)d;
    }

    public void setMinZ(double d) {
        this.surfaceCanvas.controller.zmin = (float)d;
    }

    public void setTime(double d) {
        this.surfaceCanvas.dataGenerator.setTime(d);
    }

    public void setMaxZ(double d) {
        this.surfaceCanvas.controller.zmax = (float)d;
    }

    public int getMode() {
        return this.surfaceCanvas.controller.plotMode;
    }

    public void setMode(int n) {
        this.surfaceCanvas.controller.plotMode = n;
    }

    public void setDefault() {
        this.stop();
        this.surfaceCanvas.controller.setDefault();
        this.setAutoRefresh(this.autoRefresh);
    }

    public void setContour() {
        if (this.surfaceCanvas.contour && !this.surfaceCanvas.density) {
            return;
        }
        this.surfaceCanvas.setContour(true);
        this.surfaceCanvas.destroyImage();
        this.surfaceCanvas.repaint();
    }

    public boolean isContour() {
        return this.surfaceCanvas.contour;
    }

    public void setDensity() {
        if (!this.surfaceCanvas.contour && this.surfaceCanvas.density) {
            return;
        }
        this.surfaceCanvas.setDensity(true);
        this.surfaceCanvas.destroyImage();
        this.surfaceCanvas.repaint();
    }

    public boolean isDensity() {
        return this.surfaceCanvas.density;
    }

    public void setGutter(int n) {
        this.surfaceCanvas.gutter = n;
    }

    public void setThreeD() {
        if (!(this.surfaceCanvas.contour || this.surfaceCanvas.density || this.surfaceCanvas.noDrawing)) {
            return;
        }
        this.surfaceCanvas.setContour(false);
        this.surfaceCanvas.setDensity(false);
        this.surfaceCanvas.destroyImage();
        this.surfaceCanvas.repaint();
    }

    public void setNoDrawing() {
        this.surfaceCanvas.setNoDrawing(true);
        this.surfaceCanvas.destroyImage();
        this.surfaceCanvas.repaint();
    }

    public boolean isThreeD() {
        return !this.surfaceCanvas.contour && !this.surfaceCanvas.density;
    }

    public void setShowBox(boolean bl) {
        this.surfaceCanvas.controller.boxed = bl;
    }

    public void setShowMesh(boolean bl) {
        this.surfaceCanvas.controller.showMesh = bl;
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (this.autoRefresh) {
            this.surfaceCanvas.destroyImage();
            this.surfaceCanvas.repaint();
        } else {
            this.stop();
        }
    }

    public void setScaledBox(boolean bl) {
        this.surfaceCanvas.controller.autoScale = bl;
    }

    public void setAutoscaleZ(boolean bl) {
        this.surfaceCanvas.controller.autoScaleHeigth = bl;
    }

    public void setShowFaceGrids(boolean bl) {
        this.surfaceCanvas.controller.showFaceGrids = bl;
    }

    public void setShowXYticks(boolean bl) {
        this.surfaceCanvas.controller.displayXYTicks = bl;
    }

    public void setShowZticks(boolean bl) {
        this.surfaceCanvas.controller.displayZTicks = bl;
    }

    public void setGridPts(int n) {
        if (n == this.surfaceCanvas.controller.calc_divisions) {
            return;
        }
        Controller controller = this.surfaceCanvas.controller;
        synchronized (controller) {
            this.surfaceCanvas.dataGenerator.interrupt();
            this.surfaceCanvas.interrupt();
            this.surfaceCanvas.dataGenerator.setDataArray(null);
            this.surfaceCanvas.controller.calc_divisions = n;
            this.surfaceCanvas.controller.disp_divisions = n;
        }
        if (this.autoRefresh) {
            this.surfaceCanvas.repaint();
        }
    }

    public void setNumLevels(int n) {
        if (this.surfaceCanvas.controller.numContourLines == n) {
            return;
        }
        Controller controller = this.surfaceCanvas.controller;
        synchronized (controller) {
            this.surfaceCanvas.dataGenerator.interrupt();
            this.surfaceCanvas.interrupt();
            this.surfaceCanvas.controller.numContourLines = n;
        }
        if (this.autoRefresh) {
            this.surfaceCanvas.repaint();
        }
    }

    public void setGraphFont(Font font) {
        this.surfaceCanvas.defaultFont = font;
    }

    void stop() {
        this.surfaceCanvas.dataGenerator.interrupt();
        this.surfaceCanvas.interrupt();
    }
}

