/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.surfaceplotter;

import edu.davidson.surfaceplotter.SurfaceCanvas;
import java.awt.Point;

public final class SurfaceVertex {
    SurfaceCanvas surfaceCanvas;
    private Point projection;
    private int project_index;
    public float x;
    public float y;
    public float z;

    SurfaceVertex(float f, float f2, float f3, SurfaceCanvas surfaceCanvas) {
        this.surfaceCanvas = surfaceCanvas;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.project_index = surfaceCanvas.master_project_indexV - 1;
    }

    public final boolean isInvalid() {
        return Float.isNaN(this.z);
    }

    public final Point projection() {
        if (this.project_index != this.surfaceCanvas.master_project_indexV) {
            this.projection = this.surfaceCanvas.projector.project(this.x, this.y, (this.z - this.surfaceCanvas.zminV) * this.surfaceCanvas.zfactorV - (float)10);
            this.project_index = this.surfaceCanvas.master_project_indexV;
        }
        return this.projection;
    }

    public final void transform() {
        this.x /= this.surfaceCanvas.projector.getXScaling();
        this.y /= this.surfaceCanvas.projector.getYScaling();
        this.z = (this.surfaceCanvas.zmaxV - this.surfaceCanvas.zminV) * (this.z / this.surfaceCanvas.projector.getZScaling() + (float)10) / (float)20 + this.surfaceCanvas.zminV;
    }
}

