/*
 * Decompiled with CFR 0.152.
 */
package splotter;

import edu.davidson.graphics.EtchedBorder;
import edu.davidson.surfaceplotter.SurfacePanel;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SPlotter
extends SApplet
implements SStepable {
    boolean isStandalone = false;
    boolean firstTime = true;
    String funcStr;
    String func2Str;
    String scaleStr;
    String typeStr;
    int gridPts;
    int numLevels;
    int scaleFactor = 10;
    boolean showControls;
    EtchedBorder etchedBorder1 = new EtchedBorder();
    Button plotBtn = new Button();
    SurfacePanel surfacePanel = new SurfacePanel(this);
    BorderLayout borderLayout1 = new BorderLayout();
    TextField funcField = new TextField();
    Panel panel1 = new Panel();
    Button rotateBtn = new Button();
    Button runBtn = new Button();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        double d = 0.1;
        double d2 = 10.0;
        try {
            d2 = Double.valueOf(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            d = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.funcStr = this.getParameter("Function", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.func2Str = this.getParameter("Function2", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.scaleStr = this.getParameter("Scale", "xmin=-1,xmax=1,ymin=-1,ymax=1,zmin=-1,zmax=1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.gridPts = Integer.parseInt(this.getParameter("GridPts", "32"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.numLevels = Integer.parseInt(this.getParameter("Levels", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.scaleFactor = Integer.parseInt(this.getParameter("ScaleFactor", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.typeStr = this.getParameter("Type", "threed");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clock.setDt(d);
        this.clock.setFPS((double)((int)d2));
        this.etchedBorder1.setVisible(this.showControls);
        this.setGridPoints(this.gridPts);
        this.setNumLevels(this.numLevels);
        this.set(0, "style", "scalefactor=".concat(String.valueOf(String.valueOf(this.scaleFactor))));
        this.surfacePanel.surfaceCanvas.setNoDrawing(true);
        this.clock.addClockListener((SStepable)this);
    }

    private void jbInit() throws Exception {
        ((Applet)((Object)this)).resize(350, 400);
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.plotBtn.setLabel("Plot");
        this.plotBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SPlotter.this.plotBtn_actionPerformed(actionEvent);
            }
        });
        this.funcField.setText("x*y");
        this.rotateBtn.setName("rotateBtn");
        this.rotateBtn.setLabel("Rotate");
        this.rotateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SPlotter.this.rotateBtn_actionPerformed(actionEvent);
            }
        });
        this.runBtn.setName("runBtn");
        this.runBtn.setLabel("Run");
        this.runBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SPlotter.this.runBtn_actionPerformed(actionEvent);
            }
        });
        this.etchedBorder1.setBackground(SystemColor.inactiveCaptionText);
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "South");
        this.etchedBorder1.add((Component)this.plotBtn, "West");
        this.etchedBorder1.add((Component)this.funcField, "Center");
        this.etchedBorder1.add((Component)this.panel1, "East");
        this.panel1.add((Component)this.runBtn, null);
        this.panel1.add((Component)this.rotateBtn, null);
        this.panel1.setBackground(SystemColor.inactiveCaptionBorder);
        ((Container)((Object)this)).add(this.surfacePanel, "Center");
    }

    public void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
            this.set(0, "type", this.typeStr);
            this.set(0, "scale", this.scaleStr);
            this.setFunction1(this.funcStr);
            this.setFunction2(this.func2Str);
        }
    }

    public void stop() {
        super.stop();
    }

    public void destroy() {
        this.surfacePanel.destroyThread();
        super.destroy();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Function", "String", "Analytic Function, f(x,y)"}, {"GridPts", "int", "Grid points along axis"}, {"Levels", "int", "Number of contour levels."}, {"Mode", "String", "Contour or 3D"}, {"ShowControls", "boolean", "Show user interface"}};
        return stringArray;
    }

    public void setFunction(String string) {
        this.setFunction1(string);
    }

    public void setFunction1(String string) {
        this.funcField.setText(string);
        this.clock.stopClock();
        this.surfacePanel.setFunction1(string);
    }

    public void setFunction2(String string) {
        this.clock.stopClock();
        this.surfacePanel.setFunction2(string);
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        this.surfacePanel.setAutoRefresh(bl);
    }

    public synchronized boolean set(int n, String string, String string2) {
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        String string4 = "false";
        double d = this.surfacePanel.getMinX();
        double d2 = this.surfacePanel.getMaxX();
        double d3 = this.surfacePanel.getMinY();
        double d4 = this.surfacePanel.getMaxY();
        double d5 = this.surfacePanel.getMinZ();
        double d6 = this.surfacePanel.getMaxZ();
        if (string.equals("scale")) {
            if (SUtil.parameterExist((String)string2, (String)"xmin=")) {
                d = SUtil.getParam((String)string2, (String)"xmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmax=")) {
                d2 = SUtil.getParam((String)string2, (String)"xmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=")) {
                d3 = SUtil.getParam((String)string2, (String)"ymin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymax=")) {
                d4 = SUtil.getParam((String)string2, (String)"ymax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"zmin=")) {
                d5 = SUtil.getParam((String)string2, (String)"zmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"zmax=")) {
                d6 = SUtil.getParam((String)string2, (String)"zmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"autoscalez=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"autoscalez=");
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.surfacePanel.setAutoscaleZ(false);
                } else {
                    this.surfacePanel.setAutoscaleZ(true);
                }
            }
            this.surfacePanel.setMinX(d);
            this.surfacePanel.setMaxX(d2);
            this.surfacePanel.setMinY(d3);
            this.surfacePanel.setMaxY(d4);
            this.surfacePanel.setMinZ(d5);
            this.surfacePanel.setMaxZ(d6);
        } else if (string.equals("font")) {
            String string5 = "Helvetica";
            int n2 = 0;
            int n3 = 10;
            if (SUtil.parameterExist((String)string2, (String)"family=")) {
                string5 = SUtil.getParamStr((String)string2, (String)"family=");
            }
            if (SUtil.parameterExist((String)string2, (String)"style=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"style=");
            }
            if (SUtil.parameterExist((String)string2, (String)"size=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"size=");
            }
            Font font = new Font(string5, n2, n3);
            this.surfacePanel.setGraphFont(font);
        } else if (string.equals("mode")) {
            int n4 = this.surfacePanel.getMode();
            if (SUtil.parameterExist((String)string2, (String)"mesh") || SUtil.parameterExist((String)string2, (String)"wireframe")) {
                n4 = 0;
            }
            if (SUtil.parameterExist((String)string2, (String)"hidden")) {
                n4 = 1;
            }
            if (SUtil.parameterExist((String)string2, (String)"spectrum")) {
                n4 = 2;
            }
            if (SUtil.parameterExist((String)string2, (String)"grayscale")) {
                n4 = 3;
            }
            if (SUtil.parameterExist((String)string2, (String)"dualshade")) {
                n4 = 4;
            }
            this.surfacePanel.setMode(n4);
        } else if (string.equals("type")) {
            if (SUtil.parameterExist((String)string2, (String)"contour")) {
                this.surfacePanel.setContour();
            } else if (SUtil.parameterExist((String)string2, (String)"density")) {
                this.surfacePanel.setDensity();
            } else if (SUtil.parameterExist((String)string2, (String)"threed")) {
                this.surfacePanel.setThreeD();
            } else if (SUtil.parameterExist((String)string2, (String)"none")) {
                this.surfacePanel.setNoDrawing();
            }
        } else if (string.equals("view")) {
            int n5;
            if (SUtil.parameterExist((String)string2, (String)"scalefactor=")) {
                n5 = 10;
                n5 = (int)SUtil.getParam((String)string2, (String)"scalefactor=");
                n5 = Math.max(n5, 1);
                this.surfacePanel.setScaleFactor(n5);
            }
            if (SUtil.parameterExist((String)string2, (String)"distance=")) {
                n5 = 200;
                n5 = (int)SUtil.getParam((String)string2, (String)"distance=");
                n5 = Math.max(n5, 50);
                this.surfacePanel.setDistance(n5);
            }
            if (SUtil.parameterExist((String)string2, (String)"rotationangle=")) {
                double d7 = 45.0;
                d7 = (int)SUtil.getParam((String)string2, (String)"rotationangle=");
                this.surfacePanel.setRotationAngle(d7);
            }
            if (SUtil.parameterExist((String)string2, (String)"elevationangle=")) {
                double d8 = 10.0;
                d8 = (int)SUtil.getParam((String)string2, (String)"elevationangle=");
                this.surfacePanel.setElevationAngle(d8);
            }
        } else if (string.equals("style")) {
            int n6;
            if (SUtil.parameterExist((String)string2, (String)"box")) {
                this.surfacePanel.setShowBox(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"mesh")) {
                this.surfacePanel.setShowMesh(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"facegrid")) {
                this.surfacePanel.setShowFaceGrids(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"scaledbox")) {
                this.surfacePanel.setScaledBox(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"xyticks")) {
                this.surfacePanel.setShowXYticks(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"zticks")) {
                this.surfacePanel.setShowZticks(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"gutter=")) {
                n6 = 0;
                n6 = (int)SUtil.getParam((String)string2, (String)"gutter=");
                n6 = Math.max(n6, 0);
                n6 = Math.min(n6, 200);
                this.surfacePanel.setGutter(n6);
            }
            if (SUtil.parameterExist((String)string2, (String)"numlevels=")) {
                n6 = 10;
                n6 = (int)SUtil.getParam((String)string2, (String)"numlevels=");
                n6 = Math.max(n6, 1);
                n6 = Math.min(n6, 100);
                this.surfacePanel.setNumLevels(n6);
            }
            if (SUtil.parameterExist((String)string2, (String)"scaledbox=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"scaledbox=");
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.surfacePanel.setScaledBox(false);
                } else {
                    this.surfacePanel.setScaledBox(true);
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"box=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"box=");
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.surfacePanel.setShowBox(false);
                } else {
                    this.surfacePanel.setShowBox(true);
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"mesh=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"mesh=");
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.surfacePanel.setShowMesh(false);
                } else {
                    this.surfacePanel.setShowMesh(true);
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"facegrid=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"facegrid=");
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.surfacePanel.setShowFaceGrids(false);
                } else {
                    this.surfacePanel.setShowFaceGrids(true);
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"xyticks=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"xyticks=");
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.surfacePanel.setShowXYticks(false);
                } else {
                    this.surfacePanel.setShowXYticks(true);
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"zticks=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"zticks=");
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.surfacePanel.setShowZticks(false);
                } else {
                    this.surfacePanel.setShowZticks(true);
                }
            }
        } else {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Set property not found: ").append(string).append("parameter list: ").append(string2))));
            return false;
        }
        this.setAutoRefresh(this.autoRefresh);
        return true;
    }

    public void setDefault() {
        this.deleteDataConnections();
        this.surfacePanel.setDefault();
    }

    public void setGridPoints(int n) {
        this.surfacePanel.setGridPts(n);
    }

    public void setNumLevels(int n) {
        this.surfacePanel.setNumLevels(n);
    }

    public double getRotationAngle() {
        return this.surfacePanel.getRotationAngle();
    }

    public void setRotationAngle(double d) {
        this.surfacePanel.setRotationAngle(d);
    }

    public double getElevationAngle() {
        return this.surfacePanel.getElevationAngle();
    }

    public void setElevationAngle(double d) {
        this.surfacePanel.setElevationAngle(d);
    }

    public int getPlotID() {
        return this.surfacePanel.hashCode();
    }

    void rotateBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.rotateBtn.getLabel().equals("Rotate")) {
            this.rotateBtn.setLabel("Static");
            this.surfacePanel.startRotate();
        } else {
            this.rotateBtn.setLabel("Rotate");
            this.surfacePanel.stopRotate();
        }
    }

    public void step(double d, double d2) {
        this.surfacePanel.setTime(d2);
    }

    void runBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.runBtn.getLabel().equals("Run")) {
            this.runBtn.setLabel("Stop");
            this.clock.startClock();
        } else {
            this.runBtn.setLabel("Run");
            this.clock.stopClock();
        }
    }

    void plotBtn_actionPerformed(ActionEvent actionEvent) {
        this.clock.stopClock();
        this.clock.setTime(0.0);
        this.surfacePanel.setFunction1(this.funcField.getText());
        this.surfacePanel.setTime(0.0);
        if (this.rotateBtn.getLabel().equals("Static")) {
            this.surfacePanel.startRotate();
        }
        if (this.runBtn.getLabel().equals("Stop")) {
            this.clock.startClock();
        }
    }
}

